/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.trs.cis4.util.CloseUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageUtil {
    private static float rateProcess = 0.3f;
    private static int maxWidth = 250;
    private static int maxHeight = 240;
    private static int smallRate = 3;
    private static float amplifyRate = 0.9f;

    public static void setAmplifyRate(float amplifyRate) {
        ImageUtil.amplifyRate = amplifyRate;
    }

    public static void setSmallRate(int smallRate) {
        ImageUtil.smallRate = smallRate;
    }

    public static void setRateProcess(float rateProcess) {
        ImageUtil.rateProcess = rateProcess;
    }

    public static void setMaxWidth(int maxWidth) {
        ImageUtil.maxWidth = maxWidth;
    }

    public static void setMaxHeight(int maxHeight) {
        ImageUtil.maxHeight = maxHeight;
    }

    public static int resizeFix(String sourcePath) throws IOException {
        return ImageUtil.resizeProcess(sourcePath, null, true);
    }

    public static int resizeFix(String sourcePath, String destPath) throws IOException {
        return ImageUtil.resizeProcess(sourcePath, destPath, true);
    }

    public static int resizeCheck(String sourcePath) throws IOException {
        return ImageUtil.resizeProcess(sourcePath, null, false);
    }

    public static int resizeCheck(String sourcePath, String destPath) throws IOException {
        return ImageUtil.resizeProcess(sourcePath, destPath, false);
    }

    private static int resizeProcess(String sourcePath, String destPath, boolean compress) throws IOException {
        double ratePic;
        if (destPath == null) {
            destPath = ImageUtil.getDefaultDestPath(sourcePath);
        }
        if (!destPath.matches("(?i).*\\.jpg$")) {
            System.out.println("\t\u76ee\u6807\u6587\u4ef6\u5fc5\u987b\u4ee5\u201c.jpg\u201d\u4e3a\u6269\u5c55\u540d");
            return -1;
        }
        BufferedImage sourceImage = null;
        try {
            sourceImage = ImageIO.read(new File(sourcePath));
        }
        catch (Exception e) {
            System.out.println("\t\u56fe\u7247\u538b\u7f29\u4e2d\u83b7\u53d6\u6587\u4ef6\u9519\u8bef\uff01" + e + " " + sourcePath);
            return -11;
        }
        double width = sourceImage.getWidth();
        double height = sourceImage.getHeight();
        double d = ratePic = width > height ? height / width : width / height;
        if (ratePic < (double)rateProcess) {
            System.out.println("\t\u56fe\u7247\u7684\u957f\u5bbd\u6bd4\u4f8b\u4e0d\u9002\u5408\u538b\u7f29\uff01" + sourcePath + " " + width + " " + height + " " + ratePic + "/" + rateProcess);
            return -2;
        }
        if (width < (double)(maxWidth / smallRate) && height < (double)(maxHeight / smallRate)) {
            System.out.println("\t\u56fe\u7247\u592a\u5c0f\u4e0d\u538b\u7f29\uff01" + sourcePath + " " + width + " " + height + " " + ratePic + "/" + rateProcess);
            return -3;
        }
        return ImageUtil.resize(sourceImage, destPath, compress);
    }

    private static int resize(BufferedImage sourceImage, String destPath, boolean compress) throws IOException {
        int newHeight;
        int newWidth;
        double oldHeight;
        double oldWidth = sourceImage.getWidth();
        double quotient = oldWidth / (oldHeight = (double)sourceImage.getHeight()) - (double)maxWidth / (double)maxHeight;
        if (quotient < 0.0) {
            newWidth = (int)((double)maxHeight * (oldWidth / oldHeight));
            newHeight = maxHeight;
        } else {
            newWidth = maxWidth;
            newHeight = (int)((double)maxWidth * (oldHeight / oldWidth));
        }
        if (oldWidth < (double)maxWidth && oldHeight < (double)maxHeight) {
            newWidth = (int)((float)newWidth * amplifyRate);
            newHeight = (int)((float)newHeight * amplifyRate);
        }
        if (compress) {
            FileOutputStream fos = null;
            try {
                try {
                    BufferedImage destImage = new BufferedImage(newWidth, newHeight, 1);
                    destImage.getGraphics().drawImage(sourceImage, 0, 0, newWidth, newHeight, null);
                    fos = new FileOutputStream(destPath);
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fos);
                    encoder.encode(destImage);
                }
                catch (Exception e) {
                    System.out.println("\u56fe\u7247\u538b\u7f29\u4e2d\u538b\u7f29\u6587\u4ef6\u9519\u8bef\uff01" + e + " " + destPath);
                    CloseUtil.closeOutputStream(fos);
                    return -12;
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeOutputStream(fos);
                throw throwable;
            }
            CloseUtil.closeOutputStream(fos);
        }
        if (oldWidth > (double)maxWidth || oldHeight > (double)maxHeight) {
            if (quotient < 0.0) {
                return 1;
            }
            return 2;
        }
        if (quotient < 0.0) {
            return 3;
        }
        return 4;
    }

    public static int getImageWidth(String sourcePath) throws IOException {
        BufferedImage sourceImage = ImageIO.read(new File(sourcePath));
        return sourceImage.getWidth();
    }

    public static int getImageHeight(String sourcePath) throws IOException {
        BufferedImage sourceImage = ImageIO.read(new File(sourcePath));
        return sourceImage.getHeight();
    }

    public static double[] getImageWidthAndHeight(String sourcePath) throws IOException {
        double width = 0.0;
        double height = 0.0;
        BufferedImage sourceImage = null;
        try {
            sourceImage = ImageIO.read(new File(sourcePath));
        }
        catch (Exception e) {
            System.out.println("\t\u56fe\u7247\u538b\u7f29\u4e2d\u83b7\u53d6\u6587\u4ef6\u9519\u8bef\uff01" + e + " " + sourcePath);
        }
        width = sourceImage.getWidth();
        height = sourceImage.getHeight();
        double[] ret = new double[]{width, height};
        return ret;
    }

    public static String getDefaultDestPath(String sourcePath) {
        return String.valueOf(sourcePath.substring(0, sourcePath.lastIndexOf("."))) + "_s.jpg";
    }
}

