/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil
extends Exception {
    private static final long serialVersionUID = 1L;
    protected int errNo = 0;
    protected Throwable rootCause = null;

    public ExceptionUtil(int _errNo) {
        this.errNo = _errNo;
    }

    public ExceptionUtil(String _sMsg) {
        super(_sMsg);
    }

    public ExceptionUtil(int _errNo, String _sMsg) {
        super(_sMsg);
        this.errNo = _errNo;
    }

    public ExceptionUtil(String _sMsg, Throwable _rootCause) {
        super(_sMsg);
        this.rootCause = _rootCause;
    }

    public ExceptionUtil(int _errNo, String _sMsg, Throwable _rootCause) {
        super(_sMsg);
        this.errNo = _errNo;
        this.rootCause = _rootCause;
    }

    public ExceptionUtil(int _errNo, String _sMsg, String _rootCause) {
        super(_sMsg);
        this.errNo = _errNo;
        this.rootCause = new Exception(_rootCause);
    }

    public int getErrNo() {
        return this.errNo;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getErrNoMsg() {
        return "ERR NO\uff1a" + this.errNo;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getMessage() {
        String sMessage = this.toString();
        if (this.rootCause != null) {
            sMessage = this.rootCause.getCause() != null ? String.valueOf(sMessage) + "\r\n<-- " + this.rootCause.toString() + "\r\n<-- " + this.rootCause.getCause().getMessage() : String.valueOf(sMessage) + "\r\n<-- " + this.rootCause.toString();
        }
        return sMessage;
    }

    public String toString() {
        return "[ERR-" + this.errNo + "] " + this.getMyMessage();
    }

    public String getMyMessage() {
        return super.getMessage();
    }

    public String getStackTraceText() {
        return ExceptionUtil.getStackTraceText(this);
    }

    public static String getStackTraceText(Throwable _ex) {
        StringWriter strWriter = null;
        PrintWriter prtWriter = null;
        try {
            strWriter = new StringWriter();
            prtWriter = new PrintWriter(strWriter);
            _ex.printStackTrace(prtWriter);
            prtWriter.flush();
            String string = strWriter.toString();
            return string;
        }
        catch (Exception ex2) {
            String string = _ex.getMessage();
            return string;
        }
        finally {
            if (strWriter != null) {
                try {
                    strWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (prtWriter != null) {
                prtWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream _ps) {
        if (this.rootCause == null) {
            super.printStackTrace(_ps);
        } else {
            Throwable root = this.rootCause;
            PrintStream printStream = _ps;
            synchronized (printStream) {
                _ps.println(this.toString());
                while (root instanceof ExceptionUtil) {
                    _ps.println("<-- " + root.toString());
                    Throwable temp = root;
                    root = ((ExceptionUtil)root).getRootCause();
                    if (root != null) continue;
                    temp.printStackTrace(_ps);
                    break;
                }
                if (root != null) {
                    _ps.print("<-- ");
                    root.printStackTrace(_ps);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter _pw) {
        if (this.rootCause == null) {
            super.printStackTrace(_pw);
        } else {
            Throwable root = this.rootCause;
            PrintWriter printWriter = _pw;
            synchronized (printWriter) {
                _pw.println(this.toString());
                while (root instanceof ExceptionUtil) {
                    _pw.print("<-- ");
                    Throwable preRoot = root;
                    root = ((ExceptionUtil)root).getRootCause();
                    if (root == null) {
                        preRoot.printStackTrace(_pw);
                        break;
                    }
                    _pw.println(preRoot.toString());
                }
                if (root != null) {
                    _pw.print("<-- ");
                    root.printStackTrace(_pw);
                }
            }
        }
    }
}

