/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.socket.impl;

import com.trs.cis4.socket.config.RobotBean;
import com.trs.cis4.socket.config.RobotString;
import com.trs.cis4.util.ExceptionUtil;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SocketUtils {
    private static final Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.cis4.socket.impl.SocketUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public static long getLongFromBytes(byte[] byteValue) {
        long retValue = 0L;
        int[] intValue = new int[byteValue.length];
        int i = byteValue.length - 1;
        while (i >= 0) {
            intValue[i] = byteValue[i] < 0 ? 256 + byteValue[i] : byteValue[i];
            long value = 1L;
            int j = 0;
            while (j < byteValue.length - 1 - i) {
                value *= 256L;
                ++j;
            }
            retValue += (long)intValue[i] * value;
            --i;
        }
        return retValue;
    }

    public static byte[] addStringValue(String _content, int length, String charset) {
        if (_content == null) {
            _content = "";
        }
        byte[] content = SocketUtils.getBytes(_content, charset);
        int contentLen = content.length;
        byte[] bufferStream = new byte[length + contentLen];
        byte[] contentLengByte = SocketUtils.addLengthByteValue(contentLen, length);
        int i = 0;
        while (i < length) {
            bufferStream[i] = contentLengByte[i];
            ++i;
        }
        i = 0;
        while (i < contentLen) {
            bufferStream[i + length] = content[i];
            ++i;
        }
        return bufferStream;
    }

    public static byte[] addLengthByteValue(long content, int length) {
        byte[] bufferStream = new byte[length];
        byte[] contentLengByte = new byte[length];
        if (length == 8) {
            contentLengByte[0] = (byte)(content >> 56);
            contentLengByte[1] = (byte)(content >> 48);
            contentLengByte[2] = (byte)(content >> 40);
            contentLengByte[3] = (byte)(content >> 32);
            contentLengByte[4] = (byte)(content >> 24);
            contentLengByte[5] = (byte)(content >> 16);
            contentLengByte[6] = (byte)(content >> 8);
            contentLengByte[7] = (byte)(content >> 0);
        } else if (length == 6) {
            contentLengByte[0] = (byte)(content >> 40);
            contentLengByte[1] = (byte)(content >> 32);
            contentLengByte[2] = (byte)(content >> 24);
            contentLengByte[3] = (byte)(content >> 16);
            contentLengByte[4] = (byte)(content >> 8);
            contentLengByte[5] = (byte)(content >> 0);
        } else if (length == 4) {
            contentLengByte[0] = (byte)(content >> 24);
            contentLengByte[1] = (byte)(content >> 16);
            contentLengByte[2] = (byte)(content >> 8);
            contentLengByte[3] = (byte)(content >> 0);
        } else if (length == 2) {
            contentLengByte[0] = (byte)(content >> 8);
            contentLengByte[1] = (byte)(content >> 0);
        } else if (length == 1) {
            contentLengByte[0] = (byte)(content >> 0);
        }
        int i = 0;
        while (i < length) {
            bufferStream[i] = contentLengByte[length - 1 - i];
            ++i;
        }
        return bufferStream;
    }

    public static String[] getStringsValue(byte[] bufferBytes, int length, String charset) throws ExceptionUtil {
        if (bufferBytes == null || bufferBytes.length == 0 || length <= 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int prePosition = 0;
        do {
            RobotString robotString = SocketUtils.getStringValue(prePosition, bufferBytes, length, charset);
            prePosition = prePosition + length + robotString.getLength();
            list.add(robotString.getValue());
        } while (bufferBytes.length > prePosition);
        String[] ret = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            ret[i] = (String)list.get(i);
            ++i;
        }
        return ret;
    }

    public static long[] getLongsValue(byte[] bufferBytes, int length) throws ExceptionUtil {
        if (bufferBytes == null || bufferBytes.length == 0 || length <= 0) {
            return new long[0];
        }
        ArrayList<Long> list = new ArrayList<Long>();
        int prePosition = 0;
        do {
            long value = SocketUtils.getLongValue(prePosition, bufferBytes, length);
            list.add(new Long(value));
        } while (bufferBytes.length > (prePosition += length));
        long[] ret = new long[list.size()];
        int i = 0;
        while (i < list.size()) {
            ret[i] = (Long)list.get(i);
            ++i;
        }
        return ret;
    }

    public static RobotString getStringValue(int prePosition, byte[] bufferBytes, int length, String charset) throws ExceptionUtil {
        RobotString robotString = new RobotString();
        if (bufferBytes == null || bufferBytes.length == 0) {
            robotString.setValue("");
            robotString.setLength(0);
            return robotString;
        }
        int lenInt = new Long(SocketUtils.getLongValue(prePosition, bufferBytes, length)).intValue();
        byte[] bytes = new byte[lenInt];
        int i = 0;
        while (i < lenInt) {
            int lengthSize = prePosition + length + i;
            if (lengthSize >= bufferBytes.length) {
                String logData = "";
                if (bufferBytes.length < 100) {
                    int j = 0;
                    while (j < bufferBytes.length) {
                        logData = String.valueOf(logData) + " " + bufferBytes[j];
                        ++j;
                    }
                }
                log.error((Object)("\u6570\u7ec4\u8d8a\u754c\uff01" + lenInt + " (" + lengthSize + " " + bufferBytes.length + ") (" + prePosition + " " + length + ") " + logData));
                break;
            }
            bytes[i] = bufferBytes[lengthSize];
            ++i;
        }
        String retStr = SocketUtils.getString(bytes, charset);
        robotString.setValue(retStr);
        robotString.setLength(lenInt);
        return robotString;
    }

    public static String getString(byte[] bytes, String charset) {
        String retStr = "";
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return retStr;
        }
        try {
            retStr = new String(bytes, charset);
        }
        catch (Exception e) {
            log.error((Object)("getContentValue:" + e + " charset:" + charset));
        }
        return retStr;
    }

    public static byte[] getBytes(String _content, String charset) {
        byte[] content = null;
        try {
            content = _content.getBytes(charset);
        }
        catch (Exception e) {
            log.error((Object)("getBytes:" + e + " charset:" + charset));
        }
        return content;
    }

    public static long getLongValue(int prePosition, byte[] bufferBytes, int length) throws ExceptionUtil {
        if (bufferBytes == null || bufferBytes.length == 0) {
            return 0L;
        }
        int len2 = bufferBytes.length;
        if (prePosition + length > len2) {
            int len1 = prePosition + length;
            throw new ExceptionUtil(0, "\u6570\u636e\u603b\u957f\u5ea6\u4e0d\u6b63\u786e\uff01", "\uff08\u5b57\u8282\u957f\u5ea6\u4e0d\u6b63\u786e" + len1 + "/" + len2 + "\uff09");
        }
        byte[] lenBytes = new byte[length];
        int i = 0;
        while (i < length) {
            int len1 = prePosition + length - 1 - i;
            if (len1 > len2 - 1) {
                throw new ExceptionUtil(0, "\u83b7\u53d6\u6570\u636e\u957f\u5ea6\u53d1\u751f\u9519\u8bef\uff01", "\uff08\u5b57\u8282\u957f\u5ea6\u4e0d\u6b63\u786e" + len1 + "/" + len2 + "\uff09");
            }
            lenBytes[i] = bufferBytes[len1];
            ++i;
        }
        long dataLong = SocketUtils.getLongFromBytes(lenBytes);
        return dataLong;
    }

    public static String outInfoDetal(RobotBean robotBean) {
        String retString = "\u53c2\u6570\uff1a" + robotBean.getRobotConfig().getRobothost() + " " + robotBean.getRobotConfig().getRobotport() + " " + robotBean.getRobotConfig().getRobotvalue() + " " + robotBean.getRobotConfig().getCharset() + " " + robotBean.getRobotConfig().getMachineCode();
        retString = String.valueOf(retString) + " " + robotBean.getRobotConfig().getBufferBlock() + " " + robotBean.getRobotConfig().getReadWriteTimeout() + " " + robotBean.getRobotConfig().getLinkTimeout() + " " + robotBean.getRobotConfig().getSaveData();
        retString = String.valueOf(retString) + " \u547d\u4ee4\u7801:" + robotBean.getSendCode();
        if (robotBean.getReturnCode() < 0) {
            retString = String.valueOf(retString) + "  \u8fd4\u56de\u7801\uff1a" + robotBean.getReturnCode();
            try {
                String errorString = SocketUtils.getStringValue(0, robotBean.getReturnBytes(), 2, robotBean.getRobotConfig().getCharset()).getValue();
                retString = String.valueOf(retString) + "  \u8fd4\u56de\u503c\uff1a" + errorString;
            }
            catch (Exception e) {
                log.error((Object)("errInfo4:" + e));
            }
        }
        return "(" + retString + ") ";
    }

    public static String outInfo2(RobotBean robotBean) {
        return " (\u5730\u5740\uff1a" + robotBean.getRobotConfig().getRobothost() + " \u7aef\u53e3\uff1a" + robotBean.getRobotConfig().getRobotport() + ") ";
    }
}

