/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 13;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;

    TimestamptzAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 181, 181, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    TimestamptzAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 181, 181, s, false);
        this.initForDescribe(181, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = 13;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    String getString(int n) throws SQLException {
        String string;
        int n2;
        int n3;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        int n4 = this.columnIndex + this.byteLength * n;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n5 = ((this.rowSpaceByte[0 + n4] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n4] & 0xFF) - 100;
        calendar.set(1, n5);
        calendar.set(2, this.oracleMonth(n4));
        calendar.set(5, this.oracleDay(n4));
        calendar.set(11, this.oracleHour(n4));
        calendar.set(12, this.oracleMin(n4));
        calendar.set(13, this.oracleSec(n4));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n4) & REGIONIDBIT) != 0) {
            n3 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n4));
            if (TIMEZONETAB.checkID(n3 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n4)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n3);
            }
            n2 = TIMEZONETAB.getOffset(calendar, n3);
            calendar.add(10, n2 / 3600000);
            calendar.add(12, n2 % 3600000 / 60000);
            string = new String(ZONEIDMAP.getRegion(n3));
        } else {
            calendar.add(10, this.oracleTZ1(n4) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n4) - OFFSET_MINUTE);
            n3 = this.oracleTZ1(n4) - OFFSET_HOUR;
            n2 = this.oracleTZ2(n4) - OFFSET_MINUTE;
            string = new String(n3 + ":" + n2);
        }
        n5 = calendar.get(1);
        n3 = calendar.get(2) + 1;
        n2 = calendar.get(5);
        int n6 = calendar.get(11);
        int n7 = calendar.get(12);
        int n8 = calendar.get(13);
        int n9 = this.oracleNanos(n4);
        return n5 + "-" + n3 + "-" + n2 + " " + n6 + "." + n7 + "." + n8 + "." + n9 + " " + string;
    }

    Date getDate(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        int n2 = this.columnIndex + this.byteLength * n;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(n2));
        calendar.set(5, this.oracleDay(n2));
        calendar.set(11, this.oracleHour(n2));
        calendar.set(12, this.oracleMin(n2));
        calendar.set(13, this.oracleSec(n2));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n2) & REGIONIDBIT) != 0) {
            int n4 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n2));
            if (TIMEZONETAB.checkID(n4 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n2)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n4);
            }
            int n5 = TIMEZONETAB.getOffset(calendar, n4);
            calendar.add(10, n5 / 3600000);
            calendar.add(12, n5 % 3600000 / 60000);
        } else {
            calendar.add(10, this.oracleTZ1(n2) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n2) - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        return new Date(l);
    }

    Time getTime(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        int n2 = this.columnIndex + this.byteLength * n;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(n2));
        calendar.set(5, this.oracleDay(n2));
        calendar.set(11, this.oracleHour(n2));
        calendar.set(12, this.oracleMin(n2));
        calendar.set(13, this.oracleSec(n2));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n2) & REGIONIDBIT) != 0) {
            int n4 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n2));
            if (TIMEZONETAB.checkID(n4 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n2)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n4);
            }
            int n5 = TIMEZONETAB.getOffset(calendar, n4);
            calendar.add(10, n5 / 3600000);
            calendar.add(12, n5 % 3600000 / 60000);
        } else {
            calendar.add(10, this.oracleTZ1(n2) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n2) - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        return new Time(l);
    }

    Timestamp getTimestamp(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        int n2 = this.columnIndex + this.byteLength * n;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(n2));
        calendar.set(5, this.oracleDay(n2));
        calendar.set(11, this.oracleHour(n2));
        calendar.set(12, this.oracleMin(n2));
        calendar.set(13, this.oracleSec(n2));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n2) & REGIONIDBIT) != 0) {
            int n4 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n2));
            if (TIMEZONETAB.checkID(n4 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n2)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n4);
            }
            int n5 = TIMEZONETAB.getOffset(calendar, n4);
            calendar.add(10, n5 / 3600000);
            calendar.add(12, n5 % 3600000 / 60000);
        } else {
            calendar.add(10, this.oracleTZ1(n2) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n2) - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l);
        int n6 = this.oracleNanos(n2);
        timestamp.setNanos(n6);
        return timestamp;
    }

    Object getObject(int n) throws SQLException {
        return this.getTIMESTAMPTZ(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getTIMESTAMPTZ(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getTIMESTAMPTZ(n);
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            byte[] byArray = new byte[13];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, 13);
            tIMESTAMPTZ = new TIMESTAMPTZ(byArray);
        }
        return tIMESTAMPTZ;
    }

    static int setHighOrderbits(int n) {
        return (n & 0x1FC0) >> 6;
    }

    static int setLowOrderbits(int n) {
        return (n & 0x3F) << 2;
    }

    static int getHighOrderbits(int n) {
        return (n & 0x7F) << 6;
    }

    static int getLowOrderbits(int n) {
        return (n & 0xFC) >> 2;
    }
}

