/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

class T4CMAREngine {
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = 64;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    short versionNumber = (short)-1;
    byte proSvrVer;
    InputStream inStream;
    OutputStream outStream;
    final byte[] ignored = new byte[255];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final byte[] tmpBuffer5 = new byte[5];
    final byte[] tmpBuffer6 = new byte[6];
    final byte[] tmpBuffer7 = new byte[7];
    final byte[] tmpBuffer8 = new byte[8];
    final int[] retLen = new int[1];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:18:53_PDT_2005";

    static String toHex(long l, int n) {
        String string;
        switch (n) {
            case 1: {
                string = "00" + Long.toString(l & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return T4CMAREngine.toHex(l >> 32, 4) + T4CMAREngine.toHex(l, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n);
    }

    static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    static String toHex(short s) {
        return T4CMAREngine.toHex(s, 2);
    }

    static String toHex(int n) {
        return T4CMAREngine.toHex(n, 4);
    }

    static String toHex(byte[] byArray, int n) {
        if (byArray == null) {
            return "null";
        }
        if (n > byArray.length) {
            return "byte array not long enough";
        }
        String string = "[";
        int n2 = Math.min(64, n);
        for (int i = 0; i < n2; ++i) {
            string = string + T4CMAREngine.toHex(byArray[i]) + " ";
        }
        if (n2 < n) {
            string = string + "...";
        }
        return string + "]";
    }

    static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return T4CMAREngine.toHex(byArray, byArray.length);
    }

    T4CMAREngine(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            DatabaseError.throwSqlException(433);
        }
        this.net = communication;
        try {
            this.inStream = communication.getInputStream();
            this.outStream = communication.getOutputStream();
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new T4CTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    void initBuffers() {
    }

    void marshalSB1(byte by) throws IOException {
        this.outStream.write(by);
    }

    void marshalUB1(short s) throws IOException {
        this.outStream.write((byte)(s & 0xFF));
    }

    void marshalSB2(short s) throws IOException {
        byte by = this.value2Buffer(s, this.tmpBuffer2, (byte)1);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer2, 0, by);
        }
    }

    void marshalUB2(int n) throws IOException {
        this.marshalSB2((short)(n & 0xFFFF));
    }

    void marshalSB4(int n) throws IOException {
        byte by = this.value2Buffer(n, this.tmpBuffer4, (byte)2);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer4, 0, by);
        }
    }

    void marshalUB4(long l) throws IOException {
        this.marshalSB4((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    void marshalSB8(long l) throws IOException {
        byte by = this.value2Buffer(l, this.tmpBuffer8, (byte)3);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer8, 0, by);
        }
    }

    void marshalSWORD(int n) throws IOException {
        this.marshalSB4(n);
    }

    void marshalUWORD(long l) throws IOException {
        this.marshalSB4((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray);
        }
    }

    void marshalB1Array(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray, n, n2);
        }
    }

    void marshalUB4Array(long[] lArray) throws IOException {
        for (int i = 0; i < lArray.length; ++i) {
            this.marshalSB4((int)(lArray[i] & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    void marshalO2U(boolean bl) throws IOException {
        if (bl) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    void marshalCHR(byte[] byArray) throws IOException {
        this.marshalCHR(byArray, 0, byArray.length);
    }

    void marshalCHR(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(byArray, n, n2);
            } else {
                this.outStream.write(byArray, n, n2);
            }
        }
    }

    void marshalCLR(byte[] byArray, int n) throws IOException {
        this.marshalCLR(byArray, 0, n);
    }

    void marshalCLR(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 64) {
            int n3;
            int n4 = 0;
            this.outStream.write(-2);
            do {
                int n5;
                n3 = (n5 = n2 - n4) > 64 ? 64 : n5;
                this.outStream.write((byte)(n3 & 0xFF));
                this.outStream.write(byArray, n + n4, n3);
            } while ((n4 += n3) < n2);
            this.outStream.write(0);
        } else {
            this.outStream.write((byte)(n2 & 0xFF));
            if (byArray.length != 0) {
                this.outStream.write(byArray, n, n2);
            }
        }
    }

    void marshalKEYVAL(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2, byte[] byArray3, int n) throws SQLException, IOException {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != null && nArray[i] > 0) {
                this.marshalUB4(nArray[i]);
                this.marshalCLR(byArray[i], 0, nArray[i]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray2[i] != null && nArray2[i] > 0) {
                this.marshalUB4(nArray2[i]);
                this.marshalCLR(byArray2[i], 0, nArray2[i]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray3[i] != 0) {
                this.marshalUB4(1L);
                continue;
            }
            this.marshalUB4(0L);
        }
    }

    void marshalKEYVAL(byte[][] byArray, byte[][] byArray2, byte[] byArray3, int n) throws SQLException, IOException {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != null) {
                nArray[i] = byArray[i].length;
            }
            if (byArray2[i] == null) continue;
            nArray2[i] = byArray2[i].length;
        }
        this.marshalKEYVAL(byArray, nArray, byArray2, nArray2, byArray3, n);
    }

    void marshalDALC(byte[] byArray) throws SQLException, IOException {
        if (byArray == null || byArray.length < 1) {
            this.outStream.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & byArray.length);
            this.marshalCLR(byArray, byArray.length);
        }
    }

    void addPtr(byte by) throws IOException {
        if ((this.types.rep[4] & 1) > 0) {
            this.outStream.write(by);
        } else {
            byte by2 = this.value2Buffer(by, this.tmpBuffer4, (byte)4);
            if (by2 != 0) {
                this.outStream.write(this.tmpBuffer4, 0, by2);
            }
        }
    }

    byte value2Buffer(int n, byte[] byArray, byte by) throws IOException {
        boolean bl = true;
        byte by2 = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            byArray[by2] = (byte)(n >>> 8 * i & 0xFF);
            if ((this.types.rep[by] & 1) > 0) {
                if (bl && byArray[by2] == 0) continue;
                bl = false;
                by2 = (byte)(by2 + 1);
                continue;
            }
            by2 = (byte)(by2 + 1);
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }

    byte value2Buffer(long l, byte[] byArray, byte by) throws IOException {
        boolean bl = true;
        byte by2 = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            byArray[by2] = (byte)(l >>> 8 * i & 0xFFL);
            if ((this.types.rep[by] & 1) > 0) {
                if (bl && byArray[by2] == 0) continue;
                bl = false;
                by2 = (byte)(by2 + 1);
                continue;
            }
            by2 = (byte)(by2 + 1);
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }

    void reverseArray(byte[] byArray, byte by) {
        for (int i = 0; i < by / 2; ++i) {
            byte by2 = byArray[i];
            byArray[i] = byArray[by - 1 - i];
            byArray[by - 1 - i] = by2;
        }
    }

    byte unmarshalSB1() throws SQLException, IOException {
        byte by = (byte)this.unmarshalUB1();
        return by;
    }

    short unmarshalUB1() throws SQLException, IOException {
        short s = 0;
        try {
            s = (short)this.inStream.read();
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        if (s < 0) {
            DatabaseError.throwSqlException(410);
        }
        return s;
    }

    short unmarshalSB2() throws SQLException, IOException {
        short s = (short)this.unmarshalUB2();
        return s;
    }

    int unmarshalUB2() throws SQLException, IOException {
        int n = (int)this.buffer2Value((byte)1);
        return n & 0xFFFF;
    }

    int unmarshalUCS2(byte[] byArray, long l) throws SQLException, IOException {
        int n = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((n & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(n & 0xFF);
        if (l + 1L < (long)byArray.length) {
            byArray[(int)l] = this.tmpBuffer2[0];
            byArray[(int)l + 1] = this.tmpBuffer2[1];
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    int unmarshalSB4() throws SQLException, IOException {
        int n = (int)this.unmarshalUB4();
        return n;
    }

    long unmarshalUB4() throws SQLException, IOException {
        long l = this.buffer2Value((byte)2);
        return l;
    }

    int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        long l = this.buffer2Value((byte)2, new ByteArrayInputStream(byArray));
        return (int)l;
    }

    long unmarshalSB8() throws SQLException, IOException {
        long l = this.buffer2Value((byte)3);
        return l;
    }

    int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        int n = this.unmarshalSB4(byArray);
        return n;
    }

    int unmarshalSWORD() throws SQLException, IOException {
        int n = (int)this.unmarshalUB4();
        return n;
    }

    long unmarshalUWORD() throws SQLException, IOException {
        long l = this.unmarshalUB4();
        return l;
    }

    byte[] unmarshalNBytes(int n) throws SQLException, IOException {
        byte[] byArray = new byte[n];
        try {
            if (this.inStream.read(byArray) < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return byArray;
    }

    int unmarshalNBytes(byte[] byArray, int n, int n2) throws SQLException, IOException {
        int n3;
        for (n3 = 0; n3 < n2; n3 += this.getNBytes(byArray, n + n3, n2 - n3)) {
        }
        return n3;
    }

    int getNBytes(byte[] byArray, int n, int n2) throws SQLException, IOException {
        int n3 = 0;
        try {
            n3 = this.inStream.read(byArray, n, n2);
            if (n3 < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return n3;
    }

    byte[] getNBytes(int n) throws SQLException, IOException {
        byte[] byArray = new byte[n];
        try {
            if (this.inStream.read(byArray) < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return byArray;
    }

    byte[] unmarshalTEXT(int n) throws SQLException, IOException {
        byte[] byArray;
        int n2 = 0;
        byte[] byArray2 = new byte[n];
        while (n2 < n) {
            try {
                if (this.inStream.read(byArray2, n2, 1) < 0) {
                    DatabaseError.throwSqlException(410);
                }
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            if (byArray2[n2++] != 0) continue;
        }
        if (byArray2.length == --n2) {
            byArray = byArray2;
        } else {
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
        }
        return byArray;
    }

    byte[] unmarshalCHR(int n) throws SQLException, IOException {
        byte[] byArray = null;
        if (this.types.isConvNeeded()) {
            byArray = this.unmarshalCLR(n, this.retLen);
            if (byArray.length != this.retLen[0]) {
                byte[] byArray2 = new byte[this.retLen[0]];
                System.arraycopy(byArray, 0, byArray2, 0, this.retLen[0]);
                byArray = byArray2;
            }
        } else {
            byArray = this.getNBytes(n);
        }
        return byArray;
    }

    void unmarshalCLR(byte[] byArray, int n, int[] nArray) throws SQLException, IOException {
        this.unmarshalCLR(byArray, n, nArray, Integer.MAX_VALUE);
    }

    void unmarshalCLR(byte[] byArray, int n, int[] nArray, int n2) throws SQLException, IOException {
        short s = 0;
        int n3 = n;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        s = this.unmarshalUB1();
        if (s < 0) {
            DatabaseError.throwSqlException(401);
        }
        if (s == 0) {
            nArray[0] = 0;
            return;
        }
        if (this.escapeSequenceNull(s)) {
            nArray[0] = 0;
            return;
        }
        if (s != 254) {
            n5 = Math.min(n2 - n4, s);
            n3 = this.unmarshalBuffer(byArray, n3, n5);
            n4 += n5;
            int n7 = s - n5;
            if (n7 > 0) {
                this.unmarshalBuffer(this.ignored, 0, n7);
            }
        } else {
            n6 = -1;
            block5: while (n6 == -1 || (s = this.unmarshalUB1()) > 0) {
                if (s == 254) {
                    switch (n6) {
                        case -1: {
                            n6 = 1;
                            continue block5;
                        }
                        case 1: {
                            n6 = 0;
                            break;
                        }
                        case 0: {
                            if (bl) {
                                n6 = 0;
                                break;
                            }
                            n6 = 0;
                            continue block5;
                        }
                    }
                }
                if (n3 == -1) {
                    this.unmarshalBuffer(this.ignored, 0, s);
                } else {
                    n5 = Math.min(n2 - n4, s);
                    n3 = this.unmarshalBuffer(byArray, n3, n5);
                    n4 += n5;
                    int n8 = s - n5;
                    if (n8 > 0) {
                        this.unmarshalBuffer(this.ignored, 0, n8);
                    }
                }
                n6 = 0;
                if (s <= 252) continue;
                bl = true;
            }
        }
        if (nArray != null) {
            nArray[0] = n3 != -1 ? n4 : byArray.length - n;
        }
    }

    byte[] unmarshalCLR(int n, int[] nArray) throws SQLException, IOException {
        byte[] byArray = new byte[n * this.conv.c2sNlsRatio];
        this.unmarshalCLR(byArray, 0, nArray, n);
        return byArray;
    }

    int unmarshalKEYVAL(byte[][] byArray, byte[][] byArray2, int n) throws SQLException, IOException {
        byte[] byArray3 = new byte[1000];
        int[] nArray = new int[1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.unmarshalSB4();
            if (n3 > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray[i] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray[i], 0, nArray[0]);
            }
            if ((n3 = this.unmarshalSB4()) > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray2[i] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray2[i], 0, nArray[0]);
            }
            n2 = this.unmarshalSB4();
        }
        byArray3 = null;
        return n2;
    }

    int unmarshalBuffer(byte[] byArray, int n, int n2) throws SQLException, IOException {
        if (n2 <= 0) {
            return n;
        }
        if (byArray.length < n + n2) {
            this.unmarshalNBytes(byArray, n, byArray.length - n);
            this.unmarshalNBytes(this.ignored, 0, n + n2 - byArray.length);
            n = -1;
        } else {
            this.unmarshalNBytes(byArray, n, n2);
            n += n2;
        }
        return n;
    }

    byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short s = 0;
        short s2 = 0;
        byte[] byArray = null;
        Vector<byte[]> vector = new Vector<byte[]>(10, 10);
        short s3 = this.unmarshalUB1();
        if (s3 < 0) {
            DatabaseError.throwSqlException(401);
        }
        if (s3 == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(s3)) {
            byte[] byArray2;
            if (s3 == 254) {
                while ((s = this.unmarshalUB1()) > 0) {
                    if (s == 254 && this.types.isServerConversion()) continue;
                    s2 = (short)(s2 + s);
                    byArray2 = new byte[s];
                    this.unmarshalBuffer(byArray2, 0, s);
                    vector.addElement(byArray2);
                }
            } else {
                s2 = s3;
                byArray2 = new byte[s3];
                this.unmarshalBuffer(byArray2, 0, s3);
                vector.addElement(byArray2);
            }
            byArray = new byte[s2];
            int n = 0;
            while (vector.size() > 0) {
                int n2 = ((byte[])vector.elementAt(0)).length;
                System.arraycopy(vector.elementAt(0), 0, byArray, n, n2);
                n += n2;
                vector.removeElementAt(0);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    boolean escapeSequenceNull(int n) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 253: {
                DatabaseError.throwSqlException(401);
            }
            case 255: {
                bl = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return bl;
    }

    int processIndicator(boolean bl, int n) throws SQLException, IOException {
        short s = this.unmarshalSB2();
        int n2 = 0;
        if (!bl) {
            n2 = s == 0 ? n : (s == -2 || s > 0 ? (int)s : 65536 + s);
        }
        return n2;
    }

    long unmarshalDALC(byte[] byArray, int n, int[] nArray) throws SQLException, IOException {
        long l = this.unmarshalUB4();
        if (l > 0L) {
            this.unmarshalCLR(byArray, n, nArray);
        }
        return l;
    }

    byte[] unmarshalDALC() throws SQLException, IOException {
        long l = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, this.retLen)) == null) {
                DatabaseError.throwSqlException(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        long l = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, nArray)) == null) {
                DatabaseError.throwSqlException(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    long buffer2Value(byte by) throws SQLException, IOException {
        byte[] byArray;
        int n = 0;
        long l = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            try {
                n = this.inStream.read();
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            if ((n & 0x80) > 0) {
                n &= 0x7F;
                bl = true;
            }
            if (n < 0) {
                DatabaseError.throwSqlException(410);
            }
            if (n == 0) {
                return 0L;
            }
            if (by == 1 && n > 2 || by == 2 && n > 4 || by == 3 && n > 8) {
                DatabaseError.throwSqlException(412);
            }
        } else if (by == 1) {
            n = 2;
        } else if (by == 2) {
            n = 4;
        } else if (by == 3) {
            n = 8;
        }
        switch (n) {
            case 1: {
                byArray = this.tmpBuffer1;
                break;
            }
            case 2: {
                byArray = this.tmpBuffer2;
                break;
            }
            case 3: {
                byArray = this.tmpBuffer3;
                break;
            }
            case 4: {
                byArray = this.tmpBuffer4;
                break;
            }
            case 5: {
                byArray = this.tmpBuffer5;
                break;
            }
            case 6: {
                byArray = this.tmpBuffer6;
                break;
            }
            case 7: {
                byArray = this.tmpBuffer7;
                break;
            }
            case 8: {
                byArray = this.tmpBuffer8;
                break;
            }
            default: {
                byArray = new byte[n];
            }
        }
        try {
            if (this.inStream.read(byArray) < 0) {
                DatabaseError.throwSqlException(410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        for (int i = 0; i < byArray.length; ++i) {
            long l2 = (this.types.rep[by] & 2) > 0 ? (long)(byArray[byArray.length - 1 - i] & 0xFF) & 0xFFL : (long)(byArray[i] & 0xFF) & 0xFFL;
            l |= l2 << 8 * (byArray.length - 1 - i);
        }
        if (by != 3) {
            l &= 0xFFFFFFFFFFFFFFFFL;
        }
        if (bl) {
            l = -l;
        }
        return l;
    }

    long buffer2Value(byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        byte[] byArray;
        int n = 0;
        long l = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            n = byteArrayInputStream.read();
            if ((n & 0x80) > 0) {
                n &= 0x7F;
                bl = true;
            }
            if (n < 0) {
                DatabaseError.throwSqlException(410);
            }
            if (n == 0) {
                return 0L;
            }
            if (by == 1 && n > 2 || by == 2 && n > 4) {
                DatabaseError.throwSqlException(412);
            }
        } else if (by == 1) {
            n = 2;
        } else if (by == 2) {
            n = 4;
        }
        if (byteArrayInputStream.read(byArray = new byte[n]) < 0) {
            DatabaseError.throwSqlException(410);
        }
        for (int i = 0; i < byArray.length; ++i) {
            short s = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - i] & 0xFF) : (short)(byArray[i] & 0xFF);
            l |= (long)(s << 8 * (byArray.length - 1 - i));
        }
        l &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l = -l;
        }
        return l;
    }
}

