/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;

public class MetadataInitializer {
    private XMLDBMSMap map;
    private static String DEFAULT = "Default";

    public MetadataInitializer(XMLDBMSMap xMLDBMSMap) {
        if (xMLDBMSMap == null) {
            throw new IllegalArgumentException("map argument must not be null.");
        }
        this.map = xMLDBMSMap;
    }

    public void initializeMetadata(String string, Connection connection, boolean bl) throws XMLMiddlewareException {
        if (string == null) {
            string = DEFAULT;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Enumeration enumeration = this.map.getTables();
            while (enumeration.hasMoreElements()) {
                Table table = (Table)enumeration.nextElement();
                if (table.getDatabaseName().equals(string)) {
                    this.addColumnMetadata(databaseMetaData, table, bl);
                    continue;
                }
                if (!bl) continue;
                throw new XMLMiddlewareException("Connection not found for database: " + table.getDatabaseName());
            }
            return;
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
    }

    public void initializeMetadata(String[] stringArray, Connection[] connectionArray, boolean bl) throws XMLMiddlewareException {
        Hashtable<String, Connection> hashtable = new Hashtable<String, Connection>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n] == null ? DEFAULT : stringArray[n];
            hashtable.put(string, connectionArray[n]);
            ++n;
        }
        Enumeration enumeration = this.map.getTables();
        while (enumeration.hasMoreElements()) {
            Table table = (Table)enumeration.nextElement();
            Connection connection = (Connection)hashtable.get(table.getDatabaseName());
            if (connection != null) {
                DatabaseMetaData databaseMetaData;
                try {
                    databaseMetaData = connection.getMetaData();
                }
                catch (SQLException sQLException) {
                    throw new XMLMiddlewareException(sQLException);
                }
                this.addColumnMetadata(databaseMetaData, table, bl);
                continue;
            }
            if (!bl) continue;
            throw new XMLMiddlewareException("Connection not found for database: " + table.getDatabaseName());
        }
    }

    public void initializeMetadata(String string, String string2, String string3, String string4, ResultSet resultSet) throws XMLMiddlewareException {
        Table table = this.map.getTable(string, string2, string3, string4);
        if (table == null) {
            throw new XMLMiddlewareException("Table not found: " + Table.getUniversalName(string, string2, string3, string4));
        }
        this.initializeMetadata(table, resultSet);
    }

    public void initializeMetadata(Table table, ResultSet resultSet) throws XMLMiddlewareException {
        this.initColumns(table);
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = 1;
            while (n <= resultSetMetaData.getColumnCount()) {
                Column column = table.getColumn(resultSetMetaData.getColumnName(n));
                if (column != null) {
                    this.setColumnMetadata(column, n, resultSetMetaData.getColumnType(n), resultSetMetaData.isNullable(n), resultSetMetaData.getColumnDisplaySize(n), resultSetMetaData.getPrecision(n), resultSetMetaData.getScale(n));
                }
                ++n;
            }
            return;
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
    }

    private void addColumnMetadata(DatabaseMetaData databaseMetaData, Table table, boolean bl) throws XMLMiddlewareException {
        boolean bl2 = false;
        int n = 1;
        try {
            Column column;
            char[] cArray = databaseMetaData.getSearchStringEscape().toCharArray();
            String string = databaseMetaData.supportsCatalogsInDataManipulation() ? table.getCatalogName() : null;
            String string2 = databaseMetaData.supportsSchemasInDataManipulation() ? this.escapeDBName(table.getSchemaName(), cArray) : null;
            String string3 = this.escapeDBName(table.getTableName(), cArray);
            ResultSet resultSet = databaseMetaData.getColumns(string, string2, string3, null);
            while (resultSet.next()) {
                int n2;
                bl2 = true;
                this.initColumns(table);
                column = table.getColumn(resultSet.getString(4));
                if (column == null) continue;
                short s = resultSet.getShort(5);
                int n3 = n2 = resultSet.getInt(7);
                int n4 = resultSet.getInt(9);
                int n5 = resultSet.getInt(11);
                this.setColumnMetadata(column, n++, s, n5, n2, n3, n4);
            }
            resultSet.close();
            if (bl && !bl2) {
                throw new XMLMiddlewareException("Table not found: " + table.getUniversalName() + ". Check that the table exists, that its name is spelled correctly, " + "and that the case used in the map document exactly matches the " + "case used in the database. This might be different than the case " + "you used when creating the table.");
            }
            column = table.checkMetadata();
            if (column != null) {
                throw new XMLMiddlewareException("Column " + column.getName() + " not found in table " + table.getUniversalName() + ". Check that the column exists, " + "that its name is spelled correctly, and that the case " + "used in the map document exactly matches the case used in the " + "database. This might be different than the case you used when " + "creating the column.");
            }
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
    }

    private String escapeDBName(String string, char[] cArray) {
        int n = 0;
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = new char[string.length() * (cArray.length + 1)];
        int n2 = 0;
        while (n2 < string.length()) {
            if (cArray2[n2] == '_' || cArray2[n2] == '%') {
                int n3 = 0;
                while (n3 < cArray.length) {
                    cArray3[n] = cArray[n3];
                    ++n;
                    ++n3;
                }
            }
            cArray3[n] = cArray2[n2];
            ++n;
            ++n2;
        }
        return new String(cArray3, 0, n);
    }

    private void setColumnMetadata(Column column, int n, int n2, int n3, int n4, int n5, int n6) {
        column.setResultSetIndex(n);
        n2 = this.fixDateTimeType(n2);
        column.setType(n2);
        column.setNullability(n3);
        StringFormatter stringFormatter = column.getFormatter();
        if (stringFormatter == null || !stringFormatter.canConvert(n2)) {
            column.setFormatter(this.map.getDefaultFormatter(n2));
        }
        switch (n2) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                column.setLength(n4);
                return;
            }
            case 2: 
            case 3: {
                column.setPrecision(n5);
                column.setScale(n6);
                return;
            }
        }
    }

    private void initColumns(Table table) {
        Enumeration enumeration = table.getColumns();
        while (enumeration.hasMoreElements()) {
            Column column = (Column)enumeration.nextElement();
            column.resetMetadata();
        }
    }

    private int fixDateTimeType(int n) {
        switch (n) {
            case 9: {
                return 91;
            }
            case 10: {
                return 92;
            }
            case 11: {
                return 93;
            }
        }
        return n;
    }
}

