/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps;

import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.MapBase;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmlutils.XMLName;

public class PropertyMapBase
extends MapBase {
    public static final int UNKNOWN = 0;
    public static final int ELEMENTTYPE = 1;
    public static final int ATTRIBUTE = 2;
    public static final int PCDATA = 3;
    private XMLName xmlName;
    private Column column;
    private int type = 0;
    private boolean containsXML = false;
    private OrderInfo orderInfo;
    private boolean isTokenList = false;
    private OrderInfo tokenListOrderInfo;

    PropertyMapBase() {
    }

    public final XMLName getXMLName() {
        return this.xmlName;
    }

    public final int getType() {
        return this.type;
    }

    void setXMLName(String string, String string2, int n) {
        if (n == 3 && (string != null || string2 != null)) {
            throw new IllegalArgumentException("URI and local name must be null when type is PCDATA.");
        }
        XMLName xMLName = n == 3 ? null : XMLName.create(string, string2);
        this.setXMLName(xMLName, n);
    }

    void setXMLName(XMLName xMLName, int n) {
        if (n == 1 || n == 2) {
            MapBase.checkArgNull(xMLName, "xmlName");
        } else if (n == 3) {
            if (xMLName != null) {
                throw new IllegalArgumentException("xmlName name must be null when type is PCDATA.");
            }
        } else {
            throw new IllegalArgumentException("Type must be ELEMENTTYPE, ATTRIBUTE, or PCDATA.");
        }
        this.xmlName = xMLName;
        this.type = n;
        if (n != 1) {
            this.containsXML = false;
        }
    }

    public final Column getColumn() {
        return this.column;
    }

    void setColumn(Column column) {
        MapBase.checkArgNull(column, "column");
        this.column = column;
    }

    public final boolean containsXML() {
        return this.containsXML;
    }

    public void setContainsXML(boolean bl) {
        if (this.type != 1) {
            throw new IllegalStateException("Can call setContainsXML only for element types.");
        }
        this.containsXML = bl;
    }

    public final OrderInfo getOrderInfo() {
        return this.orderInfo;
    }

    public void setOrderInfo(OrderInfo orderInfo) {
        if (this.type == 2) {
            throw new IllegalStateException("Cannot call setOrderInfo(OrderInfo) on PropertyMaps for attributes.");
        }
        this.orderInfo = orderInfo;
    }

    public final OrderInfo getTokenListOrderInfo() {
        return this.tokenListOrderInfo;
    }

    public void setTokenListOrderInfo(OrderInfo orderInfo) {
        if (!this.isTokenList) {
            throw new IllegalStateException("Cannot call setTokenListOrderInfo(OrderInfo) when the property being mapped is not a token list.");
        }
        this.tokenListOrderInfo = orderInfo;
    }

    public final boolean isTokenList() {
        return this.isTokenList;
    }

    public void setIsTokenList(boolean bl) {
        this.isTokenList = bl;
        this.tokenListOrderInfo = null;
    }
}

