/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler.servlet;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.Base64Util;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.RemoteAddrUtil;
import com.trs.presentation.util.LoginHelper;
import com.trs.presentation.util.ResponseHelper;
import com.trs.webframework.controler.servlet.CheckNetworkControler;
import com.trs.webframework.controler.servlet.MlfMessage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class LoginServiceControler
extends HttpServlet {
    private static Logger logger = Logger.getLogger(LoginServiceControler.class);
    private static final long serialVersionUID = 1L;
    private static final long SESSION_EXPIRE = 30L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo;
        block10: {
            request.setCharacterEncoding("UTF-8");
            response.setContentType("text/html; charset=UTF-8");
            ContextHelper.setLoginUser(User.getSystem());
            pathInfo = request.getPathInfo();
            try {
                if ("/applogin".equals(pathInfo)) {
                    this.doAppLogin(request, response);
                    return;
                }
                if ("/login".equals(pathInfo)) {
                    try {
                        this.login8531(request, response, true);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    return;
                }
                if ("/checkLogin".equals(pathInfo)) {
                    this.checkLogin(request, response);
                    return;
                }
                if ("/logout".equals(pathInfo)) {
                    this.logout(request, response);
                    return;
                }
                if (!"/login8531".equals(pathInfo)) break block10;
                try {
                    this.login8531(request, response, false);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                return;
            }
            catch (WCMException ex) {
                logger.error((Object)ex.getMyMessage(), (Throwable)ex);
                return;
            }
        }
        logger.error((Object)("\u60a8\u5728\u8bf7\u6c42\u5565\uff1a" + pathInfo));
        this.write(response, "\u6b22\u8fce\u8bbf\u95ee\uff01");
    }

    private void login8531(HttpServletRequest request, HttpServletResponse response, boolean _isWCM) throws IOException, DocumentException, WCMException {
        ServletContext context = this.getServletContext();
        LoginHelper oLoginHelper = new LoginHelper(request, context);
        String UserName = request.getParameter("UserName");
        if (CMyString.isEmpty(UserName = Base64Util.decode(UserName))) {
            MlfMessage mlfmsg = new MlfMessage(3, "\u8bf7\u586b\u5199\u7528\u6237\u540d\uff01");
            this.write(response, mlfmsg.toJSONString());
            return;
        }
        String Password = request.getParameter("Password");
        if (CMyString.isEmpty(Password = Base64Util.decode(Password))) {
            MlfMessage mlfmsg = new MlfMessage(3, "\u8bf7\u586b\u5199\u5bc6\u7801\uff01");
            this.write(response, mlfmsg.toJSONString());
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(UserName + "||" + Password));
        }
        if (!this.verifyCode(request, response)) {
            return;
        }
        User oCurrUser = User.findByName(UserName);
        if (null == oCurrUser) {
            MlfMessage mlfmsg = new MlfMessage(3, "\u5f53\u524d\u7528\u6237\u540d\u4e0d\u5b58\u5728");
            this.write(response, mlfmsg.toJSONString());
            return;
        }
        int code = 9999;
        try {
            code = oLoginHelper.login(UserName, Password);
        }
        catch (WCMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            String message = e.getMessage();
            if (e.getCause() != null) {
                Throwable cause = e.getCause();
                message = cause.getMessage();
            }
            MlfMessage mlfmsg = new MlfMessage(3, "\u767b\u5f55\u5931\u8d25\uff01\u539f\u56e0\u3010" + message + "\u3011");
            this.write(response, mlfmsg.toJSONString());
            return;
        }
        String msg = LoginHelper.getErrorMsg(code);
        if (code == 30) {
            User loginUser = oLoginHelper.getLoginUser();
            ContextHelper.clear();
            ContextHelper.initContext(loginUser);
            MlfMessage mlfmsg = new MlfMessage(1, "\u767b\u5f55\u6210\u529f\uff01");
            this.write(response, mlfmsg.toJSONString());
            return;
        }
        MlfMessage mlfmsg = new MlfMessage(3, msg);
        this.write(response, mlfmsg.toJSONString());
    }

    private boolean verifyCode(HttpServletRequest request, HttpServletResponse response) {
        String sRemoteAddr = RemoteAddrUtil.getRemoteAddr(request);
        if (this.isLocalAreaNetwork(sRemoteAddr)) {
            String sCode = request.getParameter("Code");
            if (CMyString.isEmpty(sCode = Base64Util.decode(sCode))) {
                MlfMessage mlfmsg = new MlfMessage(3, "\u8bf7\u586b\u5199\u9a8c\u8bc1\u7801\uff01");
                this.write(response, mlfmsg.toJSONString());
                return false;
            }
            String code = (String)request.getSession(true).getAttribute("rand");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("request get code:" + sCode + ",session get code:" + code));
            }
            if (CMyString.isEmpty(code)) {
                MlfMessage mlfmsg = new MlfMessage(3, "\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff01");
                this.write(response, mlfmsg.toJSONString());
                return false;
            }
            if (!code.equalsIgnoreCase(sCode)) {
                MlfMessage mlfmsg = new MlfMessage(3, "\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
                this.write(response, mlfmsg.toJSONString());
                return false;
            }
        }
        return true;
    }

    private boolean isLocalAreaNetwork(String _remoteAddr) {
        boolean isArea = true;
        for (String sAreaNet : CheckNetworkControler.AREANET) {
            if (this.isAllowIP(sAreaNet, _remoteAddr)) continue;
            isArea = false;
        }
        return isArea;
    }

    private boolean isAllowIP(String _sStandardAddr, String _sRemoteAddr) {
        if (CMyString.isEmpty(_sStandardAddr)) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("_sStandardAddr:" + _sStandardAddr + ";_sRemoteAddr:" + _sRemoteAddr));
        }
        Object[] pAllowIPList = _sStandardAddr.split("\\.");
        String[] pIPList = _sRemoteAddr.split("\\.");
        Object[] pRemoteIPList = new String[]{pIPList[0], pIPList[1]};
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("_sStandardAddr:" + Arrays.toString(pAllowIPList) + ";_sRemoteAddr:" + Arrays.toString(pRemoteIPList)));
        }
        for (int j = 0; j < pRemoteIPList.length; ++j) {
            if (pRemoteIPList[j].equals(pAllowIPList[j])) continue;
            return true;
        }
        return false;
    }

    private void logout(HttpServletRequest request, HttpServletResponse response) throws WCMException {
        User loginUser;
        ServletContext context = this.getServletContext();
        ResponseHelper rspsHelper = new ResponseHelper(response);
        rspsHelper.initCurrentPage(request);
        LoginHelper oLoginHelper = new LoginHelper(request, context);
        if (!oLoginHelper.checkLogin()) {
            loginUser = ContextHelper.getLoginUser();
            ContextHelper.clear();
        } else {
            loginUser = oLoginHelper.getLoginUser();
            ContextHelper.initContext(loginUser);
            oLoginHelper.logout();
        }
        response.setHeader("TRSNotLogin", "true");
        request.getSession().invalidate();
        MlfMessage mlfmsg = new MlfMessage(1, "\u9000\u51fa\u6210\u529f\uff01");
        this.write(response, mlfmsg.toJSONString());
    }

    private void doAppLogin(HttpServletRequest request, HttpServletResponse response) throws WCMException {
        String UserName;
        ServletContext context = this.getServletContext();
        LoginHelper oLoginHelper = new LoginHelper(request, context);
        if (oLoginHelper.checkLogin()) {
            oLoginHelper.logout();
        }
        if (CMyString.isEmpty(UserName = request.getParameter("UserName"))) {
            MlfMessage mlfmsg = new MlfMessage(3, "\u8bf7\u586b\u5199\u7528\u6237\u540d\uff01");
            this.write(response, mlfmsg.toJSONString());
            return;
        }
        String Password = request.getParameter("Password");
        if (CMyString.isEmpty(Password)) {
            MlfMessage mlfmsg = new MlfMessage(3, "\u8bf7\u586b\u5199\u5bc6\u7801\uff01");
            this.write(response, mlfmsg.toJSONString());
            return;
        }
        int code = 9999;
        try {
            code = oLoginHelper.login(UserName, Password);
        }
        catch (WCMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            String message = e.getMessage();
            if (e.getCause() != null) {
                Throwable cause = e.getCause();
                message = cause.getMessage();
            }
            MlfMessage mlfmsg = new MlfMessage(3, "\u767b\u5f55\u5931\u8d25\uff01\u539f\u56e0\u3010" + message + "\u3011");
            this.write(response, mlfmsg.toJSONString());
            return;
        }
        String msg = LoginHelper.getErrorMsg(code);
        if (code == 30) {
            User loginUser = oLoginHelper.getLoginUser();
            ContextHelper.clear();
            ContextHelper.initContext(loginUser);
            MlfMessage mlfmsg = new MlfMessage(1, "\u767b\u5f55\u6210\u529f\uff01");
            String jsessionid = request.getSession().getId();
            String security = UserName + "," + jsessionid;
            String EncryptSecurity = "";
            try {
                String sPrivateKeyPath = ((Object)((Object)this)).getClass().getResource("/mlfprivate.key").getPath();
                EncryptSecurity = oLoginHelper.createEncodeUserInfo(loginUser, sPrivateKeyPath, security);
                EncryptSecurity = EncryptSecurity.substring("RandomInfo=".length(), EncryptSecurity.length());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            mlfmsg.setProperty("data", EncryptSecurity);
            mlfmsg.setProperty("sessionId", jsessionid);
            mlfmsg.setProperty("expireTime", String.valueOf(System.currentTimeMillis() + 1800000L));
            this.write(response, mlfmsg.toJSONString());
        } else {
            MlfMessage mlfmsg = new MlfMessage(3, msg);
            this.write(response, mlfmsg.toJSONString());
        }
    }

    private boolean checkLogin(HttpServletRequest request, HttpServletResponse response) {
        ServletContext context = this.getServletContext();
        LoginHelper oLoginHelper = new LoginHelper(request, context);
        boolean isLoging = oLoginHelper.checkLogin();
        this.write(response, isLoging + "");
        return isLoging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean write(HttpServletResponse response, String _content) {
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            ((Writer)writer).write(_content);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            String d = Base64Util.encode("admin");
            System.out.println(d);
            System.out.println(Base64Util.decode("admin"));
            System.out.println(Base64Util.decode("YWRtaW5fbWxm"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

