/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.domain.setting;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.template.domain.setting.ITemplateSetting;
import java.util.Enumeration;
import java.util.Properties;

public class TemplateSettingFactory {
    public static final String PROPERTY_NAME_SETTING = "setting.properties";
    private static TemplateSettingFactory itsInstance = new TemplateSettingFactory();
    private static Properties s_oSettingTypeMap;

    public ITemplateSetting makeSettingByType(String _sSettingType) throws WCMException {
        String sSettingImplName = s_oSettingTypeMap.getProperty(_sSettingType.toUpperCase());
        return (ITemplateSetting)this.makeInstance(sSettingImplName);
    }

    public ITemplateSetting[] makeAllSettings() throws WCMException {
        ITemplateSetting[] result = new ITemplateSetting[s_oSettingTypeMap.size()];
        for (int i = 0; i < result.length; ++i) {
            String arSettingTypeClassz = this.getSettingTypeClassz()[i];
            result[i] = (ITemplateSetting)this.makeInstance(arSettingTypeClassz);
        }
        return result;
    }

    public static TemplateSettingFactory getInstance() {
        if (s_oSettingTypeMap == null) {
            TemplateSettingFactory.loadProperties();
            if (s_oSettingTypeMap == null) {
                throw new RuntimeException(I18NMessage.get(TemplateSettingFactory.class, "TemplateSettingFactory.label1", "\u65e0\u6cd5\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6!"));
            }
        }
        return itsInstance;
    }

    public String[] getSettingTypes() {
        String[] result = new String[s_oSettingTypeMap.size()];
        Enumeration<Object> enmSettingImplNames = s_oSettingTypeMap.keys();
        int nCounter = 0;
        while (enmSettingImplNames.hasMoreElements()) {
            result[nCounter++] = (String)enmSettingImplNames.nextElement();
        }
        return result;
    }

    public String[] getSettingTypeClassz() {
        String[] result = new String[s_oSettingTypeMap.size()];
        Enumeration<Object> enmSettingImplNames = s_oSettingTypeMap.elements();
        int nCounter = 0;
        while (enmSettingImplNames.hasMoreElements()) {
            result[nCounter++] = (String)enmSettingImplNames.nextElement();
        }
        return result;
    }

    private static void loadProperties() {
        s_oSettingTypeMap = new Properties();
        s_oSettingTypeMap.put("DWT_CHANNELS", "com.trs.template.domain.setting.ChannelsTemplateSetting");
        s_oSettingTypeMap.put("DWT_FIELDS", "com.trs.template.domain.setting.FieldsTemplateSetting");
        s_oSettingTypeMap.put("DWT_TEMPLATES", "com.trs.template.domain.setting.TemplatesTemplateSetting");
    }

    private Object makeInstance(String strClassName) throws WCMException {
        try {
            return Class.forName(strClassName).newInstance();
        }
        catch (Exception ex) {
            throw new WCMException("Cannot create setting-instance for [" + strClassName + "]", ex);
        }
    }
}

