/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.scm.domain.ISCMGroupMgr;
import com.trs.scm.domain.SCMGroupAccountCacheMgr;
import com.trs.scm.domain.SCMGroupUserCacheMgr;
import com.trs.scm.domain.SCMGroupsCacheMgr;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.GroupAccount;
import com.trs.scm.persistent.GroupAccounts;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMGroupUser;
import com.trs.scm.persistent.SCMGroupUsers;
import com.trs.scm.persistent.SCMGroups;
import com.trs.scm.publish.domain.SCMMCPublishTaskCacheMgr;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SCMGroupMgr
implements ISCMGroupMgr {
    private static final Logger logger = Logger.getLogger((String)SCMMCPublishTaskCacheMgr.class.getName());
    private SCMGroupAccountCacheMgr m_oSCMGroupAccountCacheMgr = (SCMGroupAccountCacheMgr)DreamFactory.createObjectById("SCMGroupAccountCacheMgr");
    private SCMGroupUserCacheMgr m_oSCMGroupUserCacheMgr = (SCMGroupUserCacheMgr)DreamFactory.createObjectById("SCMGroupUserCacheMgr");
    private SCMGroupsCacheMgr m_SCMGroupsCacheMgr = (SCMGroupsCacheMgr)DreamFactory.createObjectById("SCMGroupsCacheMgr");

    @Override
    public boolean addAccountToGroup(Account _oAccount, SCMGroup _oGroup) throws Exception {
        if (_oAccount == null) {
            throw new Exception("\u8981\u6dfb\u52a0\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        if (_oGroup == null) {
            throw new Exception("\u8981\u6dfb\u52a0\u5230\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        WCMFilter oFilter = new WCMFilter("", "SCMGROUPID = ? and ACCOUNTID = ?", "");
        oFilter.addSearchValues(_oGroup.getId());
        oFilter.addSearchValues(_oAccount.getId());
        User oUser = ContextHelper.getLoginUser();
        GroupAccounts oGroupAccounts = GroupAccounts.openWCMObjs(oUser, oFilter);
        if (oGroupAccounts != null && oGroupAccounts.size() > 0) {
            return true;
        }
        GroupAccount oGroupAccount = new GroupAccount();
        oGroupAccount.setAccountId(_oAccount.getId());
        oGroupAccount.setSCMGroupId(_oGroup.getId());
        oGroupAccount.save(oUser);
        return true;
    }

    @Override
    public boolean delete(SCMGroup _oGroup) throws Exception {
        if (_oGroup == null) {
            throw new Exception("\u8981\u5220\u9664\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        User oUser = ContextHelper.getLoginUser();
        WCMFilter oFilter = new WCMFilter("", "SCMGROUPID = ?", "");
        oFilter.addSearchValues(_oGroup.getId());
        GroupAccounts oGroupAccounts = GroupAccounts.openWCMObjs(oUser, oFilter);
        if (oGroupAccounts.size() != 0) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e2d\u8fd8\u5b58\u5728\u8d26\u53f7\uff01");
        }
        oGroupAccounts.removeAll(true);
        SCMGroupUsers oSCMGroupUsers = SCMGroupUsers.openWCMObjs(oUser, oFilter);
        int nSize = oSCMGroupUsers.size();
        for (int i = nSize - 1; i >= 0; --i) {
            SCMGroupUser tempSCMGroupUser = (SCMGroupUser)oSCMGroupUsers.getAt(i);
            tempSCMGroupUser.delete(oUser);
        }
        _oGroup.delete(oUser);
        return true;
    }

    @Override
    public Users getAdmins(SCMGroup _oGroup) throws Exception {
        if (_oGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        Users oUsers = this.m_oSCMGroupUserCacheMgr.queryAdminsOfSCMGroup(_oGroup.getId());
        return oUsers;
    }

    @Override
    public SCMGroups getManagedGroups(User _oUser) throws Exception {
        if (_oUser == null) {
            throw new Exception("\u6307\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        SCMGroups oGroups = this.m_oSCMGroupUserCacheMgr.querySCMGroupsOfUser(_oUser.getId());
        return oGroups;
    }

    @Override
    public SCMGroups query(WCMFilter _oFilter) throws Exception {
        return SCMGroups.openWCMObjs(ContextHelper.getLoginUser(), _oFilter);
    }

    @Override
    public boolean removeAccountFromGroup(Account _oAccount, SCMGroup _oGroup) throws Exception {
        if (_oAccount == null) {
            throw new Exception("\u8981\u5220\u9664\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        if (_oGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        WCMFilter oFilter = new WCMFilter("", "SCMGROUPID = ? and ACCOUNTID = ?", "");
        oFilter.addSearchValues(_oGroup.getId());
        oFilter.addSearchValues(_oAccount.getId());
        User oUser = ContextHelper.getLoginUser();
        GroupAccounts oGroupAccounts = GroupAccounts.openWCMObjs(oUser, oFilter);
        oGroupAccounts.removeAll(true);
        WCMFilter oCleanFilter = new WCMFilter("", "ACCOUNTID = ?", "");
        oCleanFilter.addSearchValues(_oAccount.getId());
        oGroupAccounts = GroupAccounts.openWCMObjs(oUser, oCleanFilter);
        if (oGroupAccounts == null || oGroupAccounts.size() == 0) {
            _oAccount.setStatus(-1);
            _oAccount.save(oUser);
        }
        return true;
    }

    @Override
    public SCMGroup save(SCMGroup _oGroup) throws Exception {
        if (_oGroup == null) {
            throw new Exception("\u8981\u4fdd\u5b58\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        String sGroupName = _oGroup.getGroupName();
        if (_oGroup.isChangeProperty("GROUPNAME")) {
            sGroupName = _oGroup.getNewPropertyAsString("GROUPNAME");
        }
        WCMFilter oFilter = new WCMFilter("", "GROUPNAME = ?", "");
        oFilter.addSearchValues(sGroupName);
        User oUser = ContextHelper.getLoginUser();
        SCMGroups oGroups = SCMGroups.openWCMObjs(oUser, oFilter);
        if (oGroups != null && oGroups.size() > 0) {
            throw new Exception("\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a\u3010" + sGroupName + "\u3011\u7684\u5206\u7ec4\uff01");
        }
        _oGroup.save(oUser);
        return _oGroup;
    }

    @Override
    public void saveAdminsOfGroup(SCMGroup _oGroup, Users _oUsers) throws Exception {
        if (_oGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        if (_oUsers == null) {
            throw new Exception("\u7ef4\u62a4\u4eba\u5458\u7684\u96c6\u5408\u4e3a\u7a7a\uff01");
        }
        WCMFilter oFilter = new WCMFilter("", "SCMGROUPID=?", "");
        int nGroupId = _oGroup.getId();
        oFilter.addSearchValues(nGroupId);
        User oUser = ContextHelper.getLoginUser();
        SCMGroupUsers oSCMGroupUsers = SCMGroupUsers.openWCMObjs(oUser, oFilter);
        int nSize = oSCMGroupUsers.size();
        for (int i = nSize - 1; i >= 0; --i) {
            int nUserId;
            boolean bRemoved;
            SCMGroupUser currGroupUser = (SCMGroupUser)oSCMGroupUsers.getAt(i);
            if (currGroupUser == null || (bRemoved = _oUsers.remove(nUserId = currGroupUser.getUserId(), false))) continue;
            currGroupUser.delete(oUser);
        }
        int nSize2 = _oUsers.size();
        for (int i = 0; i < nSize2; ++i) {
            User tempUser = (User)_oUsers.getAt(i);
            if (tempUser == null) continue;
            SCMGroupUser oNewSCMGroupUser = new SCMGroupUser();
            oNewSCMGroupUser.setSCMGroupId(nGroupId);
            oNewSCMGroupUser.setUserId(tempUser.getId());
            oNewSCMGroupUser.save(oUser);
        }
    }

    @Override
    public void saveAdminOfGroup(SCMGroup _oGroup, User _oUser, int _nIsAdmin) throws Exception {
        if (_oGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        if (_oUser == null) {
            throw new Exception("\u6307\u5b9a\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        int nGroupId = _oGroup.getId();
        User oUser = ContextHelper.getLoginUser();
        SCMGroupUser oNewSCMGroupUser = SCMGroupUser.findByGIdUId(oUser, _oUser, nGroupId);
        if (oNewSCMGroupUser != null) {
            oNewSCMGroupUser.setAdmin(_nIsAdmin);
            oNewSCMGroupUser.save(oUser);
        }
    }

    @Override
    public int deleteAdminOfGroup(SCMGroup _oGroup, User _oUser) throws Exception {
        if (_oGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        if (_oUser == null) {
            throw new Exception("\u7ef4\u62a4\u4eba\u5458\u7684\u96c6\u5408\u4e3a\u7a7a\uff01");
        }
        WCMFilter oFilter = new WCMFilter("", "SCMGROUPID=? and USERID=?", "");
        int nGroupId = _oGroup.getId();
        int nUserId = _oUser.getId();
        oFilter.addSearchValues(nGroupId);
        oFilter.addSearchValues(nUserId);
        User oUser = ContextHelper.getLoginUser();
        SCMGroupUsers oSCMGroupUsers = SCMGroupUsers.openWCMObjs(oUser, oFilter);
        int nSize = oSCMGroupUsers.size();
        for (int i = nSize - 1; i >= 0; --i) {
            SCMGroupUser currGroupUser = (SCMGroupUser)oSCMGroupUsers.getAt(i);
            if (currGroupUser == null) continue;
            return currGroupUser.delete(oUser);
        }
        return 0;
    }

    @Override
    public SCMGroups getGroups(Account _oAccount) throws Exception {
        if (_oAccount == null) {
            throw new Exception("\u6307\u5b9a\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        SCMGroups oGroups = this.m_oSCMGroupAccountCacheMgr.querySCMGroupsOfAccount(_oAccount.getId());
        return oGroups;
    }

    @Override
    public boolean hasAccounts(SCMGroup _oGroup) throws Exception {
        if (_oGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        int nGroupId = _oGroup.getId();
        Accounts oAccounts = this.m_oSCMGroupAccountCacheMgr.queryAccountsOfSCMGroup(nGroupId);
        return oAccounts != null && oAccounts.size() > 0;
    }

    @Override
    public SCMGroups querySCMGroupsByPId(int parentId) throws WCMException {
        String sFrom = "XWCMSCMGROUP";
        String sWhere = "PARENTID=" + parentId;
        WCMFilter oFilter = new WCMFilter(sFrom, sWhere, "");
        SCMGroups oSCMGroups = SCMGroups.openWCMObjs(null, oFilter);
        return oSCMGroups;
    }

    @Override
    public SCMGroups getAllSubGroups(SCMGroup _oParentGroup) throws Exception {
        if (_oParentGroup == null) {
            throw new Exception("\u7236\u7ec4\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        SCMGroups oAllChildGroups = SCMGroups.createNewInstance(null);
        this.addSubGroups(_oParentGroup, oAllChildGroups);
        return oAllChildGroups;
    }

    private void addSubGroups(SCMGroup _oParentGroup, SCMGroups oAllChildGroups) throws Exception {
        SCMGroups oSCMGroups = this.getSubGroups(_oParentGroup);
        if (oSCMGroups == null || oSCMGroups.size() == 0) {
            return;
        }
        for (int i = 0; i < oSCMGroups.size(); ++i) {
            SCMGroup oSCMGroup = (SCMGroup)oSCMGroups.getAt(i);
            if (oSCMGroup == null) continue;
            SCMGroups oSubGroups = this.getSubGroups(oSCMGroup);
            if (oSubGroups == null || oSubGroups.size() == 0) {
                oAllChildGroups.addElement(oSCMGroup);
                continue;
            }
            oAllChildGroups.addElement(oSCMGroup);
            this.addSubGroups(oSCMGroup, oAllChildGroups);
        }
    }

    @Override
    public SCMGroups getSubGroups(SCMGroup _oParentGroup) throws Exception {
        if (_oParentGroup == null) {
            throw new Exception("\u7236\u7ec4\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        SCMGroups oReturnSCMGroups = SCMGroups.createNewInstance(null);
        HashMap oCacheMap = this.m_SCMGroupsCacheMgr.getSCMGroupsCache();
        Iterator iterator = null;
        if (oCacheMap != null) {
            iterator = oCacheMap.entrySet().iterator();
        } else {
            logger.debug((Object)"\u5206\u7ec4\u7f13\u5b58\u4e3a\u7a7a\uff01");
            return null;
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SCMGroup oSCMGroup = (SCMGroup)entry.getValue();
            if (oSCMGroup == null || oSCMGroup.getParentId() != _oParentGroup.getId()) continue;
            oReturnSCMGroups.addElement(oSCMGroup);
        }
        if (null == oReturnSCMGroups || oReturnSCMGroups.size() == 0) {
            return null;
        }
        return oReturnSCMGroups;
    }

    @Override
    public SCMGroups getAllUserCanMgrGroups(User currUser) throws Exception {
        if (currUser == null) {
            return null;
        }
        SCMGroups oSCMGroups = this.getManagedGroups(currUser);
        try {
            oSCMGroups = this.getRootGroups(oSCMGroups);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oSCMGroups == null) {
            return null;
        }
        SCMGroups oAllGroups = SCMGroups.createNewInstance(currUser);
        if (oSCMGroups != null && oSCMGroups.size() != 0) {
            oAllGroups.addElements(oSCMGroups);
            for (int i = 0; i < oSCMGroups.size(); ++i) {
                SCMGroups subGroups;
                SCMGroup oSCMGroup = (SCMGroup)oSCMGroups.getAt(i);
                if (oSCMGroup == null || (subGroups = this.getAllSubGroups(oSCMGroup)) == null || subGroups.size() == 0) continue;
                oAllGroups.addElements(subGroups);
            }
        }
        if (oAllGroups != null && oAllGroups.size() > 0) {
            return oAllGroups;
        }
        return null;
    }

    private SCMGroups getRootGroups(SCMGroups _oSCMGroups) throws Exception {
        if (_oSCMGroups == null) {
            return null;
        }
        SCMGroups oReturnGroups = SCMGroups.createNewInstance(null);
        for (int x = 0; x < _oSCMGroups.size(); ++x) {
            SCMGroup oXSCMGroup = (SCMGroup)_oSCMGroups.getAt(x);
            if (oXSCMGroup == null) continue;
            int hasParentFlag = 0;
            for (int y = 0; y != x && y < _oSCMGroups.size(); ++y) {
                SCMGroup oYSCMGroup = (SCMGroup)_oSCMGroups.getAt(y);
                if (oYSCMGroup == null || !this.isSubGroup(oYSCMGroup, oXSCMGroup)) continue;
                ++hasParentFlag;
                break;
            }
            if (hasParentFlag != 0) continue;
            oReturnGroups.addElement(oXSCMGroup);
        }
        return oReturnGroups;
    }

    private boolean isSubGroup(SCMGroup _oFirstSCMGroup, SCMGroup _oSCMGroup) throws Exception {
        if (_oSCMGroup == null || _oFirstSCMGroup == null) {
            return false;
        }
        for (SCMGroup oParentGroup = _oSCMGroup.getParent(); oParentGroup != null; oParentGroup = oParentGroup.getParent()) {
            if (oParentGroup.getId() != _oFirstSCMGroup.getId()) continue;
            return true;
        }
        return false;
    }
}

