/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.filter.Filter;
import com.trs.components.wcm.filter.FilterMgr;
import com.trs.components.wcm.filter.FilterOption;
import com.trs.components.wcm.filter.FilterOptionGroup;
import com.trs.components.wcm.filter.FilterOptions;
import com.trs.components.wcm.filter.FilterXmlToObjConverter;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FilterImporter {
    private static Logger logger = Logger.getLogger(FilterImporter.class);
    private String m_sImportFile;
    private Channel m_oCurrChannel;
    private boolean m_bToCurrChnl = false;
    private FilterXmlToObjConverter m_converter = null;
    private Map m_mOptionIdMapping = new HashMap();
    private FilterMgr m_oFilterMgr = null;

    public FilterImporter(int _nImportType, Channel oCurrChannel) throws WCMException {
        this.m_oCurrChannel = oCurrChannel;
        this.m_converter = new FilterXmlToObjConverter(_nImportType, oCurrChannel);
        this.m_oFilterMgr = (FilterMgr)DreamFactory.createObjectById("FilterMgr");
    }

    public void setImportToCurrChnl(boolean importToCurrChnl) {
        this.m_bToCurrChnl = importToCurrChnl;
    }

    public void importFromZip(String sImportZipFile) throws WCMException {
        if (!CMyFile.fileExists(sImportZipFile)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            sImportZipFile = filesMan.mapFilePath(sImportZipFile, 0) + CMyFile.extractFileName(sImportZipFile);
        }
        String sUnZipFilePath = CMyFile.extractFilePath(sImportZipFile);
        this.m_sImportFile = sUnZipFilePath = sUnZipFilePath + CMyFile.extractMainFileName(sImportZipFile) + File.separator;
        CMyUnZipFile uzf = new CMyUnZipFile(sImportZipFile, sUnZipFilePath);
        try {
            uzf.addFileExtFilters("xml");
            uzf.doUnZipAnd();
            CMyFile.deleteFile(sImportZipFile);
        }
        catch (CMyException e) {
            throw new WCMException(200, "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!", e);
        }
        ArrayList allXmlFiles = uzf.getFilteredFiles();
        XmlObject[] xmlObjs = null;
        int length = allXmlFiles.size();
        for (int i = 0; i < length; ++i) {
            String sXmlFile = (String)allXmlFiles.get(i);
            xmlObjs = this.m_converter.convertXml(sXmlFile, null, null);
            this.importFilters(xmlObjs, this.m_oCurrChannel);
        }
        CMyFile.deleteDir(this.m_sImportFile);
    }

    private void importFilters(XmlObject[] xmlObjs, Channel channel) throws WCMException {
        for (int i = 0; i < xmlObjs.length; ++i) {
            this.importFilter(xmlObjs[i], channel);
        }
    }

    private Filter importFilter(XmlObject xmlObj, Channel channel) throws WCMException {
        Filter filter = (Filter)xmlObj.getCurrentObj();
        if (this.m_bToCurrChnl) {
            filter.setChannelId(channel.getId());
        }
        filter.save(ContextHelper.getLoginUser());
        XmlObject[] groups = xmlObj.getChild("XWCMFILTEROPTIONGROUPS");
        this.importOptionGroups(groups, filter);
        this.afterFilterSave(filter);
        return filter;
    }

    private void afterFilterSave(Filter filter) throws WCMException {
        FilterOptions options = this.m_oFilterMgr.queryOptionsByFilter(filter, null);
        int nSize = options.size();
        for (int i = 0; i < nSize; ++i) {
            FilterOption option = (FilterOption)options.getAt(i);
            if (option == null) continue;
            boolean isChange = false;
            String sNotAllowOptions = option.getNotAllowedSelectOptions();
            if (!CMyString.isEmpty(sNotAllowOptions)) {
                String sNewOptions = this.getNewOptionIds(sNotAllowOptions);
                option.setNotAllowedSelectOptions(sNewOptions);
                isChange = true;
            }
            if (!isChange) continue;
            option.save(ContextHelper.getLoginUser());
        }
        String sDisabledOptions = filter.getPropertyAsString("disabledoptions");
        if (!CMyString.isEmpty(sDisabledOptions)) {
            String sNewOptions = this.getNewOptionIds(sDisabledOptions);
            filter.setPropertyWithString("disabledoptions", sNewOptions);
            filter.save(ContextHelper.getLoginUser());
        }
    }

    private String getNewOptionIds(String sOldOptionIds) {
        if (CMyString.isEmpty(sOldOptionIds)) {
            return "";
        }
        int[] oldIds = CMyString.splitToInt(sOldOptionIds, ",");
        StringBuffer sbNewIds = new StringBuffer();
        for (int i = 0; i < oldIds.length; ++i) {
            Integer oNewId = (Integer)this.m_mOptionIdMapping.get(new Integer(oldIds[i]));
            if (oNewId == null) continue;
            sbNewIds.append(oNewId).append(",");
        }
        if (sbNewIds.length() > 0) {
            sbNewIds.setLength(sbNewIds.length() - 1);
        }
        return sbNewIds.toString();
    }

    private void importOptionGroups(XmlObject[] xmlObjs, Filter filter) throws WCMException {
        for (int i = 0; i < xmlObjs.length; ++i) {
            this.importOptionGroup(xmlObjs[i], filter);
        }
    }

    private FilterOptionGroup importOptionGroup(XmlObject xmlObj, Filter filter) throws WCMException {
        FilterOptionGroup group = (FilterOptionGroup)xmlObj.getCurrentObj();
        group.setFilterId(filter.getId());
        group.save(ContextHelper.getLoginUser());
        XmlObject[] options = xmlObj.getChild("XWCMFILTEROPTIONS");
        this.importOptions(options, group);
        return group;
    }

    private void importOptions(XmlObject[] xmlObjs, FilterOptionGroup group) throws WCMException {
        for (int i = 0; i < xmlObjs.length; ++i) {
            this.importOption(xmlObjs[i], group);
        }
    }

    private FilterOption importOption(XmlObject xmlObj, FilterOptionGroup group) throws WCMException {
        FilterOption option = (FilterOption)xmlObj.getCurrentObj();
        option.setGroupId(group.getId());
        String[] pics = new String[]{"FIRSTPIC", "SECONDPIC", "THIRDPIC"};
        for (int i = 0; i < pics.length; ++i) {
            String sPicFileName = option.getPropertyAsString(pics[i]);
            if (CMyString.isEmpty(sPicFileName)) continue;
            if (!CMyFile.fileExists(this.m_sImportFile + sPicFileName)) {
                logger.error((Object)CMyString.format("\u5bfc\u5165\u7b5b\u9009\u5668\u56fe\u7247\u65f6\u56fe\u7247\u4e0d\u5b58\u5728[{0}]", new String[]{this.m_sImportFile + sPicFileName}));
                continue;
            }
            FilesMan filesMan = FilesMan.getFilesMan();
            String sNewFileName = filesMan.getNextFilePathName("P0", CMyFile.extractFileExt(sPicFileName));
            try {
                CMyFile.copyFile(this.m_sImportFile + sPicFileName, sNewFileName);
            }
            catch (CMyException e) {
                throw new WCMException("\u590d\u5236\u6587\u4ef6\u5931\u8d25", e);
            }
            option.setPropertyWithString(pics[i], CMyFile.extractFileName(sNewFileName));
        }
        Integer oOldId = (Integer)this.m_converter.getObjIdMapping().get(option);
        option.save(ContextHelper.getLoginUser());
        this.m_mOptionIdMapping.put(oOldId, option.getKey());
        return option;
    }
}

