/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.IChannelNameMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class ChannelNameMgr
implements IChannelNameMgr {
    public static final int MAX_CACHE_SIZE = 1000;
    private int m_nMaxCachSize = 1000;
    public static long LRU_CACHE_EXPIRES = 3600000L;
    private static Cache cache = (Cache)DreamFactory.createObjectById("lruCache");
    private static Logger logger = Logger.getLogger(ChannelNameMgr.class);

    public ChannelNameMgr() {
        cache.setMaxSize(1000L);
    }

    @Override
    public void clear() {
    }

    public int getMaxCacheSize() {
        return this.m_nMaxCachSize;
    }

    public void setMaxCacheSize(int p_nMaxSize) {
        this.m_nMaxCachSize = p_nMaxSize;
    }

    private String makeKey(int p_nSiteId, String p_sName) {
        return Integer.toHexString(p_nSiteId) + ':' + p_sName;
    }

    private void putToCache(int p_nSiteId, String p_sName, Channel p_channel) throws WCMException {
        String sKey = this.getKey(this.makeKey(p_nSiteId, p_sName));
        cache.set(sKey, p_channel.getKey());
        cache.pexpire(sKey, 3600000L);
    }

    @Override
    public Channel findByName(int p_nSiteId, String p_sName) throws WCMException {
        try {
            String sKey = this.getKey(this.makeKey(p_nSiteId, p_sName));
            Object oCacheKey = cache.get(sKey);
            if (oCacheKey != null) {
                return Channel.findByKey(oCacheKey);
            }
            return this.loadByName(p_nSiteId, p_sName);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label3", "\u63d0\u53d6\u6307\u5b9a\u540d\u79f0\u7684\u9891\u9053\u5931\u8d25(SiteId=") + p_nSiteId + ",Name=" + p_sName + ")findByName", ex);
        }
    }

    private boolean change(int _nOldSiteId, String p_sOldName, Channel p_channel) throws WCMException {
        if (p_channel == null) {
            return false;
        }
        try {
            String oKey = this.makeKey(_nOldSiteId, p_sOldName);
            String sKey = this.getKey(oKey);
            if (cache.exists(sKey).booleanValue()) {
                cache.clear(sKey);
            }
            int nNewSiteId = p_channel.getNewPropertyAsInt("SITEID", p_channel.getSiteId());
            String sNewChnlName = p_channel.getNewPropertyAsString("CHNLNAME");
            if (sNewChnlName == null) {
                sNewChnlName = p_channel.getName();
            }
            this.putToCache(nNewSiteId, sNewChnlName, p_channel);
            return true;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label4", "\u66f4\u65b0\u9891\u9053\u540d\u79f0\u7f13\u51b2\u5931\u8d25(ChannelId=") + p_channel.getId() + ",OldName=" + p_sOldName + ")notifyNameChanged", ex);
        }
    }

    private void remove(Channel p_channel) throws WCMException {
        String sKey = this.getKey(this.makeKey(p_channel.getSiteId(), p_channel.getName()));
        cache.clear(sKey);
    }

    private Channel loadByName(int p_nSiteId, String p_sName) throws Exception {
        String QUERY_SQL = "select ChannelId from WCMCHANNEL where SiteId=? and ChnlName=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        Channel channel = null;
        String sTemp = null;
        try {
            oConn = DBManager.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement("select ChannelId from WCMCHANNEL where SiteId=? and ChnlName=?");
            oPreStmt.setInt(1, p_nSiteId);
            sTemp = DBManager.getDBManager().getDBType().encodeStrToWrite(p_sName);
            oPreStmt.setString(2, sTemp);
            oPreStmt.setMaxRows(1);
            rsData = oPreStmt.executeQuery();
            if (rsData.next()) {
                channel = Channel.findById(rsData.getInt(1));
            }
            if (channel == null) {
                Channel channel2 = null;
                return channel2;
            }
            this.putToCache(p_nSiteId, p_sName, channel);
            Channel channel3 = channel;
            return channel3;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label5", "\u4ece\u6570\u636e\u5e93\u4e2d\u63d0\u53d6\u9891\u9053\u5bf9\u8c61(SiteId=") + p_nSiteId + ",ChnlName=" + p_sName + I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label6", ")\u5931\u8d25"), ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                DBManager.getDBManager().freeConnection(oConn);
            }
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        this.putToCache((Channel)_oObjAdded);
    }

    private void putToCache(Channel _newChannel) throws WCMException {
        this.putToCache(_newChannel.getSiteId(), _newChannel.getName(), _newChannel);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        this.remove((Channel)_oObjDeleted);
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        logger.debug((Object)(_oObjModified + "...." + _oObjModified.isChangeProperty("CHNLNAME")));
        if (_oObjModified.isChangeProperty("SITEID") || _oObjModified.isChangeProperty("CHNLNAME")) {
            Channel currChannel = (Channel)_oObjModified;
            this.change(currChannel.getSiteId(), currChannel.getName(), currChannel);
        }
    }

    @Override
    public boolean init() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        cache.set(this.getKey(), "true");
        logger.info((Object)I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label7", "\u6b63\u5728\u521d\u59cb\u5316\u9891\u9053\u540d\u79f0\u7f13\u51b2..."));
        WCMFilter currFilter = new WCMFilter("", "", "CHANNELID desc ", "", this.getMaxCacheSize());
        Channels currChannels = Channels.openWCMObjs(null, currFilter);
        for (int i = 0; i < currChannels.size(); ++i) {
            Channel currChannel = (Channel)currChannels.getAt(i);
            if (currChannel == null) continue;
            this.putToCache(currChannel);
        }
        logger.info((Object)I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label8", "\u521d\u59cb\u5316\u9891\u9053\u540d\u79f0\u7f13\u51b2\u5b8c\u6210\uff01"));
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public boolean isDoNotify(BaseObj _currObj) {
        return _currObj != null && _currObj.getWCMType() == 101;
    }

    public static void main(String[] args) {
        ChannelNameMgr currMgr = new ChannelNameMgr();
        try {
            System.out.println(currMgr.findByName(2, I18NMessage.get(ChannelNameMgr.class, "ChannelNameMgr.label9", "\u4e13\u9898\u680f\u76ee")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getKey() {
        return this.getClass().getName();
    }

    private String getKey(String str) {
        return this.getKey() + "." + str;
    }
}

