/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content;

import com.eprobiti.trs.TRSException;
import com.eprobiti.trs.TRSResultSet;
import com.sun.star.uno.RuntimeException;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.domain.DatasWithChnlDocFilterHelper;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.content.trsserver.TRSToWCMFilter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.InjectSQLHelper;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyMemory;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ViewDocuments
extends CMSBaseObjs {
    private static final long serialVersionUID = 7839476804435044166L;
    private static Logger logger = Logger.getLogger(ViewDocuments.class);
    public static final String DB_TABLE_NAME = "WCMCHNLDOC";
    public static final String ID_FIELD_NAME = "RECID";
    private boolean m_bFromRecycle = false;
    private String m_sSelectFieldsFromDocument = "DOCID,DocTitle,DocType,DocKeyWords,DocPeople,SubDocTitle,DocChannel,SiteId,DocSource,DocSourceName,CrUser,CrTime";
    private String m_sSelectFieldsFromChnlDoc = "WCMCHNLDOC.RecId,WCMCHNLDOC.ChnlId,WCMCHNLDOC.DocId,WCMCHNLDOC.DocChannel";
    public static final Integer ID_NOT_LOAD = new Integer(0);
    private static final long ONE_MINUTES = 60000L;
    public static boolean QUERY_ACCORD_DOCUMENT_RIGHT = true;
    public static int MAX_FETCH_SIZE = 500;
    private Map m_hViewDocumentsCache = null;
    private HashMap m_oPublicCache = new HashMap(2);
    private int m_nRightIndex = -1;
    private static final String REG_INJECT_SQL = "(?i)([^a-zA-Z]*(delete|from|select|where)[^a-zA-Z]*)";
    private DatasWithChnlDocFilterHelper m_oFilterMaker = new DatasWithChnlDocFilterHelper();

    public ViewDocuments(User _currUser) {
        super(_currUser);
    }

    public ViewDocuments(User _currUser, int _initCapacity, int _incCapacity) {
        super(_currUser, _initCapacity, _incCapacity);
    }

    public ViewDocuments(User _currUser, BaseChannel _oChannelOrSite) {
        super(_currUser);
        this.setCurrChannelOrSite(_oChannelOrSite);
    }

    @Override
    protected String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public Class getElementClass() {
        return ViewDocument.class;
    }

    @Override
    public String getIdFieldName() {
        return ID_FIELD_NAME;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new ViewDocuments(null);
    }

    public BaseChannel getCurrChannelOrSite() {
        return (BaseChannel)this.getPublicCache().get(ViewDocument.KEY_CURR_HOST);
    }

    public void setCurrChannelOrSite(BaseChannel _oChannelOrSite) {
        this.getPublicCache().put(ViewDocument.KEY_CURR_HOST, _oChannelOrSite);
    }

    public boolean canSort() {
        BaseChannel host = this.getCurrChannelOrSite();
        if (host == null) {
            return false;
        }
        if (host.isSite()) {
            return false;
        }
        Channel channel = (Channel)host;
        if (channel.isOnlySearch()) {
            return false;
        }
        String sOrderBy = channel.getOrderBy();
        return sOrderBy == null || (sOrderBy = sOrderBy.trim()).length() <= 0 || sOrderBy.toUpperCase().indexOf("DOCORDERPRI") >= 0;
    }

    public HashMap getPublicCache() {
        return this.m_oPublicCache;
    }

    protected WCMFilter getHostFilter(Object _hostObject, WCMFilter _filter) throws WCMException {
        if (_hostObject instanceof Channels) {
            return this.m_oFilterMaker.makeChannelFilter((Channels)_hostObject, _filter, this.isFromRecycle());
        }
        if (_hostObject instanceof Channel) {
            return this.m_oFilterMaker.makeChannelFilter((Channel)_hostObject, _filter, true, this.isFromRecycle());
        }
        if (_hostObject instanceof WebSite) {
            return this.m_oFilterMaker.makeFilter((WebSite)_hostObject, _filter, true, this.isFromRecycle());
        }
        if (_hostObject instanceof WebSites) {
            return this.m_oFilterMaker.makeFilter((WebSites)_hostObject, _filter, true, this.isFromRecycle());
        }
        return _filter;
    }

    public void open(Channels _channels, WCMFilter _filter) throws WCMException {
        WCMFilter hostFilter = this.getHostFilter(_channels, _filter);
        if (hostFilter == null) {
            return;
        }
        if (_channels.size() == 1) {
            this.getPublicCache().put(ViewDocument.KEY_CURR_HOST, _channels.getAt(0));
        }
        this.openViewDocuments(hostFilter);
    }

    public void open(Channel _channel, WCMFilter _filter) throws WCMException {
        WCMFilter hostFilter = this.getHostFilter(_channel, _filter);
        if (hostFilter == null) {
            return;
        }
        this.getPublicCache().put(ViewDocument.KEY_CURR_HOST, _channel);
        this.openViewDocuments(hostFilter);
    }

    public void open(WebSite _site, WCMFilter _filter) throws WCMException {
        WCMFilter hostFilter = this.getHostFilter(_site, _filter);
        if (hostFilter == null) {
            return;
        }
        this.getPublicCache().put(ViewDocument.KEY_CURR_HOST, _site);
        this.openViewDocuments(hostFilter);
    }

    public void open(WebSites _sites, WCMFilter _filter) throws WCMException {
        WCMFilter hostFilter = this.getHostFilter(_sites, _filter);
        if (hostFilter == null) {
            return;
        }
        if (_sites.size() == 1) {
            this.getPublicCache().put(ViewDocument.KEY_CURR_HOST, _sites.getAt(0));
        }
        this.openViewDocuments(hostFilter);
    }

    public void openViewDocuments(WCMFilter _filter) throws WCMException {
        if (CMyString.isEmpty(_filter.getFrom())) {
            _filter.setFrom(DB_TABLE_NAME);
        }
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)"openViewDocuments SQL Info:");
            logger.fatal((Object)(_filter + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        DebugTimer timer = new DebugTimer();
        timer.start();
        int nCount = DBManager.getDBManager().sqlExecuteCountQuery(_filter);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("Query Count use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)(_filter.toCountQueryInfo() + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (nCount == 0) {
            return;
        }
        CPager currPager = new CPager(this.getPageSize());
        currPager.setItemCount(nCount);
        currPager.setCurrentPageIndex(this.getCurrPage());
        timer.start();
        this.loadPrePageDatas(_filter, currPager);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPrePageDatas use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (this.isEmpty() || !this.needDocumentFields()) {
            return;
        }
        timer.start();
        this.loadPageDocuments(currPager.getCurrentPageIndex() - 1);
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPageDocuments use [" + timer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
    }

    protected boolean needDocumentFields() {
        return !CMyString.isEmpty(this.getSelectFieldsFromDocument());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPrePageDatas(WCMFilter _filter, CPager _pager) throws WCMException {
        DebugTimer aTimer = new DebugTimer();
        this.vIdList = new Vector(_pager.getItemCount());
        Connection oConn = null;
        Statement oPreStmt = null;
        ResultSet rsData = null;
        String strSQL = "";
        WCMFilter loadPreDataFilter = null;
        try {
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label1", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            loadPreDataFilter = this.makeQueryPreDataFilter(_filter);
            strSQL = loadPreDataFilter.toSQL();
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            if (_pager.getPageSize() < 0) {
                if (_pager.getItemCount() < MAX_FETCH_SIZE) {
                    oPreStmt.setFetchSize(_pager.getItemCount());
                } else {
                    oPreStmt.setFetchSize(MAX_FETCH_SIZE);
                }
            } else if (_pager.getPageSize() < MAX_FETCH_SIZE) {
                oPreStmt.setFetchSize(_pager.getPageSize());
            } else {
                oPreStmt.setFetchSize(MAX_FETCH_SIZE);
            }
            DBManager.setParameters((PreparedStatement)oPreStmt, loadPreDataFilter);
            aTimer.start();
            rsData = oPreStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.fatal((Object)loadPreDataFilter);
            }
            int nCount = 0;
            ResultSetMetaData rsmdData = null;
            while (rsData.next()) {
                if (++nCount < _pager.getFirstItemIndex()) {
                    this.vIdList.add(ID_NOT_LOAD);
                    continue;
                }
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                ViewDocument viewDocument = (ViewDocument)this.createElementInstance();
                viewDocument.readChnlDocPropertyFromRs(rsData, rsmdData);
                if (this.m_nRightIndex != -1 && QUERY_ACCORD_DOCUMENT_RIGHT && DocumentAuthServer.isDefineRightOnDocument(viewDocument.getDocId())) {
                    RightValue rightValue = new RightValue();
                    rightValue.load(this.currUser, 605, viewDocument.getDocId(), true);
                    if (!this.hasRight(rightValue)) {
                        String GET_CRUSER_SQL = "select CrUser from WCMDocument where DocId=?";
                        String sCrUser = DBManager.getDBManager().sqlExecuteStringQuery("select CrUser from WCMDocument where DocId=?", new int[]{viewDocument.getDocId()});
                        if (!this.currUser.getName().equals(sCrUser)) {
                            --nCount;
                            _pager.setItemCount(_pager.getItemCount() - 1);
                            continue;
                        }
                    }
                }
                int nId = rsData.getInt(this.getIdFieldName());
                this.vIdList.add(new Integer(nId));
                if (this.m_oObjsBuffer == null) {
                    this.m_oObjsBuffer = new Hashtable();
                }
                this.m_oObjsBuffer.put(viewDocument.getKey(), viewDocument);
                this.putViewDocument(viewDocument.getDocId(), viewDocument);
                if (nCount < _pager.getLastItemIndex()) continue;
            }
            rsData.close();
            for (int i = nCount; i < _pager.getItemCount(); ++i) {
                this.vIdList.add(ID_NOT_LOAD);
            }
            this.currIndex = this.size() > 0 ? 0 : -2;
        }
        catch (SQLException ex) {
            try {
                throw new WCMException(40, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label2", "\u9884\u5148\u8bfb\u5165\u5c0f\u6570\u636e\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n" + loadPreDataFilter, ex);
                catch (Exception ex2) {
                    throw new WCMException(0, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label3", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", ex2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oPreStmt != null) {
                        oPreStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn == null) throw throwable;
                this.getDBManager().freeConnection(oConn);
                throw throwable;
            }
        }
        try {
            if (oPreStmt != null) {
                oPreStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oConn == null) return;
        this.getDBManager().freeConnection(oConn);
    }

    @Override
    protected BaseObj createElementInstance() throws WCMException {
        return new ViewDocument(this.getPublicCache());
    }

    private boolean hasRight(RightValue _rightValue) {
        if (this.m_nRightIndex == 64) {
            return _rightValue.getValue() > 0L;
        }
        return _rightValue.isHasRight(this.m_nRightIndex);
    }

    private WCMFilter makeQueryPreDataFilter(WCMFilter _filter) {
        WCMFilter newFilter = new WCMFilter(_filter);
        String strFrom = _filter.getFrom();
        if (strFrom == null || (strFrom = strFrom.trim()).length() == 0) {
            newFilter.setFrom(this.getDbTableName());
        }
        newFilter.setSelect(this.m_sSelectFieldsFromChnlDoc);
        return newFilter;
    }

    private boolean loadPageDocuments(int _pageIndex) throws WCMException {
        if (this.pageSize == -1) {
            this.pageSize = MAX_FETCH_SIZE;
            int nPageIndex = 0;
            int i = 0;
            while (i < this.size()) {
                this.loadPageDocuments(nPageIndex);
                i += MAX_FETCH_SIZE;
                ++nPageIndex;
            }
            return true;
        }
        return this.realLoadPageDocuments(_pageIndex);
    }

    protected boolean realLoadPageDocuments(int _pageIndex) throws WCMException {
        String strSQL = this.makeLoadPageDocumentsSQL(_pageIndex);
        if (strSQL == null) {
            return false;
        }
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        try {
            int nDocId;
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setMaxRows(this.pageSize);
            if (this.pageSize > MAX_FETCH_SIZE) {
                oStmt.setFetchSize(MAX_FETCH_SIZE);
            } else {
                oStmt.setFetchSize(this.pageSize);
            }
            this.setPageDocumentsPreStmtParams(_pageIndex, oStmt);
            aTimer.start();
            rsData = oStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            aTimer.start();
            while (rsData.next()) {
                ViewDocument[] pViewDocuments;
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                if ((pViewDocuments = this.getViewDocuments(nDocId = rsData.getInt("DOCID"))) == null) {
                    this.printErrorInfo(nDocId, strSQL, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label4", "ViewDocument\u7f13\u51b2\u7ef4\u62a4\u6709\u95ee\u9898\uff1f\u6307\u5b9a\u7684DocId\u5bf9\u5e94\u7684ViewDocument\u4e0d\u80fd\u83b7\u5f97\uff01"));
                    continue;
                }
                ViewDocument currObject = pViewDocuments[0];
                currObject.readFromRs(rsData, rsmdData);
                int nCount = pViewDocuments.length;
                for (int i = 1; i < nCount; ++i) {
                    pViewDocuments[i].cloneDocumentProperties(currObject);
                }
            }
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            nDocId = 1;
            return nDocId != 0;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    protected void printErrorInfo(int _nCurrDocId, String _sCurrSQL, String _sTitle) {
        logger.error((Object)_sTitle);
        logger.error((Object)("DocId:" + _nCurrDocId));
        logger.error((Object)("strSQL:" + _sCurrSQL));
        logger.error((Object)("m_oObjsBuffer:" + this.m_oObjsBuffer));
        logger.error((Object)("m_oObjsBuffer.size:" + this.m_oObjsBuffer.size()));
    }

    private void setPageDocumentsPreStmtParams(int _pageIndex, PreparedStatement stmt) throws SQLException {
        int nEnd;
        int nStart = this.getStartPos(_pageIndex);
        if (nStart >= (nEnd = this.getEndPos(nStart)) || nStart < 0) {
            return;
        }
        int i = nStart;
        int nParamIndex = 1;
        while (i < nEnd) {
            ViewDocument viewDocument = (ViewDocument)this.getAt(i);
            if (viewDocument == null) {
                this.printErrorInfo(this.getIdAt(i), null, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label6", "setPageDocumentsPreStmtParams\u53d1\u73b0\u7a0b\u5e8f\u9519\u8bef\uff01"));
                stmt.setInt(nParamIndex, 0);
            } else {
                stmt.setInt(nParamIndex, viewDocument.getDocId());
            }
            ++i;
            ++nParamIndex;
        }
    }

    private String makeLoadPageDocumentsSQL(int _pageIndex) {
        this.setSelectFieldsFromDocument("DocId," + this.getSelectFieldsFromDocument());
        String sFrom = "WCMDOCUMENT";
        String sWhere = this.makeLoadPageWhere(_pageIndex, "DOCID");
        StringBuffer sbSQL = new StringBuffer(this.getSelectFieldsFromDocument().length() + sFrom.length() + sWhere.length() + 21);
        sbSQL.append("select ");
        sbSQL.append(this.getSelectFieldsFromDocument());
        sbSQL.append(" from ");
        sbSQL.append(sFrom);
        if (sWhere.length() > 0) {
            sbSQL.append(" where ");
            sbSQL.append(sWhere);
        }
        return sbSQL.toString();
    }

    protected String makeLoadPageWhere(int _pageIndex, String _sFieldName) {
        int nEnd;
        int nStart = this.getStartPos(_pageIndex);
        if (nStart >= (nEnd = this.getEndPos(nStart)) || nStart < 0) {
            return "";
        }
        String sWhere = _sFieldName + " in(";
        sWhere = sWhere + "?";
        for (int i = nStart + 1; i < nEnd; ++i) {
            sWhere = sWhere + ", ?";
        }
        sWhere = sWhere + ")";
        return sWhere;
    }

    private void putViewDocument(int _nDocId, ViewDocument _ViewDocument2) {
        if (this.m_hViewDocumentsCache == null) {
            this.m_hViewDocumentsCache = this.pageSize > 0 ? new HashMap(this.pageSize) : new HashMap(this.vIdList.capacity());
        }
        ViewDocument[] pViewDocuments = null;
        Integer iDocIdKey = new Integer(_nDocId);
        pViewDocuments = (ViewDocument[])this.m_hViewDocumentsCache.get(iDocIdKey);
        if (pViewDocuments == null) {
            pViewDocuments = new ViewDocument[]{_ViewDocument2};
        } else {
            int nOldLength = pViewDocuments.length;
            ViewDocument[] pTemp = new ViewDocument[nOldLength + 1];
            if (nOldLength > 0) {
                System.arraycopy(pViewDocuments, 0, pTemp, 0, nOldLength);
            }
            pTemp[nOldLength] = _ViewDocument2;
            pViewDocuments = pTemp;
        }
        this.m_hViewDocumentsCache.put(iDocIdKey, pViewDocuments);
    }

    protected ViewDocument[] getViewDocuments(int _nDocId) {
        if (this.m_hViewDocumentsCache == null) {
            return null;
        }
        Integer iDocIdKey = new Integer(_nDocId);
        return (ViewDocument[])this.m_hViewDocumentsCache.get(iDocIdKey);
    }

    public void open(CMSBaseObjs _oSitesOrChannels, WCMFilter _extraFilter) throws WCMException {
        if (_oSitesOrChannels instanceof Channels) {
            this.open((Channels)_oSitesOrChannels, _extraFilter);
        } else if (_oSitesOrChannels instanceof WebSites) {
            this.open((WebSites)_oSitesOrChannels, _extraFilter);
        } else {
            throw new WCMException(I18NMessage.get(ViewDocuments.class, "ViewDocuments.label7", "\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b[") + _oSitesOrChannels.getClassName(true) + "]\uff01");
        }
    }

    public boolean isFromRecycle() {
        return this.m_bFromRecycle;
    }

    public void setFromRecycle(boolean fromRecycle) {
        this.m_bFromRecycle = fromRecycle;
    }

    public static final boolean containsInjectSQL(String _sValue) {
        if (CMyString.isEmpty(_sValue)) {
            return false;
        }
        Pattern oPattern = Pattern.compile(REG_INJECT_SQL);
        Matcher oMatcher = oPattern.matcher(_sValue);
        return oMatcher.find();
    }

    public void setSelectFieldsFromChnlDoc(String _sSelectFieldsFromChnlDoc) {
        if (_sSelectFieldsFromChnlDoc == null || (_sSelectFieldsFromChnlDoc = _sSelectFieldsFromChnlDoc.trim()).length() == 0) {
            return;
        }
        this.validInjectSQL(_sSelectFieldsFromChnlDoc, DB_TABLE_NAME);
        String[] pSelectFields = _sSelectFieldsFromChnlDoc.split(",");
        String sAppendPrex = "WCMCHNLDOC.";
        int nAppendPrexLength = _sSelectFieldsFromChnlDoc.indexOf(46) > 0 ? sAppendPrex.length() : 0;
        StringBuffer sbSelectFields = new StringBuffer(_sSelectFieldsFromChnlDoc.length() + nAppendPrexLength * pSelectFields.length);
        for (int i = 0; i < pSelectFields.length; ++i) {
            if (i > 0) {
                sbSelectFields.append(",");
            }
            if (pSelectFields[i].indexOf(46) < 0) {
                sbSelectFields.append(sAppendPrex);
            }
            sbSelectFields.append(pSelectFields[i]);
        }
        this.m_sSelectFieldsFromChnlDoc = sbSelectFields.toString();
    }

    public void setSelectFieldsFromDocument(String selectFieldsFromDocument) {
        this.validInjectSQL(selectFieldsFromDocument, "WCMDOCUMENT");
        this.m_sSelectFieldsFromDocument = selectFieldsFromDocument;
    }

    public String getSelectFieldsFromDocument() {
        return this.m_sSelectFieldsFromDocument;
    }

    public void setSelectFields(String _sSelectFieldFromChnlDoc, String _sSelectFieldsFromDocument) {
        this.setSelectFieldsFromChnlDoc(_sSelectFieldFromChnlDoc);
        this.setSelectFieldsFromDocument(_sSelectFieldsFromDocument);
    }

    public int getRightIndex() {
        return this.m_nRightIndex;
    }

    public void setRightIndex(int rightIndex) {
        this.m_nRightIndex = rightIndex;
    }

    public void setNeedWithAuthFilter(User _loginUser, boolean _bNeedWithAuthFilter) {
        this.m_oFilterMaker.setNeedWithAuthFilter(_loginUser, _bNeedWithAuthFilter);
    }

    public void openTRSServerViewDocuments(TRSResultSet _sTrsRs, TRSToWCMFilter _filter, CPager _sCurrPager) {
        this.vIdList = new Vector(_sCurrPager.getItemCount());
        if (this.m_oObjsBuffer == null) {
            this.m_oObjsBuffer = new Hashtable();
        }
        int nStartIndex = (_sCurrPager.getCurrentPageIndex() - 1) * _sCurrPager.getPageSize();
        DebugTimer aTimer = new DebugTimer();
        int nCount = 0;
        for (nCount = 0; nCount < _sCurrPager.getFirstItemIndex() - 1; ++nCount) {
            this.vIdList.add(ID_NOT_LOAD);
        }
        try {
            int nExecCount = 0;
            aTimer.start();
            _sTrsRs.moveTo(0, (long)nStartIndex);
            int nPageSize = _sCurrPager.getPageSize();
            while (nExecCount < nPageSize) {
                ++nExecCount;
                ++nCount;
                ViewDocument newViewDocument = (ViewDocument)this.createElementInstance();
                Enumeration enTRSFields = _filter.getTRSFields();
                while (enTRSFields.hasMoreElements()) {
                    String sTRSFieldName = (String)enTRSFields.nextElement();
                    String sWCMFiledName = _filter.getWCMField(sTRSFieldName);
                    if (sTRSFieldName.equalsIgnoreCase(_filter.getIDFieldName())) {
                        newViewDocument.setDocId(_sTrsRs.getInt(sTRSFieldName));
                        continue;
                    }
                    if (sTRSFieldName.equalsIgnoreCase("doctitle")) {
                        newViewDocument.setPropertyWithString(sWCMFiledName, _sTrsRs.getString(sTRSFieldName, "red"));
                        continue;
                    }
                    if (sTRSFieldName.equalsIgnoreCase("doccontent")) {
                        newViewDocument.setPropertyWithString(sWCMFiledName, _sTrsRs.getString(sTRSFieldName));
                        newViewDocument.setAttribute("doccontent", _sTrsRs.getStringWithCutsize(sTRSFieldName, 200, "red"));
                        continue;
                    }
                    newViewDocument.setPropertyWithString(sWCMFiledName, _sTrsRs.getString(sTRSFieldName));
                }
                Integer recId = null;
                try {
                    int nRecId = _sTrsRs.getInt("recid");
                    recId = new Integer(nRecId);
                }
                catch (TRSException ex) {
                    continue;
                }
                newViewDocument.setChnlDocProperty("recid", recId);
                newViewDocument.setChnlDocProperty("chnlid", new Integer(_sTrsRs.getInt("docchannel")));
                for (String sField : new String[]{"docstatus", "docorderpri", "modal"}) {
                    newViewDocument.setChnlDocProperty(sField, new Integer(_sTrsRs.getInt(sField)));
                }
                this.vIdList.add(recId);
                this.m_oObjsBuffer.put(recId, newViewDocument);
                if (nCount < _sCurrPager.getLastItemIndex() && _sTrsRs.moveNext()) continue;
                break;
            }
            aTimer.stop();
        }
        catch (Exception e) {
            logger.error((Object)"load data from trsserver failed.", (Throwable)e);
        }
        if (aTimer.getTime() > 60000L) {
            logger.warn((Object)("load data from trsserver too long(ms): " + aTimer.getTime()));
        }
        for (int i = nCount; i < _sCurrPager.getItemCount(); ++i) {
            this.vIdList.add(ID_NOT_LOAD);
        }
    }

    public void loadFrom(Documents _documents, String _sSelectFieldsFromChnlDoc) throws WCMException {
        int nCount = _documents.size();
        if (nCount <= 0) {
            return;
        }
        this.vIdList = new Vector(nCount);
        DBManager dbManager = DBManager.getDBManager();
        Connection oConn = dbManager.getConnection();
        Statement oPreStmt = null;
        ResultSet rsData = null;
        _sSelectFieldsFromChnlDoc = CMyString.showNull(_sSelectFieldsFromChnlDoc, "").toLowerCase();
        if (("," + _sSelectFieldsFromChnlDoc + ",").indexOf(",recid,") < 0) {
            _sSelectFieldsFromChnlDoc = CMyString.isEmpty(_sSelectFieldsFromChnlDoc) ? "recid" : _sSelectFieldsFromChnlDoc + ",recid";
        }
        String sQueryChnlDocSQL = "select " + _sSelectFieldsFromChnlDoc + " from WCMChnlDoc where DocId=? and Modal=" + 1;
        try {
            int nSize = _documents.size();
            for (int i = 0; i < nSize; ++i) {
                Document document = (Document)_documents.getAt(i);
                if (document == null) continue;
                ViewDocument viewDocument = (ViewDocument)this.createElementInstance();
                oPreStmt = oConn.prepareStatement(sQueryChnlDocSQL);
                oPreStmt.setInt(1, document.getId());
                rsData = oPreStmt.executeQuery();
                if (!rsData.next()) continue;
                viewDocument.readChnlDocPropertyFromRs(rsData, rsData.getMetaData());
                int nId = rsData.getInt(this.getIdFieldName());
                this.vIdList.add(new Integer(nId));
                if (this.m_oObjsBuffer == null) {
                    this.m_oObjsBuffer = new Hashtable();
                }
                this.m_oObjsBuffer.put(viewDocument.getKey(), viewDocument);
                this.putViewDocument(viewDocument.getDocId(), viewDocument);
                rsData.close();
                rsData = null;
                oPreStmt.close();
                oPreStmt = null;
                viewDocument.setProperties(document.getProperties());
            }
        }
        catch (Exception e) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01", e);
        }
        finally {
            try {
                if (oPreStmt != null) {
                    oPreStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    private final void validInjectSQL(String _sValue, String _sTableName) {
        if (InjectSQLHelper.containsInjectSelectSQL(_sValue, _sTableName)) {
            logger.error((Object)("Inject Select[" + _sValue + "]"), (Throwable)new Exception("who call me?"));
            throw new RuntimeException("Invalid select! Inject?!");
        }
    }
}

