/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandlerByUser
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DocStatHandlerByUser.class);
    private Users canManagerUsers = new Users(null);
    private final int error = -2;
    private final int group = -1;
    private User loginUser;
    private int nTypeIndex = -1;
    private String sTypeName = "";
    private HashMap m_hRelGroupsOfUser = null;
    private String acceptType = "";
    private String acceptValue = "";
    private int acceptTypeIndex = -1;
    private int nUserIndex = -1;
    private int nAddFieldCount = -1;

    public DocStatHandlerByUser(String sTypeName, String acceptTypeName, String acceptValue, int nAddFieldCount) throws WCMException {
        this.sTypeName = sTypeName;
        this.m_hRelGroupsOfUser = new HashMap();
        this.loginUser = ContextHelper.getLoginUser();
        this.acceptType = acceptTypeName;
        this.acceptValue = acceptValue;
        this.nAddFieldCount = nAddFieldCount;
        this.getCanMrgUsers();
    }

    @Override
    public void visitStart(ResultSet resultSet, int nSQLIndex) throws WCMException {
        super.visitStart(resultSet, nSQLIndex);
        this.nTypeIndex = this.getKeyIndex(this.sTypeName, resultSet);
        this.acceptTypeIndex = this.getKeyIndex(this.acceptType, resultSet);
        this.nUserIndex = this.getKeyIndex("CrUser", resultSet);
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            int nDataCount = resultSet.getInt(1);
            User oUser = User.findByName(resultSet.getString(this.nUserIndex));
            if (oUser == null) {
                return;
            }
            int nUserId = oUser.getId();
            if (!this.loginUser.isAdministrator() && this.canManagerUsers.indexOf(User.findById(nUserId)) < 0) {
                return;
            }
            if (this.acceptTypeIndex > 0 && "ChnlId".equalsIgnoreCase(this.acceptType) && "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("STAT_BY_CHANNELECUMULATIVE", "TRUE"))) {
                int nChnlId = resultSet.getInt(this.acceptTypeIndex);
                boolean isSonChannel = false;
                Channel _chnl = Channel.findById(nChnlId);
                if (_chnl == null) {
                    return;
                }
                while (_chnl != null) {
                    if (_chnl.getId() == Integer.parseInt(this.acceptValue)) {
                        isSonChannel = true;
                        break;
                    }
                    _chnl = _chnl.getParent();
                }
                if (!isSonChannel) {
                    return;
                }
            } else {
                Group _group;
                String UserName;
                Groups oGroups;
                if (this.acceptTypeIndex > 0 && !resultSet.getString(this.acceptTypeIndex).equalsIgnoreCase(this.acceptValue)) {
                    return;
                }
                if (this.acceptTypeIndex == -1 && (oGroups = this.makeCurrRelGroups(UserName = resultSet.getString(this.getKeyIndex("CrUser", resultSet)))).indexOf(_group = Group.findById(Integer.parseInt(this.acceptValue))) < 0) {
                    return;
                }
            }
            if (this.nTypeIndex > 0) {
                if (this.sTypeName.equalsIgnoreCase("ChnlId") && "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("STAT_BY_CHANNELECUMULATIVE", "TRUE"))) {
                    String Key2 = resultSet.getString(this.nTypeIndex);
                    int nChannelId = Integer.parseInt(Key2);
                    for (Channel parent = Channel.findById(nChannelId); parent != null; parent = parent.getParent()) {
                        Key2 = parent.getId() + "";
                        String sKey = this.makePrivateKey(Key2, resultSet);
                        int oldValue = this.getValue(nSQLIndex, sKey);
                        this.setValue(nSQLIndex, sKey, nDataCount + oldValue);
                        this.addMajorObject(Key2);
                    }
                } else {
                    String Key3 = resultSet.getString(this.nTypeIndex);
                    String sKey = this.makePrivateKey(Key3, resultSet);
                    int oldValue = this.getValue(nSQLIndex, sKey);
                    this.setValue(nSQLIndex, sKey, nDataCount + oldValue);
                    this.addMajorObject(Key3);
                }
            } else {
                if (oUser == null) {
                    throw new WCMException("\u672a\u627e\u5230\u6307\u5b9a\u7528\u6237! [UserlId = " + nUserId + "]");
                }
                DebugTimer timerTemp = new DebugTimer();
                timerTemp.start();
                Groups oRelGroups = this.makeCurrRelGroups(oUser.getName());
                timerTemp.stop();
                logger.debug((Object)("makeCurrRelGroups of " + oUser.getName() + " use[" + timerTemp.getTime() + "]ms"));
                int nSize = oRelGroups.size();
                for (int nRelGroupIndex = 0; nRelGroupIndex < nSize; ++nRelGroupIndex) {
                    Group oRelGroup = (Group)oRelGroups.getAt(nRelGroupIndex);
                    if (oRelGroup == null) continue;
                    String sGroupId = oRelGroup.getId() + "";
                    String oGroupKey = this.makePrivateKey(sGroupId, resultSet);
                    int iExistsDataCount = this.getValue(nSQLIndex, oGroupKey);
                    int nDataCountOfCurrGroup = nDataCount;
                    this.setValue(nSQLIndex, oGroupKey, nDataCountOfCurrGroup += iExistsDataCount);
                    this.addMajorObject(sGroupId);
                }
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private String makePrivateKey(String Key2, ResultSet resultSet) throws SQLException {
        int nColumnCount = resultSet.getMetaData().getColumnCount();
        if (nColumnCount > 1 + this.nAddFieldCount) {
            String[] sParam = new String[]{Key2, resultSet.getString(nColumnCount)};
            return this.makeKey(sParam);
        }
        return Key2;
    }

    public void getCanMrgUsers() throws WCMException {
        if (this.loginUser.isAdministrator()) {
            return;
        }
        this.canManagerUsers.addElement(this.loginUser);
        Groups oGroups = this.loginUser.getGroups();
        for (int i = 0; i < oGroups.size(); ++i) {
            Group oGroup = (Group)oGroups.getAt(i);
            if (oGroup == null || !oGroup.isAdministrator(this.loginUser)) continue;
            Users oUsers = oGroup.getUsers(this.loginUser);
            for (int j = 0; j < oUsers.size(); ++j) {
                User oUser = (User)oUsers.getAt(j);
                if (oUser == null) continue;
                this.canManagerUsers.addElement(oUser);
            }
            Groups groups = Groups.openWCMObjs(null, null);
            int size = groups.size();
            for (int x = 0; x < size; ++x) {
                Group oAllGroup = (Group)groups.getAt(x);
                if (oAllGroup == null) continue;
                for (Group oParent = oAllGroup.getParent(); oParent != null; oParent = oParent.getParent()) {
                    if (oParent.getId() != oGroup.getId()) continue;
                    Users oSubUsers = oAllGroup.getUsers(this.loginUser);
                    for (int y = 0; y < oSubUsers.size(); ++y) {
                        User oUser = (User)oSubUsers.getAt(y);
                        if (oUser == null) continue;
                        this.canManagerUsers.addElement(oUser);
                    }
                }
            }
        }
    }

    private int getKeyIndex(String keyName, ResultSet resultSet) throws WCMException {
        if (keyName == null || keyName == "") {
            return -2;
        }
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int nColumnCount = metaData.getColumnCount();
            for (int i = 1; i <= nColumnCount; ++i) {
                if (!keyName.equalsIgnoreCase(metaData.getColumnName(i))) continue;
                return i;
            }
        }
        catch (SQLException e) {
            throw new WCMException(1100, "\u8bbe\u7f6ecruser\u7684\u7d22\u5f15\u4f4d\u7f6e\u51fa\u73b0\u9519\u8bef", e);
        }
        return -1;
    }

    private Groups makeCurrRelGroups(String _sLowerCaseUserName) throws WCMException {
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfUser.get(_sLowerCaseUserName);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        oCurrRelGroups = new Groups(null);
        User oCurrUser = User.findByName(_sLowerCaseUserName);
        if (oCurrUser == null) {
            return oCurrRelGroups;
        }
        Groups groups = oCurrUser.getGroups();
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null && AuthServer.hasRight(this.loginUser, (CMSObj)parent, 13); parent = parent.getParent()) {
                oCurrRelGroups.addElement(parent);
            }
        }
        this.m_hRelGroupsOfUser.put(oCurrUser.getKey(), oCurrRelGroups);
        return oCurrRelGroups;
    }
}

