/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.domain.publisher.PageGenerator;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskDispatcher;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskRuntime;
import com.trs.components.common.publish.domain.template.ITemplateEmployCacheMgr;
import com.trs.components.common.publish.persistent.element.IFolderQuoter;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTasks;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PublishServer
extends BaseServer {
    private static final Logger logger = Logger.getLogger(PublishServer.class);
    private ITemplateEmployCacheMgr m_oCacheMgr = (ITemplateEmployCacheMgr)DreamFactory.createObjectById("ITemplateEmployCacheMgr");
    private IPublishTaskDispatcher m_taskDispatcher;
    private IPublishTaskMgr m_taskManager = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");

    public PublishServer() {
        this.m_taskDispatcher = (IPublishTaskDispatcher)DreamFactory.createObjectById("IPublishTaskDispatcher");
        try {
            ContextHelper.getLoginUser();
        }
        catch (RuntimeException e) {
            ContextHelper.setLoginUser(User.getSystem());
        }
    }

    public static PublishServer getInstance() {
        PublishServer server = (PublishServer)DreamFactory.createObjectById("PublishServer");
        if (!server.isStarted()) {
            server.startup();
            if (!server.isStarted()) {
                throw new RuntimeException(I18NMessage.get(PublishServer.class, "PublishServer.label1", "PublishServer\u672a\u542f\u52a8\uff01"));
            }
        }
        return server;
    }

    @Override
    protected boolean doStart() throws WCMException {
        logger.info((Object)"to start template employer cache...");
        this.m_oCacheMgr.init();
        logger.info((Object)"template employer cache is ready now.");
        logger.info((Object)"to start publish task dispatcher...");
        this.m_taskDispatcher.startup();
        logger.info((Object)"publish task dispatcher is ready now.");
        return true;
    }

    @Override
    protected void doShutdown() {
        logger.info((Object)"to shutdown template employer cache...");
        this.m_oCacheMgr.clear();
        logger.info((Object)"template employer cache is closed.");
        logger.info((Object)"to shutdown the publish task dispatcher...");
        this.m_taskDispatcher.shutdown();
        logger.info((Object)"publish task dispatcher is closed.");
    }

    public String[] previewFolder(IPublishFolder _folder, String[] _warningsHolder) throws WCMException {
        return this.previewFolder(_folder, _warningsHolder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] previewFolder(IPublishFolder _folder, String[] _warningsHolder, Template _template) throws WCMException {
        if (_folder == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishServer.class, "PublishServer.label2", "\u6ca1\u6709\u6307\u5b9a\u53d1\u5e03\u7684\u680f\u76ee!"));
        }
        _folder.validateCanDoPreview();
        PublishTaskContext taskContext = new PublishTaskContext(null, _folder);
        PublishPageContext pageContext = new PublishPageContext(_folder, taskContext);
        pageContext.setTemplate(_template);
        try {
            String[] results = PageGenerator.generateOutlines(pageContext);
            if (_warningsHolder != null) {
                _warningsHolder[0] = pageContext.getWarnings();
            }
            String[] stringArray = results;
            return stringArray;
        }
        finally {
            pageContext.clear();
            taskContext.clear();
        }
    }

    public String previewContent(IPublishContent _content, String[] _warningsHolder) throws Exception {
        return this.previewContent(_content, _warningsHolder, null);
    }

    public String previewContent(IPublishContent _content, String[] _warningsHolder, Template _template) throws Exception {
        return this.previewContent(_content, _warningsHolder, _template, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String previewContent(IPublishContent _content, String[] _warningsHolder, Template _template, Map paramMap) throws Exception {
        block10: {
            if (_content == null) {
                throw new WCMException(10, "ContentTypeConfig to publish required!");
            }
            try {
                _content.validateCanDoPreview();
            }
            catch (BizError e) {
                throw e;
            }
            catch (Exception e) {
                if (_template != null && e instanceof CMyException && ((CMyException)e).getErrNo() == 200003) break block10;
                throw e;
            }
        }
        PublishTaskContext taskContext = new PublishTaskContext(null, _content.getFolder());
        if (paramMap != null) {
            for (Map.Entry entry : paramMap.entrySet()) {
                taskContext.putInCache((String)entry.getKey(), entry.getValue());
            }
        }
        PublishPageContext pageContext = new PublishPageContext(_content, taskContext);
        pageContext.setTemplate(_template);
        try {
            String result = PageGenerator.generateDetail(pageContext);
            if (_warningsHolder != null) {
                _warningsHolder[0] = pageContext.getWarnings();
            }
            String string = result;
            return string;
        }
        finally {
            pageContext.clear();
            taskContext.clear();
        }
    }

    public void publishFolder(IPublishFolder _folder, int _nPublishType) throws WCMException {
        if (_folder == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishServer.class, "PublishServer.label4", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u53d1\u5e03\u7684\u5bf9\u8c61!"));
        }
        PublishServer.validateElement(_folder);
        PublishTask task = this.m_taskManager.createFolderPublishTask(_folder, _nPublishType);
        if (task == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(task);
    }

    public void publishFolderAndPublishedDocs(IPublishFolder _folder, int _nPublishType, CMyDateTime _startDocCrtime, CMyDateTime _endDocCrtime) throws WCMException {
        if (_folder == null) {
            throw new WCMDatainvalidException(10, I18NMessage.get(PublishServer.class, "PublishServer.label4", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u53d1\u5e03\u7684\u5bf9\u8c61!"));
        }
        PublishServer.validateElement(_folder);
        PublishTask task = this.m_taskManager.createPublishTaskForFolderAndPubDocs(_folder, _nPublishType, _startDocCrtime, _endDocCrtime);
        if (task == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(task);
    }

    public void deleteFolder(IPublishFolder _folder) throws Exception {
        this.deleteFolder(_folder, true);
    }

    public void deleteFolder(IPublishFolder _folder, boolean _bUpdateStatus) throws Exception {
        if (_folder == null) {
            throw new WCMException(10, "FolderTypeConfig to delete is required!");
        }
        PageDestroyer.withdraw(_folder, null);
        if (_bUpdateStatus) {
            _folder.setPublishStatus(10);
        }
        this.updateFoldersQuotingMe(_folder);
    }

    public void deleteFolderSelfOnly(IPublishFolder _folder) throws Exception {
        if (_folder == null) {
            return;
        }
        PageDestroyer.withdraw(_folder, null);
        this.updateFoldersQuotingMe(_folder);
    }

    public void publishContent(IPublishContent _content, IPublishElements folders) throws WCMException {
        PublishTask task;
        if (_content == null) {
            throw new WCMException(10, I18NMessage.get(PublishServer.class, "PublishServer.label5", "\u7f3a\u5c11\u5f85\u53d1\u5e03\u7684\u6587\u6863\uff01"));
        }
        IPublishFolder folder = _content.getFolder();
        if (folder == null) {
            throw new WCMException(10, I18NMessage.get(PublishServer.class, "PublishServer.label6", "\u5f85\u53d1\u5e03\u7684\u6587\u6863\u7f3a\u5c11\u76ee\u5f55\uff01"));
        }
        if (!folder.canDoDetailPageTask() && _content.getDetailTemplate() == null) {
            throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label7", "\u6240\u5728\u7684Folder[") + folder.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label8", "]\u4e0d\u5141\u8bb8\u53d1\u5e03\u7ec6\u89c8\uff01"));
        }
        if (folders != null) {
            for (int i = folders.size() - 1; i >= 0; --i) {
                IPublishFolder folderTemp = (IPublishFolder)folders.get(i);
                if (folderTemp != null && folderTemp.canDoOutlinePageTask()) continue;
                folders.remove(i);
            }
        }
        if ((task = this.m_taskManager.createContentPublishTask(_content, folder, folders)) == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(task);
    }

    public void publishContent(IPublishContent _content, int _nPubType) throws WCMException {
        if (_content == null) {
            throw new WCMException(10, "ContentTypeConfig to publish required!");
        }
        if (_content.getFolder() == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies required (plz call IPublishContent.setFolder())!");
        }
        boolean bNeedStatusCheck = ConfigServer.getServer().getSysConfigValue("DIRECTPUB_STATUS_CHECK", "false").trim().equalsIgnoreCase("true");
        if (7 == _nPubType) {
            PublishServer.validateElement(_content.getFolder());
        } else if (_nPubType == 10 && !bNeedStatusCheck) {
            IPublishFolder folder = _content.getFolder();
            if (!folder.canDoDetailPageTask() && _content.getDetailTemplate() == null) {
                throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label7", "\u6240\u5728\u7684Folder[") + folder.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label8", "]\u4e0d\u5141\u8bb8\u53d1\u5e03\u7ec6\u89c8\uff01"));
            }
        } else {
            PublishServer.validateElement(_content);
        }
        PublishTask task = this.m_taskManager.createContentPublishTask(_content, _nPubType);
        if (task == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(task);
    }

    public void publishContent(IPublishContent _content) throws Exception {
        this.publishContent(_content, 3);
    }

    public void publishContents(IPublishElements _contents, IPublishFolder _folder, int _nPubType) throws Exception {
        if (_contents == null) {
            throw new WCMException(10, "Contents to publish is required!");
        }
        if (_folder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies is required!");
        }
        if (7 == _nPubType) {
            PublishServer.validateElement(_folder);
        }
        if (_contents.isEmpty()) {
            return;
        }
        boolean bNeedStatusCheck = ConfigServer.getServer().getSysConfigValue("DIRECTPUB_STATUS_CHECK", "false").trim().equalsIgnoreCase("true");
        int iCount = 0;
        IPublishContent content = null;
        int nSize = _contents.size();
        for (int i = 0; i < nSize; ++i) {
            content = (IPublishContent)_contents.get(i);
            if (content == null) continue;
            if (_folder.isRoot()) {
                content.setFolder(content.getOriginalHome());
            } else {
                content.setFolder(_folder);
            }
            if (7 != _nPubType) {
                if (_nPubType == 10 && !bNeedStatusCheck) {
                    IPublishFolder contentFolder = content.getFolder();
                    if (!contentFolder.canDoDetailPageTask() && content.getDetailTemplate() == null) {
                        throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label7", "\u6240\u5728\u7684Folder[") + contentFolder.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label8", "]\u4e0d\u5141\u8bb8\u53d1\u5e03\u7ec6\u89c8\uff01"));
                    }
                } else {
                    content.validateCanDoPub();
                }
            }
            ++iCount;
        }
        if (iCount == 0) {
            return;
        }
        if (iCount == 1) {
            PublishTask task = this.m_taskManager.createContentPublishTask(content, _nPubType);
            if (task != null) {
                this.m_taskDispatcher.pushTask(task);
            }
        } else {
            List<PublishTask> tasks = this.m_taskManager.createContentPublishTask(_contents, _folder, _nPubType);
            for (PublishTask task : tasks) {
                if (task == null) continue;
                this.m_taskDispatcher.pushTask(task);
            }
        }
    }

    public void deleteContent(IPublishContent _content) throws Exception {
        this.deleteContent(_content, true);
    }

    public void deleteContent(IPublishContent _content, boolean _bWithdrawRelateResource) throws Exception {
        if (_content == null) {
            throw new WCMException(10, "ContentTypeConfig to delete required!");
        }
        IPublishFolder folder = _content.getFolder();
        if (folder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies required (call IPublishContent.setFolder())!");
        }
        this.withdrawFileIfNeed(_content, false, _bWithdrawRelateResource);
        _content.setPublishStatus(10);
        _content.setPublishTimeAndURL(null, null);
        PublishTask task = this.m_taskManager.createDeleteContentsSynPublishTask(folder, _content);
        if (task == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(task);
    }

    public void deleteContents(IPublishElements _contents, IPublishFolder _folder) throws Exception {
        this.deleteContents(_contents, _folder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContents(IPublishElements _contents, IPublishFolder _folder, boolean _bWithdrawRelateResource) throws Exception {
        if (_contents == null) {
            throw new WCMException(10, "Contents to delete is required!");
        }
        if (_folder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies is required!");
        }
        if (_contents.isEmpty()) {
            return;
        }
        PublishTaskContext taskContext = null;
        try {
            for (int i = 0; i < _contents.size(); ++i) {
                IPublishContent content = (IPublishContent)_contents.get(i);
                content.setFolder(_folder);
                this.withdrawFileIfNeed(content, false, _bWithdrawRelateResource);
                content.setPublishStatus(10);
                content.setPublishTimeAndURL(null, null);
            }
        }
        finally {
            if (taskContext != null) {
                taskContext.clear();
            }
        }
        PublishTask task = this.m_taskManager.createDeleteContentsSynPublishTask(_folder, _contents);
        if (task == null) {
            return;
        }
        this.m_taskDispatcher.pushTask(task);
    }

    public void deleteContents(IPublishElements _contents, IPublishFolder _folder, IPublishElements _folders) throws Exception {
        this.deleteContents(_contents, _folder, _folders, true);
    }

    public void deleteContents(IPublishElements _contents, IPublishFolder _folder, IPublishElements _folders, boolean _bUpdateStatus) throws Exception {
        this.deleteContents(_contents, _folder, _folders, _bUpdateStatus, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContents(IPublishElements _contents, IPublishFolder _folder, IPublishElements _folders, boolean _bUpdateStatus, boolean _bWithdrawRelateResource) throws Exception {
        if (_contents == null) {
            throw new WCMException(10, "Contents to delete is required!");
        }
        if (_folder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies is required!");
        }
        if (_contents.isEmpty()) {
            return;
        }
        PublishTaskContext taskContext = null;
        try {
            for (int i = 0; i < _contents.size(); ++i) {
                IPublishContent content = (IPublishContent)_contents.get(i);
                content.setFolder(_folder);
                this.withdrawFileIfNeed(content, false, _bWithdrawRelateResource);
                if (_bUpdateStatus) {
                    content.setPublishStatus(10);
                }
                content.setPublishTimeAndURL(null, null);
            }
        }
        finally {
            if (taskContext != null) {
                taskContext.clear();
            }
        }
        List<PublishTask> tasks = this.m_taskManager.createDestroyPublishTask(_contents, _folder, _folders);
        for (PublishTask task : tasks) {
            this.m_taskDispatcher.pushTask(task);
        }
    }

    public void deleteContentsWithMirror(IPublishElements _contents, IPublishFolder _folder, IPublishElements _folders) throws Exception {
        this.deleteContentsWithMirror(_contents, _folder, _folders, true);
    }

    public void deleteContentsWithMirror(IPublishElements _contents, IPublishFolder _folder, IPublishElements _folders, boolean _bWithdrawRelateResource) throws Exception {
        if (_contents == null) {
            throw new WCMException(10, "Contents to delete is required!");
        }
        if (_folder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies is required!");
        }
        if (_contents.isEmpty()) {
            return;
        }
        for (int i = 0; i < _contents.size(); ++i) {
            IPublishContent content = (IPublishContent)_contents.get(i);
            content.setFolder(_folder);
            this.withdrawFileIfNeed(content, true, _bWithdrawRelateResource);
            content.setPublishStatus(10);
            content.setPublishTimeAndURL(null, null);
        }
        List<PublishTask> tasks = this.m_taskManager.createDestroyPublishTask(_contents, _folder, _folders);
        for (PublishTask task : tasks) {
            this.m_taskDispatcher.pushTask(task);
        }
    }

    private void withdrawFileIfNeed(IPublishContent content, boolean withdrawAll, boolean _bWithdrawRelateResource) throws Exception {
        int nModal = content.getModal();
        if (nModal != 2 && !content.isLink()) {
            PageDestroyer.withdraw(content, null);
        }
        if (!withdrawAll) {
            return;
        }
        int status = 10;
        boolean zIsEntity = nModal == 1;
        IPublishElements folders = this.getMirrorFolders(content.getId());
        StringBuffer buff = null;
        if (folders != null && folders.size() > 0) {
            IPublishFolder oldFolder = content.getFolder();
            if (!zIsEntity) {
                content.setFolder(content.getOriginalHome());
                try {
                    PageDestroyer.withdraw(content, null, _bWithdrawRelateResource);
                    content.setPublishStatus(status);
                    content.setPublishTimeAndURL(null, null);
                }
                catch (Exception ex) {
                    buff = new StringBuffer(1024);
                    buff.append("Failed to withdraw: ");
                    buff.append(content.getInfo());
                    buff.append(" in: ");
                    buff.append(content.getOriginalHome());
                }
            }
            int size = folders.size();
            for (int i = 0; i < size; ++i) {
                IPublishFolder currFolder = (IPublishFolder)folders.get(i);
                if (currFolder == null) continue;
                content.setFolder(currFolder);
                try {
                    PageDestroyer.withdraw(content, null, _bWithdrawRelateResource);
                    content.setPublishStatus(status);
                    content.setPublishTimeAndURL(null, null);
                    continue;
                }
                catch (Exception ex) {
                    if (buff == null) {
                        buff = new StringBuffer(1024);
                        buff.append("Failed to withdraw: ");
                        buff.append(content.getInfo());
                        buff.append(" in: ");
                        buff.append(currFolder.getInfo());
                        continue;
                    }
                    buff.append(", ").append(currFolder.getInfo());
                }
            }
            content.setFolder(oldFolder);
        }
        if (buff != null) {
            throw new Exception(buff.toString());
        }
    }

    private IPublishElements getMirrorFolders(int id) throws WCMException {
        DBManager dbmanager = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select chnlid from wcmchnldoc where modal=3 and docid=?";
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, id);
            rs = pstmt.executeQuery();
            StringBuffer buff = new StringBuffer(64);
            while (rs.next()) {
                buff.append(',').append(rs.getInt(1));
            }
            if (buff.length() > 1) {
                IPublishElements iPublishElements = PublishElementFactory.lookupElements(101, buff.substring(1));
                return iPublishElements;
            }
        }
        catch (Exception e) {
            throw new WCMException("\u64a4\u9500\u53d1\u5e03\u5931\u8d25!", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            dbmanager.freeConnection(conn);
        }
        return null;
    }

    private void updateFoldersQuotingMe(IPublishFolder _folder) throws WCMException {
        Collection quoters = null;
        try {
            quoters = _folder instanceof IFolderQuoter ? ((IFolderQuoter)((Object)_folder)).getFoldersQuotingMe(true) : _folder.getFoldersQuotingMe();
            if (quoters == null || quoters.isEmpty()) {
                return;
            }
            for (IPublishFolder aFolder : quoters) {
                PublishTask task = this.m_taskManager.createFolderPublishTask(aFolder, 8);
                if (task == null) {
                    return;
                }
                this.m_taskDispatcher.pushTask(task);
            }
        }
        catch (Exception ex) {
            throw new WCMException(222, I18NMessage.get(PublishServer.class, "PublishServer.label9", "\u66f4\u65b0\u53d1\u5e03\u5f15\u7528[") + _folder.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label10", "]\u7684\u6587\u4ef6\u5939\u5931\u8d25\uff01"), ex);
        }
        finally {
            if (quoters != null) {
                quoters.clear();
            }
        }
    }

    public PublishTasks getMyTasks(WCMFilter _filter) throws Exception {
        return this.m_taskManager.getTasks(_filter);
    }

    public PublishTasks getAllTasks(WCMFilter _filter) throws Exception {
        return this.m_taskManager.getTasks(_filter);
    }

    public void pauseTask(PublishTask _task) throws WCMException {
        if (_task == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (_task.isExecuted()) {
            return;
        }
        this.m_taskDispatcher.pauseTask(_task.getId());
    }

    public void resumeTask(PublishTask _task) throws WCMException {
        if (_task == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (_task.isExecuted()) {
            return;
        }
        this.m_taskDispatcher.resumeTask(_task.getId());
    }

    public PublishTaskRuntime getTaskRuntime(int iTaskID) {
        return this.m_taskDispatcher.getTaskRuntime(iTaskID);
    }

    public PublishTask getRunningTask(int iTaskID) {
        return this.m_taskDispatcher.getRunningTask(iTaskID);
    }

    public Iterator getRunningTasks() {
        return this.m_taskDispatcher.getRunningTasks();
    }

    public void cancelTask(PublishTask _task) throws WCMException {
        if (_task == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (_task.isExecuted()) {
            return;
        }
        this.m_taskDispatcher.cancelTask(_task.getId());
    }

    public void deleteTask(PublishTask _task) throws Exception {
        if (_task == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (!_task.isExecuted()) {
            this.m_taskDispatcher.cancelTask(_task.getId());
        }
        _task.delete(ContextHelper.getLoginUser());
    }

    public void cancelTask(PublishTasks _tasks) throws Exception {
        if (_tasks == null) {
            throw new WCMException(10, "The publish tasks collection is required!");
        }
        if (_tasks.isEmpty()) {
            return;
        }
        for (int i = 0; i < _tasks.size(); ++i) {
            PublishTask task = (PublishTask)_tasks.getAt(i);
            if (task.isExecuted()) continue;
            this.m_taskDispatcher.cancelTask(task.getId());
        }
    }

    public void redoTask(PublishTask _task) throws Exception {
        this.redoTask(_task, ContextHelper.getLoginUser());
    }

    public void redoTask(PublishTasks _tasks) throws Exception {
        if (_tasks == null) {
            throw new WCMException(10, "The publish tasks collection is required!");
        }
        if (_tasks.isEmpty()) {
            return;
        }
        User currUser = _tasks.getCurrUser();
        for (int i = 0; i < _tasks.size(); ++i) {
            this.redoTask((PublishTask)_tasks.getAt(i), currUser);
        }
    }

    private void redoTask(PublishTask _task, User _currUser) throws Exception {
        if (_task == null) {
            throw new WCMException(10, "The publish task is required!");
        }
        if (!_task.isExecuted()) {
            throw new WCMException(223, "The publish task must has been executed before re-start!");
        }
        PublishTask copy = _task.duplicate(_currUser, true);
        this.m_taskDispatcher.pushTask(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int distributeFile(String _sLocalFilePathName, IPublishElement _fileOwner) throws WCMException {
        FileDistributeShip aShip = new FileDistributeShip();
        try {
            int n = aShip.distributeFile(_sLocalFilePathName, _fileOwner);
            return n;
        }
        finally {
            aShip.clear();
        }
    }

    public static void validateElement(int _nElementType, int _nElementId) throws WCMException {
        IPublishElement publishElement = PublishElementFactory.lookupElement(_nElementType, _nElementId);
        if (publishElement == null) {
            throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label11", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u53d1\u5e03\u5bf9\u8c61\uff01[Type=") + _nElementType + ",Id=" + _nElementId + "]");
        }
        PublishServer.validateElement(publishElement);
    }

    public static void validateElement(IPublishElement _publishElement) throws WCMException {
        if (_publishElement == null) {
            throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label12", "\u6ca1\u6709\u6307\u5b9a\u53d1\u5e03\u5bf9\u8c61\uff01"));
        }
        _publishElement.validateCanDoPub();
    }

    public static boolean isValidateElement(IPublishElement _publishElement) {
        try {
            PublishServer.validateElement(_publishElement);
            return true;
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(PublishServer.class, "PublishServer.label13", "\u53d1\u5e03\u5143\u7d20[") + _publishElement.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label14", "]\u7684\u975e\u6cd5\uff01")), e);
            }
            return false;
        }
    }

    public static boolean isValidateElement(int _nElementType, int _nElementId) {
        try {
            PublishServer.validateElement(_nElementType, _nElementId);
            return true;
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(PublishServer.class, "PublishServer.label15", "\u53d1\u5e03\u5143\u7d20[Type=") + _nElementType + ", Id=" + _nElementId + I18NMessage.get(PublishServer.class, "PublishServer.label16", "]\u975e\u6cd5\uff01")), e);
            }
            return false;
        }
    }

    private String getFolderIndexFile(IPublishFolder _folder) {
        return "index.html";
    }

    private String makeBackupFileFor(String sFileName) {
        return sFileName + ".bak";
    }

    public void publishConfirm(IPublishFolder _folder, String _sSourceFile, String _sTargetFile, String _sBackupFile) throws WCMException {
        String sErrMsg;
        String sTargetFileTemp;
        if (_folder == null) {
            throw new WCMException(10, I18NMessage.get(PublishServer.class, "PublishServer.label17", "\u7f3a\u5c11\u5f85\u786e\u8ba4\u7684\u76ee\u5f55\uff01"));
        }
        if (_sSourceFile == null) {
            throw new WCMException(10, I18NMessage.get(PublishServer.class, "PublishServer.label18", "\u7f3a\u5c11\u5f85\u786e\u8ba4\u7684\u5143\u6587\u4ef6\uff01"));
        }
        if (_sTargetFile == null) {
            _sTargetFile = this.getFolderIndexFile(_folder);
            logger.info((Object)I18NMessage.get(PublishServer.class, "PublishServer.label19", "\u4ece\u7cfb\u7edf\u914d\u7f6e\u8bfb\u53d6\u76ee\u6807\u914d\u7f6e\u6587\u4ef6..."));
        }
        if (_sBackupFile == null) {
            _sBackupFile = this.makeBackupFileFor(_sTargetFile);
            logger.info((Object)I18NMessage.get(PublishServer.class, "PublishServer.label20", "\u4ece\u7cfb\u7edf\u914d\u7f6e\u8bfb\u53d6\u5907\u4efd\u914d\u7f6e\u6587\u4ef6..."));
        }
        PublishPathCompass compass = new PublishPathCompass();
        String sFolderPubPath = CMyString.setStrEndWith(compass.getLocalPath(_folder, false), File.separatorChar);
        try {
            if (CMyFile.fileExists(sFolderPubPath + _sSourceFile)) {
                if (CMyFile.fileExists(sFolderPubPath + _sTargetFile)) {
                    CMyFile.copyFile(sFolderPubPath + _sTargetFile, sFolderPubPath + _sBackupFile);
                }
                CMyFile.copyFile(sFolderPubPath + _sSourceFile, sFolderPubPath + _sTargetFile);
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(PublishServer.class, "PublishServer.label21", "\u62f7\u8d1d\u672c\u5730\u6587\u4ef6\u5931\u8d25\uff01"), (Throwable)e);
        }
        String sFullPath = PublishPathCompass.calFullDataPath(_folder, false);
        FileDistributeShip ship = new FileDistributeShip();
        String sTimeStamp = CMyDateTime.now().toString("yyyyMMdd_hhmmss");
        String sSourceFileTemp = _sSourceFile + "." + sTimeStamp;
        if (!this.renameFile(_folder, _sSourceFile, sFullPath, ship, sSourceFileTemp)) {
            return;
        }
        String sBackupFileTemp = _sBackupFile + "." + sTimeStamp;
        if (this.renameFile(_folder, _sBackupFile, sFullPath, ship, sBackupFileTemp)) {
            try {
                ship.withdrawFile(sBackupFileTemp, _folder, sFullPath);
            }
            catch (Exception e) {
                logger.error((Object)I18NMessage.get(PublishServer.class, "PublishServer.label22", "\u5df2\u7ecf\u5ffd\u7565\u786e\u8ba4\u53d1\u5e03\u8fc7\u7a0b\u4e2d\u5220\u9664\u539f\u5907\u4efd\u6587\u4ef6\u65f6\u7684\u9519\u8bef"), (Throwable)e);
            }
        }
        if (this.renameFile(_folder, _sTargetFile, sFullPath, ship, sTargetFileTemp = _sTargetFile + "." + sTimeStamp)) {
            try {
                ship.renameFile(_folder, sTargetFileTemp, _sBackupFile, sFullPath);
            }
            catch (Exception e) {
                sErrMsg = I18NMessage.get(PublishServer.class, "PublishServer.label23", "\u786e\u8ba4\u53d1\u5e03\u8fc7\u7a0b\u4e2d\u91cd\u547d\u540d\u6b63\u5f0f\u76ee\u6807\u6587\u4ef6\u4e3a\u5907\u4efd\u6587\u4ef6\u65f6\u7684\u9519\u8bef");
                logger.error((Object)sErrMsg, (Throwable)e);
            }
        }
        try {
            ship.renameFile(_folder, sSourceFileTemp, _sTargetFile, sFullPath);
        }
        catch (Exception e) {
            sErrMsg = I18NMessage.get(PublishServer.class, "PublishServer.label23", "\u786e\u8ba4\u53d1\u5e03\u8fc7\u7a0b\u4e2d\u91cd\u547d\u540d\u6b63\u5f0f\u76ee\u6807\u6587\u4ef6\u4e3a\u5907\u4efd\u6587\u4ef6\u65f6\u7684\u9519\u8bef");
            logger.error((Object)sErrMsg, (Throwable)e);
            throw new WCMException(sErrMsg, e);
        }
    }

    private boolean renameFile(IPublishFolder _folder, String _sSrcFileName, String sFullPath, FileDistributeShip ship, String _sTargetFileName) {
        try {
            ship.renameFile(_folder, _sSrcFileName, _sTargetFileName, sFullPath);
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(PublishServer.class, "PublishServer.label24", "\u66f4\u540d\u6587\u4ef6\u5931\u8d25\uff01") + _sSrcFileName + "-->" + _sTargetFileName));
            return false;
        }
        return true;
    }
}

