/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.PhotoServiceProvider;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.PinyinHelper;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipInputStream;
import com.trs.infra.util.store.FileService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

class UnZipFile4Batch
extends CMyUnZipFile {
    private Hashtable m_hAllFileNameIndex = null;
    private List m_filters = null;
    private boolean m_zFiltered = false;

    public UnZipFile4Batch(String _sZipFile, String _sUnZipPath) {
        super(_sZipFile, _sUnZipPath);
    }

    private boolean include(String fn) {
        String ext = CMyFile.extractFileExt(fn);
        return this.m_filters.indexOf(ext.toLowerCase()) != -1;
    }

    public void setFilters(String[] exts) {
        if (exts == null || exts.length == 0) {
            return;
        }
        this.m_filters = new ArrayList(exts.length);
        int len = exts.length;
        for (int i = 0; i < len; ++i) {
            this.m_filters.add(exts[i].toLowerCase());
        }
        this.m_zFiltered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUnZipAnd() throws CMyException {
        String fn = this.getZipFile();
        if (!CMyFile.fileExists(fn)) {
            throw new CMyException(55, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label18", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u538b\u7f29\u6587\u4ef6[") + fn + "]");
        }
        String destDir = this.getUnZipPath();
        if (!CMyFile.fileExists(destDir)) {
            CMyFile.makeDir(destDir, true);
        }
        InputStream fis = null;
        BufferedInputStream bis = null;
        ZipInputStream zis = null;
        try {
            boolean zFileSeperatorSalsh = '/' != File.pathSeparatorChar;
            byte[] buff = new byte[1024];
            int chunk = 0;
            OutputStream fos = null;
            String sWritedFn = null;
            String sFnEncoding = this.getFileNameEncoding();
            if (CMyString.isEmpty(sFnEncoding)) {
                sFnEncoding = "GBK";
            }
            this.m_hAllFileNameIndex = new Hashtable(10, 1.0f);
            fis = new FileService(fn).getInputStream();
            bis = new BufferedInputStream(fis);
            zis = new ZipInputStream(bis);
            ZipEntry entry = zis.getNextEntry(sFnEncoding);
            while (entry != null) {
                if (!entry.isDirectory()) {
                    fn = entry.getName();
                    if (zFileSeperatorSalsh) {
                        fn = fn.replace('/', File.separatorChar);
                    }
                    fn = destDir + fn;
                    if (this.m_zFiltered && !this.include(fn)) {
                        entry = zis.getNextEntry(sFnEncoding);
                        continue;
                    }
                    sWritedFn = PinyinHelper.convert(fn);
                    String sPath = CMyFile.extractFilePath(sWritedFn);
                    if (!CMyFile.pathExists(sPath)) {
                        CMyFile.makeDir(sPath, true);
                    }
                    try {
                        fos = new FileService(sWritedFn).getOutputStream();
                        while ((chunk = zis.read(buff, 0, buff.length)) != -1) {
                            fos.write(buff, 0, chunk);
                        }
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.flush();
                            }
                            catch (Exception exception) {}
                            try {
                                fos.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    this.m_hAllFileNameIndex.put(fn, sWritedFn);
                }
                entry = zis.getNextEntry(sFnEncoding);
            }
        }
        catch (Exception ex) {
            throw new CMyException(200, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label19", "\u89e3\u538b\u6587\u4ef6\u3010") + this.getZipFile() + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label20", "\u3011\u5230\u76ee\u5f55\u3010") + this.getUnZipPath() + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label21", "\u3011\u5931\u8d25\uff01"), ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception exception) {}
            }
            try {
                CMyFile.deleteFile(this.getZipFile());
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Hashtable getAllFileNameIndex() {
        return this.m_hAllFileNameIndex;
    }

    public SortedMap getSortedFileNameIndex() {
        TreeMap map = new TreeMap(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String fn1 = String.valueOf(arg0);
                String fn2 = String.valueOf(arg1);
                return fn2.compareTo(fn1);
            }
        });
        if (this.m_hAllFileNameIndex != null && !this.m_hAllFileNameIndex.isEmpty()) {
            Iterator itrKeys = this.m_hAllFileNameIndex.keySet().iterator();
            Object fn = null;
            while (itrKeys.hasNext()) {
                fn = itrKeys.next();
                map.put(fn, this.m_hAllFileNameIndex.get(fn));
            }
        }
        return map;
    }
}

