/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.job.impl;

import com.trs.dev4.jdk16.job.IJobExecutor;
import com.trs.dev4.jdk16.job.IJobListener;
import com.trs.dev4.jdk16.job.JobDetail;
import com.trs.dev4.jdk16.job.impl.BaseJobService;
import com.trs.dev4.jdk16.job.impl.JobExecutorWrapper;
import com.trs.dev4.jdk16.job.impl.JobRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SchedulerJobService
extends BaseJobService
implements IJobListener {
    private static final Logger logger = Logger.getLogger(SchedulerJobService.class);
    private final Map<String, JobRunner> jobRunners = new HashMap<String, JobRunner>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10);

    @Override
    protected void cancelJob(JobDetail jobDetail) {
        JobRunner jobWrapper = this.getRunner(jobDetail);
        if (jobWrapper != null) {
            jobWrapper.getScheduledFuture().cancel(true);
            this.jobRunners.remove(jobDetail.getJobName());
        }
    }

    @Override
    public void scheduleJob(JobDetail jobDetail) {
        IJobExecutor jobExecutor;
        JobRunner jobRunner = this.getRunner(jobDetail);
        if (jobRunner != null) {
            if (!jobRunner.changedDetail(jobDetail)) {
                logger.debug((Object)("JobRunner no change with executorName(" + jobDetail.getJobName() + ")."));
                jobRunner.check();
                return;
            }
            this.cancelJob(jobDetail);
        }
        if ((jobExecutor = this.getExecutor(jobDetail)) == null) {
            logger.debug((Object)("Can't found jobExecutor with executorName(" + jobDetail.getExecutorName() + ")."));
            return;
        }
        JobExecutorWrapper jobExecutorWrapper = new JobExecutorWrapper(jobExecutor, jobDetail, this);
        ScheduledFuture<?> scheduledObject = jobDetail.getPeriodAsSecond() != 0 ? this.scheduler.scheduleAtFixedRate(jobExecutorWrapper, jobDetail.getDelayAsSecond(), jobDetail.getPeriodAsSecond(), TimeUnit.SECONDS) : this.scheduler.schedule(jobExecutorWrapper, 1L, TimeUnit.SECONDS);
        this.jobRunners.put(jobDetail.getJobName(), new JobRunner(jobDetail, scheduledObject));
    }

    private JobRunner getRunner(JobDetail jobDetail) {
        return this.jobRunners.get(jobDetail.getJobName());
    }

    @Override
    public void beforeExecute(IJobExecutor jobExecutor, JobDetail jobDetail) {
    }

    @Override
    public void afterExecuted(IJobExecutor jobExecutor, JobDetail jobDetail) {
        if (jobDetail.getPeriodAsSecond() == 0) {
            this.jobRunners.remove(jobDetail.getId());
        }
    }

    @Override
    public List<JobDetail> listScheduledJobs() {
        ArrayList<JobDetail> jobDetails = new ArrayList<JobDetail>();
        for (JobRunner jobRunner : this.jobRunners.values()) {
            jobDetails.add(jobRunner.getJobDetail());
        }
        return jobDetails;
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.scheduler.shutdown();
    }

    @Override
    public boolean existsJob(String jobName) {
        return this.jobRunners.containsKey(jobName);
    }

    @Override
    public int countJobs() {
        return this.jobRunners.size();
    }

    @Override
    protected void preSchedule() {
        for (JobRunner jobRunner : this.jobRunners.values()) {
            jobRunner.reset();
        }
    }

    @Override
    protected void postScheduled() {
        for (JobRunner jobRunner : this.jobRunners.values()) {
            if (jobRunner.isChecked()) continue;
            this.cancelJob(jobRunner.getJobDetail());
        }
    }
}

