/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cacheserver.memcached;

import com.trs.dev4.jdk16.cacheserver.memcached.IMemcachedClient;
import com.trs.dev4.jdk16.cacheserver.memcached.KetamaBinaryConnectionFactory;
import com.trs.dev4.jdk16.model.IModuleLifecycle;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.apache.log4j.Logger;

public class MemcachedClientSpyImpl
implements IMemcachedClient,
IModuleLifecycle {
    private static final Logger logger = Logger.getLogger(MemcachedClientSpyImpl.class);
    MemcachedClient memcachedClient;
    private String addresses;
    private ConnectionFactory factory;

    public MemcachedClientSpyImpl(String addresses) throws Exception {
        this.factory = new KetamaBinaryConnectionFactory();
        this.addresses = addresses;
    }

    public MemcachedClientSpyImpl(ConnectionFactory fact, String addresses) throws Exception {
        this.factory = fact;
        this.addresses = addresses;
    }

    @Override
    public void delete(String key) {
        this.memcachedClient.delete(key);
    }

    @Override
    public Object get(String key) {
        return this.memcachedClient.get(key);
    }

    @Override
    public void set(String key, int expr, Object value) {
        this.memcachedClient.set(key, expr, value);
    }

    @Override
    public void add(String key, int expr, Object value) {
        if (this.memcachedClient.get(key) != null) {
            return;
        }
        this.memcachedClient.add(key, expr, value);
    }

    @Override
    public void replace(String key, int expr, Object value) {
        if (this.memcachedClient.get(key) == null) {
            return;
        }
        this.memcachedClient.replace(key, expr, value);
    }

    @Override
    public Map<String, String> getStats(String server) {
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> getStats(String server, String itemName) {
        return new HashMap<String, String>();
    }

    @Override
    public Object asynGet(String key) {
        Future f = this.memcachedClient.asyncGet(key);
        try {
            return f.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            f.cancel(false);
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Collection<InetSocketAddress> getAvaliableServers() {
        return null;
    }

    @Override
    public List<String> getServersDescription() {
        return null;
    }

    @Override
    public List<String> listAllKeys(String server) {
        return null;
    }

    @Override
    public String getModuleName() {
        return "MemcachedClientSpyImpl";
    }

    @Override
    public void start() {
        try {
            this.memcachedClient = new MemcachedClient(this.factory, AddrUtil.getAddresses((String)this.addresses));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.memcachedClient = null;
        }
    }

    @Override
    public void stop() {
        if (this.memcachedClient != null) {
            this.memcachedClient.shutdown();
        }
    }

    @Override
    public void restart() {
    }
}

