/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.session.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.trs.infra.session.RequestSessionInfo;
import com.trs.infra.session.Session;
import com.trs.infra.session.SessionContext;
import com.trs.infra.session.impl.ChainList;
import com.trs.infra.session.impl.ChainNode;
import com.trs.infra.session.impl.EmptyIterator;
import com.trs.infra.session.impl.StandardSessionBase;
import com.trs.infra.session.impl.StandardSessionImpl;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public abstract class StandardContextBase
implements SessionContext {
    private static final Logger s_logger;
    private static final int RANDOM_LENGTH = 8;
    private static final int HOST_LENGTH = 8;
    private static final int TIME_LENGTH = 8;
    private static final int COOKIE_LENGTH = 32;
    private static final char[] COOKIE_DIGITS;
    private final SessionThread sessionThread = new SessionThread();
    private ServletContext servletContext;
    private HttpSessionAttributeListener[] attributeListeners;
    private HttpSessionListener[] sessionListeners;
    private String cookieDomain = null;
    private String cookieName = "SID";
    private String cookiePath = "/";
    private int cookieTLD = 0;
    private String balancerRoute;
    private String balancerSeparator;
    private char[] cookieHostPrefix;
    private String cookieHostSurfix;
    private Random cookieRandom;
    private boolean reverseProxyEnabled;
    private boolean reverseProxyR2L;
    private int sessionTimeout = 1800;
    private int sessionLimit;
    private int addressLimit;
    private final Map addressLimitMap = new ConcurrentHashMap();
    private String noLimitURI;
    private volatile int createdCount;
    private final Map addressesMap = new ConcurrentHashMap();
    private final Map usernamesMap = new ConcurrentHashMap();
    private final Map sessionsMap = new ConcurrentHashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.session.impl.StandardContextBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
        COOKIE_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    public final ServletContext getServletContext() {
        return this.servletContext;
    }

    public final void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public final synchronized void addListener(HttpSessionAttributeListener listener) {
        if (listener == null) {
            return;
        }
        HttpSessionAttributeListener[] oldListeners = this.attributeListeners;
        HttpSessionAttributeListener[] newListeners = null;
        if (oldListeners == null || oldListeners.length <= 0) {
            newListeners = new HttpSessionAttributeListener[]{listener};
            this.attributeListeners = newListeners;
            return;
        }
        int oldLength = oldListeners.length;
        newListeners = new HttpSessionAttributeListener[oldLength + 1];
        System.arraycopy(oldListeners, 0, newListeners, 0, oldLength);
        newListeners[oldLength] = listener;
        this.attributeListeners = newListeners;
    }

    public final synchronized void addListener(HttpSessionListener listener) {
        if (listener == null) {
            return;
        }
        HttpSessionListener[] oldListeners = this.sessionListeners;
        HttpSessionListener[] newListeners = null;
        if (oldListeners == null || oldListeners.length <= 0) {
            newListeners = new HttpSessionListener[]{listener};
            this.sessionListeners = newListeners;
            return;
        }
        int oldLength = oldListeners.length;
        newListeners = new HttpSessionListener[oldLength + 1];
        System.arraycopy(oldListeners, 0, newListeners, 0, oldLength);
        newListeners[oldLength] = listener;
        this.sessionListeners = newListeners;
    }

    public final Object[] getListeners(Class listenerClass) {
        if (listenerClass == null) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.servlet.http.HttpSessionAttributeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (listenerClass == clazz) {
            return this.attributeListeners;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("javax.servlet.http.HttpSessionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (listenerClass == clazz2) {
            return this.sessionListeners;
        }
        return null;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public final String getCookieName() {
        return this.cookieName;
    }

    public final void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public final String getCookiePath() {
        return this.cookiePath;
    }

    public final void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public final int getCookieTLD() {
        return this.cookieTLD;
    }

    public final void setCookieTLD(int cookieTLD) {
        this.cookieTLD = cookieTLD;
    }

    public final String getBalancerRoute() {
        return this.balancerRoute;
    }

    public final void setBalancerRoute(String balancerRoute) {
        this.balancerRoute = balancerRoute;
    }

    public final String getBalancerSeparator() {
        return this.balancerSeparator;
    }

    public final void setBalancerSeparator(String balancerSeparator) {
        this.balancerSeparator = balancerSeparator;
    }

    public final boolean isReverseProxyEnabled() {
        return this.reverseProxyEnabled;
    }

    public final void setReverseProxyEnabled(boolean reverseProxyEnabled) {
        this.reverseProxyEnabled = reverseProxyEnabled;
    }

    public final boolean isReverseProxyR2L() {
        return this.reverseProxyR2L;
    }

    public final void setReverseProxyR2L(boolean reverseProxyR2L) {
        this.reverseProxyR2L = reverseProxyR2L;
    }

    public final int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public final void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public final int getSessionLimit() {
        return this.sessionLimit;
    }

    public final void setSessionLimit(int sessionLimit) {
        this.sessionLimit = sessionLimit;
    }

    public final int getAddressLimit() {
        return this.addressLimit;
    }

    public final void setAddressLimit(int addressLimit) {
        this.addressLimit = addressLimit;
    }

    public int getAddressLimit(String address) {
        Integer objLimit;
        if (address != null && (objLimit = (Integer)this.addressLimitMap.get(address)) != null) {
            return objLimit;
        }
        return this.getAddressLimit();
    }

    public void setAddressLimit(String address, int limit) {
        if (address == null) {
            return;
        }
        if (limit == Integer.MIN_VALUE) {
            this.addressLimitMap.remove(address);
            return;
        }
        this.addressLimitMap.put(address, new Integer(limit));
    }

    public void setAddressLimit(String list) {
        if (list == null) {
            return;
        }
        String[] saPair = list.split(";");
        int i = 0;
        while (i < saPair.length) {
            try {
                String[] sAddressLimit = saPair[i].split("=");
                String sAddress = sAddressLimit[0];
                int iLimit = -1;
                if (sAddressLimit.length > 1) {
                    iLimit = Integer.parseInt(sAddressLimit[1]);
                }
                this.setAddressLimit(sAddress, iLimit);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public String getNoLimitURI() {
        return this.noLimitURI;
    }

    public void setNoLimitURI(String noLimitURI) {
        this.noLimitURI = noLimitURI;
    }

    public boolean isNoLimitURI(String uri) {
        return this.noLimitURI != null && this.noLimitURI.equals(uri);
    }

    public int getAddressCount() {
        return this.addressesMap.size();
    }

    public Iterator getAddresses() {
        return this.addressesMap.keySet().iterator();
    }

    public int getUserNameCount() {
        return this.usernamesMap.size();
    }

    public Iterator getUserNames() {
        return this.usernamesMap.keySet().iterator();
    }

    public int getCreatedCount() {
        return this.createdCount;
    }

    public int getSessionCount() {
        return this.sessionsMap.size();
    }

    public Iterator getSessions() {
        return this.sessionsMap.values().iterator();
    }

    public int getSessionCountFrom(String address) {
        ChainList list = (ChainList)this.addressesMap.get(address);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public Iterator getSessionsFrom(String address) {
        ChainList list = (ChainList)this.addressesMap.get(address);
        if (list == null) {
            return EmptyIterator.INSTANCE;
        }
        return list.iterator();
    }

    public int getSessionCountName(String userName) {
        ChainList list = (ChainList)this.usernamesMap.get(userName);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public Iterator getSessionsName(String userName) {
        ChainList list = (ChainList)this.usernamesMap.get(userName);
        if (list == null) {
            return EmptyIterator.INSTANCE;
        }
        return list.iterator();
    }

    public void start() {
        if (this.servletContext == null) {
            s_logger.warn((Object)"ServletContext is null");
        }
        if (this.sessionTimeout < 0) {
            this.sessionTimeout = 1800;
            s_logger.error((Object)"sessionTimeout too small");
        }
        this.createdCount = 0;
        this.initCookiePrefix();
        this.initCookieSurfix();
        this.sessionThread.startup();
    }

    public void close() {
        this.sessionThread.terminate();
        this.addressesMap.clear();
        this.usernamesMap.clear();
        this.sessionsMap.clear();
    }

    protected final void initCookiePrefix() {
        this.cookieRandom = new Random();
        this.cookieRandom.setSeed(System.currentTimeMillis());
        this.cookieHostPrefix = new char[8];
        byte[] adddress = null;
        try {
            adddress = InetAddress.getByName(InetAddress.getLocalHost().getHostName()).getAddress();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (adddress == null) {
            adddress = new byte[4];
            this.cookieRandom.nextBytes(adddress);
        }
        int i = 0;
        int j = 0;
        while (i < 4 && j < 8) {
            byte iTemp = adddress[i++];
            this.cookieHostPrefix[j++] = COOKIE_DIGITS[iTemp >>> 4 & 0xF];
            this.cookieHostPrefix[j++] = COOKIE_DIGITS[iTemp & 0xF];
        }
    }

    protected final void initCookieSurfix() {
        if (this.balancerRoute == null || this.balancerRoute.length() <= 0) {
            this.cookieHostSurfix = null;
            return;
        }
        if (this.balancerSeparator == null || this.balancerSeparator.length() <= 0) {
            this.balancerSeparator = ".";
        }
        String surfix = String.valueOf(this.balancerSeparator) + this.balancerRoute;
        this.cookieHostSurfix = new String(surfix.toCharArray());
    }

    public Session getSession(HttpServletRequest request) {
        String sessionID = this.loadSessionId(request);
        if (sessionID != null) {
            return this.getSession(sessionID);
        }
        return null;
    }

    public Session getSession(String id) {
        StandardSessionBase session = this.getSessionInternal(id);
        if (session != null) {
            return session;
        }
        return null;
    }

    protected StandardSessionBase getSessionInternal(String id) {
        return (StandardSessionBase)this.sessionsMap.get(id);
    }

    public String loadSessionId(HttpServletRequest request) {
        String cookieValue = this.loadSessionCookieValue(request);
        if (cookieValue == null) {
            cookieValue = this.loadSessionURLRewriteValue(request);
        }
        if (cookieValue != null) {
            return cookieValue.substring(0, 32);
        }
        return cookieValue;
    }

    private final String loadSessionCookieValue(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                String cookieValue;
                Cookie cookie = cookies[i];
                if (this.cookieName.equals(cookie.getName()) && (cookieValue = cookie.getValue()) != null && cookieValue.length() >= 32) {
                    return cookieValue;
                }
                ++i;
            }
        }
        return null;
    }

    private final String loadSessionURLRewriteValue(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (uri != null) {
            int lastSemicolon;
            String value;
            int indexStart = 0;
            do {
                if ((indexStart = uri.indexOf(59, indexStart)) >= 0) continue;
                return null;
            } while (!uri.startsWith(this.cookieName, ++indexStart) || uri.charAt(indexStart += this.cookieName.length()) != '=' || (value = (lastSemicolon = uri.indexOf(59, ++indexStart)) < 0 ? uri.substring(indexStart).trim() : uri.substring(indexStart, lastSemicolon).trim()).length() < 32);
            return value;
        }
        return null;
    }

    public Session loadSession(HttpServletRequest request, HttpServletResponse response) {
        String sessionId;
        StandardSessionBase session;
        boolean sessionIdFromCookie = true;
        String cookieValue = this.loadSessionCookieValue(request);
        if (cookieValue == null) {
            cookieValue = this.loadSessionURLRewriteValue(request);
            if (cookieValue == null) {
                return null;
            }
            sessionIdFromCookie = false;
        }
        if ((session = this.getSessionInternal(sessionId = cookieValue.substring(0, 32))) == null || !session.isValid()) {
            return null;
        }
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            requestURI = String.valueOf(requestURI) + "?" + queryString;
        }
        session.setThisAccessURI(requestURI);
        if (sessionIdFromCookie && cookieValue.length() > 0 && this.cookieHostSurfix != null && !cookieValue.substring(32).equals(this.cookieHostSurfix)) {
            this.makeSessionCookie(request, response, sessionId);
        }
        return session;
    }

    public RequestSessionInfo loadSessionInfo(HttpServletRequest request) {
        String sessionID = this.loadSessionId(request);
        StandardSessionBase session = (StandardSessionBase)this.getSession(request);
        RequestSessionInfo rsi = new RequestSessionInfo();
        rsi.setRequestedSessionId(sessionID);
        rsi.setRequestedSessionIdFromCookie(true);
        rsi.setRequestedSessionIdFromURL(false);
        rsi.setRequestedSessionIdValid(session != null && session.isValid());
        return rsi;
    }

    public Session makeSession(HttpServletRequest request, HttpServletResponse response) {
        return this.makeSession(request, response, true);
    }

    public Session makeSession(HttpServletRequest request, HttpServletResponse response, boolean checkLimit) {
        String clientAddress = this.getClientAddress(request);
        String requestURI = request.getRequestURI();
        if (checkLimit && this.checkSessionLimit(clientAddress, requestURI)) {
            return null;
        }
        String sessionID = this.makeSessionID();
        this.makeSessionCookie(request, response, sessionID);
        StandardSessionBase session = this.newSession();
        session.setSessionID(sessionID);
        session.setNew(true);
        session.setMaxInactiveInterval(this.getSessionTimeout());
        session.setLevel(0);
        session.setClientAddress(clientAddress);
        session.setRoutedProxies(request.getHeader("X-Forwarded-For"));
        session.setClientBrowser(request.getHeader("User-Agent"));
        session.setCreateURI(requestURI, request.getQueryString());
        session.setCreateTime(System.currentTimeMillis());
        ++this.createdCount;
        this.afterCreateSession(session);
        this.addSession(session);
        this.fireSessionCreated(session);
        return session;
    }

    protected boolean beforeCreateSession() {
        return true;
    }

    protected void afterCreateSession(StandardSessionBase session) {
    }

    private final boolean checkSessionLimit(String address, String uri) {
        int iLimitAtAddress = this.getAddressLimit(address);
        if (iLimitAtAddress == 0) {
            return true;
        }
        if (this.sessionLimit > 0 && this.getSessionCount() >= this.sessionLimit) {
            return !this.isNoLimitURI(uri);
        }
        if (iLimitAtAddress > 0 && this.getSessionCountFrom(address) >= iLimitAtAddress) {
            return !this.isNoLimitURI(uri);
        }
        return false;
    }

    private final void makeSessionCookie(HttpServletRequest request, HttpServletResponse response, String sessionID) {
        String domain;
        String cookieValue = sessionID;
        if (this.cookieHostSurfix != null) {
            StringBuffer sb = new StringBuffer(32 + this.cookieHostSurfix.length());
            sb.append(sessionID).append(this.cookieHostSurfix);
            cookieValue = sb.toString();
        }
        Cookie cookie = new Cookie(this.cookieName, cookieValue);
        String path = this.cookiePath;
        if (path != null && path.length() > 0) {
            cookie.setPath(path);
        } else {
            cookie.setPath("/");
        }
        if (this.cookieTLD >= 2 && (domain = this.getTopLevelDomain(this.getServerHostName(request))) != null && domain.length() > 0) {
            cookie.setDomain(domain);
        }
        response.addCookie(cookie);
        response.setHeader("P3P", "CP=\"CAO PSA OUR\"");
    }

    private final String getTopLevelDomain(String host) {
        if (host == null) {
            return null;
        }
        int lastDotIndex = host.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        if (++lastDotIndex == host.length()) {
            return null;
        }
        char testDigit = host.charAt(lastDotIndex);
        if (testDigit <= '9' && testDigit >= '0') {
            return null;
        }
        if ((lastDotIndex = host.lastIndexOf(46, lastDotIndex - 2)) < 0) {
            return null;
        }
        if (this.cookieTLD >= 3) {
            int i = this.cookieTLD;
            while (i > 2) {
                int temp = host.lastIndexOf(46, lastDotIndex - 1);
                if (temp <= 0) {
                    return null;
                }
                lastDotIndex = temp;
                --i;
            }
        }
        return host.substring(++lastDotIndex);
    }

    private final String getServerHostName(HttpServletRequest request) {
        String hostname;
        if (this.reverseProxyEnabled && (hostname = request.getHeader("X-Forwarded-Host")) != null) {
            return hostname;
        }
        return request.getServerName();
    }

    /*
     * Unable to fully structure code
     */
    private final String getClientAddress(HttpServletRequest request) {
        block7: {
            if (!this.reverseProxyEnabled) {
                return request.getRemoteAddr();
            }
            X_Forwarded_For = request.getHeader("X-Forwarded-For");
            if (!this.reverseProxyR2L) ** GOTO lbl27
            while (X_Forwarded_For != null) {
                address = null;
                iLastDot = X_Forwarded_For.lastIndexOf(44);
                if (iLastDot >= 0) {
                    address = X_Forwarded_For.substring(iLastDot + 1).trim();
                    X_Forwarded_For = X_Forwarded_For.substring(0, iLastDot);
                } else {
                    address = X_Forwarded_For;
                    X_Forwarded_For = null;
                }
                if (!StandardContextBase.isIPAddress(address)) continue;
                return address;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                address = null;
                iFirstDot = X_Forwarded_For.indexOf(44);
                if (iFirstDot > 0) {
                    address = X_Forwarded_For.substring(0, iFirstDot).trim();
                    X_Forwarded_For = X_Forwarded_For.substring(iFirstDot + 1);
                } else {
                    address = X_Forwarded_For;
                    X_Forwarded_For = null;
                }
                if (!StandardContextBase.isIPAddress(address)) continue;
                return address;
lbl27:
                // 2 sources

                ** while (X_Forwarded_For != null)
            }
        }
        return request.getRemoteAddr();
    }

    public static final boolean isIPAddress(String s) {
        if (s != null) {
            int temp;
            int dot1 = (s = s.trim()).indexOf(46);
            if (dot1 <= 0) {
                return false;
            }
            try {
                temp = Integer.parseInt(s.substring(0, dot1++));
                if (temp < 0 || temp > 255) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
            int dot2 = s.indexOf(46, dot1);
            if (dot2 <= 0) {
                return false;
            }
            try {
                temp = Integer.parseInt(s.substring(dot1, dot2++));
                if (temp < 0 || temp > 255) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
            int dot3 = s.indexOf(46, dot2);
            if (dot3 <= 0) {
                return false;
            }
            try {
                temp = Integer.parseInt(s.substring(dot2, dot3++));
                if (temp < 0 || temp > 255) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
            try {
                temp = Integer.parseInt(s.substring(dot3));
                return temp >= 0 && temp <= 255;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    protected String makeSessionID() {
        char[] cuff = new char[32];
        int i = 0;
        while (i < 8) {
            cuff[i] = this.cookieHostPrefix[i];
            ++i;
        }
        long l = System.currentTimeMillis();
        i = 15;
        while (i >= 8) {
            cuff[i] = COOKIE_DIGITS[(int)(l & 0xFL)];
            l >>>= 4;
            --i;
        }
        byte[] buff = new byte[8];
        this.cookieRandom.nextBytes(buff);
        i = 16;
        int j = 0;
        while (j < 8) {
            cuff[i++] = COOKIE_DIGITS[buff[j] >>> 4 & 0xF];
            cuff[i++] = COOKIE_DIGITS[buff[j] & 0xF];
            ++j;
        }
        return new String(cuff);
    }

    protected StandardSessionBase newSession() {
        return new StandardSessionImpl(this);
    }

    protected void addSession(Session session) {
        StandardSessionBase _old = (StandardSessionBase)this.sessionsMap.put(session.getSessionID(), session);
        if (_old != null) {
            s_logger.fatal((Object)("Conflicting session:" + _old.getSessionID()));
            this.destroySession(_old);
        }
        this.addAddress(session);
        this.addUserName(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAddress(Session session) {
        Map map = this.addressesMap;
        synchronized (map) {
            String addr = session.getClientAddress();
            ChainList list = (ChainList)this.addressesMap.get(addr);
            if (list == null) {
                list = new ChainList(addr);
                this.addressesMap.put(addr, list);
            }
            list.add(new ChainNode(session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUserName(Session session) {
        String userName = session.getUserName();
        if (userName == null) {
            return;
        }
        Map map = this.usernamesMap;
        synchronized (map) {
            ChainList list = (ChainList)this.usernamesMap.get(userName);
            if (list == null) {
                list = new ChainList(userName);
                this.usernamesMap.put(userName, list);
            }
            list.add(new ChainNode(session));
        }
    }

    protected void remoteSession(Session session) {
        StandardSessionBase _old = (StandardSessionBase)this.sessionsMap.remove(session.getSessionID());
        if (_old == null) {
            return;
        }
        if (_old != session) {
            s_logger.fatal((Object)("Conflicting session:" + _old.getSessionID()));
        }
        this.destroySession(_old);
    }

    protected void destroySession(StandardSessionBase session) {
        this.remoteAddress(session);
        this.remoteUserName(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteAddress(Session session) {
        Map map = this.addressesMap;
        synchronized (map) {
            String addr = session.getClientAddress();
            ChainList list = (ChainList)this.addressesMap.get(addr);
            if (list != null) {
                list.cutByValue(session);
                if (list.size() == 0) {
                    this.addressesMap.remove(addr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteUserName(Session session) {
        String userName = session.getUserName();
        if (userName == null) {
            return;
        }
        Map map = this.usernamesMap;
        synchronized (map) {
            ChainList list = (ChainList)this.usernamesMap.get(userName);
            if (list != null) {
                list.cutByValue(session);
                if (list.size() == 0) {
                    this.usernamesMap.remove(userName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeUserName(Session session, String _oldUserName, String _newUserName) {
        Map map = this.usernamesMap;
        synchronized (map) {
            ChainList list;
            if (_oldUserName != null && (list = (ChainList)this.usernamesMap.get(_oldUserName)) != null) {
                list.cutByValue(session);
                if (list.size() == 0) {
                    this.usernamesMap.remove(_oldUserName);
                }
            }
            if (_newUserName != null) {
                list = (ChainList)this.usernamesMap.get(_newUserName);
                if (list == null) {
                    list = new ChainList(_newUserName);
                    this.usernamesMap.put(_newUserName, list);
                }
                list.add(new ChainNode(session));
            }
        }
    }

    protected void backgroundProcessExpires() {
        int sessionTimeoutMinute = this.sessionTimeout / 60;
        ArrayList<StandardSessionBase> expired = new ArrayList<StandardSessionBase>(this.getSessionCount() / sessionTimeoutMinute);
        Iterator itr = this.getSessions();
        while (itr.hasNext()) {
            StandardSessionBase session = (StandardSessionBase)itr.next();
            if (session == null) continue;
            if (session.isInvalidated()) {
                expired.add(session);
                continue;
            }
            if (session.isDestroyed()) {
                expired.add(session);
                continue;
            }
            if (!session.isExpired() || !this.beforeExpireSession(session)) continue;
            session.expire();
            if (session.isValid()) continue;
            expired.add(session);
        }
        int length = expired.size();
        int i = 0;
        while (i < length) {
            StandardSessionBase session = (StandardSessionBase)expired.get(i);
            this.remoteSession(session);
            this.afterExpireSession(session);
            session.destroy();
            ++i;
        }
        if (length > 0) {
            expired.clear();
        }
    }

    protected boolean beforeExpireSession(StandardSessionBase session) {
        return true;
    }

    protected void afterExpireSession(StandardSessionBase session) {
    }

    protected void fireSessionCreated(Session session) {
        HttpSessionListener[] listeners = this.sessionListeners;
        if (listeners == null || listeners.length <= 0) {
            return;
        }
        HttpSessionEvent event = new HttpSessionEvent(session.getHttpSession());
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            HttpSessionListener listener = listeners[i];
            if (listener != null) {
                try {
                    listener.sessionCreated(event);
                }
                catch (Throwable e) {
                    s_logger.error((Object)"Error on sessionCreated", e);
                }
            }
            ++i;
        }
    }

    protected void fireSessionDestroyed(Session session) {
        HttpSessionListener[] listeners = this.sessionListeners;
        if (listeners == null || listeners.length <= 0) {
            return;
        }
        HttpSessionEvent event = new HttpSessionEvent(session.getHttpSession());
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            HttpSessionListener listener = listeners[i];
            if (listener != null) {
                try {
                    listener.sessionDestroyed(event);
                }
                catch (Throwable e) {
                    s_logger.error((Object)"Error on sessionDestroyed", e);
                }
            }
            ++i;
        }
    }

    private class SessionThread
    extends Thread {
        private static final int CHECK_INTERVAL_SECONDS = 60;
        private volatile boolean m_zContinue = true;

        public SessionThread() {
            super("StandardSessionContextBase$SessionThread");
            this.setDaemon(true);
        }

        public void run() {
            while (this.m_zContinue) {
                try {
                    StandardContextBase.this.backgroundProcessExpires();
                }
                catch (Throwable e) {
                    s_logger.error((Object)"Unexpected exception", e);
                }
                try {
                    this.waitMinite();
                }
                catch (Throwable e) {
                    s_logger.error((Object)"Unexpected exception", e);
                }
            }
        }

        private synchronized void waitMinite() {
            try {
                this.wait(600000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable e) {
                s_logger.error((Object)"Unexpected exception", e);
            }
        }

        public void startup() {
            this.m_zContinue = true;
            this.start();
        }

        public void terminate() {
            this.m_zContinue = false;
            this.interrupt();
        }
    }
}

