/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.version.AppendixUsedVersion;
import com.trs.components.wcm.version.AppendixUsedVersions;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;

public class AppendixUsedVersionMgr {
    public void save(String appendixName) throws WCMException {
        if (appendixName == null) {
            throw new WCMException(I18NMessage.get(AppendixUsedVersion.class, "AppendixUsedVersion.lable1", "\u4fdd\u5b58\u9644\u4ef6\u65f6\u9644\u4ef6\u540d\u79f0\u4e3a\u7a7a"));
        }
        AppendixUsedVersion appendixUsedVersion = this.findByAppendixName(appendixName);
        if (appendixUsedVersion == null) {
            appendixUsedVersion = new AppendixUsedVersion();
            appendixUsedVersion.setAppendixName(appendixName);
            appendixUsedVersion.setProperty("USEDVERSIONS", 1L);
            appendixUsedVersion.insert();
        } else {
            appendixUsedVersion.setUsedVersions(appendixUsedVersion.getUsedVersions() + 1);
            appendixUsedVersion.update();
        }
    }

    public boolean isInUse(String appendixName) throws WCMException {
        if (appendixName == null) {
            return false;
        }
        AppendixUsedVersion appendixUsedVersion = this.findByAppendixName(appendixName);
        return appendixUsedVersion != null;
    }

    public void delete(String _appendixName, Boolean _bInUse) throws WCMException {
        if (CMyString.isEmpty(_appendixName)) {
            throw new WCMException(I18NMessage.get(AppendixUsedVersionMgr.class, "AppendixUsedVersionMgr.lable1", "\u53c2\u6570\u4e3a\u7a7a"));
        }
        AppendixUsedVersion appendixUsedVersion = this.findByAppendixName(_appendixName);
        if (appendixUsedVersion != null) {
            int usedVersions = appendixUsedVersion.getUsedVersions();
            if (usedVersions - 1 > 0) {
                appendixUsedVersion.setUsedVersions(usedVersions - 1);
                appendixUsedVersion.update(this.getLoginUser());
            } else {
                if (!_bInUse.booleanValue()) {
                    FilesMan.getFilesMan().deleteFile(_appendixName);
                }
                appendixUsedVersion.delete();
            }
        }
    }

    public AppendixUsedVersion findByAppendixName(String appendixName) throws WCMException {
        if (CMyString.isEmpty(appendixName)) {
            return null;
        }
        WCMFilter afilter = new WCMFilter("", "APPENDIXNAME=?", "", "", 1);
        afilter.addSearchValues(appendixName);
        AppendixUsedVersions appendixUsedVersions = AppendixUsedVersions.openWCMObjs(this.getLoginUser(), afilter);
        if (appendixUsedVersions == null || appendixUsedVersions.size() == 0) {
            return null;
        }
        return (AppendixUsedVersion)appendixUsedVersions.getAt(0);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

