/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.Base64Util;
import com.trs.idm.util.StringHelper;

public class UnicodeUtil {
    public static void main(String[] args) {
        System.out.println(UnicodeUtil.decodeBase64LdapDN("T1UlM0QldTRFMEEldTZENzcxMjMlMkNEQyUzRFBDQ0NURVNUT0ElMkNEQyUzRCV1NEUyRCV1NjU4N2FhYSUyQ0RDJTNEQ09NJTJDREMlM0QxMjMldTZENEIldThCRDUlMkNEQyUzRGNu"));
    }

    public static String decodeBase64LdapDN(String base64ResultOfJS) {
        String base64Result = Base64Util.decode(base64ResultOfJS);
        String[] arraysOfEqual = StringHelper.splitWithMutiChar(base64Result, "%2C");
        if (arraysOfEqual == null || arraysOfEqual.length == 0) {
            System.out.println("No ");
            return null;
        }
        StringBuffer strBuff = new StringBuffer();
        int i = 0;
        while (i < arraysOfEqual.length) {
            String str = arraysOfEqual[i];
            String[] keyValue = StringHelper.splitWithMutiChar(str, "%3D");
            String key = keyValue[0];
            String value = keyValue[1];
            value = UnicodeUtil.decodeMixCharacterWithUnicodeRecursive(value, null);
            strBuff.append(key);
            strBuff.append("=");
            strBuff.append(value);
            if (i != arraysOfEqual.length - 1) {
                strBuff.append(",");
            }
            ++i;
        }
        return strBuff.toString();
    }

    private static String decodeMixCharacterWithUnicodeRecursive(String original, StringBuffer result) {
        int index;
        if (StringHelper.isEmpty(original)) {
            return null;
        }
        String toSplit = original;
        if (result == null) {
            result = new StringBuffer();
        }
        if ((index = toSplit.indexOf("%u")) >= 0) {
            result.append(toSplit.substring(0, index));
            String unicode = "\\u" + toSplit.substring(index + 2, index + 6);
            String chn = UnicodeUtil.decodeUnicode(unicode);
            result.append(chn);
            toSplit = toSplit.substring(index + 6, toSplit.length());
            UnicodeUtil.decodeMixCharacterWithUnicodeRecursive(toSplit, result);
        } else {
            result.append(original);
        }
        return result.toString();
    }

    public static String gbEncoding(String gbString) {
        char[] utfBytes = gbString.toCharArray();
        String unicodeBytes = "";
        int byteIndex = 0;
        while (byteIndex < utfBytes.length) {
            String hexB = Integer.toHexString(utfBytes[byteIndex]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes = String.valueOf(unicodeBytes) + "\\u" + hexB;
            ++byteIndex;
        }
        System.out.println("unicodeBytes is: " + unicodeBytes);
        return unicodeBytes;
    }

    public static String decodeUnicode(String dataStr) {
        int start = 0;
        int end = 0;
        StringBuffer buffer = new StringBuffer();
        while (start > -1) {
            end = dataStr.indexOf("\\u", start + 2);
            String charStr = "";
            charStr = end == -1 ? dataStr.substring(start + 2, dataStr.length()) : dataStr.substring(start + 2, end);
            char letter = (char)Integer.parseInt(charStr, 16);
            buffer.append(new Character(letter).toString());
            start = end;
        }
        return buffer.toString();
    }
}

