/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarUtil {
    public static void main(String[] args) {
        JarUtil.printJarFileInfo("lib/servlet-2.3.jar");
        System.out.println("\n------------------------------------------------------------------------------");
        System.out.println(JarUtil.getJarInfo("lib/servlet-2.3.jar"));
    }

    public static String getJarInfo(String jarName) {
        return JarUtil.getJarInfo(jarName, System.getProperty("line.separator"));
    }

    public static String getJarInfo(String jarName, String lineStr) {
        StringBuffer sb = new StringBuffer();
        try {
            String fileName = jarName;
            File f = new File(fileName);
            if (!f.exists()) {
                sb.append("the file not exist! ").append(fileName).append(lineStr);
            } else {
                JarFile jarfile = new JarFile(f);
                sb.append(jarfile.getName()).append('.');
                sb.append(new Timestamp(f.lastModified()));
                sb.append("\tSize:").append(jarfile.size());
                sb.append(lineStr);
                Enumeration<JarEntry> enu = jarfile.entries();
                while (enu.hasMoreElements()) {
                    ZipEntry zipEntry = enu.nextElement();
                    sb.append(JarUtil.getZipEntryInfoBuffer(zipEntry));
                    sb.append(lineStr);
                }
                Manifest manifest = jarfile.getManifest();
                Map<String, Attributes> map = manifest.getEntries();
                sb.append("manifest.getEntries()=").append(map.size());
                sb.append(lineStr);
                for (String entryName : map.keySet()) {
                    sb.append("All attributes for the entry: ").append(entryName);
                    sb.append(lineStr);
                    Attributes attrs = map.get(entryName);
                    for (Attributes.Name name : attrs.keySet()) {
                        sb.append(name).append(':').append(attrs.getValue(name));
                        sb.append(lineStr);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            sb.append("[fail!]").append(e);
            sb.append(lineStr);
        }
        return sb.toString();
    }

    private static void printJarFileInfo(String jarName) {
        try {
            String fileName = jarName;
            File f = new File(fileName);
            if (!f.exists()) {
                System.out.println("the file not exist! " + fileName);
                return;
            }
            JarFile jarfile = new JarFile(f);
            System.out.println(String.valueOf(jarfile.getName()) + "," + new Timestamp(f.lastModified()) + "\tSize:" + jarfile.size());
            Enumeration<JarEntry> enu = jarfile.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipEntry = enu.nextElement();
                System.out.println(JarUtil.getZipEntryInfo(zipEntry));
            }
            Manifest manifest = jarfile.getManifest();
            Map<String, Attributes> map = manifest.getEntries();
            System.out.println("manifest.getEntries()=" + map.size());
            for (String entryName : map.keySet()) {
                System.out.println("\nall attributes for the entry: " + entryName);
                Attributes attrs = map.get(entryName);
                for (Attributes.Name name : attrs.keySet()) {
                    String attrValue = attrs.getValue(name);
                    System.out.println(name + ": " + attrValue);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getZipEntryInfo(ZipEntry zipEntry) {
        return JarUtil.getZipEntryInfoBuffer(zipEntry).toString();
    }

    private static StringBuffer getZipEntryInfoBuffer(ZipEntry zipEntry) {
        StringBuffer sb = new StringBuffer(64);
        sb.append(zipEntry.getName());
        sb.append('\t').append(new Timestamp(zipEntry.getTime()));
        if (zipEntry.isDirectory()) {
            sb.append(",isDirectory!");
        } else {
            sb.append(",CompressedSize:").append(zipEntry.getCompressedSize());
            sb.append(",Size:").append(zipEntry.getSize());
        }
        sb.append(",CRC:").append(zipEntry.getCrc());
        return sb;
    }
}

