/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.protocol.resolver.response.impl;

import com.trs.idm.saml.interact.IResponse;
import com.trs.idm.saml.interact.impl.simple.response.SimpleSelfPageLoginHttpPostResponse;
import com.trs.idm.saml.interact.impl.simple.response.SimpleTokenResolveResponse;
import com.trs.idm.saml.protocol.resolver.response.IResponseResolver;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.util.StringHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class SimpleTokenResponseResolver
implements IResponseResolver {
    protected static final Logger LOG = Logger.getLogger(SimpleTokenResponseResolver.class);
    private IServiceProvider sp;

    public SimpleTokenResponseResolver(IServiceProvider sp) {
        this.sp = sp;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sp:" + this.sp));
        }
    }

    public IResponse resolve(String responseXML) {
        LOG.debug((Object)("responseXML: " + responseXML));
        if (StringHelper.isEmpty(responseXML)) {
            LOG.info((Object)"responseXML is null,return null");
            return null;
        }
        Document document = null;
        String responsType = null;
        String responseCode = null;
        String responseContent = null;
        try {
            document = new SAXReader().read(this.getResponseAsStream(responseXML));
            responsType = document.selectSingleNode("//idsTokenResponse").valueOf("@type");
            responseCode = document.selectSingleNode("//responseCode").getText();
            responseContent = document.selectSingleNode("//responseContent").getText();
        }
        catch (Exception e) {
            LOG.error((Object)("error while parsing responseXML:  " + responseXML));
        }
        LOG.info((Object)("responsType: " + responsType + ";" + "responseCode: " + responseCode + "; responseContent: " + responseContent));
        if ("SimpleTokenResolveResponse".equals(responsType)) {
            LOG.info((Object)"this is a response of SimpleTokenResolveResponse");
            SimpleTokenResolveResponse response = new SimpleTokenResolveResponse(responseContent);
            response.setResponseCode(responseCode);
            return response;
        }
        if ("SimpleSelfPageLoginHttpPostResponse".equals(responsType)) {
            LOG.info((Object)"this is a response of SimpleSelfPageLoginHttpPostResponse");
            SimpleSelfPageLoginHttpPostResponse response = new SimpleSelfPageLoginHttpPostResponse(responseCode, responseContent);
            response.setResponseCode(responseCode);
            return response;
        }
        return null;
    }

    private InputStream getResponseAsStream(String responseXML) {
        try {
            return new ByteArrayInputStream(responseXML.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"error while change responseXML into InputStream", (Throwable)e);
            return null;
        }
    }
}

