/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.jdom.Attribute;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.adapters.DOMAdapter;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class DOMBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: DOMBuilder.java,v $ $Revision: 1.36 $ $Date: 2001/05/18 22:45:10 $ $Name: jdom_1_0_b7_rc4 $";
    private static final String DEFAULT_ADAPTER_CLASS = "org.jdom.adapters.XercesDOMAdapter";
    private boolean validate;
    private String adapterClass;
    private JDOMFactory factory = new DefaultJDOMFactory();

    public DOMBuilder() {
        this(false);
    }

    public DOMBuilder(String adapterClass) {
        this(adapterClass, false);
    }

    public DOMBuilder(String adapterClass, boolean validate) {
        this.adapterClass = adapterClass;
        this.setValidation(validate);
    }

    public DOMBuilder(boolean validate) {
        this.setValidation(validate);
    }

    public Document build(File file) throws JDOMException {
        try {
            FileInputStream in = new FileInputStream(file);
            return this.build(in);
        }
        catch (FileNotFoundException e) {
            throw new JDOMException("Error in building from " + file, e);
        }
    }

    public Document build(InputStream in) throws JDOMException {
        Document doc = this.factory.document(null);
        org.w3c.dom.Document domDoc = null;
        try {
            DOMAdapter adapter;
            if (this.adapterClass != null) {
                try {
                    adapter = (DOMAdapter)Class.forName(this.adapterClass).newInstance();
                    domDoc = adapter.getDocument(in, this.validate);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                try {
                    adapter = (DOMAdapter)Class.forName("org.jdom.adapters.JAXPDOMAdapter").newInstance();
                    domDoc = adapter.getDocument(in, this.validate);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            if (domDoc == null && this.adapterClass == null) {
                try {
                    adapter = (DOMAdapter)Class.forName(DEFAULT_ADAPTER_CLASS).newInstance();
                    domDoc = adapter.getDocument(in, this.validate);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            this.buildTree(domDoc, doc, null, true);
        }
        catch (Throwable e) {
            if (e instanceof SAXParseException) {
                SAXParseException p = (SAXParseException)e;
                String systemId = p.getSystemId();
                if (systemId != null) {
                    throw new JDOMException("Error on line " + p.getLineNumber() + " of document " + systemId, e);
                }
                throw new JDOMException("Error on line " + p.getLineNumber(), e);
            }
            throw new JDOMException("Error in building from stream", e);
        }
        return doc;
    }

    public Document build(URL url) throws JDOMException {
        try {
            return this.build(url.openStream());
        }
        catch (IOException e) {
            throw new JDOMException("Error in building from " + url, e);
        }
    }

    public Document build(org.w3c.dom.Document domDocument) {
        Document doc = this.factory.document(null);
        this.buildTree(domDocument, doc, null, true);
        return doc;
    }

    public Element build(org.w3c.dom.Element domElement) {
        Document doc = this.factory.document(null);
        this.buildTree(domElement, doc, null, true);
        return doc.getRootElement();
    }

    private void buildTree(Node node, Document doc, Element current, boolean atRoot) {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodes = node.getChildNodes();
                int i = 0;
                int size = nodes.getLength();
                while (i < size) {
                    this.buildTree(nodes.item(i), doc, current, true);
                    ++i;
                }
                break;
            }
            case 1: {
                String localName = node.getLocalName();
                String prefix = node.getPrefix();
                String uri = node.getNamespaceURI();
                Element element = null;
                Namespace ns = null;
                if (uri == null) {
                    if (localName == null) {
                        localName = ((org.w3c.dom.Element)node).getTagName();
                    }
                    element = this.factory.element(localName);
                } else {
                    ns = Namespace.getNamespace(prefix, uri);
                    element = this.factory.element(localName, ns);
                }
                NamedNodeMap attributeList = node.getAttributes();
                int i = 0;
                int size = attributeList.getLength();
                while (i < size) {
                    Attr att = (Attr)attributeList.item(i);
                    String attname = att.getName();
                    String attvalue = att.getValue();
                    if (attname.equals("xmlns")) {
                        Namespace declaredNS = Namespace.getNamespace("", attvalue);
                        if (!declaredNS.equals(ns)) {
                            element.addNamespaceDeclaration(declaredNS);
                        }
                    } else if (attname.startsWith("xmlns:")) {
                        String attsubname = attname.substring(6);
                        Namespace declaredNS = Namespace.getNamespace(attsubname, attvalue);
                        if (!declaredNS.equals(ns)) {
                            element.addNamespaceDeclaration(declaredNS);
                        }
                    } else {
                        prefix = att.getPrefix();
                        uri = att.getNamespaceURI();
                        String attLocalName = att.getLocalName();
                        if (attLocalName == null) {
                            attLocalName = attname;
                        }
                        Namespace attns = Namespace.getNamespace(prefix, uri);
                        Attribute attribute = this.factory.attribute(attLocalName, attvalue, attns);
                        element.setAttribute(attribute);
                    }
                    ++i;
                }
                if (atRoot) {
                    doc.setRootElement(element);
                } else {
                    current.addContent(element);
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int i2 = 0;
                int size2 = children.getLength();
                while (i2 < size2) {
                    Node item = children.item(i2);
                    if (item != null) {
                        this.buildTree(item, doc, element, false);
                    }
                    ++i2;
                }
                break;
            }
            case 3: {
                String text = node.getNodeValue();
                current.addContent(text);
                break;
            }
            case 4: {
                String cdata = node.getNodeValue();
                current.addContent(this.factory.cdata(cdata));
                break;
            }
            case 7: {
                if (atRoot) {
                    doc.addContent(this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                    break;
                }
                current.addContent(this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                break;
            }
            case 8: {
                if (atRoot) {
                    doc.addContent(this.factory.comment(node.getNodeValue()));
                    break;
                }
                current.addContent(this.factory.comment(node.getNodeValue()));
                break;
            }
            case 5: {
                EntityRef entity = this.factory.entityRef(node.getNodeName());
                current.addContent(entity);
                break;
            }
            case 10: {
                DocumentType domDocType = (DocumentType)node;
                String publicID = domDocType.getPublicId();
                String systemID = domDocType.getSystemId();
                DocType docType = this.factory.docType(domDocType.getName());
                if (publicID != null && !publicID.equals("")) {
                    docType.setPublicID(publicID);
                }
                if (systemID != null && !systemID.equals("")) {
                    docType.setSystemID(systemID);
                }
                doc.setDocType(docType);
                break;
            }
        }
    }

    public void setFactory(JDOMFactory factory) {
        this.factory = factory;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }
}

