/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.tds.HASessionContext;
import com.sybase.jdbc2.tds.Language;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.SQLException;

public class LoginToken
extends Token {
    protected static final int MAX_NAMELEN = 30;
    protected static final int MAX_REMPWDLEN = 255;
    protected static final int MAX_PROGNLEN = 10;
    protected static final int MAX_PACKETSIZELEN = 6;
    protected String _hostName;
    protected String _user;
    protected String _password;
    protected String _hostProc;
    protected int _bufSize = 512;
    protected String _appName;
    protected String _serviceName;
    protected String _remPw;
    protected int _lint2 = 2;
    protected int _lint4 = 0;
    protected int _lflt = 4;
    protected int _lflt4 = 12;
    protected int _ldate = 8;
    protected int _ldate4 = 16;
    protected static final byte[] TDSVERSION;
    private static final String PROGNAME = "jConnect";
    protected byte[] _progVers;
    protected String _language;
    protected String _charset;
    protected String _packetSize;
    protected byte[] _lhasessionid;
    protected int _lhalogin;
    protected static final byte[] SPARE;
    protected static final byte[] OLDSECURE;
    protected static final byte[] SECSPARE;
    protected static final byte[] DUMMY;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 5;
        TDSVERSION = byArray;
        SPARE = new byte[3];
        OLDSECURE = new byte[2];
        SECSPARE = new byte[2];
        DUMMY = new byte[4];
    }

    protected LoginToken() {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        this._progVers = byArray;
        this._lhasessionid = new byte[6];
    }

    public LoginToken(SybProperty sybProperty, TdsProtocolContext tdsProtocolContext, HASessionContext hASessionContext) throws SQLException {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        this._progVers = byArray;
        this._lhasessionid = new byte[6];
        this._user = sybProperty.getString(3);
        if (this._user == null) {
            ErrorMessage.raiseError("JZ004");
        }
        if (this._user.length() > 30) {
            ErrorMessage.raiseError("JZ001", this._user);
        }
        this._password = sybProperty.getString(4);
        if (this._password == null) {
            this._password = "";
        }
        if (this._password.length() > 30) {
            ErrorMessage.raiseError("JZ002", "");
        }
        this._hostName = sybProperty.getString(1);
        if (this._hostName != null && this._hostName.length() > 30) {
            tdsProtocolContext._conn.chainWarnings(ErrorMessage.createWarning("010HT", this._hostName));
            this._hostName = this._hostName.substring(0, 30);
        }
        this._hostProc = sybProperty.getString(2);
        if (this._hostProc == null || this._hostProc == "") {
            this._hostProc = "\u0000";
        }
        this._appName = sybProperty.getString(5);
        this._serviceName = sybProperty.getString(0);
        this._remPw = sybProperty.getString(9);
        this._charset = sybProperty.getString(8);
        this._language = sybProperty.getString(7);
        if (this._language == null) {
            this._language = Language.defaultLanguage();
        }
        this._packetSize = String.valueOf(sybProperty.getInteger(12));
        this._progVers[0] = 0;
        this._progVers[1] = 5;
        this._progVers[2] = 0;
        this._progVers[3] = 5;
        if (sybProperty.getBoolean(30)) {
            this._lint2 = 3;
            this._lint4 = 1;
            this._lflt = 10;
            this._lflt4 = 13;
            this._ldate = 9;
            this._ldate4 = 17;
        }
        this._lhalogin = hASessionContext.getLogin();
        System.arraycopy(hASessionContext.getSessionID(), 0, this._lhasessionid, 0, 6);
    }

    protected void prepareRemPwd(TdsOutputStream tdsOutputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._remPw == null) {
            stringBuffer.append('\u0000');
            stringBuffer.append((char)tdsOutputStream.getStringByteLen(this._password));
            stringBuffer.append(this._password);
        } else {
            char c = '\u0000';
            int n = 0;
            char[] cArray = new char[256];
            int n2 = this._remPw.length();
            char[] cArray2 = new char[n2];
            this._remPw.getChars(0, n2, cArray2, 0);
            while (n < n2 && (c = cArray2[n++]) != ',') {
                if (c != '\\') continue;
                ++n;
            }
            while (n < n2) {
                int n3 = 0;
                while ((c = cArray2[n++]) != ',') {
                    if (c == '\\') {
                        Debug.assert(this, n < n2);
                        c = cArray2[n++];
                    }
                    cArray[n3++] = c;
                    if (n >= n2) break;
                }
                if (n3 == 0) {
                    stringBuffer.append('\u0000');
                } else {
                    String string = new String(cArray, 0, n3);
                    stringBuffer.append((char)tdsOutputStream.getStringByteLen(string));
                    stringBuffer.append(string);
                }
                if (cArray2[n - 1] != ',' || n < n2) continue;
                stringBuffer.append('\u0000');
            }
        }
        this._remPw = stringBuffer.toString();
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        try {
            tdsOutputStream.writeStringLen(this._hostName, 30);
            tdsOutputStream.writeStringLen(this._user, 30);
            tdsOutputStream.writeStringLen(this._password, 30);
            tdsOutputStream.writeStringLen(this._hostProc, 30);
            tdsOutputStream.write(this._lint2);
            tdsOutputStream.write(this._lint4);
            tdsOutputStream.write(6);
            tdsOutputStream.write(this._lflt);
            tdsOutputStream.write(this._ldate);
            tdsOutputStream.write(1);
            tdsOutputStream.write(1);
            tdsOutputStream.write(0);
            tdsOutputStream.write(0);
            tdsOutputStream.writeInt(this._bufSize);
            tdsOutputStream.write(SPARE);
            tdsOutputStream.writeStringLen(this._appName, 30);
            tdsOutputStream.writeStringLen(this._serviceName, 30);
            this.prepareRemPwd(tdsOutputStream);
            tdsOutputStream.writeStringLen(this._remPw, 255);
            tdsOutputStream.write(TDSVERSION);
            tdsOutputStream.writeStringLen(PROGNAME, 10);
            tdsOutputStream.write(this._progVers);
            tdsOutputStream.write(0);
            tdsOutputStream.write(this._lflt4);
            tdsOutputStream.write(this._ldate4);
            tdsOutputStream.writeStringLen(this._language, 30);
            tdsOutputStream.write(0);
            tdsOutputStream.write(OLDSECURE);
            tdsOutputStream.write(0);
            tdsOutputStream.write(0);
            tdsOutputStream.write(this._lhalogin);
            tdsOutputStream.write(this._lhasessionid);
            tdsOutputStream.write(SECSPARE);
            tdsOutputStream.writeStringLen(this._charset, 30);
            tdsOutputStream.write(1);
            tdsOutputStream.writeStringLen(this._packetSize, 6);
            tdsOutputStream.write(DUMMY);
        }
        catch (IOException iOException) {
            Token.writeSQE(iOException);
        }
    }
}

