/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.ClobReader;
import COM.ibm.db2.app.ClobWithIO;
import COM.ibm.db2.app.ClobWriter;
import COM.ibm.db2.app.Lob;
import java.io.Reader;
import java.io.Writer;

class ClobWithDB2UDFLocator
extends Lob
implements ClobWithIO {
    int locator;
    int locatorType;
    int locatorCodepage;

    ClobWithDB2UDFLocator(int n, int n2, int n3) throws Exception {
        this.locator = n;
        this.locatorType = n2;
        this.locatorCodepage = n3;
    }

    public void close() {
        this.locator = 0;
    }

    void assertOpen() throws Exception {
        if (this.locator == 0) {
            throw new Exception("Clob is closed.");
        }
    }

    public long size() throws Exception {
        this.assertOpen();
        return ClobWithDB2UDFLocator.getSize(this.locator, this.locatorType, this.locatorCodepage);
    }

    public Reader getReader() throws Exception {
        return new ClobReader(this);
    }

    public Writer getWriter() throws Exception {
        return new ClobWriter(this);
    }

    public synchronized void append(char[] cArray, int n, int n2) throws Exception {
        this.assertOpen();
        ClobWithDB2UDFLocator.doAppend(cArray, n, n2, this.locator, this.locatorType, this.locatorCodepage);
    }

    public synchronized int substr(int n, char[] cArray, int n2, int n3) throws Exception {
        this.assertOpen();
        int n4 = Math.min((int)this.size() - n, n3);
        ClobWithDB2UDFLocator.doSubstr(n, cArray, n2, n3, this.locator, this.locatorType, this.locatorCodepage);
        return n4;
    }

    static native int getSize(int var0, int var1, int var2);

    static native void doAppend(char[] var0, int var1, int var2, int var3, int var4, int var5);

    static native void doSubstr(int var0, char[] var1, int var2, int var3, int var4, int var5, int var6);
}

