/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import org.apache.log4j.Logger;

public class FileCharsetBatchUpdate {
    private static Logger logger = Logger.getLogger(FileCharsetBatchUpdate.class);

    public static void execute(String path, final String acceptPattern, final String sCharset) throws CMyException {
        FileService root = new FileService(path);
        if (!root.exists()) {
            logger.info((Object)("\u6307\u5b9a\u7684\u53c2\u6570path[" + path + "]\u4e0d\u662f\u6587\u4ef6\u6216\u76ee\u5f55"));
            return;
        }
        if (root.isFile()) {
            FileCharsetBatchUpdate.execute(path, sCharset);
            return;
        }
        root.listFiles(new FileStoreFilter(){

            @Override
            public boolean accept(FileStore pathname) {
                if (pathname.isDirectory()) {
                    pathname.listFiles(this);
                    return false;
                }
                String sFilePath = pathname.getAbsolutePath();
                if (sFilePath.endsWith(acceptPattern)) {
                    try {
                        FileCharsetBatchUpdate.execute(sFilePath, sCharset);
                    }
                    catch (CMyException e) {
                        e.printStackTrace();
                        logger.error((Object)("\u8f6c\u6362\u6587\u4ef6[" + sFilePath + "]\u7f16\u7801\u65f6\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
                    }
                }
                return false;
            }
        });
    }

    public static void execute(String fileName, String sCharset) throws CMyException {
        String sEncoding = CharsetDetector.detect(fileName);
        String sContent = CMyFile.readFile(fileName, sEncoding);
        if (fileName.endsWith(".jsp")) {
            sContent = sContent.replaceFirst("pageEncoding=\"[^\"]+\"", "pageEncoding=\"" + sCharset + "\"");
        }
        CMyFile.writeFile(fileName, sContent, sCharset);
    }

    public static void main(String[] args) throws CMyException {
        String sRootPath = "E:\\workspace\\TRS.WCM.V6.1.Std-1095-87-EN\\SourceCode\\WebApp";
        FileCharsetBatchUpdate.execute(sRootPath, ".jsp", "utf-8");
    }
}

