/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.element;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.taskdispatch.IPublishElementsIterator;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.TableInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class PublishElementsIteratorDocumentsImpl
implements IPublishElementsIterator {
    protected static Logger logger = Logger.getLogger(PublishElementsIteratorDocumentsImpl.class);
    private WCMFilter filter = null;
    private ResultSet m_rsData = null;
    private Connection m_oConn = null;
    private PreparedStatement m_preStmt = null;
    private ResultSetMetaData m_rsmdData = null;
    public static long DEBUG_USE_TIME = 400L;
    private ContentWrapper m_oContent = null;
    private String m_sDocumentsFields = null;
    public static List m_listExcludeFields = new ArrayList(3);
    int m_nPreDocId = 0;

    public PublishElementsIteratorDocumentsImpl(WCMFilter _filter) throws WCMException {
        this.filter = _filter;
        this.initResultSet();
    }

    @Override
    public void clear() {
        this.m_rsmdData = null;
        if (this.m_rsData != null) {
            try {
                this.m_rsData.close();
                this.m_rsData = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_preStmt != null) {
            try {
                this.m_preStmt.close();
                this.m_preStmt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_oConn != null) {
            DBManager.getDBManager().freeConnection(this.m_oConn);
            this.m_oConn = null;
        }
    }

    @Override
    public void remove() {
    }

    @Override
    public synchronized boolean hasNext() {
        Template detailTemplate;
        if (this.m_rsData == null) {
            return false;
        }
        boolean bHasNext = false;
        int nMoveCount = 0;
        int nDocId = 0;
        while (true) {
            if (++nMoveCount > 4000) {
                // empty if block
            }
            try {
                bHasNext = this.m_rsData.next();
            }
            catch (SQLException e) {
                logger.error((Object)(I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label2", "\u79fb\u52a8\u6e38\u6807\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff01\u524d\u4e00\u4e2aDocId\u4e3a") + this.m_nPreDocId), (Throwable)e);
                throw new RuntimeException(I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label3", "\u79fb\u52a8\u6e38\u6807\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff01\n") + CMyException.getStackTraceText(e));
            }
            if (!bHasNext) {
                return false;
            }
            nDocId = 0;
            try {
                nDocId = this.m_rsData.getInt("DOCID");
            }
            catch (SQLException e) {
                logger.error((Object)I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label4", "\u83b7\u53d6ID\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff01"), (Throwable)e);
                throw new RuntimeException(I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label3", "\u79fb\u52a8\u6e38\u6807\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff01\n") + CMyException.getStackTraceText(e));
            }
            detailTemplate = null;
            int nChannelId = 0;
            try {
                nChannelId = this.m_rsData.getInt("DOCCHANNEL");
                TemplateEmployMgr mgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
                detailTemplate = mgr.getDetailTemplate(101, nChannelId);
            }
            catch (Exception e) {
                throw new RuntimeException(I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label5", "\u83b7\u53d6\u7ec6\u89c8\u6a21\u677f[") + nChannelId + I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label6", "]\u5931\u8d25!"), e);
            }
            try {
                FolderPublishConfig aFolderConfig = FolderPublishConfig.findOf(101, nChannelId);
                if (detailTemplate != null && aFolderConfig != null) break;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label7", "\u6587\u6863[ID=") + nDocId + I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label8", "]\u4e0d\u80fd\u751f\u6210\u7ec6\u89c8\u9875\u9762\uff01")));
            }
            catch (Exception e) {
                logger.error((Object)I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label9", "\u83b7\u53d6\u6240\u5c5e\u9891\u9053\u914d\u7f6e\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)e);
                throw new RuntimeException(I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label9", "\u83b7\u53d6\u6240\u5c5e\u9891\u9053\u914d\u7f6e\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(e));
            }
        }
        try {
            if (this.m_rsmdData == null) {
                this.m_rsmdData = this.m_rsData.getMetaData();
            }
            Document document = new Document();
            document.readFromRs(this.m_rsData, this.m_rsmdData);
            this.m_oContent = new ContentWrapper(document);
            this.m_oContent.setDetailTemplate(detailTemplate);
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label10", "\u83b7\u53d6ID=") + nDocId + I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label11", "\u7684\u6587\u6863\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)e);
            throw new RuntimeException(I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label10", "\u83b7\u53d6ID=") + nDocId + I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label11", "\u7684\u6587\u6863\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(e));
        }
        this.m_nPreDocId = nDocId;
        return true;
    }

    public synchronized Object next() {
        return this.m_oContent;
    }

    private void initResultSet() throws WCMException {
        DebugTimer aTimer = new DebugTimer();
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = "";
        String sSelect = "*";
        if (this.filter != null) {
            sSelect = CMyString.showNull(this.filter.getSelect());
        }
        if (sSelect.indexOf(42) >= 0) {
            TableInfo tableInfo = dbMgr.getTableInfo("WCMDOCUMENT");
            Enumeration enFieldNames = tableInfo.getFieldNames();
            this.m_sDocumentsFields = "DOCID";
            String sFieldName = null;
            while (enFieldNames.hasMoreElements()) {
                sFieldName = (String)enFieldNames.nextElement();
                if (m_listExcludeFields.indexOf(sFieldName) >= 0) continue;
                this.m_sDocumentsFields = this.m_sDocumentsFields + "," + sFieldName;
            }
        }
        try {
            this.clear();
            strSQL = this.makeSQL();
            logger.info((Object)strSQL);
            this.m_oConn = dbMgr.getConnection();
            this.m_preStmt = this.m_oConn.prepareStatement(strSQL);
            if (this.filter != null && this.filter.getMaxRowNumber() > 0) {
                this.m_preStmt.setMaxRows(this.filter.getMaxRowNumber());
            }
            this.setParameters(this.m_preStmt);
            aTimer.start();
            this.m_rsData = this.m_preStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("[initResultSet]executeQuery from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("[initResultSet]SQL:" + strSQL));
            }
        }
        catch (SQLException ex) {
            this.clear();
            throw new WCMException(40, I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label12", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            this.clear();
            throw new WCMException(0, I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label12", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)\uff1aSQL=" + strSQL, ex);
        }
    }

    private String makeSQL() {
        if (this.filter == null) {
            return "select " + this.m_sDocumentsFields + " from WCMDOCUMENT";
        }
        String sTableName = this.getDbTableName();
        String sIdFieldName = this.getIdFieldName();
        WCMFilter newFilter = new WCMFilter(this.filter);
        String strFrom = this.filter.getFrom();
        String strSelect = this.filter.getSelect();
        if (strFrom == null || (strFrom = strFrom.trim()).length() == 0) {
            newFilter.setFrom(sTableName);
        }
        if (strSelect == null || (strSelect = strSelect.trim()).length() == 0) {
            strSelect = strFrom.indexOf(44) >= 0 ? sTableName + ".*" : "*";
        } else if (strSelect.indexOf(42) < 0 && this.filter.findSelectField(sIdFieldName) == null) {
            strSelect = strSelect + sTableName + "." + sIdFieldName;
        }
        if (strSelect.indexOf(42) >= 0) {
            strSelect = this.m_sDocumentsFields;
        }
        newFilter.setSelect(strSelect);
        return newFilter.toSQL();
    }

    public String getDbTableName() {
        return "WCMDOCUMENT";
    }

    public String getIdFieldName() {
        return "DOCID";
    }

    private void setParameters(PreparedStatement _oPreStmt) throws WCMException {
        if (_oPreStmt == null || this.filter == null) {
            return;
        }
        List listSearchValues = this.filter.getSearchValues();
        if (listSearchValues == null) {
            return;
        }
        try {
            int nSize = listSearchValues.size();
            for (int i = 0; i < nSize; ++i) {
                Object value = listSearchValues.get(i);
                if (value == null) continue;
                if (value instanceof Long) {
                    _oPreStmt.setLong(i + 1, (Long)value);
                    continue;
                }
                if (value instanceof Double) {
                    _oPreStmt.setDouble(i + 1, (Double)value);
                    continue;
                }
                if (value instanceof Integer) {
                    _oPreStmt.setInt(i + 1, (Integer)value);
                    continue;
                }
                if (value instanceof String) {
                    _oPreStmt.setString(i + 1, (String)value);
                    continue;
                }
                if (value instanceof CMyDateTime) {
                    _oPreStmt.setTimestamp(i + 1, ((CMyDateTime)value).toTimestamp());
                    continue;
                }
                if (value instanceof CDBText) {
                    _oPreStmt.setString(i + 1, ((CDBText)value).getText());
                    continue;
                }
                throw new WCMException(1103, I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label13", "\u672a\u77e5\u7684\u5bf9\u8c61") + (i + 1) + I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label14", "\u5c5e\u6027\u7c7b\u578b\uff1a(") + this.getClass().getName() + ".setParameters)");
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label15", "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".setParameters\uff09", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(PublishElementsIteratorDocumentsImpl.class, "PublishElementsIteratorDocumentsImpl.label15", "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".setParameters\uff09", ex);
        }
    }

    static {
        m_listExcludeFields.add("DOCPUBHTMLCON");
        m_listExcludeFields.add("DOCHTMLCON");
        m_listExcludeFields.add("DOCONTENT");
        m_listExcludeFields.add("DOCID");
    }

    private class ContentWrapper
    extends PublishContentDocumentImpl {
        static final String UPDATE_DOCUMENT_URL_SQL = "update WCMDocument  set DOCPUBTIME=?, DocPubURL=? where DocId=?";
        static final String UPDATE_CHNLDOC_URL_SQL = "update WCMChnlDoc set DOCPUBTIME=?, DocPubURL=? where DocId=? and Modal in(1, 2)";
        static final String UPDATE_DOCUMENT_STATUS_SQL = "update WCMDocument set DOCStatus=? where DocId=?";
        static final String UPDATE_CHNLDOC_STATUS_SQL = "update WCMChnlDoc set DOCStatus=? where DocId=? and Modal in(1, 2)";
        DBManager dbMgr;
        IFolderPubStatusCacheMgr m_oCacheMgr;

        public ContentWrapper(Document _doc) {
            super(_doc);
            this.dbMgr = null;
            this.m_oCacheMgr = null;
            this.dbMgr = DBManager.getDBManager();
            this.m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        }

        public void setDetailTemplate(Template _template) {
            this.m_oDetailTemplate = _template;
        }

        @Override
        public void setPublishStatus(int _nStatus) throws WCMException {
            int nUpdateStatusId;
            switch (_nStatus) {
                case 10: {
                    nUpdateStatusId = 15;
                    break;
                }
                case 50: {
                    nUpdateStatusId = 10;
                    break;
                }
                default: {
                    return;
                }
            }
            Channel channel = (Channel)this.getFolder().getSubstance();
            int[] pStatusesCanDoPub = this.m_oCacheMgr.findStatusesCanDoIncreasePub(103, channel.getSiteId());
            if (pStatusesCanDoPub == null || pStatusesCanDoPub.length <= 0) {
                return;
            }
            int[] pParameters = new int[2 + pStatusesCanDoPub.length];
            pParameters[0] = nUpdateStatusId;
            pParameters[1] = this.getId();
            System.arraycopy(pStatusesCanDoPub, 0, pParameters, 2, pStatusesCanDoPub.length);
            StringBuffer sbStatus = new StringBuffer(pStatusesCanDoPub.length * 2 + 21);
            sbStatus.append(" and DOCStatus in(?");
            int nSize = pStatusesCanDoPub.length;
            for (int i = 1; i < nSize; ++i) {
                sbStatus.append(",?");
            }
            sbStatus.append(")");
            String[] sUpdateSQL = new String[2];
            StringBuffer sbTemp = new StringBuffer(UPDATE_DOCUMENT_STATUS_SQL.length() + sbStatus.length());
            sbTemp.append(UPDATE_DOCUMENT_STATUS_SQL);
            sbTemp.append(sbStatus);
            sUpdateSQL[0] = sbTemp.toString();
            sbTemp.setLength(0);
            sbTemp = new StringBuffer(UPDATE_CHNLDOC_STATUS_SQL.length() + sbStatus.length());
            sbTemp.append(UPDATE_CHNLDOC_STATUS_SQL);
            sbTemp.append(sbStatus);
            sUpdateSQL[1] = sbTemp.toString();
            sbTemp.setLength(0);
            this.dbMgr.sqlExecuteUpdate(sUpdateSQL, pParameters);
        }

        @Override
        public void setPublishTimeAndURL(CMyDateTime _time, String _url) throws WCMException {
            Channel channel = (Channel)this.getFolder().getSubstance();
            int[] pStatusesCanDoPub = this.m_oCacheMgr.findStatusesCanDoPub(103, channel.getSiteId());
            if (pStatusesCanDoPub == null || pStatusesCanDoPub.length <= 0) {
                return;
            }
            Object[] pParameters = new Object[3 + pStatusesCanDoPub.length];
            pParameters[0] = _time.toDate();
            pParameters[1] = _url;
            pParameters[2] = new Integer(this.getId());
            StringBuffer sbStatus = new StringBuffer(pStatusesCanDoPub.length * 2 + 21);
            sbStatus.append(" and DOCStatus in(?");
            pParameters[3] = new Integer(pStatusesCanDoPub[0]);
            int nSize = pStatusesCanDoPub.length;
            for (int i = 1; i < nSize; ++i) {
                pParameters[3 + i] = new Integer(pStatusesCanDoPub[i]);
                sbStatus.append(",?");
            }
            sbStatus.append(")");
            String[] sUpdateSQL = new String[2];
            StringBuffer sbTemp = new StringBuffer(UPDATE_DOCUMENT_URL_SQL.length() + sbStatus.length());
            sbTemp.append(UPDATE_DOCUMENT_URL_SQL);
            sbTemp.append(sbStatus);
            sUpdateSQL[0] = sbTemp.toString();
            sbTemp.setLength(0);
            sbTemp = new StringBuffer(UPDATE_CHNLDOC_URL_SQL.length() + sbStatus.length());
            sbTemp.append(UPDATE_DOCUMENT_URL_SQL);
            sbTemp.append(sbStatus);
            sUpdateSQL[1] = sbTemp.toString();
            sbTemp.setLength(0);
            this.dbMgr.sqlExecuteUpdate(sUpdateSQL, pParameters);
        }
    }
}

