/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.logo.Logo;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyDateTime;

public class ChannelLCListenerForWebSiteLastModifyTime
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify,
IObjectLCListenerOnDel {
    private BaseChannel getParentObj(BaseObj baseObj) throws WCMException {
        Logo logo;
        Channel channel = null;
        if (baseObj instanceof Channel) {
            channel = (Channel)baseObj;
        } else if (baseObj instanceof Logo && (logo = (Logo)baseObj).getHostType() == 101) {
            channel = Channel.findById(logo.getHostId());
        }
        if (channel == null) {
            return null;
        }
        Channel baseChannel = channel.getParent();
        if (baseChannel == null) {
            return channel.getSite();
        }
        return baseChannel;
    }

    private void updateLastModifyTime(BaseObj baseObj) throws WCMException {
        BaseChannel baseChannel = this.getParentObj(baseObj);
        if (baseChannel == null) {
            return;
        }
        baseChannel.setProperty("lastmodifytime", CMyDateTime.now());
        baseChannel.save();
    }

    @Override
    public void notifyOnAddObj(BaseObj objAdded) throws WCMException {
        this.updateLastModifyTime(objAdded);
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        this.updateLastModifyTime(objModified);
    }

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        this.updateLastModifyTime(objDeleted);
    }
}

