/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.servlet;

import com.trs.idm.client.actor.FormValues;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.exception.IdMException;
import com.trs.idm.interact.agent.AgentFactory;
import com.trs.idm.interact.agent.AgentUtil;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.interact.agent.LoginResult;
import com.trs.idm.model.sso.samedomain.SameDomainSSOHelper;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.CookieHelper;
import com.trs.idm.util.LoginEncoder;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import com.trs.idm.util.UrlUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LoginProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String FORWARD_FOR_FAIL = "afterLoginFail.gotoType";
    public static final String FORWARD_FOR_OK = "afterLoginOk.gotoType";
    public static final String LOGIN_FAIL_URL = "afterLoginFail.gotoUrl";
    public static final String LOGIN_OK_URL = "afterLoginOk.gotoUrl";
    public static final String SESS_ATTRS_PASSWD = "com.trs.ids.sessAttrs.passwd";
    public static final String SESS_ATTRS_USERNAME = "com.trs.ids.sessAttrs.username";
    public static final String SESS_ATTR_SOURCENAME = "com.trs.ids.sessAttrs.sourcename";
    public static final String CK_LOGIN_INFO = "com.trs.ids.app.lInfo";
    public static final String CK_POST_PARAM = "com.trs.ids.app.postParam";
    private IAgent agent;
    private int domainLevel;
    private String loginOkUrl;
    private String loginFailUrl;
    private boolean forwardForOk;
    private boolean forwardForFail;
    private static final Logger LOG = Logger.getLogger(LoginProxyServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.agent.isSocketAlive()) {
            req.setAttribute("ids.ssoLogin.failInfo", (Object)"\u7cfb\u7edf\u6682\u65f6\u65e0\u6cd5\u63d0\u4f9b\u8ba4\u8bc1\u670d\u52a1\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5!");
            RequestDispatcher loginFailPage = req.getRequestDispatcher(this.loginFailUrl);
            if (loginFailPage != null) {
                loginFailPage.forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                resp.sendError(500, "cannot login, because agent not connected to ids!");
            }
            return;
        }
        if (this.agent.isAllowAnonymous() && this.agent.supportSameDomainSSO()) {
            this.processSameDomainSSOSelfPageLoginRequest(req, resp);
            return;
        }
        this.processCrossDomainSSOSelfPageLoginRequest(req, resp);
    }

    private void processSameDomainSSOSelfPageLoginRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        LOG.debug((Object)"This is a same domain anonymous app, and this is a self page login request");
        String coSessionId = this.agent.getServletAppActorV2().getSessionId(req, resp, true);
        CookieHelper cookieHelper = new CookieHelper(req, resp, this.agent.getRequestServerName(req), this.domainLevel);
        String sdToken = cookieHelper.getValue("trsidssdssotoken");
        if (!StringHelper.isEmpty((String)sdToken)) {
            boolean timeout;
            LOG.debug((Object)("SDToken in Cookie: " + sdToken));
            String ssoId = SameDomainSSOHelper.getSSOIdFromSDToken((String)sdToken);
            long validTime = SameDomainSSOHelper.getValidTimeFromSDToken((String)sdToken);
            boolean bl = timeout = System.currentTimeMillis() >= validTime;
            if (!timeout) {
                SSOUser ssoUser = null;
                try {
                    ssoUser = this.agent.findSSOUser(ssoId, coSessionId, RequestUtil.getRemoteAddr((HttpServletRequest)req, (String)this.agent.getOriginalClientIPHttpHeader()));
                }
                catch (IdMException e) {
                    LOG.error((Object)"Find SSOUser from IDS by SameDomain SSOSessionID error", (Throwable)e);
                }
                LOG.info((Object)("SSOUser found by SSOId[" + ssoId + "] in SDToken from IDS Server: " + ssoUser));
                if (ssoUser != null) {
                    if (!this.agent.getServletAppActorV2().userExist(req, resp, ssoUser)) {
                        this.agent.getServletAppActorV2().addUser(req, resp, ssoUser);
                    }
                    SameDomainSSOHelper.plantAppCurrentLoginedSSOIDCookie((HttpServletRequest)req, (HttpServletResponse)resp, (boolean)true, (String)ssoId, (String)this.agent.getSDSSOCookieDomain(), (String)this.agent.getSDSSOIDSCookiePath(), (String)this.agent.getAgentName());
                    this.agent.getServletAppActorV2().loadLoginUser(req, resp, ssoUser);
                    LOG.info((Object)("User SSOUser[" + ssoUser.getUserName() + "] to do localLogin by actor.loadLoginUser finished"));
                    this.handleLoginOK(req, resp, ssoUser.getUserName(), ssoUser.getProperty("plainUserPwd"), null);
                    return;
                }
                LOG.info((Object)("Can not find SSOUser by SDToken in Cookie: " + sdToken + ", so clear same domain cookie"));
            }
            if (timeout) {
                LOG.info((Object)("SDToken[" + sdToken + "] in Cookie is time out"));
            }
            LOG.info((Object)("About to remove Same Domain Cookie, sdToken: " + sdToken));
            cookieHelper.removeCookie("trsidssdssotoken", this.agent.getSDSSOCookiePath(), this.agent.getSDSSOCookieDomain());
        }
        String userName = this.agent.getServletAppActorV2().extractUserName(req, resp);
        String passwd = this.agent.getServletAppActorV2().extractUserPwd(req, resp);
        String sourceName = null;
        String isAutoLoginForApp = null;
        FormValues extraValues = this.agent.getServletAppActorV2().extractExtraInput(req, resp);
        if (extraValues != null) {
            sourceName = extraValues.getParamValue("sourceName");
            if (StringHelper.isEmpty((String)sourceName)) {
                sourceName = "ids_internal";
            }
            isAutoLoginForApp = extraValues.getParamValue("isAutoLogin");
        }
        String ssoIdInIDSCookie = cookieHelper.getValue("trsidsssosessionid");
        LoginResult lr = new LoginResult();
        if (!StringHelper.isEmpty((String)ssoIdInIDSCookie)) {
            LOG.info((Object)("Using SSOID[" + ssoIdInIDSCookie + "] in IDS Cookie for globalLogin"));
            lr = this.agent.loginUser(ssoIdInIDSCookie, coSessionId, userName, passwd, sourceName, RequestUtil.getRemoteAddr((HttpServletRequest)req, (String)this.agent.getOriginalClientIPHttpHeader()), extraValues);
        }
        LOG.info((Object)("LoginResut : " + lr));
        if (!lr.isSuccess() || lr.getFailCode() == 10) {
            LOG.info((Object)"Using loginUserForSameDomainSSO method for globalLogin, will create a ssoSession in IDS first and excute global login");
            lr = this.agent.loginUserForSameDomainSSO(userName, passwd, sourceName, coSessionId, RequestUtil.getRemoteAddr((HttpServletRequest)req, (String)this.agent.getOriginalClientIPHttpHeader()), extraValues);
        }
        if (lr.isSuccess()) {
            SSOUser ssoUser;
            String sdTokenInLoginResult = lr.getSdToken();
            String ssoId = SameDomainSSOHelper.getSSOIdFromSDToken((String)sdTokenInLoginResult);
            LOG.info((Object)("User[" + userName + "] login in IDS ok, SDToken: " + sdTokenInLoginResult + "; ssoId: " + ssoId));
            SameDomainSSOHelper.plantSameDomainCookie((HttpServletRequest)req, (HttpServletResponse)resp, (String)sdTokenInLoginResult, (boolean)true, (String)this.agent.getSDSSOCookieDomain(), (String)this.agent.getSDSSOCookiePath(), (String)this.agent.getOriginalHostHttpHeader());
            SameDomainSSOHelper.plantIDSCookie((HttpServletRequest)req, (HttpServletResponse)resp, (boolean)true, (String)ssoId, (String)this.agent.getSDSSOCookieDomain(), (String)this.agent.getSDSSOIDSCookiePath(), (String)this.agent.getOriginalHostHttpHeader());
            String userInfoCookie = LoginEncoder.encodeInfo((String)userName, (String)passwd);
            if ("true".equals(isAutoLoginForApp)) {
                SameDomainSSOHelper.plantAutoLoginCookie((HttpServletRequest)req, (HttpServletResponse)resp, (String)userInfoCookie, (String)sourceName, (int)864000, (String)this.agent.getSDSSOCookieDomain(), (String)this.agent.getSDSSOIDSCookiePath());
            }
            if ((ssoUser = lr.getSSOUser()) == null) {
                LOG.error((Object)"Login in IDS OK, but SSOUser from IDS is null!");
                this.handleLoginFail(req, resp, lr, null, userName, passwd, coSessionId);
                return;
            }
            SameDomainSSOHelper.plantAppCurrentLoginedSSOIDCookie((HttpServletRequest)req, (HttpServletResponse)resp, (boolean)true, (String)ssoId, (String)this.agent.getSDSSOCookieDomain(), (String)this.agent.getSDSSOIDSCookiePath(), (String)this.agent.getAgentName());
            this.agent.getServletAppActorV2().loadLoginUser(req, resp, ssoUser);
            LOG.info((Object)"localLogin by actor done");
            this.handleLoginOK(req, resp, userName, passwd, lr);
        } else {
            LOG.info((Object)"Self page login in same domain sso app fail");
            this.handleLoginFail(req, resp, lr, null, userName, passwd, coSessionId);
        }
    }

    private void handleLoginOK(HttpServletRequest req, HttpServletResponse resp, String userName, String passwd, LoginResult lr) throws ServletException, IOException {
        String loginOKReturnUrl = this.getLoginOkReturnUrl(req);
        String referUrl = RequestUtil.getReferUrl((HttpServletRequest)req);
        LOG.info((Object)("localLogin OK,about to go to return url: " + loginOKReturnUrl));
        String msg = "";
        if (lr != null) {
            msg = lr.getFailInfoMessage();
        }
        this.goToReturlUrl(req, resp, loginOKReturnUrl, referUrl, userName, passwd, msg);
    }

    private void processCrossDomainSSOSelfPageLoginRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String referUrl = RequestUtil.getReferUrl((HttpServletRequest)req);
        String coSessionId = this.agent.getServletAppActorV2().getSessionId(req, resp, true);
        CookieHelper ckHelper = new CookieHelper(req, resp, this.agent.getRequestServerName(req), this.domainLevel);
        String userName = null;
        String passwd = null;
        String sourceName = null;
        String gSessionId = AgentUtil.getBindSSOId((CookieHelper)ckHelper, (IAgent)this.agent);
        FormValues extraValues = this.agent.getServletAppActorV2().extractExtraInput(req, resp);
        if (gSessionId == null) {
            String fromUrl = this.getAskFromUrl(this.agent, req);
            String encryGlobalSessId = req.getParameter("com.trs.idm.gSessionId");
            if (encryGlobalSessId == null) {
                userName = this.agent.getServletAppActorV2().extractUserName(req, resp);
                passwd = this.agent.getServletAppActorV2().extractUserPwd(req, resp);
                if (extraValues != null) {
                    sourceName = extraValues.getParamValue("sourceName");
                    if (StringHelper.isEmpty((String)sourceName)) {
                        sourceName = "ids_internal";
                    }
                    ckHelper.addCookie(SESS_ATTR_SOURCENAME, UrlUtil.encode((String)LoginEncoder.encode((String)sourceName), (String)"UTF-8"));
                }
                if (this.agent.needSavePostParamAndPostBack()) {
                    AgentUtil.savePostParamInCookie((HttpServletRequest)req, (CookieHelper)ckHelper);
                }
                ckHelper.addCookie(CK_LOGIN_INFO, UrlUtil.encode((String)LoginEncoder.encodeInfo((String)userName, (String)passwd), (String)"UTF-8"));
                LOG.info((Object)("user login info saved before redirect. (user, sourceName, coSessionId)=" + userName + "," + sourceName + "," + coSessionId));
                resp.sendRedirect(this.getAskGSessIdUrl(fromUrl));
                return;
            }
            gSessionId = this.decry(encryGlobalSessId);
            AgentUtil.saveSSOId((String)gSessionId, (CookieHelper)ckHelper, (IAgent)this.agent);
            LOG.info((Object)("saved gSessId: " + gSessionId + ". coSessionId=" + coSessionId));
        }
        if (req.getParameter("com.trs.idm.gSessionId") != null) {
            String ckLoginInfo = UrlUtil.decode((String)ckHelper.getValue(CK_LOGIN_INFO), (String)"UTF-8");
            userName = LoginEncoder.decodeUser((String)ckLoginInfo);
            passwd = LoginEncoder.decodePwd((String)ckLoginInfo);
            sourceName = LoginEncoder.decode((String)UrlUtil.decode((String)ckHelper.getValue(SESS_ATTR_SOURCENAME), (String)"UTF-8"));
            LOG.info((Object)("load user login info from cookie or session. (user, sourcename, sessId, gSessId)=" + userName + ", " + sourceName + ", " + coSessionId + ", " + gSessionId + ",ckLoginInfo in cookie:" + ckLoginInfo + ", all cookie in http request:" + req.getHeader("Cookie")));
        } else {
            userName = this.agent.getServletAppActorV2().extractUserName(req, resp);
            passwd = this.agent.getServletAppActorV2().extractUserPwd(req, resp);
            if (extraValues != null) {
                sourceName = extraValues.getParamValue("sourceName");
                ckHelper.addCookie(SESS_ATTR_SOURCENAME, UrlUtil.encode((String)LoginEncoder.encode((String)sourceName), (String)"UTF-8"));
            }
            LOG.info((Object)("load user and pwd from request params. (user, sessId, gSessId)=" + userName + ", " + coSessionId + ", " + gSessionId));
        }
        LoginResult lr = this.agent.loginUser(gSessionId, coSessionId, userName, passwd, sourceName, RequestUtil.getRemoteAddr((HttpServletRequest)req, (String)this.agent.getOriginalClientIPHttpHeader()), extraValues);
        String returnUrl = null;
        if (lr.isSuccess()) {
            ckHelper.removeCookie(CK_LOGIN_INFO);
            ckHelper.removeCookie(SESS_ATTR_SOURCENAME);
            AgentUtil.removeSSOBind((CookieHelper)ckHelper, (IAgent)this.agent);
            if (this.agent.idsServerSupportSameDomainSSO()) {
                String sdToken = lr.getSdToken();
                SameDomainSSOHelper.isSDTokenValid((String)sdToken);
            }
            SSOUser ssoUser = lr.getSSOUser();
            LOG.info((Object)("Login finish, SSOUser is: " + ssoUser));
            try {
                if (ssoUser == null) {
                    ssoUser = this.agent.findLoginSSOUser(gSessionId, coSessionId);
                }
                if (ssoUser != null) {
                    try {
                        if (!this.agent.getServletAppActorV2().userExist(req, resp, ssoUser)) {
                            this.agent.getServletAppActorV2().addUser(req, resp, ssoUser);
                            if (resp.isCommitted()) {
                                return;
                            }
                        }
                        this.agent.getServletAppActorV2().loadLoginUser(req, resp, ssoUser);
                    }
                    catch (RuntimeException e) {
                        LOG.error((Object)(String.valueOf(this.agent.getAgentName()) + " actor addUser/loadLoginUser fail! sessId=" + coSessionId + ", user=" + ssoUser.getUserName()), (Throwable)e);
                    }
                } else {
                    LOG.error((Object)("agent.findLoginSSOUser(" + coSessionId + ") == null! ssoSessionId=" + gSessionId));
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("load login user fail! (user, sessId, gSessId)=" + userName + ", " + coSessionId + ", " + gSessionId), (Throwable)e);
            }
            if (resp.isCommitted()) {
                return;
            }
            returnUrl = this.getLoginOkReturnUrl(req);
            boolean needPostBackAfterLoginOK = this.agent.needSavePostParamAndPostBack();
            boolean hasPostParamInCookie = AgentUtil.havePostParamInCookie((CookieHelper)ckHelper);
            LOG.debug((Object)("needPostBackAfterLoginOK: " + needPostBackAfterLoginOK + "; hasPostParamInCookie: " + hasPostParamInCookie));
            if (needPostBackAfterLoginOK) {
                AgentUtil.forwardToAutosubmitPageWithPostParam((HttpServletRequest)req, (HttpServletResponse)resp, (CookieHelper)ckHelper, (String)returnUrl);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("loginOK! (user, sessId, gSessId)=" + userName + ", " + coSessionId + ", " + gSessionId + (this.forwardForOk ? ", forward to " : ", redirect to ") + returnUrl));
            }
            this.goToReturlUrl(req, resp, returnUrl, referUrl, userName, passwd, lr.getFailInfoMessage());
        } else {
            this.handleLoginFail(req, resp, lr, gSessionId, userName, passwd, coSessionId);
        }
    }

    private void handleLoginFail(HttpServletRequest req, HttpServletResponse resp, LoginResult lr, String gSessionId, String userName, String passwd, String coSessionId) throws ServletException, IOException {
        String returnUrl = this.getLoginFailReturnUrl(req);
        LOG.info((Object)("loginFail! (user, sessId, gSessId)=" + userName + ", " + coSessionId + ", " + gSessionId + ". pwd=******" + (this.forwardForFail ? ", forward to " : ", redirect to ") + this.loginFailUrl + ", returnUrl =" + returnUrl + "; (failCode=" + lr.getFailCode() + "(failInfo:" + lr.getFailCode() + ");" + lr.getFailInfo() + " )" + "; (failInfoCode, failInfoMessage):" + "(" + lr.getFailInfoCode() + ", " + lr.getFailInfoMessage() + ")"));
        req.setAttribute(this.agent.getCoAppSelfLoginUserNameField(), (Object)userName);
        if (StringHelper.isEmpty((String)lr.getFailInfoMessage())) {
            req.setAttribute("ids.ssoLogin.failInfo", (Object)lr.getFailInfo());
        } else {
            req.setAttribute("ids.ssoLogin.failInfo", (Object)lr.getFailInfoMessage());
            req.setAttribute("ids.ssoLogin.failInfoCode", (Object)lr.getFailInfoCode());
            req.setAttribute("ids.ssoLogin.failInfoMessage", (Object)lr.getFailInfoMessage());
        }
        if ("2006".equals(lr.getFailInfoCode())) {
            String loginFailUrl = String.valueOf(this.agent.getGlobalLoginUrl()) + "?errCode=" + lr.getFailInfoCode() + "&coAppName=" + Base64Util.encode((String)this.agent.getAgentName()) + "&surl=" + Base64Util.encode((String)("account/errorInfo.jsp?errCode=" + lr.getFailInfoCode())) + "&type=simpleRedirect";
            LOG.info((Object)("login fail because of user necessary attribute is empty with errCode[" + lr.getFailInfoCode() + "], userName[" + userName + "], so need to redirect to ids url[" + loginFailUrl + "] and edit user info!"));
            resp.sendRedirect(loginFailUrl);
            return;
        }
        if (this.agent.continueLocalLoginIfUserNotFoundOnIDS() && new Integer(1011).toString().equals(lr.getFailInfoCode())) {
            String selfLoginActionUrl = this.agent.getCoAppSelfLoginActionURL();
            if (StringHelper.isEmpty((String)selfLoginActionUrl)) {
                selfLoginActionUrl = this.agent.getLoginActionURIs()[0];
            }
            LOG.info((Object)("user[" + userName + "] not exist in IDS, but agent.continueLocalLoginIfUserNotFoundOnIDS is true, so forwad to: " + selfLoginActionUrl + " directly!"));
            String message = this.buildNotifyMessage(this.agent.getAgentName());
            req.setAttribute("message", (Object)message);
            req.setAttribute("targetUrl", (Object)(String.valueOf(RequestUtil.getAppBaseURL((HttpServletRequest)req)) + selfLoginActionUrl));
            req.setAttribute("selfLoginPageUserNameField", (Object)this.agent.getCoAppSelfLoginUserNameField());
            req.setAttribute("selfLoginPagePasswordField", (Object)this.agent.getCoAppSelfLoginPagePasswordField());
            CookieHelper ckHelper = new CookieHelper(req, resp, this.agent.getRequestServerName(req), this.domainLevel);
            boolean needPostBackAfterLoginOK = this.agent.needSavePostParamAndPostBack();
            boolean hasPostParamInCookie = AgentUtil.havePostParamInCookie((CookieHelper)ckHelper);
            LOG.debug((Object)("needPostBackAfterLoginOK: " + needPostBackAfterLoginOK + "; hasPostParamInCookie: " + hasPostParamInCookie));
            if (needPostBackAfterLoginOK) {
                returnUrl = String.valueOf(RequestUtil.getAppBaseURL((HttpServletRequest)req)) + selfLoginActionUrl;
                AgentUtil.forwardToAutosubmitPageWithPostParam((HttpServletRequest)req, (HttpServletResponse)resp, (CookieHelper)ckHelper, (String)returnUrl);
                return;
            }
            req.getRequestDispatcher("/WEB-INF/idsAgentPages/autoSubmit.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        req.setAttribute("ids.ssoLogin.referURL", (Object)returnUrl);
        RequestDispatcher loginFailHandler = req.getRequestDispatcher("/WEB-INF/idsAgentPages/loginFail.jsp");
        if (loginFailHandler != null) {
            loginFailHandler.forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            resp.sendError(500, "login fail! and returnUrl not found: " + returnUrl);
        }
    }

    private void goToReturlUrl(HttpServletRequest req, HttpServletResponse resp, String returnUrl, String referUrl, String userName, String passwd, String loginResultMsg) throws ServletException, IOException {
        if (this.forwardForOk) {
            LOG.info((Object)("Self Page Login success, About to forward to:  " + returnUrl));
            req.setAttribute("usr", (Object)userName);
            req.setAttribute("pwd", (Object)passwd);
            req.setAttribute("url", (Object)referUrl);
            req.setAttribute("loginResultMsg", (Object)UrlUtil.encode((String)Base64Util.encode((String)loginResultMsg, (String)"utf-8")));
            req.getRequestDispatcher(returnUrl).forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            boolean idsSupportSameDomainSSO = this.agent.idsServerSupportSameDomainSSO();
            boolean appSupportSameDomainSSO = this.agent.supportSameDomainSSO();
            LOG.info((Object)("IDS SupportSameDomainSSO: " + idsSupportSameDomainSSO + "; appSupportSameDomainSSO: " + appSupportSameDomainSSO));
            LOG.info((Object)("Self Page Login success, About to redirect to:  " + returnUrl));
            if (idsSupportSameDomainSSO && !appSupportSameDomainSSO) {
                String actualRedirectUrl = String.valueOf(this.agent.getGlobalLoginUrl()) + "?coAppName=" + Base64Util.encode((String)this.agent.getAgentName()) + "&surl=" + Base64Util.encode((String)returnUrl) + "&type=simpleRedirect";
                LOG.info((Object)("Because IDS Support same domain SSO, but app does not support , so redirect to IDS Server to plant same domain Cookie, redirect URL: " + actualRedirectUrl));
                if (!StringHelper.isEmpty((String)loginResultMsg)) {
                    req.setAttribute("actualRedirectURL", (Object)actualRedirectUrl);
                    req.setAttribute("loginResultMsg", (Object)UrlUtil.encode((String)Base64Util.encode((String)loginResultMsg, (String)"utf-8")));
                    String forwardURL = "/WEB-INF/idsAgentPages/" + this.agent.getProperty("loginInfo.uri", "loginInfo.jsp");
                    req.getRequestDispatcher(forwardURL).forward((ServletRequest)req, (ServletResponse)resp);
                } else {
                    resp.sendRedirect(actualRedirectUrl);
                }
            } else if (!StringHelper.isEmpty((String)loginResultMsg)) {
                req.setAttribute("actualRedirectURL", (Object)returnUrl);
                req.setAttribute("loginResultMsg", (Object)UrlUtil.encode((String)Base64Util.encode((String)loginResultMsg, (String)"utf-8")));
                String forwardURL = "/WEB-INF/idsAgentPages/" + this.agent.getProperty("loginInfo.uri", "loginInfo.jsp");
                req.getRequestDispatcher(forwardURL).forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                resp.sendRedirect(returnUrl);
            }
        }
    }

    private String buildNotifyMessage(String coAppName) {
        StringBuffer message = new StringBuffer();
        message.append("\u7528\u6237\u5728IDS\u4e0a\u4e0d\u5b58\u5728! <br><br>");
        message.append("\u6839\u636e\u7cfb\u7edf\u8bbe\u5b9a\uff0cIDS\u5c06\u4f1a\u628a\u60a8\u7684\u7528\u6237\u540d\u5bc6\u7801\u63d0\u4ea4\u5230\u5e94\u7528\u7684\u767b\u5f55\u9875\u9762\u8fdb\u884c\u5c1d\u8bd5\u767b\u5f55\uff0c");
        message.append("\u4f46\u8fd9\u53ef\u80fd\u9020\u6210\u60a8\u4ec5\u4ec5\u80fd\u767b\u5f55" + coAppName + "\u5e94\u7528\uff0c\u65e0\u6cd5\u767b\u5f55IDS\u548c\u5176\u4ed6\u5e94\u7528\u3002<br><br>");
        message.append("\u60a8\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f<br>");
        return message.toString();
    }

    private String getLoginOkReturnUrl(HttpServletRequest request) {
        String returnUrl = RequestUtil.getParameterSafe((HttpServletRequest)request, (String)LOGIN_OK_URL);
        if (StringHelper.isEmpty((String)returnUrl)) {
            returnUrl = this.loginOkUrl;
        }
        if (StringHelper.isEmpty((String)returnUrl)) {
            returnUrl = RequestUtil.getReferUrl((HttpServletRequest)request);
        }
        return returnUrl;
    }

    private String getLoginFailReturnUrl(HttpServletRequest request) {
        String returnUrl = RequestUtil.getParameterSafe((HttpServletRequest)request, (String)LOGIN_FAIL_URL);
        if (StringHelper.isEmpty((String)returnUrl)) {
            returnUrl = this.loginFailUrl;
        }
        return returnUrl;
    }

    private String getAskGSessIdUrl(String theFromUrl) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(this.agent.getGlobalLoginUrl());
        sb.append('?').append("askFrom").append('=').append(theFromUrl);
        sb.append('&').append("askGlobalSess").append('=').append('1');
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("askUrl: " + sb));
        }
        return sb.toString();
    }

    private String getAskFromUrl(IAgent agent, HttpServletRequest request) {
        if (RequestUtil.isReverseProxyRequest((HttpServletRequest)request, (String)agent.getOriginalHostHttpHeader())) {
            String askFromUrl = RequestUtil.getOriginalUrlWithParam((HttpServletRequest)request, (String)agent.getOriginalHostHttpHeader());
            LOG.info((Object)("This is an reverse proxy proxy, current requestURL: " + RequestUtil.getFullGetStr((HttpServletRequest)request) + " ,originalURL: " + askFromUrl));
            return askFromUrl;
        }
        return request.getRequestURL().toString();
    }

    private String decry(String encryGlobalSessId) {
        return encryGlobalSessId;
    }

    public void init() throws ServletException {
        super.init();
        this.agent = AgentFactory.getInstance().initAndStart();
        if (this.agent == null) {
            LOG.error((Object)"get agent is null while LoginProxyServlet init!");
            return;
        }
        this.agent.setServerInfo(RequestUtil.getServletContainerInfo((ServletContext)this.getServletContext()));
        this.loginOkUrl = this.agent.getProperty(LOGIN_OK_URL);
        this.forwardForOk = "forward".equalsIgnoreCase(this.agent.getProperty(FORWARD_FOR_OK));
        this.loginFailUrl = this.agent.getProperty(LOGIN_FAIL_URL);
        this.forwardForFail = "forward".equalsIgnoreCase(this.agent.getProperty(FORWARD_FOR_FAIL, "forward"));
        this.domainLevel = Integer.parseInt(this.agent.getProperty("cookie.domain.level", "0"));
        LOG.info((Object)("forward: (ok, fail)=" + this.forwardForOk + ", " + this.forwardForFail + ". url: (ok, fail)=" + this.loginOkUrl + ", " + this.loginFailUrl + ", domainLevel:" + this.domainLevel));
    }

    public void destroy() {
        LOG.info((Object)(String.valueOf(this.getServletName()) + " destroying..."));
        super.destroy();
    }
}

