/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.filter.logicProcessor.AbstractIDSCmdProcessor;
import com.trs.idm.client.filter.logicProcessor.ProcessorUtil;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.util.Base64Util;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class RemoveFromGroupProcessor
extends AbstractIDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(RemoveFromGroupProcessor.class);
    private IAgent agent;
    private final String idsCmd = "removeFromGroup";

    public RemoveFromGroupProcessor(IAgent agent) {
        this.agent = agent;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean opResult;
        String userNameBase64 = req.getHeader("userName");
        String encoding = req.getHeader("encoding");
        String userName = Base64Util.decode((String)userNameBase64, (String)encoding);
        String groupNameBase64 = req.getHeader("groupName");
        String groupName = Base64Util.decode((String)groupNameBase64, (String)encoding);
        LOG.info((Object)("remove from group http request, userNameBase64:" + userNameBase64 + ", decode userName by headerEncoding:" + userName + ", decode userName by UTF-8:" + Base64Util.decode((String)userNameBase64, (String)"UTF-8") + ", decode username by GBK:" + Base64Util.decode((String)userNameBase64, (String)"GBK") + ", decode groupName by headerEncoding:" + groupName + ", decode groupName by UTF-8:" + Base64Util.decode((String)groupNameBase64, (String)"UTF-8") + ", decode groupName by GBK:" + Base64Util.decode((String)groupNameBase64, (String)"GBK")));
        String sourceName = ProcessorUtil.getSourceNameFromRequestHeader(req);
        String groupDN = ProcessorUtil.getGroupDnFromRequestHeader(req);
        SSOUser ssoUser = this.agent.getUpdateSSOUser(userName, sourceName);
        SSOGroup ssoGroup = this.agent.getUpdSSOGroup(groupName, sourceName, groupDN);
        if (ssoUser == null) {
            resp.sendError(500, "[IDSAgent]user is null! (app, idsCmd)=" + this.agent.getAgentName() + ", " + "removeFromGroup");
            return;
        }
        if (resp.isCommitted()) {
            return;
        }
        try {
            opResult = this.agent.getServletAppActorV2().removeFromGroup(req, resp, ssoUser, ssoGroup);
        }
        catch (Throwable t) {
            LOG.error((Object)"[ActorErr]updateUser fail!", t);
            resp.sendError(500, "[ActorErr]updateUser() fail! err=" + t);
            return;
        }
        if (resp.isCommitted()) {
            return;
        }
        if (opResult) {
            resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "removeFromGroup");
        } else {
            resp.sendError(500, "[ActorErr]updateUser() return false!");
        }
    }

    public String getIDSCmd() {
        return "removeFromGroup";
    }
}

