/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.model.sso.samedomain;

import com.trs.idm.util.CookieHelper;
import com.trs.idm.util.StringHelper;
import com.trs.idm.util.UrlUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SameDomainSSOHelper {
    protected static final Logger logger = Logger.getLogger(SameDomainSSOHelper.class);
    private static final String SDTOKEN_SEPARATOR = "_";

    public static String generateSDToken(String ssoSessionId, long validUtil) {
        return String.valueOf(ssoSessionId) + SDTOKEN_SEPARATOR + validUtil;
    }

    public static String getSSOIdFromSDToken(String sdToken) {
        if (StringHelper.isEmpty(sdToken)) {
            return null;
        }
        String[] strArray = StringHelper.split(sdToken, SDTOKEN_SEPARATOR);
        if (strArray == null) {
            logger.debug((Object)("String array after split sdToken[" + sdToken + "] by _ is null"));
            return null;
        }
        if (strArray.length != 2) {
            logger.debug((Object)("String array after split sdToken[" + sdToken + "] length is " + strArray.length + ",  not equals 2, so return null"));
            return null;
        }
        return strArray[0];
    }

    public static long getValidTimeFromSDToken(String sdToken) {
        if (StringHelper.isEmpty(sdToken)) {
            return 0L;
        }
        String[] strArray = StringHelper.split(sdToken, SDTOKEN_SEPARATOR);
        if (strArray == null || strArray.length != 2) {
            return 0L;
        }
        String timeStr = strArray[1];
        long time = 0L;
        try {
            time = new Long(timeStr);
        }
        catch (Exception e) {
            logger.error((Object)("Change time from String to long error, timeStr[" + timeStr + "]"), (Throwable)e);
        }
        logger.debug((Object)("timeStr: " + timeStr + "; time: " + time));
        return time;
    }

    public static boolean isSDTokenValid(String sdToken) {
        if (SameDomainSSOHelper.getSSOIdFromSDToken(sdToken) == null) {
            return false;
        }
        return System.currentTimeMillis() < SameDomainSSOHelper.getValidTimeFromSDToken(sdToken);
    }

    public static boolean hasSameDomainCookie(HttpServletRequest request, HttpServletResponse response) {
        CookieHelper cookieHelper = new CookieHelper(request, response);
        String sdToken = cookieHelper.getValue("trsidssdssotoken");
        return !StringHelper.isEmpty(sdToken);
    }

    public static void plantSameDomainCookie(HttpServletRequest request, HttpServletResponse response, String sdToken, boolean allowCreateCookie, String sdCookieDomain, String sdCookiePath) {
        logger.debug((Object)("sdToken: " + sdToken + "; allowCreateCookie: " + allowCreateCookie + "; sdCookieDomain: " + sdCookieDomain + "; sdCookiePath: " + sdCookiePath));
        CookieHelper cookieHelper = new CookieHelper(request, response);
        Cookie newSDCookie = cookieHelper.getCookie("trsidssdssotoken");
        if (newSDCookie == null && !allowCreateCookie) {
            logger.debug((Object)("Can not find SameDomain Cookie in Domain[" + sdCookieDomain + "] Path[" + sdCookiePath + "], and not allow to create, so return directly"));
            return;
        }
        if (newSDCookie == null && allowCreateCookie) {
            newSDCookie = new Cookie("trsidssdssotoken", sdToken);
            logger.info((Object)("Can not find SameDomain Cookie in Domain[" + sdCookieDomain + "] Path[" + sdCookiePath + "], create one by SDToken[" + sdToken + "]"));
        }
        newSDCookie.setValue(sdToken);
        newSDCookie.setDomain(sdCookieDomain);
        newSDCookie.setPath(sdCookiePath);
        response.addCookie(newSDCookie);
        logger.debug((Object)("Plant Same Domain Cookie   in Domain[" + sdCookieDomain + "] Path[" + sdCookiePath + "] by SDToken[" + sdToken + "] OK!"));
        SameDomainSSOHelper.plantCookieInCurrentDomain(request, response, "trsidssdssotoken", sdToken, sdCookiePath);
    }

    private static void plantCookieInCurrentDomain(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue, String cookiePath) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        String currentDomain = UrlUtil.getDomainByLevel(request.getServerName(), 2);
        logger.debug((Object)("request.getServerName(): " + request.getServerName() + "; currentDomain: " + currentDomain));
        cookie.setDomain(currentDomain);
        cookie.setPath(cookiePath);
        response.addCookie(cookie);
    }

    public static void plantIDSCookie(HttpServletRequest request, HttpServletResponse response, boolean allowCreateCookie, String ssoId, String sdCookieDomain, String idsCookiePath) {
        logger.debug((Object)("SSOSession: " + ssoId + "; allowCreateCookie: " + allowCreateCookie + "; sdCookieDomain: " + sdCookieDomain + "; idsCookiePath: " + idsCookiePath));
        CookieHelper cookieHelper = new CookieHelper(request, response);
        Cookie idsCookie = cookieHelper.getCookie("trsidsssosessionid");
        if (idsCookie == null && !allowCreateCookie) {
            logger.debug((Object)("Can not find IDS Cookie  in Domain[" + sdCookieDomain + "] Path[" + idsCookiePath + "], and not allow to create, so return directly"));
            return;
        }
        if (idsCookie == null && allowCreateCookie) {
            idsCookie = new Cookie("trsidsssosessionid", ssoId);
            logger.info((Object)("Can not find IDS Cookie  in Domain[" + sdCookieDomain + "] Path[" + idsCookiePath + "], create one by SSOSession[" + ssoId + "]"));
        }
        idsCookie.setValue(ssoId);
        idsCookie.setDomain(sdCookieDomain);
        idsCookie.setPath(idsCookiePath);
        response.addCookie(idsCookie);
        logger.debug((Object)("Plant IDS Cookie in Domain[" + sdCookieDomain + "] Path[" + idsCookiePath + "] by SSOSession[" + ssoId + "] OK!"));
        SameDomainSSOHelper.plantCookieInCurrentDomain(request, response, "trsidsssosessionid", ssoId, idsCookiePath);
    }

    public static void removeSameDomainCookie(HttpServletRequest request, HttpServletResponse response, String domain, String path) {
        logger.debug((Object)"Remove same domain cookie");
        CookieHelper cookieHelper = new CookieHelper(request, response);
        cookieHelper.removeCookie("trsidssdssotoken", path, domain);
    }

    public static void plantAutoLoginCookie(HttpServletRequest req, HttpServletResponse resp, String userInfoCookie, String userSourceInfoCookie, int age, String sdCookieDomain, String sdCookiePath) {
        if (!StringHelper.isEmpty(userInfoCookie)) {
            userInfoCookie = userInfoCookie.replace('=', '*');
        }
        Cookie userCookie = new Cookie("idsALInfo", userInfoCookie);
        Cookie userSourceCookie = new Cookie("idsALUserSource", userSourceInfoCookie);
        userCookie.setDomain(sdCookieDomain);
        userSourceCookie.setDomain(sdCookieDomain);
        userCookie.setMaxAge(age);
        userCookie.setPath(sdCookiePath);
        userSourceCookie.setMaxAge(age);
        userSourceCookie.setPath(sdCookiePath);
        resp.addCookie(userCookie);
        resp.addCookie(userSourceCookie);
    }

    public static void plantAppCurrentLoginedSSOIDCookie(HttpServletRequest request, HttpServletResponse response, boolean allowCreateCookie, String ssoId, String sdCookieDomain, String idsCookiePath, String agentName) {
        logger.debug((Object)("SSOSessionId: " + ssoId + "; allowCreateCookie: " + allowCreateCookie + "; sdCookieDomain: " + sdCookieDomain + "; idsCookiePath: " + idsCookiePath + "; agentName: " + agentName));
        CookieHelper cookieHelper = new CookieHelper(request, response);
        Cookie appCurrentLoginedSSOIDCookie = cookieHelper.getCookie("trsidsAppCurrentLoginedSSOSessionId_" + agentName);
        if (appCurrentLoginedSSOIDCookie == null && !allowCreateCookie) {
            logger.debug((Object)("Can not find appCurrentLoginedSSOIDCookie Cookie  in Domain[" + sdCookieDomain + "] Path[" + idsCookiePath + "], and not allow to create, so return directly"));
            return;
        }
        if (appCurrentLoginedSSOIDCookie == null && allowCreateCookie) {
            appCurrentLoginedSSOIDCookie = new Cookie("trsidsAppCurrentLoginedSSOSessionId_" + agentName, ssoId);
            logger.info((Object)("Can not find appCurrentLoginedSSOIDCookie Cookie  in Domain[" + sdCookieDomain + "] Path[" + idsCookiePath + "], create one by SSOSession[" + ssoId + "]"));
        }
        appCurrentLoginedSSOIDCookie.setValue(ssoId);
        appCurrentLoginedSSOIDCookie.setDomain(sdCookieDomain);
        appCurrentLoginedSSOIDCookie.setPath(idsCookiePath);
        response.addCookie(appCurrentLoginedSSOIDCookie);
        logger.debug((Object)("Plant appCurrentLoginedSSOIDCookie Cookie in Domain[" + sdCookieDomain + "] Path[" + idsCookiePath + "] by SSOSession[" + ssoId + "] OK!"));
    }

    public static String getAppCurrentLoginedSSOID(HttpServletRequest request, HttpServletResponse response, String agentName) {
        CookieHelper sdCookieHelper = new CookieHelper(request, response);
        String appCurrentLoginedSSOID = sdCookieHelper.getValue("trsidsAppCurrentLoginedSSOSessionId_" + agentName);
        return appCurrentLoginedSSOID;
    }
}

