/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.ftp.protocol;

import com.trs.net.ftp.FtpException;
import com.trs.net.ftp.protocol.ControlReader;
import com.trs.net.ftp.protocol.ControlWriter;
import com.trs.net.ftp.protocol.FtpProtocolException;
import com.trs.net.ftp.protocol.ProtocolListener;
import com.trs.net.ftp.protocol.ProtocolListenerContainer;
import com.trs.net.ftp.protocol.TransferInputStream;
import com.trs.net.ftp.protocol.TransferOutputStream;
import com.trs.net.proxy.Proxy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;

public class FtpClientPI {
    private static final char[] CRLF = new char[]{'\r', '\n'};
    private ProtocolListenerContainer m_oAllListener = new ProtocolListenerContainer(this);
    private String m_sFtpServerHost;
    private int m_iFtpServerPort;
    private Proxy m_oProxyServer;
    private String m_sCtrlEncoding = "GBK";
    private int m_iBufferSize;
    private int[] m_iAllFeature;
    private Socket m_oDataSocket;
    private Socket m_oCtrlSocket;
    private ControlReader m_oCtrlReader;
    private ControlWriter m_oCtrlWriter;
    private StringBuffer m_oCtrlBuffer;
    private boolean m_zHoldActiveListen;
    private ServerSocket m_oHoldActiveSocket;
    private int m_iReplyCode;
    private int m_iReplyCode1st;
    private int m_iReplyCode2nd;
    private int m_iReplyCode3rd;
    private String m_sReplyLine;
    private boolean m_zReplyPend;
    private ArrayList m_oReplyList = new ArrayList();
    private int m_iDataType;
    private int m_iDataFormat;
    private int m_iDataStructure;
    private int m_iDataTransferMode;
    private boolean m_zActiveMode;
    private boolean m_zPassiveMode;
    private int m_iPassivePort;
    private String m_sPassiveHost;
    private int m_iDataTimeout = 1000;
    private int m_iWaitTimeout = 1000;
    private int m_iCtrlTimeout = 0;

    public FtpClientPI() {
        this.m_oCtrlBuffer = new StringBuffer(256);
        this.m_iAllFeature = new int[256];
        this.disconnect();
    }

    private void reInitDefault() {
        this.m_iBufferSize = 8192;
        this.m_zActiveMode = true;
        this.m_zPassiveMode = true;
        this.m_iPassivePort = 0;
        this.m_sPassiveHost = null;
        this.m_iDataType = 65;
        this.m_iDataFormat = 78;
        this.m_iDataStructure = 70;
        this.m_iDataTransferMode = 83;
        int i = 0;
        while (i < this.m_iAllFeature.length) {
            this.m_iAllFeature[i] = -1;
            ++i;
        }
        this.m_iAllFeature[8] = 0;
        this.m_iAllFeature[7] = 0;
    }

    public void addProtocolListener(ProtocolListener listener) {
        this.m_oAllListener.addProtocolListener(listener);
    }

    public void removeProtocolListener(ProtocolListener listener) {
        this.m_oAllListener.removeProtocolListener(listener);
    }

    public String getCtrlEncoding() {
        return this.m_sCtrlEncoding;
    }

    public void setCtrlEncoding(String encoding) {
        this.m_sCtrlEncoding = encoding;
    }

    public void setCtrlTimeout(int timeout) {
        this.m_iCtrlTimeout = timeout;
    }

    public int getBufferSize() {
        return this.m_iBufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.m_iBufferSize = bufferSize;
    }

    public int getDataTimeout() {
        return this.m_iDataTimeout;
    }

    public void setDataTimeout(int dataTimeout) {
        this.m_iDataTimeout = dataTimeout;
    }

    public int getWaitTimeout() {
        return this.m_iWaitTimeout;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.m_iWaitTimeout = waitTimeout;
    }

    private void destroySocket() {
        if (this.m_oCtrlSocket == null) {
            return;
        }
        if (this.m_oCtrlReader != null) {
            try {
                this.m_oCtrlReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_oCtrlReader = null;
        }
        if (this.m_oCtrlWriter != null) {
            try {
                this.m_oCtrlWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_oCtrlWriter = null;
        }
        if (this.m_oCtrlSocket != null) {
            try {
                this.m_oCtrlSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_oCtrlSocket = null;
        }
        if (this.m_oDataSocket != null) {
            try {
                this.m_oDataSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_oDataSocket = null;
        }
    }

    Socket createSocket(String host, int port, Proxy proxy) throws IOException {
        if (proxy == null) {
            return new Socket(host, port);
        }
        return null;
    }

    public boolean connect(String host, int port, Proxy proxy) throws IOException {
        if (this.isConnected()) {
            return true;
        }
        this.m_sFtpServerHost = host;
        this.m_iFtpServerPort = port;
        this.m_oProxyServer = proxy;
        this.m_oCtrlSocket = this.createSocket(host, port, proxy);
        InputStream is = this.m_oCtrlSocket.getInputStream();
        InputStreamReader isr = new InputStreamReader(is, this.m_sCtrlEncoding);
        this.m_oCtrlReader = new ControlReader(isr);
        OutputStream os = this.m_oCtrlSocket.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os, this.m_sCtrlEncoding);
        this.m_oCtrlWriter = new ControlWriter(osw);
        this.readReply();
        if (this.m_iReplyCode1st != 2) {
            this.disconnect();
        }
        return this.m_iReplyCode1st == 2;
    }

    public void disconnect() {
        this.destroySocket();
        this.reInitDefault();
        this.m_oCtrlReader = null;
        this.m_oCtrlWriter = null;
        this.m_oCtrlSocket = null;
        this.m_oCtrlBuffer.setLength(0);
        this.m_oReplyList.clear();
        this.m_sReplyLine = null;
        this.m_iReplyCode = 0;
        this.m_iReplyCode1st = 0;
        this.m_iReplyCode2nd = 0;
        this.m_iReplyCode3rd = 0;
        this.m_sFtpServerHost = null;
        this.m_iFtpServerPort = 21;
        this.m_oProxyServer = null;
        int i = 0;
        while (i < this.m_iAllFeature.length) {
            this.m_iAllFeature[i] = -1;
            ++i;
        }
        this.m_iAllFeature[8] = 0;
        this.m_iAllFeature[7] = 0;
    }

    public boolean open() {
        return this.isConnected();
    }

    public void close() {
        if (this.m_oCtrlSocket == null) {
            return;
        }
        try {
            this.m_oCtrlSocket.setSoTimeout(1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.quit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disconnect();
    }

    public boolean isConnected() {
        return this.m_oCtrlSocket != null;
    }

    public String getFtpServerHost() {
        return this.m_sFtpServerHost;
    }

    public int getFtpServerPort() {
        return this.m_iFtpServerPort;
    }

    public Proxy getProxyServer() {
        return this.m_oProxyServer;
    }

    public int getFeatureStatus(int cmd) {
        if (cmd < 0 || cmd >= this.m_iAllFeature.length) {
            return -1;
        }
        return this.m_iAllFeature[cmd];
    }

    public boolean getActiveMode() {
        return this.m_zActiveMode;
    }

    public void setActiveMode(boolean activeMode) {
        this.m_zActiveMode = activeMode;
    }

    public boolean getPassiveMode() {
        return this.m_zPassiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.m_zPassiveMode = passiveMode;
    }

    public String getPassiveHost() {
        return this.m_sPassiveHost;
    }

    public int getPassivePort() {
        return this.m_iPassivePort;
    }

    public int getDataType() {
        return this.m_iDataType;
    }

    public boolean setDataType(int dataType) throws IOException {
        this.type(dataType);
        if (this.m_iReplyCode1st == 2) {
            this.m_iDataType = dataType;
            return true;
        }
        return false;
    }

    public int getDataFormat() {
        return this.m_iDataFormat;
    }

    public boolean setDataFormat(int dataFormat) throws IOException {
        this.type(65, dataFormat);
        if (this.m_iReplyCode1st == 2) {
            this.m_iDataFormat = dataFormat;
            return true;
        }
        return false;
    }

    public int getDataStructure() {
        return this.m_iDataStructure;
    }

    public boolean setDataStructure(int structure) throws IOException {
        this.stru(structure);
        if (this.m_iReplyCode1st == 2) {
            this.m_iDataStructure = structure;
            return true;
        }
        return false;
    }

    public int getDataTransferMode() {
        return this.m_iDataTransferMode;
    }

    public boolean setDataTransferMode(int transfer) throws IOException {
        this.mode(transfer);
        if (this.m_iReplyCode1st == 2) {
            this.m_iDataTransferMode = transfer;
            return true;
        }
        return false;
    }

    public InputStream listNames(String path) throws IOException {
        return this.getDataStream("NLST", path, 0L);
    }

    public InputStream listFiles(String path) throws IOException {
        return this.getDataStream("LIST", path, 0L);
    }

    public InputStream retrieveFile(String filename, long iOffset) throws IOException {
        return this.getDataStream("RETR", filename, iOffset);
    }

    public OutputStream appendFile(String filename) throws IOException {
        return this.putDataStream("APPE", filename, 0L);
    }

    public OutputStream storeFile(String filename, long iOffset) throws IOException {
        return this.putDataStream("STOR", filename, iOffset);
    }

    public OutputStream storeFile(String filename, int iOffset) throws IOException {
        return this.putDataStream("STOR", filename, iOffset);
    }

    public OutputStream storeUniqueFile(String filename) throws IOException {
        return this.putDataStream("STOU", filename, 0L);
    }

    protected InputStream getDataStream(String cmd, String arg, long rst) throws IOException {
        Socket socket = this.openDataConnection(cmd, arg, rst);
        if (socket != null) {
            InputStream is = socket.getInputStream();
            if (this.m_iDataType == 65 && this.m_iBufferSize > 0) {
                is = new BufferedInputStream(is, this.m_iBufferSize);
            }
            return new TransferInputStream(this, is);
        }
        return null;
    }

    protected OutputStream putDataStream(String cmd, String arg, long rst) throws IOException {
        Socket socket = this.openDataConnection(cmd, arg, rst);
        if (socket != null) {
            OutputStream os = socket.getOutputStream();
            if (this.m_iDataType == 65 && this.m_iBufferSize > 0) {
                os = new BufferedOutputStream(os, this.m_iBufferSize);
            }
            return new TransferOutputStream(this, os);
        }
        return null;
    }

    protected Socket openDataConnection(String cmd, String arg, long rst) throws IOException {
        Socket socket = null;
        boolean zCommandFailed = false;
        if (socket == null && this.m_zPassiveMode && (socket = this.openDataConnByPASV()) != null) {
            if (rst > 0L && !this.sendResumeOffset(rst)) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                socket = null;
                zCommandFailed = true;
            } else {
                this.issueCommand(cmd, arg);
                if (this.m_iReplyCode1st != 1) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    socket = null;
                    zCommandFailed = true;
                }
            }
        }
        if (socket == null && this.m_zActiveMode && !zCommandFailed) {
            ServerSocket server = this.openActiveListen();
            if (!this.sendActiveListen(server)) {
                this.shutActiveListen(server);
                return null;
            }
            if (rst > 0L && !this.sendResumeOffset(rst)) {
                this.shutActiveListen(server);
                return null;
            }
            try {
                try {
                    socket = server.accept();
                }
                catch (SocketTimeoutException e) {
                    this.m_oAllListener.fireActiveTimeout(server, this.m_iWaitTimeout);
                    this.shutActiveListen(server);
                    return null;
                }
            }
            finally {
                this.shutActiveListen(server);
            }
            this.issueCommand(cmd, arg);
            if (this.m_iReplyCode1st != 1) {
                this.shutActiveListen(server);
                return null;
            }
        }
        if (socket != null) {
            if (this.m_iDataTimeout > 0) {
                socket.setSoTimeout(this.m_iDataTimeout);
            }
            if (this.m_iBufferSize > 0) {
                socket.setReceiveBufferSize(this.m_iBufferSize);
                socket.setSendBufferSize(this.m_iBufferSize);
            }
            this.m_oDataSocket = socket;
        }
        return socket;
    }

    protected final void shutDataConnection() {
        if (this.m_oDataSocket != null) {
            try {
                this.m_oDataSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_oDataSocket = null;
        }
    }

    private final void parseEPSVReply(String sReply) throws IOException {
        int iRight = sReply.lastIndexOf(124);
        int iLeft = sReply.lastIndexOf(124, iRight - 1);
        if (iLeft < 0 || iRight <= 0) {
            throw new FtpProtocolException("EPSV Reply error:" + sReply);
        }
        try {
            this.m_sPassiveHost = this.m_oCtrlSocket.getInetAddress().getHostAddress();
            this.m_iPassivePort = Integer.parseInt(sReply.substring(iLeft + 1, iRight));
        }
        catch (Exception e) {
            throw new FtpProtocolException("EPSV Reply:" + sReply + ",error:" + e.getMessage());
        }
        if (this.m_oProxyServer != null) {
            this.m_sPassiveHost = this.m_sFtpServerHost;
        }
    }

    private final void parsePASVReply(String sReply) throws IOException {
        String sHostPort = sReply.substring(sReply.indexOf(40) + 1, sReply.indexOf(41)).trim();
        int iIndex2 = sHostPort.lastIndexOf(44);
        int iIndex1 = sHostPort.lastIndexOf(44, iIndex2 - 1);
        int iPortByte1 = 0;
        int iPortByte2 = 0;
        try {
            iPortByte1 = Integer.parseInt(sHostPort.substring(iIndex1 + 1, iIndex2));
            iPortByte2 = Integer.parseInt(sHostPort.substring(iIndex2 + 1));
        }
        catch (Exception e) {
            throw new FtpProtocolException("EPSV Reply:" + sReply + ",error:" + e.getMessage());
        }
        this.m_sPassiveHost = sHostPort.substring(0, iIndex1).replace(',', '.');
        this.m_iPassivePort = (iPortByte1 << 8) + iPortByte2;
    }

    private final Socket openDataConnByPASV() throws IOException {
        if (this.m_iAllFeature[8] != 0) {
            this.epsv(null);
            if (this.m_iReplyCode == 229) {
                this.m_iAllFeature[8] = 1;
                this.parseEPSVReply(this.m_sReplyLine);
                return this.createSocket(this.m_sPassiveHost, this.m_iPassivePort, this.m_oProxyServer);
            }
            if (this.m_iReplyCode1st == 5) {
                this.m_iAllFeature[8] = 0;
            }
        }
        this.pasv();
        if (this.m_iReplyCode == 227) {
            this.parsePASVReply(this.m_sReplyLine);
            return this.createSocket(this.m_sPassiveHost, this.m_iPassivePort, this.m_oProxyServer);
        }
        return null;
    }

    private final ServerSocket openActiveListen() throws IOException {
        ServerSocket server = new ServerSocket(0, 1, this.m_oCtrlSocket.getLocalAddress());
        if (this.m_iWaitTimeout > 0) {
            server.setSoTimeout(this.m_iWaitTimeout);
        }
        return server;
    }

    private final boolean sendActiveListen(ServerSocket server) throws IOException {
        if (this.m_iAllFeature[7] != 0) {
            this.eprt(server.getInetAddress(), server.getLocalPort());
            if (this.m_iReplyCode == 200) {
                this.m_iAllFeature[7] = 1;
                return true;
            }
            if (this.m_iReplyCode1st == 5) {
                this.m_iAllFeature[7] = 0;
            }
        }
        this.port(server.getInetAddress(), server.getLocalPort());
        return this.m_iReplyCode == 200;
    }

    private final void shutActiveListen(ServerSocket server) {
        try {
            server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean sendResumeOffset(long marker) throws IOException {
        int iReplyCode = this.rest(marker);
        return iReplyCode == 350;
    }

    private final int readReply() throws IOException {
        this.m_oReplyList.clear();
        String sLine = this.m_oCtrlReader.readLine();
        if (sLine == null) {
            throw new EOFException("Unexpected control connection close.");
        }
        if (sLine.length() < 3) {
            throw new EOFException("Unexpected reply (too short):" + sLine);
        }
        this.m_oReplyList.add(sLine);
        this.m_iReplyCode1st = sLine.charAt(0) - 48;
        this.m_iReplyCode2nd = sLine.charAt(1) - 48;
        this.m_iReplyCode3rd = sLine.charAt(2) - 48;
        this.m_iReplyCode = this.m_iReplyCode1st * 100 + this.m_iReplyCode2nd * 10 + this.m_iReplyCode3rd;
        this.m_zReplyPend = this.m_iReplyCode1st == 1;
        this.m_sReplyLine = sLine;
        if (sLine.length() > 3 && sLine.charAt(3) == '-') {
            char c;
            int l;
            do {
                if ((sLine = this.m_oCtrlReader.readLine()) == null) {
                    throw new EOFException("Unexpected control connection close.");
                }
                this.m_oReplyList.add(sLine);
            } while ((l = sLine.length()) < 3 || (c = sLine.charAt(0)) < '0' || c > '9' || l != 3 && (l <= 3 || sLine.charAt(3) != ' '));
        }
        this.m_oAllListener.fireReplyReceived(this.m_iReplyCode, this.getReplyString());
        return this.m_iReplyCode;
    }

    public int readReplyPending() throws IOException {
        while (this.m_zReplyPend) {
            this.readReply();
        }
        return this.m_iReplyCode;
    }

    public int getReplyCode() {
        return this.m_iReplyCode;
    }

    public int getReplyCode1st() {
        return this.m_iReplyCode1st;
    }

    public int getReplyCode2nd() {
        return this.m_iReplyCode2nd;
    }

    public int getReplyCode3rd() {
        return this.m_iReplyCode3rd;
    }

    public String getReplyLine() {
        return this.m_sReplyLine;
    }

    public ArrayList getReplyList() {
        return this.m_oReplyList;
    }

    public boolean getReplyPend() {
        return this.m_zReplyPend;
    }

    public String getReplyString() {
        int size = this.m_oReplyList.size();
        StringBuffer sb = new StringBuffer(size * 256);
        int i = 0;
        while (i < size) {
            sb.append(this.m_oReplyList.get(i));
            sb.append(CRLF);
            ++i;
        }
        return sb.toString();
    }

    public String getReplyContent() {
        return this.getReplyString();
    }

    public FtpException newFtpException() {
        return new FtpException(this.getReplyCode(), this.getReplyString());
    }

    public int issueCommand(String cmd, String arg) throws IOException {
        while (this.m_zReplyPend) {
            this.readReply();
        }
        this.m_oCtrlWriter.write(cmd);
        if (arg != null) {
            this.m_oCtrlWriter.write(32);
            this.m_oCtrlWriter.write(arg);
        }
        this.m_oCtrlWriter.write(CRLF, 0, 2);
        this.m_oCtrlWriter.flush();
        this.m_oAllListener.fireCommandSent(cmd, arg);
        return this.readReply();
    }

    public int user(String username) throws IOException {
        return this.issueCommand("USER", username);
    }

    public int pass(String password) throws IOException {
        return this.issueCommand("PASS", password);
    }

    public int acct(String account) throws IOException {
        return this.issueCommand("ACCT", account);
    }

    public int cwd(String pathname) throws IOException {
        return this.issueCommand("CWD", pathname);
    }

    public int cdup() throws IOException {
        return this.issueCommand("CDUP", null);
    }

    public int smnt(String pathname) throws IOException {
        return this.issueCommand("SMNT", pathname);
    }

    public int rein() throws IOException {
        return this.issueCommand("REIN", null);
    }

    public int quit() throws IOException {
        return this.issueCommand("QUIT", null);
    }

    public int port(String host, int port) throws IOException {
        StringBuffer sb = this.m_oCtrlBuffer;
        sb.setLength(0);
        sb.append(host.replace('.', ','));
        sb.append(',').append(port >>> 8);
        sb.append(',').append(port & 0xFF);
        return this.issueCommand("PORT", sb.toString());
    }

    public int port(InetAddress host, int port) throws IOException {
        return this.port(host.getHostAddress(), port);
    }

    public int pasv() throws IOException {
        return this.issueCommand("PASV", null);
    }

    public int type(int dataType) throws IOException {
        StringBuffer sb = this.m_oCtrlBuffer;
        sb.setLength(0);
        sb.append((char)dataType);
        return this.issueCommand("TYPE", sb.toString());
    }

    public int type(int dataType, int format) throws IOException {
        StringBuffer sb = this.m_oCtrlBuffer;
        sb.setLength(0);
        sb.append((char)dataType).append(' ').append((char)format);
        return this.issueCommand("TYPE", sb.toString());
    }

    public int stru(int structure) throws IOException {
        StringBuffer sb = this.m_oCtrlBuffer;
        sb.setLength(0);
        sb.append((char)structure);
        return this.issueCommand("STRU", sb.toString());
    }

    public int mode(int mode) throws IOException {
        StringBuffer sb = this.m_oCtrlBuffer;
        sb.setLength(0);
        sb.append((char)mode);
        return this.issueCommand("MODE", sb.toString());
    }

    public int retr(String pathname) throws IOException {
        return this.issueCommand("RETR", pathname);
    }

    public int stor(String pathname) throws IOException {
        return this.issueCommand("STOR", pathname);
    }

    public int stou() throws IOException {
        return this.issueCommand("STOU", null);
    }

    public int appe(String pathname) throws IOException {
        return this.issueCommand("APPE", pathname);
    }

    public int allo(int bytes) throws IOException {
        StringBuffer sb = this.m_oCtrlBuffer;
        sb.setLength(0);
        sb.append(bytes);
        return this.issueCommand("ALLO", sb.toString());
    }

    public int allo(int bytes, int pagesize) throws IOException {
        StringBuffer sb = this.m_oCtrlBuffer;
        sb.setLength(0);
        sb.append(bytes).append(" R ").append(pagesize);
        return this.issueCommand("ALLO", sb.toString());
    }

    public int rest(long marker) throws IOException {
        StringBuffer sb = this.m_oCtrlBuffer;
        sb.setLength(0);
        sb.append(marker);
        return this.issueCommand("REST", sb.toString());
    }

    public int rnfr(String pathname) throws IOException {
        return this.issueCommand("RNFR", pathname);
    }

    public int rnto(String pathname) throws IOException {
        return this.issueCommand("RNTO", pathname);
    }

    public int abor() throws IOException {
        return this.issueCommand("ABOR", null);
    }

    public int dele(String pathname) throws IOException {
        return this.issueCommand("DELE", pathname);
    }

    public int rmd(String pathname) throws IOException {
        return this.issueCommand("RMD", pathname);
    }

    public int mkd(String pathname) throws IOException {
        return this.issueCommand("MKD", pathname);
    }

    public int pwd() throws IOException {
        return this.issueCommand("PWD", null);
    }

    public int list(String pathname) throws IOException {
        return this.issueCommand("LIST", pathname);
    }

    public int nlst(String pathname) throws IOException {
        return this.issueCommand("NLST", pathname);
    }

    public int site(String args) throws IOException {
        return this.issueCommand("SITE", args);
    }

    public int syst() throws IOException {
        return this.issueCommand("SYST", null);
    }

    public int stat(String pathname) throws IOException {
        return this.issueCommand("STAT", pathname);
    }

    public int help(String command) throws IOException {
        return this.issueCommand("HELP", command);
    }

    public int noop() throws IOException {
        return this.issueCommand("NOOP", null);
    }

    public int eprt(InetAddress host, int port) throws IOException {
        String sHost = host.getHostAddress();
        StringBuffer sb = this.m_oCtrlBuffer;
        sb.setLength(0);
        sb.append('|');
        sb.append(sHost.indexOf(58) >= 0 ? (char)'2' : '1');
        sb.append('|');
        sb.append(sHost);
        sb.append('|');
        sb.append(port);
        sb.append('|');
        return this.issueCommand("EPRT", sb.toString());
    }

    public int epsv(String netprt) throws IOException {
        return this.issueCommand("EPSV", netprt);
    }

    public int mdtm(String pathname) throws IOException {
        return this.issueCommand("MDTM", pathname);
    }

    public int size(String pathname) throws IOException {
        return this.issueCommand("SIZE", pathname);
    }
}

