/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.CharsetToUniInputStream;
import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.DynamicClassLoader;
import com.sybase.jdbc2.jdbc.DynamicObjectInputStream;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.jdbc.RawToAsciiInputStream;
import com.sybase.jdbc2.jdbc.TextPointer;
import com.sybase.jdbc2.jdbc.UnicharToAsciiInputStream;
import com.sybase.jdbc2.jdbc.UnicharToUniInputStream;
import com.sybase.jdbc2.tds.CachedTdsJdbcInputStream;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.CacheStream;
import com.sybase.jdbc2.utils.Cacheable;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsJdbcInputStream
extends TdsDataObject
implements Cacheable {
    private static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";
    private static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    private static final String JAVA_LANG_FLOAT = "java.lang.Float";
    private static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    private static final String JAVA_LANG_LONG = "java.lang.Long";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_MATH_BIGDECIMAL = "java.math.BigDecimal";
    private static final String JAVA_IO_FILTERINPUTSTREAM = "java.io.FilterInputStream";
    private static final String JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final int BUFLEN = 512;
    public static final int RAW_TO_ASCII_STREAM = 1;
    public static final int RAW_TO_UNI_STREAM = 2;
    public static final int CHARSET_TO_UNI_STREAM = 3;
    public static final int RAW_STREAM = 4;
    public static final int UNICHAR_TO_UNI_STREAM = 5;
    public static final int UNICHAR_TO_ASCII_STREAM = 6;
    private CacheManager _monitor;
    private RawInputStream _columnInputStream;
    private InputStreamReader _columnInputStreamReader;
    private DynamicClassLoader _classLoader;

    public TdsJdbcInputStream(TdsProtocolContext tdsProtocolContext, Tds tds) throws IOException {
        super(tdsProtocolContext);
        this._classLoader = this._tds.getClassLoader();
    }

    public int available() throws IOException {
        return this._dataLength != -1 ? this._dataLength : this.in.available();
    }

    protected void beginRead() throws IOException {
        if (this._monitor == null && this._state == 0 && this._prev != null && this._prev._state != 3) {
            this._prev.cache();
        }
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
                this._state = 3;
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
        this.getSize();
        if (this._isNull) {
            return;
        }
        if (this._monitor == null) {
            if (this._state == 0) {
                if (this._context._rereadable) {
                    this.openCacheStream();
                }
                this._state = 1;
            }
        } else if (this._state == 0) {
            ErrorMessage.raiseIOException("JZ0R3");
        }
        if (this._state == 3) {
            if (this._context._rereadable) {
                this.reset();
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
    }

    public void cache() throws IOException {
        if (this._state == 3) {
            return;
        }
        if (this._monitor == null) {
            this.startRead();
            if (this._context._rereadable && (this._state == 0 || this._columnInputStream == null)) {
                this.openCacheStream();
            }
        }
        this._state = 2;
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                this._columnInputStream.cache((CacheStream)this.in);
            } else {
                this._columnInputStream.close();
                this._columnInputStream = null;
            }
            this._state = 3;
            return;
        }
        this.getSize();
        if (this._dataLength == -1 && this._columnInputStream == null) {
            try {
                this._columnInputStream = this.makeNewRIS(4);
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
            this._columnInputStream.cache((CacheStream)this.in);
            this._state = 3;
            this.reset();
            this._columnInputStream = null;
            return;
        }
        byte[] byArray = new byte[512];
        int n = this._dataLength;
        while (n > 0) {
            int n2 = n < 512 ? n : 512;
            this.in.read(byArray, 0, n2);
            n -= n2;
        }
        if (this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
        if (this._monitor != null) {
            this.in.reset();
        }
    }

    public void clear() throws IOException {
        if (this._columnInputStream != null) {
            this._columnInputStream.close();
            this._columnInputStream = null;
        } else {
            switch (this._state) {
                case 0: {
                    if (this._monitor != null) break;
                    this.skipParam();
                    break;
                }
                case 1: {
                    this.skipParam();
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                    break;
                }
                case 2: {
                    this.getSize();
                    this.in.skip(this._dataLength);
                    if (this._monitor == null) break;
                    this._monitor.doneReading();
                    break;
                }
            }
        }
        this.initialize();
    }

    protected TdsDataObject createCachedCopy() throws SQLException, IOException {
        return new CachedTdsJdbcInputStream(this);
    }

    protected void endRead() throws SQLException {
        if (this._state != 3 && this._monitor != null) {
            this._monitor.doneReading();
        }
        this._state = 3;
    }

    public InputStream getAsciiStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                    case 225: {
                        this._columnInputStream = this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34 ? this.makeNewRIS(6) : this.makeNewRIS(1);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            bigDecimal = new BigDecimal((double)this.readUnsignedByte());
                            break;
                        }
                        case 52: {
                            bigDecimal = new BigDecimal((double)this.readShort());
                            break;
                        }
                        case 56: {
                            bigDecimal = new BigDecimal((double)this.readInt());
                            break;
                        }
                        case 38: {
                            bigDecimal = new BigDecimal((double)this.readINTN());
                            break;
                        }
                        case 59: {
                            bigDecimal = new BigDecimal(this.readFloat());
                            break;
                        }
                        case 62: {
                            bigDecimal = new BigDecimal(this.readDouble());
                            break;
                        }
                        case 109: {
                            bigDecimal = new BigDecimal(this.readFLTN());
                            break;
                        }
                        case 106: 
                        case 108: {
                            bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            bigDecimal = new BigDecimal(Convert.numString(this.readString()));
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            bigDecimal = this.readMONEYN();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        bigDecimal = Convert.setScale(bigDecimal, n);
        return bigDecimal;
    }

    public InputStream getBinaryStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 4) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 34: 
                    case 37: 
                    case 45: 
                    case 225: {
                        this._columnInputStream = this.makeNewRIS(4);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    public boolean getBoolean() throws SQLException {
        boolean bl = false;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            bl = this.readUnsignedByte() != 0;
                            break;
                        }
                        case 52: {
                            bl = this.readShort() != 0;
                            break;
                        }
                        case 56: {
                            bl = this.readInt() != 0;
                            break;
                        }
                        case 38: {
                            bl = this.readINTN() != 0L;
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bigDecimal = this.readMONEYN();
                            bl = bigDecimal.signum() != 0;
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            bl = this.readFLTN() != 0.0;
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            bl = bigDecimal.signum() != 0;
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            String string = this.readString();
                            bl = string != null && (string.trim().toLowerCase().equals("true") || string.trim().equals("1"));
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
            Object var3_7 = null;
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return bl;
    }

    public byte getByte() throws SQLException {
        long l = 0L;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            l = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            l = this.readShort();
                            break;
                        }
                        case 56: {
                            l = this.readInt();
                            break;
                        }
                        case 38: {
                            l = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            l = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            l = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            l = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                        }
                    }
                    Convert.checkByteOflo(l);
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return (byte)l;
    }

    public byte[] getBytes() throws SQLException {
        byte[] byArray = null;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 36: {
                            int n;
                            if (this._dataFmt._blobType != 4) {
                                ErrorMessage.raiseError("JZ0TE", "Object");
                            }
                            this._columnInputStream = this.makeNewRIS(4);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            byte[] byArray2 = new byte[512];
                            while ((n = this._columnInputStream.read(byArray2, 0, 512)) != -1) {
                                byteArrayOutputStream.write(byArray2, 0, n);
                            }
                            byArray = byteArrayOutputStream.toByteArray();
                            byteArrayOutputStream.close();
                            this._columnInputStream.close();
                            this._columnInputStream = null;
                            break;
                        }
                        case 34: 
                        case 37: 
                        case 45: 
                        case 225: {
                            byArray = this.funkyBinaryReader();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "varbinay, long binary, binary, image");
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return byArray;
    }

    public Reader getCharacterStream() throws SQLException {
        Reader reader = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(4);
                        this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(1);
                        this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        return this._columnInputStreamReader;
                    }
                    case 225: {
                        if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                            this._columnInputStream = this.makeNewRIS(5);
                            String string = null;
                            string = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
                            this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, string);
                        } else {
                            this._columnInputStream = this.makeNewRIS(1);
                            this._columnInputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                        }
                        return this._columnInputStreamReader;
                    }
                }
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return reader;
    }

    public DateObject getDateObject(int n, Calendar calendar) throws SQLException {
        DateObject dateObject = null;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            dateObject = Convert.objectToDateObject(this.readString(), n, calendar);
                            break;
                        }
                        case 58: 
                        case 61: 
                        case 111: {
                            dateObject = this.readDATETIMN().dateObjectValue(calendar);
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "char, varchar, datetime, short datetime");
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorMessage.raiseError("JZ009", illegalArgumentException.getMessage());
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return dateObject;
    }

    public double getDouble() throws SQLException {
        double d = 0.0;
        try {
            block17: {
                try {
                    this.beginRead();
                    if (this._isNull) break block17;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            d = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            d = this.readShort();
                            break;
                        }
                        case 56: {
                            d = this.readInt();
                            break;
                        }
                        case 38: {
                            d = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            d = this.readFLTN();
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            if (bigDecimal != null) {
                                d = bigDecimal.doubleValue();
                            }
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            d = Double.valueOf(Convert.numString(this.readString()));
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bigDecimal = this.readMONEYN();
                            if (bigDecimal != null) {
                                d = bigDecimal.doubleValue();
                            }
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                }
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return d;
    }

    public float getFloat() throws SQLException {
        float f = 0.0f;
        try {
            block19: {
                try {
                    this.beginRead();
                    if (this._isNull) break block19;
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            f = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            f = this.readShort();
                            break;
                        }
                        case 56: {
                            f = this.readInt();
                            break;
                        }
                        case 38: {
                            f = this.readINTN();
                            break;
                        }
                        case 59: {
                            f = this.readFloat();
                            break;
                        }
                        case 62: {
                            f = (float)this.readDouble();
                            break;
                        }
                        case 109: {
                            f = (float)this.readFLTN();
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            if (bigDecimal != null) {
                                f = bigDecimal.floatValue();
                            }
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            f = Float.valueOf(Convert.numString(this.readString())).floatValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bigDecimal = this.readMONEYN();
                            if (bigDecimal != null) {
                                f = bigDecimal.floatValue();
                            }
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                }
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return f;
    }

    public int getInt() throws SQLException {
        long l = 0L;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            l = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            l = this.readShort();
                            break;
                        }
                        case 56: {
                            l = this.readInt();
                            break;
                        }
                        case 38: {
                            l = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            l = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            l = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            l = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                        }
                    }
                    Convert.checkIntOflo(l);
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return (int)l;
    }

    public long getLong() throws SQLException {
        long l = 0L;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            l = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            l = this.readShort();
                            break;
                        }
                        case 56: {
                            l = this.readInt();
                            break;
                        }
                        case 38: {
                            l = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            l = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            l = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            l = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return l;
    }

    /*
     * Exception decompiling
     */
    public Object getObject() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String getObjectClassName(int n, int n2, int n3) throws SQLException {
        String string = JAVA_LANG_OBJECT;
        switch (n) {
            case 50: {
                return JAVA_LANG_BOOLEAN;
            }
            case 48: 
            case 52: 
            case 56: {
                return JAVA_LANG_INTEGER;
            }
            case 38: {
                if (n3 > 4) return JAVA_LANG_LONG;
                return JAVA_LANG_INTEGER;
            }
            case 59: {
                return JAVA_LANG_FLOAT;
            }
            case 62: 
            case 109: {
                if (n3 != 4) return JAVA_LANG_DOUBLE;
                return JAVA_LANG_FLOAT;
            }
            case 35: 
            case 39: 
            case 47: 
            case 175: {
                return JAVA_LANG_STRING;
            }
            case 60: 
            case 106: 
            case 108: 
            case 110: 
            case 122: {
                return JAVA_MATH_BIGDECIMAL;
            }
            case 34: 
            case 37: 
            case 45: 
            case 103: 
            case 104: 
            case 225: {
                return new byte[1].getClass().getName();
            }
            case 58: 
            case 61: 
            case 111: {
                return JAVA_SQL_TIMESTAMP;
            }
            case 36: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        return JAVA_LANG_OBJECT;
                    }
                    case 3: 
                    case 4: {
                        return JAVA_IO_FILTERINPUTSTREAM;
                    }
                    default: {
                        return string;
                    }
                }
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return string;
    }

    protected byte[] getRawBytes() throws SQLException {
        byte[] byArray = null;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    int n;
                    this._columnInputStream = this.makeNewRIS(4);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[512];
                    while ((n = this._columnInputStream.read(byArray2, 0, 512)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    this._columnInputStream.close();
                    this._columnInputStream = null;
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return byArray;
    }

    public short getShort() throws SQLException {
        long l = 0L;
        try {
            try {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            l = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            l = this.readShort();
                            break;
                        }
                        case 56: {
                            l = this.readInt();
                            break;
                        }
                        case 38: {
                            l = this.readINTN();
                            break;
                        }
                        case 59: 
                        case 62: 
                        case 109: {
                            l = new Double(this.readFLTN()).longValue();
                            break;
                        }
                        case 106: 
                        case 108: {
                            l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            l = new BigDecimal(Convert.numString(this.readString())).longValue();
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            l = this.readMONEYN().longValue();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, varchar, text, money, short money");
                        }
                    }
                    Convert.checkShortOflo(l);
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return (short)l;
    }

    public int getState() {
        return this._state;
    }

    public String getString() throws SQLException {
        String string = null;
        try {
            block32: {
                try {
                    this.beginRead();
                    if (this._isNull) break block32;
                    block2 : switch (this._dataFmt._datatype) {
                        case 48: 
                        case 50: {
                            string = String.valueOf(this.readUnsignedByte());
                            break;
                        }
                        case 52: {
                            string = String.valueOf(this.readShort());
                            break;
                        }
                        case 56: {
                            string = String.valueOf(this.readInt());
                            break;
                        }
                        case 38: {
                            string = String.valueOf(this.readINTN());
                            break;
                        }
                        case 59: {
                            string = String.valueOf(this.readFloat());
                            break;
                        }
                        case 62: {
                            string = String.valueOf(this.readDouble());
                            break;
                        }
                        case 109: {
                            string = String.valueOf(this.readFLTN());
                            break;
                        }
                        case 106: 
                        case 108: {
                            BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                            if (bigDecimal != null) {
                                string = bigDecimal.toString();
                            }
                            break;
                        }
                        case 35: 
                        case 39: 
                        case 47: 
                        case 175: {
                            string = this.readString();
                            break;
                        }
                        case 34: 
                        case 37: 
                        case 45: 
                        case 103: 
                        case 104: {
                            string = HexConverts.hexConvert(this.funkyBinaryReader());
                            break;
                        }
                        case 225: {
                            if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                                string = this.readUnicodeString();
                                break;
                            }
                            string = HexConverts.hexConvert(this.funkyBinaryReader());
                            break;
                        }
                        case 60: 
                        case 110: 
                        case 122: {
                            BigDecimal bigDecimal = this.readMONEYN();
                            if (bigDecimal != null) {
                                string = bigDecimal.toString();
                            }
                            break;
                        }
                        case 58: 
                        case 61: 
                        case 111: {
                            string = this.readDATETIMN().stringValue();
                            break;
                        }
                        case 36: {
                            switch (this._dataFmt._blobType) {
                                case 1: {
                                    Object object = this.readObject();
                                    if (object == null) {
                                        string = null;
                                        break block2;
                                    }
                                    string = object.toString();
                                    break block2;
                                }
                                case 3: {
                                    int n;
                                    this._columnInputStream = this.makeNewRIS(4);
                                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this._columnInputStream, this._tds._charsetName);
                                    char[] cArray = new char[512];
                                    StringBuffer stringBuffer = new StringBuffer();
                                    while ((n = inputStreamReader.read(cArray, 0, 512)) != -1) {
                                        stringBuffer.append(cArray, 0, n);
                                    }
                                    string = stringBuffer.toString();
                                    inputStreamReader.close();
                                    this._columnInputStream.close();
                                    this._columnInputStream = null;
                                    break block2;
                                }
                                case 4: {
                                    int n;
                                    this._columnInputStream = this.makeNewRIS(4);
                                    byte[] byArray = new byte[512];
                                    StringBuffer stringBuffer = new StringBuffer();
                                    while ((n = this._columnInputStream.read(byArray, 0, 512)) != -1) {
                                        stringBuffer.append(HexConverts.hexConvert(byArray, n));
                                    }
                                    string = stringBuffer.toString();
                                    this._columnInputStream.close();
                                    this._columnInputStream = null;
                                    break block2;
                                }
                            }
                            ErrorMessage.raiseError("JZ0TC");
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0TC");
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ009", numberFormatException.toString());
                }
            }
            Object var3_14 = null;
        }
        catch (Throwable throwable) {
            Object var3_15 = null;
            this.endRead();
            throw throwable;
        }
        this.endRead();
        return string;
    }

    /*
     * Exception decompiling
     */
    public TextPointer getTextPtr() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream getUnicodeStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 3) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this._columnInputStream = this.makeNewRIS(3);
                        return this._columnInputStream;
                    }
                    case 4: 
                    case 34: 
                    case 37: 
                    case 45: {
                        this._columnInputStream = this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                    case 225: {
                        this._columnInputStream = this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34 ? this.makeNewRIS(5) : this.makeNewRIS(2);
                        return this._columnInputStream;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    public void initialize() {
        super.initialize();
        this._columnInputStream = null;
        if (this.in instanceof CacheStream) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
            this.in = this._context._in;
        }
    }

    public boolean isNull() throws SQLException {
        return this._isNull;
    }

    /*
     * Unable to fully structure code
     */
    protected RawInputStream makeNewRIS(int var1_1) throws SQLException {
        if (this._columnInputStream != null) {
            if (this._context._rereadable) {
                try {
                    try {
                        this._columnInputStream.close();
                        this._state = 3;
                        this.reset();
                    }
                    catch (IOException var4_2) {
                        ErrorMessage.raiseErrorCheckDead(var4_2);
                    }
                    var3_4 = null;
                    this._columnInputStream = null;
                }
                catch (Throwable var2_6) {
                    var3_5 = null;
                    this._columnInputStream = null;
                    throw var2_6;
                }
            }
            ErrorMessage.raiseError("JZ0R3");
        }
        var2_7 = null;
        var3_4 = null;
        var4_3 = this._dataLength;
        if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
            var4_3 = this._dataFmt._length;
        }
        if (this._context._maxFieldSize > 0) {
            var4_3 = Math.min(var4_3, this._context._maxFieldSize);
        }
        if (this._state != 3) {
            var3_4 = this._monitor;
            this._state = 1;
        }
        try {
            switch (var1_1) {
                case 4: {
                    var2_7 = new RawInputStream(this, this._dataLength, var4_3, var3_4);
                    break;
                }
                case 1: {
                    var2_7 = new RawToAsciiInputStream(this, this._dataLength, var4_3, var3_4);
                    break;
                }
                case 3: {
                    var2_7 = new CharsetToUniInputStream(this, this._dataLength, var4_3, var3_4, this._tds._charsetName);
                    break;
                }
                case 2: {
                    var5_8 = this._dataLength == -1 ? -1 : 2 * this._dataLength;
                    var6_10 = var4_3 == -1 ? -1 : 2 * var4_3;
                    var2_7 = new CharsetToUniInputStream(new RawToAsciiInputStream(this, this._dataLength, var4_3, var3_4), var5_8, var6_10, null, "8859_1");
                    break;
                }
                case 5: {
                    var2_7 = this.getBigEndian() ? new UnicharToUniInputStream((InputStream)this, this._dataLength, var4_3, var3_4, false) : new UnicharToUniInputStream((InputStream)this, this._dataLength, var4_3, var3_4, true);
                    break;
                }
                case 6: {
                    if (var4_3 != this._dataLength) {
                        var4_3 = var4_3 * 2 < this._dataLength ? (var4_3 *= 2) : this._dataLength;
                    }
                    var2_7 = new UnicharToAsciiInputStream(this, this._dataLength, var4_3, this.getBigEndian(), var3_4);
                    break;
                }
                default: {
                    ** if (this._state == 3) goto lbl-1000
                }
            }
        }
        catch (IOException var5_9) {
            ErrorMessage.raiseError("JZ0I5", var5_9.toString());
        }
        if (this._state != 3) lbl-1000:
        // 2 sources

        {
            v0 = false;
        } else lbl-1000:
        // 2 sources

        {
            v0 = true;
        }
        var2_7.setCached(v0);
        return var2_7;
    }

    public void open(boolean bl) {
        this._state = bl ? 2 : 1;
        if (this._context._lastResult == 209) {
            this._context._lastResult = -1;
        }
    }

    private void openCacheStream() {
        this.in = new CacheStream(this._context._cm, this.in, this._context._timeout);
    }

    private Object readObject() throws SQLException {
        Object object = null;
        try {
            this._columnInputStream = this.makeNewRIS(4);
            if (this._columnInputStream.available() > 0) {
                ObjectInputStream objectInputStream = this._classLoader == null ? new ObjectInputStream(this._columnInputStream) : new DynamicObjectInputStream((InputStream)this._columnInputStream, this._classLoader);
                object = objectInputStream.readObject();
                objectInputStream.close();
            } else {
                this._isNull = true;
            }
            this._columnInputStream.close();
            this._columnInputStream = null;
        }
        catch (Exception exception) {
            ErrorMessage.raiseError("JZ010", exception.getMessage());
        }
        return object;
    }

    public void reset() throws IOException {
        if (this._state == 3 && !this._isNull) {
            this.in.reset();
            if (this._monitor != null) {
                this._dataLength = -2;
                this.getSize();
            }
        } else {
            ErrorMessage.raiseIOException("JZ0P7");
        }
    }

    public void resetInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setManager(CacheManager cacheManager) {
        this._monitor = cacheManager;
    }

    private void skipParam() throws IOException {
        this.getSize();
        if (this._dataLength == -1) {
            try {
                try {
                    this._columnInputStream = this.makeNewRIS(4);
                    this._columnInputStream.close();
                }
                catch (SQLException sQLException) {
                    ErrorMessage.raiseIOECheckDead(sQLException);
                }
                Object var2_2 = null;
                this._columnInputStream = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this._columnInputStream = null;
                throw throwable;
            }
        }
        this.in.skip(this._dataLength);
    }
}

