/*
 * Decompiled with CFR 0.152.
 */
package org.aton.cache;

import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.aton.cache.ICachedObj;
import org.aton.cache.PoolConfig;
import org.aton.exception.ExceptionFire;

public abstract class PoolBase
implements Runnable,
Observer,
ICachedObj {
    protected PoolConfig m_config = null;
    protected Class m_pooledObjClass = null;
    private boolean m_bRunning = false;
    protected Vector m_vFreeObjs = null;
    protected Vector m_vBusyObjs = null;
    private boolean m_bPending = false;
    private volatile int m_nTotalObjs = 0;
    private static final String CLASS_NAME;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.aton.cache.PoolBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public PoolBase(PoolConfig p_config) throws Exception {
        if (p_config == null) {
            throw new ExceptionFire(11, "\u6307\u5b9a\u7f13\u51b2\u6c60\u914d\u7f6e\u5bf9\u8c61\u4e3anull", String.valueOf(CLASS_NAME) + ".Constructor");
        }
        try {
            this.checkPooledObjClass(p_config.getPooledObjBaseClass());
            this.m_config = p_config;
            this.m_pooledObjClass = p_config.getPooledObjClass();
        }
        catch (Exception ex) {
            throw new ExceptionFire(1, "\u8fde\u63a5\u7f13\u51b2\u6c60\u914d\u7f6e\u4fe1\u606f\u65e0\u6548", String.valueOf(CLASS_NAME) + ".Constructor", ex);
        }
    }

    protected PoolBase() throws Exception {
    }

    protected void checkPooledObjClass(Class p_baseClass) throws Exception {
    }

    protected void finalize() {
        this.shutdown();
    }

    protected abstract Object createNewPooledObj() throws Exception;

    protected abstract void closePooledObj(Object var1) throws Exception;

    protected abstract boolean isPooledObjClosed(Object var1);

    protected abstract boolean isPooledObjBusy(Object var1);

    public void update(Observable _observable, Object _arg) {
        if (_arg != null && !this.isPooledObjBusy(_arg)) {
            this.free(_arg);
        }
    }

    public void run() {
        try {
            Object newObj = this.makeNewObj();
            PoolBase poolBase = this;
            synchronized (poolBase) {
                this.m_vFreeObjs.addElement(newObj);
                this.m_bPending = false;
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void makeNewObjInBackground() {
        this.m_bPending = true;
        try {
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getCachedKey() {
        return this.m_config == null ? null : this.m_config.getPooledObjClassName();
    }

    public Class getPooledObjClass() {
        return this.m_pooledObjClass;
    }

    public PoolConfig getConfig() {
        return this.m_config;
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public int getTotalObjs() {
        return this.m_nTotalObjs;
    }

    public int getFreeObjsCount() {
        return this.m_vFreeObjs.size();
    }

    public int getBusyObjsCount() {
        return this.m_vBusyObjs.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object makeNewObj() throws Exception {
        Object newObj = null;
        try {
            try {
                this.m_bPending = true;
                newObj = this.createNewPooledObj();
                ++this.m_nTotalObjs;
                Object object = newObj;
                Object var3_3 = null;
                this.m_bPending = false;
                return object;
            }
            catch (Exception ex) {
                if (newObj == null) throw new ExceptionFire(1, "\u521b\u5efa\u7f13\u51b2\u5bf9\u8c61\u65f6\u5931\u8d25", String.valueOf(CLASS_NAME) + ".makeNewObj", ex);
                if (this.isPooledObjClosed(newObj)) throw new ExceptionFire(1, "\u521b\u5efa\u7f13\u51b2\u5bf9\u8c61\u65f6\u5931\u8d25", String.valueOf(CLASS_NAME) + ".makeNewObj", ex);
                this.closePooledObj(newObj);
                throw new ExceptionFire(1, "\u521b\u5efa\u7f13\u51b2\u5bf9\u8c61\u65f6\u5931\u8d25", String.valueOf(CLASS_NAME) + ".makeNewObj", ex);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.m_bPending = false;
            throw throwable;
        }
    }

    public synchronized void startup() throws Exception {
        if (this.m_bRunning) {
            return;
        }
        try {
            int nMaxNum = this.m_config.getMaxNum();
            this.m_vFreeObjs = new Vector(nMaxNum, 1);
            this.m_vBusyObjs = new Vector(nMaxNum, 1);
            int i = 0;
            while (i < this.m_config.getInitNum()) {
                this.m_vFreeObjs.add(this.makeNewObj());
                ++i;
            }
            this.m_bRunning = true;
        }
        catch (Exception ex) {
            throw new ExceptionFire(1, "\u63d0\u53d6\u914d\u7f6e\u4fe1\u606f\u5e76\u521d\u59cb\u5316\u7f13\u51b2\u6c60\u5931\u8d25", String.valueOf(CLASS_NAME) + ".startup", ex);
        }
    }

    public synchronized void shutdown() {
        if (!this.m_bRunning) {
            return;
        }
        this.closeAll();
        this.m_vFreeObjs = null;
        this.m_vBusyObjs = null;
        this.m_bRunning = false;
    }

    public synchronized void restart() throws Exception {
        if (this.m_bRunning) {
            this.shutdown();
        }
        this.startup();
    }

    public Object getAvailableObj() {
        if (!this.m_bRunning) {
            return null;
        }
        Vector vector = this.m_vFreeObjs;
        synchronized (vector) {
            if (!this.m_vFreeObjs.isEmpty()) {
                Object obj = this.m_vFreeObjs.lastElement();
                int index = this.m_vFreeObjs.size() - 1;
                this.m_vFreeObjs.removeElementAt(index);
                Vector vector2 = this.m_vBusyObjs;
                synchronized (vector2) {
                    this.m_vBusyObjs.addElement(obj);
                }
                return obj;
            }
        }
        if (this.m_nTotalObjs < this.m_config.getMaxNum() && !this.m_bPending) {
            this.makeNewObjInBackground();
        } else if (!this.m_config.isWaitIfBusy()) {
            return null;
        }
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getAvailableObj();
    }

    public void free(Object p_obj) {
        if (p_obj == null || this.m_vBusyObjs == null) {
            return;
        }
        Vector vector = this.m_vBusyObjs;
        synchronized (vector) {
            if (this.m_vBusyObjs.removeElement(p_obj)) {
                Vector vector2 = this.m_vFreeObjs;
                synchronized (vector2) {
                    this.m_vFreeObjs.addElement(p_obj);
                }
            }
        }
        try {
            this.notifyAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void closeAll() {
        Vector[] vPooledObjs = new Vector[]{this.m_vFreeObjs, this.m_vBusyObjs};
        Object pooledObj = null;
        int i = 0;
        while (i < vPooledObjs.length) {
            if (vPooledObjs[i] != null) {
                int index = vPooledObjs[i].size() - 1;
                while (index >= 0) {
                    try {
                        pooledObj = vPooledObjs[i].get(index);
                        this.closePooledObj(pooledObj);
                        pooledObj = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --index;
                }
                vPooledObjs[i].clear();
            }
            ++i;
        }
    }
}

