/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.ReflectUtil;
import com.trs.idm.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.JavaIdentifierTransformer;
import net.sf.json.util.PropertyFilter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtil {
    private static final Logger LOG = Logger.getLogger(JSONUtil.class);

    public static final String toJSONArray(Object[] objArray) {
        if (objArray == null || objArray.length == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        Object[] objectArray = objArray;
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            try {
                jsonArray.add(obj);
            }
            catch (JSONException e) {
                LOG.error((Object)"Transfer ObjArray to String fail", (Throwable)e);
            }
            ++n2;
        }
        return jsonArray.toString();
    }

    public static String toJSONArray(List<? extends Object> entities) {
        if (entities == null || entities.size() == 0) {
            return "[]";
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(entities.get(0).getClass());
        return JSONArray.fromObject(entities, (JsonConfig)jsonConfig).toString();
    }

    public static String toJSON(Object obj) {
        if (obj instanceof Map) {
            return JSONUtil.toMapJSON((Map)obj);
        }
        Map<String, Object> map = ReflectUtil.toMap(obj);
        return JSONUtil.toJSON(map);
    }

    public static String toJSON(Object object, String ... fields) {
        JsonConfig jsonConfig = new JsonConfig();
        if (fields != null) {
            final ArrayList<String> fieldIndexes = new ArrayList<String>();
            int i = 0;
            while (i < fields.length) {
                fieldIndexes.add(fields[i]);
                ++i;
            }
            jsonConfig.setRootClass(object.getClass());
            jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

                public boolean apply(Object source, String name, Object value) {
                    return !fieldIndexes.contains(name);
                }
            });
        }
        return JSONObject.fromObject((Object)object, (JsonConfig)jsonConfig).toString();
    }

    public static String toJSONExclude(Object obj, String ... excludeFields) {
        JsonConfig jsonConfig = new JsonConfig();
        if (excludeFields != null) {
            final List<String> fieldIndexes = Arrays.asList(excludeFields);
            jsonConfig.setRootClass(obj.getClass());
            jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

                public boolean apply(Object source, String name, Object value) {
                    return fieldIndexes.contains(name);
                }
            });
        }
        return JSONObject.fromObject((Object)obj, (JsonConfig)jsonConfig).toString();
    }

    public static String toJSON(Map<String, Object> map) {
        return JSONUtil.toMapJSON(map);
    }

    public static String toMapJSON(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        JSONObject jsonObject = new JSONObject();
        Set<String> keys = map.keySet();
        for (String objKey : keys) {
            try {
                jsonObject.put((Object)objKey, map.get(objKey));
            }
            catch (JSONException e) {
                LOG.error((Object)"Transfer Map to JSon String fail", (Throwable)e);
            }
        }
        return jsonObject.toString();
    }

    @Deprecated
    public static final String toJSON(Object[] objArray) {
        return JSONUtil.toJSONArray(objArray);
    }

    @Deprecated
    public static String toJSON(List<? extends Object> entities) {
        return JSONUtil.toJSONArray(entities);
    }

    public static Object fromJSON(String json, Class objClazz) {
        JSONObject jsonObject;
        JsonConfig jsonConfig;
        block4: {
            if (StringHelper.isEmpty(json)) {
                return null;
            }
            jsonConfig = new JsonConfig();
            jsonConfig.setRootClass(objClazz);
            try {
                jsonObject = JSONObject.fromObject((Object)json, (JsonConfig)jsonConfig);
                if (jsonObject != null && !jsonObject.isEmpty()) break block4;
                return null;
            }
            catch (Exception ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        return JSONObject.toBean((JSONObject)jsonObject, (JsonConfig)jsonConfig);
    }

    public static boolean isJsonFormat(String json, Class objClazz) {
        if (StringHelper.isEmpty(json)) {
            return false;
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objClazz);
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)json, (JsonConfig)jsonConfig);
            return jsonObject != null && !jsonObject.isEmpty();
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public static List<Object> fromJSONArray(String json, Class<?> objClazz) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (StringHelper.isEmpty(json)) {
            return objects;
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objClazz);
        JSONArray jsonArray = JSONArray.fromObject((Object)json, (JsonConfig)jsonConfig);
        if (jsonArray.isEmpty()) {
            return objects;
        }
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            objects.add(JSONObject.toBean((JSONObject)jsonObject, objClazz));
            ++i;
        }
        return objects;
    }

    public static String getValue(String jsonStr, String fieldName) {
        JSONObject jsonObj = JSONObject.fromObject((Object)jsonStr);
        return jsonObj.getString(fieldName);
    }

    public static void assertValidJSON(String jsonStr) {
        try {
            JSONObject.fromObject((Object)jsonStr);
        }
        catch (Exception e) {
            LOG.error((Object)"assertValidJSON error", (Throwable)e);
        }
    }

    public static Object fromJSONNotSensitive(String ss, Class clazz, Map<String, Class<?>> interParamClassMap) {
        JSONObject jsonObject = JSONObject.fromObject((Object)ss);
        JsonConfig config = new JsonConfig();
        config.setJavaIdentifierTransformer(new JavaIdentifierTransformer(){

            public String transformToJavaIdentifier(String str) {
                char[] chars = str.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                return new String(chars);
            }
        });
        config.setRootClass(clazz);
        config.setClassMap(interParamClassMap);
        return JSONObject.toBean((JSONObject)jsonObject, (JsonConfig)config);
    }
}

