/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.Base64Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;

public class CAUtil {
    private static String lineSeparator = System.getProperty("line.separator");
    public static final String PEM_START_LINE = "-----BEGIN CERTIFICATE-----\n";
    public static final String PEM_END_LINE = "\n-----END CERTIFICATE-----";

    public static String getCertsInfo(X509Certificate[] certs) {
        if (certs == null) {
            return "null!";
        }
        int certCount = certs.length;
        StringBuffer sb = new StringBuffer(80 * certCount);
        sb.append('[').append(certCount).append(" certs]");
        int i = 0;
        while (i < certCount) {
            sb.append(lineSeparator).append(CAUtil.getCertInfo(certs[i]));
            ++i;
        }
        return sb.toString();
    }

    public static String getCertInfo(X509Certificate cert) {
        if (cert == null) {
            return "null!";
        }
        StringBuffer sb = new StringBuffer(80);
        sb.append("Issuer:").append(cert.getIssuerDN().getName());
        sb.append(";Subject:").append(cert.getSubjectDN().getName());
        return sb.toString();
    }

    public static String getSubjectName(X509Certificate cert) {
        if (cert == null) {
            return "null!";
        }
        return cert.getSubjectDN().getName();
    }

    public static String getBase64Pem(X509Certificate cert) throws CertificateEncodingException {
        return PEM_START_LINE + CAUtil.getPureBase64Pem(cert) + PEM_END_LINE;
    }

    public static String getPureBase64Pem(X509Certificate cert) throws CertificateEncodingException {
        if (cert == null) {
            return null;
        }
        byte[] bsX509 = null;
        bsX509 = cert.getEncoded();
        return Base64Util.encode(bsX509);
    }

    public static X509Certificate generateCertificate(String b64Pem) throws CertificateException {
        if (b64Pem == null) {
            throw new IllegalArgumentException("the base64 pem is null!");
        }
        return CAUtil.generateCertificate(b64Pem.getBytes());
    }

    public static X509Certificate generateCertificate(byte[] base64Pem) throws CertificateException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(base64Pem);
        return CAUtil.generateCertificate(inStream);
    }

    public static X509Certificate generateCertificate(InputStream inStream) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate xCert = null;
        xCert = cf.generateCertificate(inStream);
        if (xCert instanceof X509Certificate) {
            return (X509Certificate)xCert;
        }
        throw new CertificateException("Not X509! the ertificate is " + xCert);
    }

    public static String parseDNPart(String dn, String key) {
        if (dn == null || key == null) {
            throw new IllegalArgumentException("(dn, key): " + dn + ", " + key + "!");
        }
        StringTokenizer st = new StringTokenizer(dn, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (!s.startsWith(String.valueOf(key) + "=")) continue;
            return s.substring(key.length() + 1);
        }
        return null;
    }

    public static String getValueOfSubjectDN(X509Certificate cert, String key) {
        if (cert == null) {
            return null;
        }
        String dn = cert.getSubjectDN().getName();
        return CAUtil.parseDNPart(dn, key);
    }
}

