/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.protocol.builder.request.impl;

import com.trs.idm.saml.common.SPConfig;
import com.trs.idm.saml.interact.IRequest;
import com.trs.idm.saml.interact.RequestBase;
import com.trs.idm.saml.interact.impl.simple.request.SimpleLocalCheckSSOStatusRequest;
import com.trs.idm.saml.interact.impl.simple.request.SimpleNotifyLoginRequest;
import com.trs.idm.saml.interact.impl.simple.request.SimpleNotifyLogoutRequest;
import com.trs.idm.saml.interact.impl.simple.request.SimpleRedirectCheckSSOStatusRequest;
import com.trs.idm.saml.interact.impl.simple.request.SimpleSSOLogoutHttpPostRequest;
import com.trs.idm.saml.interact.impl.simple.request.SimpleSSOLogoutRedirectRequest;
import com.trs.idm.saml.interact.impl.simple.request.SimpleSelfPageLoginHttpPostRequest;
import com.trs.idm.saml.interact.impl.simple.request.SimpleSelfPageLoginRedirectRequest;
import com.trs.idm.saml.interact.impl.simple.request.SimpleTokenLocalResolveRequest;
import com.trs.idm.saml.interact.impl.simple.request.SimpleTokenRemoteResolveRequest;
import com.trs.idm.saml.protocol.builder.request.IRequestBuilder;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SimpleTokenRequestBuilder
implements IRequestBuilder {
    private static final Logger LOG = Logger.getLogger(SimpleTokenRequestBuilder.class);
    private IServiceProvider sp;
    private String userNameField;
    private String passwordField;

    public SimpleTokenRequestBuilder(IServiceProvider sp) {
        this.sp = sp;
    }

    public IRequest build(HttpServletRequest request) {
        LOG.debug((Object)"about to build IRequest from HttpServletRequest");
        String encry_token = request.getParameter("com.trs.idm.token");
        IRequest tokenRequest = null;
        if (!StringHelper.isEmpty(encry_token)) {
            boolean checkTokenOnIDP = this.sp.getConfig().getConfigAsBool(SPConfig.SSO_SIMPLETOKEN_SERCURITYMODE, true);
            LOG.info((Object)"has token in http request, this is a tokenResolveRequest !");
            LOG.info((Object)("token : " + encry_token + "; checkTokenOnIDP: " + checkTokenOnIDP));
            tokenRequest = checkTokenOnIDP ? this.createRemoteTokenResolveRequest(encry_token) : this.createLocalTokenResolveRequest(encry_token);
            return tokenRequest;
        }
        if (this.isSelLoginActionUri(request)) {
            return this.createSelfPageLoginRequest(this.sp, request);
        }
        String idsCmd = request.getHeader("trs-ids-cmd");
        LOG.debug((Object)("idsCmd is : " + idsCmd));
        if (!StringHelper.isEmpty(idsCmd) && "login".equals(idsCmd)) {
            return new SimpleNotifyLoginRequest(this.sp, request);
        }
        if (!StringHelper.isEmpty(idsCmd) && "logout".equals(idsCmd)) {
            return new SimpleNotifyLogoutRequest(this.sp, request);
        }
        String checkSSOLoginStatus = RequestUtil.getAttributeAsTrimStr(request, "si.simple.check.ssoLogin.flag");
        if (!StringHelper.isEmpty(checkSSOLoginStatus)) {
            if ("si.simple.check.ssoLogin.first".equals(checkSSOLoginStatus)) {
                return this.createSimpleRedirectCheckSSOStatusRequest(this.sp, request);
            }
            if ("si.simple.check.ssoLogin.second".equals(checkSSOLoginStatus)) {
                return this.createSimpleLocalCheckSSOStatusRequest(this.sp, request);
            }
        }
        if ("SimpleSSOLogoutHttpPostRequest".equals(RequestUtil.getAttributeAsTrimStr(request, "request_type"))) {
            return new SimpleSSOLogoutHttpPostRequest(this.sp, request);
        }
        if ("SimpleSSOLogoutRedirectRequest".equals(RequestUtil.getAttributeAsTrimStr(request, "request_type"))) {
            return new SimpleSSOLogoutRedirectRequest(this.sp, request);
        }
        tokenRequest = this.createSimpleLocalCheckSSOStatusRequest(this.sp, request);
        return tokenRequest;
    }

    private boolean isSelLoginActionUri(HttpServletRequest request) {
        String selfLoginPageLoginActionUri = this.sp.getConfig().getConfig("loginAction.uri");
        LOG.info((Object)("login action url of selfLoginPage Action is: " + selfLoginPageLoginActionUri + "; request.getServletPath() is: " + request.getServletPath()));
        if (request.getServletPath().equals(selfLoginPageLoginActionUri)) {
            LOG.info((Object)(String.valueOf(request.getRequestURI()) + " is a selfLoginPageLoginAction, return true"));
            return true;
        }
        return false;
    }

    private IRequest createSelfPageLoginRequest(IServiceProvider sp, HttpServletRequest request) {
        this.userNameField = sp.getConfig().getConfig("sso.selfLoginPage.userName.field", "userName");
        this.passwordField = sp.getConfig().getConfig("sso.selfLoginPage.password.field", "password");
        LOG.info((Object)("userNameField: " + this.userNameField + "; passwordField: " + this.passwordField));
        LOG.info((Object)("this is a http request from selfLoginPage, userName : " + RequestUtil.getParameterAndTrim(request, this.userNameField)));
        String bindingsType = sp.getConfig().getConfig("sp.simple.sso.bindings.type", "httpPost");
        LOG.info((Object)("bindingsType: " + bindingsType));
        RequestBase serviceProviderRequest = null;
        serviceProviderRequest = "httpPost".equals(bindingsType) ? new SimpleSelfPageLoginHttpPostRequest(sp, request) : new SimpleSelfPageLoginRedirectRequest(sp, request);
        LOG.info((Object)("serviceProviderRequest is: " + serviceProviderRequest));
        return serviceProviderRequest;
    }

    private IRequest createSimpleRedirectCheckSSOStatusRequest(IServiceProvider sp, HttpServletRequest request) {
        LOG.info((Object)"create a SimpleRedirectCheckSSOStatusRequest to check SSO status");
        return new SimpleRedirectCheckSSOStatusRequest(sp, request);
    }

    private IRequest createSimpleLocalCheckSSOStatusRequest(IServiceProvider sp, HttpServletRequest request) {
        LOG.info((Object)"create a SimpleLocalCheckSSOStatusRequest to check SSO status");
        return new SimpleLocalCheckSSOStatusRequest(sp, request);
    }

    private IRequest createRemoteTokenResolveRequest(String encry_token) {
        return new SimpleTokenRemoteResolveRequest(this.sp, encry_token);
    }

    private IRequest createLocalTokenResolveRequest(String encry_token) {
        return new SimpleTokenLocalResolveRequest(this.sp, encry_token);
    }
}

