/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.ftp.parser;

import com.trs.net.ftp.FtpFile;
import com.trs.net.ftp.FtpFileListParser;
import com.trs.net.ftp.parser.CustomTokenizer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ListParserDefault
implements FtpFileListParser {
    private final DateFormat m_oYearFormat = new SimpleDateFormat("MMM d yyyy", Locale.US);
    private final DateFormat m_oTimeFormat = new SimpleDateFormat("MMM d HH:mm", Locale.US);

    public FtpFile parse(String line) {
        if (line.length() < 57) {
            return null;
        }
        FtpFile file = new FtpFile();
        file.setRawString(line);
        if (this.parse(file)) {
            return file;
        }
        return null;
    }

    public boolean parse(FtpFile file) {
        String line = file.getRawString();
        if (line == null) {
            return false;
        }
        CustomTokenizer ct = new CustomTokenizer(line, " \t", false);
        if (!ct.hasMoreTokens()) {
            return false;
        }
        String sTypeAndRight = ct.nextToken();
        if (!ct.hasMoreTokens()) {
            return false;
        }
        String sLinkCount = ct.nextToken();
        if (!ct.hasMoreTokens()) {
            return false;
        }
        String sOwnerName = ct.nextToken();
        if (!ct.hasMoreTokens()) {
            return false;
        }
        String sGroupName = ct.nextToken();
        if (!ct.hasMoreTokens()) {
            return false;
        }
        String sFileSize = ct.nextToken();
        if (!ct.hasMoreTokens()) {
            return false;
        }
        String sMonthName = ct.nextToken();
        if (!ct.hasMoreTokens()) {
            return false;
        }
        String sMonthDate = ct.nextToken();
        if (!ct.hasMoreTokens()) {
            return false;
        }
        String sYearOrTime = ct.nextToken();
        if (!ct.hasMoreTokens()) {
            return false;
        }
        String sFileName = line.substring(ct.lastPosition()).trim();
        char cFileType = sTypeAndRight.charAt(0);
        switch (cFileType) {
            case '-': {
                file.setType(1);
                break;
            }
            case 'd': {
                file.setType(0);
                break;
            }
            case 'l': {
                file.setType(2);
                break;
            }
            default: {
                file.setType(-1);
            }
        }
        file.setRight(sTypeAndRight.substring(1));
        int iLinkCount = Integer.parseInt(sLinkCount);
        if (file.isDirectory()) {
            file.setLinkCount(iLinkCount - 2);
        } else {
            file.setLinkCount(iLinkCount);
        }
        file.setOwner(sOwnerName);
        file.setGroup(sGroupName);
        file.setSize(Long.parseLong(sFileSize));
        Date date = null;
        StringBuffer sb = new StringBuffer(12);
        sb.append(sMonthName).append(' ').append(sMonthDate).append(' ').append(sYearOrTime);
        String sDateTime = sb.toString();
        try {
            if (sYearOrTime.indexOf(58) > 0) {
                date = this.m_oTimeFormat.parse(sDateTime);
                Calendar now = Calendar.getInstance();
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(1, now.get(1));
                if (cal.after(now)) {
                    cal.add(1, -1);
                }
                date = cal.getTime();
            } else {
                date = this.m_oYearFormat.parse(sDateTime);
            }
        }
        catch (ParseException e) {
            return false;
        }
        file.setDate(date);
        int iLinkFlag = sFileName.indexOf("->");
        if (iLinkFlag > 0) {
            file.setName(sFileName.substring(0, iLinkFlag).trim());
            file.setLink(sFileName.substring(iLinkFlag + 2).trim());
        } else {
            file.setName(sFileName);
        }
        return true;
    }
}

