/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.TRSParameter;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class TRSPageParameter
extends TRSParameter {
    private static Logger logger = Logger.getLogger(TRSPageParameter.class);
    private String m_sName;
    private String m_sDesc;
    private boolean m_bRequired;
    private String m_sType;
    private String m_sDefault;
    private int m_nMaxLength = -1;
    private int m_nMinLength = -1;
    private String m_sMaxValue;
    private String m_sMinValue;
    private boolean m_bSearch;
    private String m_sSearchOperator;
    private String m_sSearchField;
    private String m_sSearchType;
    private String m_sExcludeValue;
    private String[] pExcludeValue = null;

    public boolean isRequired() {
        return this.m_bRequired;
    }

    public void setRequired(boolean required) {
        this.m_bRequired = required;
    }

    public String getType() {
        if (this.m_sType == null) {
            return "string";
        }
        return this.m_sType;
    }

    public void setType(String _sType) throws CMyException {
        if (!this.isSupportedType(_sType)) {
            throw new CMyException(10, I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label1", "\u7c7b\u578b[") + _sType + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label2", "]\u65e0\u6548!"));
        }
        this.m_sType = _sType.toLowerCase();
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String desc) {
        this.m_sDesc = desc;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public int getMaxLength() {
        return this.m_nMaxLength;
    }

    public void setMaxLength(int maxLength) {
        this.m_nMaxLength = maxLength;
    }

    public int getMinLength() {
        return this.m_nMinLength;
    }

    public void setMinLength(int minLength) {
        this.m_nMinLength = minLength;
    }

    public String getDefault() {
        return this.m_sDefault;
    }

    public int getDefaultAsInt(int _nDefaultValue) {
        if (this.getDefault() == null) {
            return _nDefaultValue;
        }
        try {
            return Integer.parseInt(this.getDefault());
        }
        catch (Exception ex) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label5", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6574\u578b!")), (Throwable)ex);
            return _nDefaultValue;
        }
    }

    public long getDefaultAsLong(long _lDefaultValue) {
        if (this.getDefault() == null) {
            return _lDefaultValue;
        }
        try {
            return Long.parseLong(this.getDefault());
        }
        catch (Exception ex) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label6", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u957f\u6574\u578b!")), (Throwable)ex);
            return _lDefaultValue;
        }
    }

    public float getDefaultAsFloat(float _fDefaultValue) {
        if (this.getDefault() == null) {
            return _fDefaultValue;
        }
        try {
            return Float.parseFloat(this.getDefault());
        }
        catch (Exception ex) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label7", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6d6e\u70b9\u6570!")), (Throwable)ex);
            return _fDefaultValue;
        }
    }

    public boolean getDefaultAsBoolean(boolean _bDefaultValue) {
        if (this.getDefault() == null) {
            return _bDefaultValue;
        }
        if ("true".equals(this.getDefault())) {
            return true;
        }
        if ("false".equals(this.getDefault())) {
            return true;
        }
        try {
            return this.getDefaultAsInt(0) == 1;
        }
        catch (Exception ex) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label8", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u5e03\u5c14\u578b!")), (Throwable)ex);
            return _bDefaultValue;
        }
    }

    public double getDefaultAsDouble(double _dDefaultValue) {
        if (this.getDefault() == null) {
            return _dDefaultValue;
        }
        try {
            return Double.parseDouble(this.getDefault());
        }
        catch (Exception ex) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label9", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u53cc\u7cbe\u5ea6\u6570!")), (Throwable)ex);
            return _dDefaultValue;
        }
    }

    public CMyDateTime getDefaultAsDateTime() throws CMyException {
        if (this.getDefault() == null) {
            return null;
        }
        try {
            CMyDateTime dtTemp = new CMyDateTime();
            dtTemp.setDateTimeWithString(this.getDefault());
            return dtTemp;
        }
        catch (Exception ex) {
            throw new CMyException(2, I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label10", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u65f6\u95f4\u7c7b\u578b!"), ex);
        }
    }

    public void setDefault(String default1) {
        this.m_sDefault = default1;
    }

    public String getMaxValue() {
        return this.m_sMaxValue;
    }

    public void setMaxValue(String maxValue) {
        this.m_sMaxValue = maxValue;
    }

    public String getMinValue() {
        return this.m_sMinValue;
    }

    public void setMinValue(String minValue) {
        this.m_sMinValue = minValue;
    }

    @Override
    protected void validXMLElement(Element _element) throws CMyException {
        String sName = _element.attributeValue("name");
        if (sName == null || (sName = sName.trim()).length() <= 0) {
            throw new CMyException(10, I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label11", "\u53c2\u6570\u6ca1\u6709\u6307\u5b9aName\u5c5e\u6027!"));
        }
        String sDesc = _element.attributeValue("desc");
        if (sDesc == null || (sDesc = sDesc.trim()).length() <= 0) {
            throw new CMyException(10, I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label12", "\u53c2\u6570\u6ca1\u6709\u6307\u5b9aDesc\u5c5e\u6027!"));
        }
    }

    @Override
    public boolean fromXML(Element _element) throws CMyException {
        super.fromXML(_element);
        this.setDefault(this.getPropertyAsString("default"));
        this.setName(this.getPropertyAsString("name"));
        this.setDesc(this.getPropertyAsString("desc"));
        this.setType(this.getPropertyAsString("type"));
        this.setRequired("true".equals(this.getPropertyAsString("required")));
        this.setMaxLength(this.getPropertyAsInt("max-length", -1));
        this.setMinLength(this.getPropertyAsInt("min-length", -1));
        this.setMaxValue(this.getPropertyAsString("max-value"));
        this.setMinValue(this.getPropertyAsString("min-value"));
        this.setSearch("true".equals(this.getPropertyAsString("search")));
        this.setSearchOperator(this.getPropertyAsString("search-operator"));
        this.setSearchField(this.getPropertyAsString("search-field"));
        this.setSearchType(this.getPropertyAsString("search-type"));
        this.setExcludeValue(this.getPropertyAsString("exclude-value"));
        return true;
    }

    public static TRSPageParameter createPageParameterFromXML(Element _elParameter) throws CMyException {
        TRSPageParameter newPageParameter = new TRSPageParameter();
        newPageParameter.fromXML(_elParameter);
        return newPageParameter;
    }

    private boolean isSupportedType(String _sType) {
        for (int i = 0; i < FrameworkConstants.DATA_TYPES_SUPPORTED.length; ++i) {
            if (!FrameworkConstants.DATA_TYPES_SUPPORTED[i].equals(_sType)) continue;
            return true;
        }
        return false;
    }

    public String getSearchExpress(int _nValuesCount) {
        String sExpress = null;
        String sSearchOperator = this.getSearchOperator();
        String sSearchField = this.getSearchField();
        if (sSearchField == null || (sSearchField = sSearchField.trim()).length() == 0) {
            sSearchField = this.getName();
        }
        switch (this.getType().toLowerCase().hashCode()) {
            case -891985903: {
                if (sSearchOperator == null) {
                    sSearchOperator = "like";
                }
                if (_nValuesCount > 1 && sSearchOperator.toLowerCase().indexOf("in") < 0) {
                    StringBuffer sbExpress = new StringBuffer(_nValuesCount * (sSearchField.length() + sSearchOperator.length() + 10));
                    for (int i = 0; i < _nValuesCount; ++i) {
                        sbExpress.append("(" + sSearchField + ' ' + sSearchOperator + " ? )");
                        sbExpress.append(" and ");
                    }
                    sbExpress.setLength(sbExpress.length() - 5);
                    return sbExpress.toString();
                }
                if (_nValuesCount > 1 || sSearchOperator.toLowerCase().indexOf("in") >= 0) {
                    for (int i = 0; i < _nValuesCount; ++i) {
                        sExpress = sExpress == null ? sSearchField + ' ' + sSearchOperator + " (?" : sExpress + ", ?";
                    }
                    sExpress = sExpress + ")";
                    break;
                }
                sExpress = sSearchField + ' ' + sSearchOperator + " ? ";
                break;
            }
            default: {
                if (sSearchOperator == null) {
                    sSearchOperator = "=";
                }
                sExpress = sSearchField + ' ' + sSearchOperator + '?';
            }
        }
        return sExpress;
    }

    public boolean isSearch() {
        return this.m_bSearch;
    }

    public void setSearch(boolean search) {
        this.m_bSearch = search;
    }

    public String getSearchOperator() {
        return this.m_sSearchOperator;
    }

    public void setSearchOperator(String searchOperator) {
        this.m_sSearchOperator = searchOperator;
    }

    public String getSearchField() {
        return this.m_sSearchField;
    }

    public void setSearchField(String searchField) {
        this.m_sSearchField = searchField;
    }

    public String getSearchType() {
        return this.m_sSearchType;
    }

    public void setSearchType(String searchType) {
        this.m_sSearchType = searchType;
    }

    public String getExcludeValue() {
        return this.m_sExcludeValue;
    }

    public boolean isExcludeValue(String _sValue) {
        if (this.pExcludeValue == null) {
            return false;
        }
        for (int i = 0; i < this.pExcludeValue.length; ++i) {
            if (this.pExcludeValue[i] != _sValue) continue;
            return true;
        }
        return false;
    }

    public void setExcludeValue(String excludeValue) {
        this.m_sExcludeValue = excludeValue;
        if (this.m_sExcludeValue != null) {
            this.pExcludeValue = CMyString.split(this.m_sExcludeValue, ",");
        }
    }

    @Override
    protected void validValue() {
    }

    public boolean isSelectFields() {
        return this.m_sName.trim().equalsIgnoreCase("SelectFields");
    }

    public boolean isFromTable() {
        return this.m_sName.trim().equalsIgnoreCase("FromTable");
    }

    public boolean isOrderBy() {
        this.m_sName = this.m_sName.trim();
        return this.m_sName.equalsIgnoreCase("OrderBy") || this.m_sName.equalsIgnoreCase("OrderType");
    }
}

