/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.scm.domain.ISCMMicroContentMgr;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.AccountMicroContent;
import com.trs.scm.persistent.AccountMicroContents;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.persistent.SCMMicroContents;
import com.trs.scm.publish.domain.SCMMCPublishServer;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroContentWrapper;
import com.trs.scm.sdk.model.SCMMicroContentAndFlowDoc;
import com.trs.scm.sdk.model.SCMMicroContentAndFlowDocs;
import com.trs.scm.sdk.util.CMyContentTranslate;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class SCMMicroContentServiceProvider
implements IGlueServiceProvider {
    private ISCMMicroContentMgr m_oSCMMicroContentMgr = (ISCMMicroContentMgr)DreamFactory.createObjectById("ISCMMicroContentMgr");
    private SCMMCPublishServer m_publishserver = SCMMCPublishServer.getInstance();

    @Override
    public void delete(MethodContext _oMethodContext) throws Throwable {
        String sObjectIds = _oMethodContext.getObjectIds();
        SCMMicroContents oSCMMicroContents = SCMMicroContents.findByIds(this.getLoginUser(), sObjectIds);
        int nSize = oSCMMicroContents.size();
        for (int i = 0; i < nSize; ++i) {
            SCMMicroContent oSCMMicroContent = (SCMMicroContent)oSCMMicroContents.getAt(i);
            if (oSCMMicroContent == null) continue;
            this.m_oSCMMicroContentMgr.delete(oSCMMicroContent);
        }
    }

    public int queryFirstYear(MethodContext _oContext) throws Throwable {
        int nFirstYear = 2012;
        SCMMicroContent oSCMMicroContent = this.m_oSCMMicroContentMgr.getTopOne();
        if (oSCMMicroContent != null) {
            nFirstYear = oSCMMicroContent.getCrTime().getYear();
        }
        return nFirstYear;
    }

    @Override
    public Object query(MethodContext _oContext) throws Throwable {
        int nSCMGroupId = _oContext.getValue("SCMGroupId", 0);
        SCMGroup oCurrSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oCurrSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u672a\u627e\u5230\uff01\u5206\u7ec4ID[" + nSCMGroupId + "]");
        }
        if (!SCMAuthServer.hasRight(this.getLoginUser(), oCurrSCMGroup, 5)) {
            throw new WCMException("\u7528\u6237\u5bf9\u5f53\u524d\u6307\u5b9a\u7684\u5206\u7ec4\u6ca1\u6709\u67e5\u770b\u6743\u9650\uff01User[" + this.getLoginUser().getName() + "]& SCMGroupId[" + nSCMGroupId + "]");
        }
        WCMFilter oFilter = new WCMFilter("", "SCMGROUPID = ?", "");
        oFilter.addSearchValues(nSCMGroupId);
        oFilter.mergeWith(_oContext.getExtraWCMFilter());
        return this.m_oSCMMicroContentMgr.querySCMMicroContents(oFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int save(MethodContext _oContext) throws Throwable {
        int nSCMMicroContentId = _oContext.getValue("ObjectId", 0);
        User oCurrUser = this.getLoginUser();
        SCMMicroContent oSCMMicroContent = SCMMicroContent.createNewInstance();
        Accounts oAccounts = null;
        if (nSCMMicroContentId != 0) {
            oSCMMicroContent = SCMMicroContent.findById(nSCMMicroContentId);
            oSCMMicroContent.validCanEditAndLock(oCurrUser);
            oAccounts = Accounts.findByIds(this.getLoginUser(), oSCMMicroContent.getPropertyAsString("PUBLISHACCOUNTIDS"));
        } else {
            String sAccountIds = _oContext.getValue("AccountIds");
            oAccounts = Accounts.findByIds(this.getLoginUser(), sAccountIds);
            String sContent = _oContext.getValue("Content");
            String sTempContent = CMyContentTranslate.microContentUrlShortLength(sContent);
            if (sTempContent.length() > 280) {
                throw new WCMException("\u8f93\u5165\u7684\u5fae\u535a\u5185\u5bb9\u957f\u5ea6\u8fc7\u957f\uff01\u6700\u957f140\u4e2a\u5b57\uff01");
            }
            if (CMyString.isEmpty(sTempContent)) {
                throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535a\u5185\u5bb9\u4e3a\u7a7a\uff01");
            }
            String sSource = _oContext.getValue("Source");
            if (CMyString.isEmpty(sSource)) {
                sSource = "SCM";
                _oContext.setValue("SOURCE", sSource);
            }
            _oContext.setValue("PUBLISHACCOUNTIDS", sAccountIds);
            _oContext.setValue("FlowStatus", 30);
            try {
                String[] pLogicFields = new String[]{"ObjectId", "AccountIds"};
                oSCMMicroContent = (SCMMicroContent)WCMAJAXServiceHelper.setWCMObjectProperties(oCurrUser, _oContext, oSCMMicroContent, pLogicFields);
                oSCMMicroContent.setCrUser(oCurrUser);
                oSCMMicroContent = this.m_oSCMMicroContentMgr.save(oSCMMicroContent, oAccounts, _oContext.getParams());
            }
            finally {
                if (oSCMMicroContent.isLocked()) {
                    try {
                        oSCMMicroContent.unlock();
                    }
                    catch (Exception e) {
                        throw new WCMException("\u89e3\u9664\u5fae\u535a\u9501\u65f6\u5931\u8d25");
                    }
                }
            }
        }
        int nSize = oAccounts.size();
        for (int i = 0; i < nSize; ++i) {
            Account oAccount = (Account)oAccounts.getAt(i);
            if (oAccount == null || SCMAuthServer.hasRight(oCurrUser, oAccount, 44)) continue;
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u6307\u5b9a\u7684\u8d26\u53f7\u53d1\u5e03\u5fae\u535a\u3002[Account=" + oAccount.getAccountName() + "]");
        }
        String sWorkFlowIds = ConfigServer.getServer().getSysConfigValue("WORKFLOWS_FOR_SCM", "");
        IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent flowContent = FlowContentFactory.makeFlowContent(oSCMMicroContent);
        if (!CMyString.isEmpty(sWorkFlowIds) && flowContent.getOwnerFlow() != null) {
            FlowContext flowContext = new FlowContext(oCurrUser, flowContent);
            this.checkToUsers(flowContext);
            flowContext.setPostDesc("\u63d0\u4ea4\u5ba1\u6838\u3002");
            flowServer.submitTo(flowContext);
            oSCMMicroContent.setStatus(0);
            oSCMMicroContent.save(oCurrUser);
        }
        long lScheduleTime = 0L;
        long lNowTimeNum = new Date().getTime();
        String sCheduleTime = _oContext.getValue("ScheduleTime");
        if (!CMyString.isEmpty(sCheduleTime)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date dt = dateFormat.parse(sCheduleTime);
            lScheduleTime = dt.getTime();
        }
        if (lScheduleTime == 0L || lNowTimeNum > lScheduleTime) {
            this.m_publishserver.publish(oAccounts, oSCMMicroContent, null);
        } else {
            HashMap<String, CMyDateTime> oScheduleTime = null;
            oScheduleTime = new HashMap<String, CMyDateTime>();
            oScheduleTime.put("ScheduleTime", new CMyDateTime(lScheduleTime));
            this.m_publishserver.publish(oAccounts, oSCMMicroContent, oScheduleTime);
        }
        return oSCMMicroContent.getId();
    }

    public boolean repost(MethodContext _oContext) throws Throwable {
        int nSCMMicroContentId = _oContext.getValue("SCMMicroContentId", 0);
        int nAccountId = _oContext.getValue("AccountId", 0);
        User oCurrUser = this.getLoginUser();
        Account oAccount = Account.findById(nAccountId);
        Accounts oAccounts = Accounts.createNewInstance(oCurrUser);
        oAccounts.addElement(oAccount);
        if (!SCMAuthServer.hasRight(oCurrUser, oAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        SCMMicroContent oSCMMicrocontent = SCMMicroContent.findById(nSCMMicroContentId);
        if (oSCMMicrocontent == null) {
            throw new WCMException("\u5fae\u535a\u4e0d\u5b58\u5728\uff01[ID=" + nSCMMicroContentId + "]");
        }
        if (oAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        this.m_publishserver.publish(oAccounts, oSCMMicrocontent, null);
        return true;
    }

    @Override
    public Object findById(MethodContext _oContext) throws Throwable {
        int nSCMMicroContentId = _oContext.getValue("ObjectId", 0);
        SCMMicroContent oSCMMicroContent = SCMMicroContent.findById(nSCMMicroContentId);
        if (oSCMMicroContent == null) {
            throw new WCMException("\u5fae\u535a\u4e0d\u5b58\u5728\uff01[ID=" + nSCMMicroContentId + "]");
        }
        return oSCMMicroContent;
    }

    public Object findByMicroContentId(MethodContext _oContext) throws Exception {
        int nAccountID = _oContext.getValue("AccountId", 0);
        Account oCurrAccount = Account.findById(nAccountID);
        if (oCurrAccount == null) {
            throw new NullPointerException("\u83b7\u53d6\u5230\u7684Account\u4e3a\u7a7a\uff01AccountId\uff1a" + nAccountID);
        }
        String sMicroContentId = _oContext.getValue("MicroContentId");
        MicroContent oMicroResult = this.m_oSCMMicroContentMgr.findById(oCurrAccount, sMicroContentId);
        return oMicroResult;
    }

    @Override
    public Object findByIds(MethodContext _oContext) throws Throwable {
        String sMicroContentIds = _oContext.getValue("ObjectIds");
        User oCurrUser = this.getLoginUser();
        if (CMyString.isEmpty(sMicroContentIds)) {
            throw new WCMException("\u5fae\u535aID\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff01");
        }
        return SCMMicroContents.findByIds(oCurrUser, sMicroContentIds);
    }

    public Accounts findPostedAccounts(MethodContext _oContext) throws Throwable {
        int nSCMMicroContentId = _oContext.getValue("SCMMicroContentId", 0);
        SCMMicroContent oSCMMicroContent = SCMMicroContent.findById(nSCMMicroContentId);
        if (oSCMMicroContent == null) {
            throw new WCMException("\u5fae\u535a\u4e0d\u5b58\u5728\uff01[ID=" + nSCMMicroContentId + "]");
        }
        return this.m_oSCMMicroContentMgr.findPostedAccounts(oSCMMicroContent);
    }

    public HashMap<Integer, MicroContent> findPostedMicroContents(MethodContext _oContext) throws Throwable {
        Accounts oPostedAccounts = this.findPostedAccounts(_oContext);
        HashMap<Integer, MicroContent> oResult = new HashMap<Integer, MicroContent>();
        int nSCMMicroContentId = _oContext.getValue("SCMMicroContentId", 0);
        for (int i = 0; i < oPostedAccounts.size(); ++i) {
            Account oCurrAccount = (Account)oPostedAccounts.getAt(i);
            if (oCurrAccount == null) continue;
            int nCurrAccountId = oCurrAccount.getId();
            WCMFilter oFilter = new WCMFilter("", "ACCOUNTID = ? AND SCMMicroContentID = ?", "", "MicroContentID");
            oFilter.addSearchValues(nCurrAccountId);
            oFilter.addSearchValues(nSCMMicroContentId);
            AccountMicroContents oCurrAccountMicroContents = AccountMicroContents.openWCMObjs(ContextHelper.getLoginUser(), oFilter);
            AccountMicroContent oCurrAccountMicroContent = (AccountMicroContent)oCurrAccountMicroContents.getAt(0);
            if (oCurrAccountMicroContent == null) continue;
            String sMicroContentId = oCurrAccountMicroContent.getMicroContentId();
            MicroContent oCurrResult = null;
            oCurrResult = this.m_oSCMMicroContentMgr.findById(oCurrAccount, sMicroContentId);
            if (oCurrResult == null) continue;
            oResult.put(nCurrAccountId, oCurrResult);
        }
        return oResult;
    }

    public boolean destroyMicroContent(MethodContext oContext) throws Throwable {
        String sMicroContentId = oContext.getValue("MicroContentId");
        int nAccountId = oContext.getValue("AccountId", 0);
        Account oAccount = Account.findById(nAccountId);
        if (oAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[" + nAccountId + "]");
        }
        User oCurrUser = this.getLoginUser();
        if (!SCMAuthServer.hasRight(oCurrUser, oAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u65e0\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        this.m_oSCMMicroContentMgr.delete(oAccount, sMicroContentId);
        return true;
    }

    public boolean forwardMicroContent(MethodContext _oContext) throws Throwable {
        String sAccountIds = _oContext.getValue("AccountIds");
        String sContent = _oContext.getValue("Content");
        if (sContent.length() > 280) {
            throw new WCMException("\u8f93\u5165\u7684\u5fae\u535a\u5185\u5bb9\u957f\u5ea6\u8fc7\u957f\uff01\u6700\u957f140\u4e2a\u5b57\uff01");
        }
        if (CMyString.isEmpty(sContent)) {
            sContent = "\u8f6c\u53d1\u5fae\u535a";
        }
        User oCurrUser = this.getLoginUser();
        String sErrorMsg = "";
        Accounts oAccounts = Accounts.findByIds(oCurrUser, sAccountIds);
        sAccountIds = "";
        int nSize = oAccounts.size();
        for (int j = 0; j < nSize; ++j) {
            Account oAccount = (Account)oAccounts.getAt(j);
            if (oAccount == null) continue;
            boolean hasRight = false;
            try {
                hasRight = SCMAuthServer.hasRight(oCurrUser, oAccount, 44);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hasRight) {
                oAccounts.remove(oAccount, false);
                sErrorMsg = sErrorMsg + oAccount.getAccountName() + ",";
                continue;
            }
            sAccountIds = sAccountIds + oAccount.getId() + ",";
        }
        String sMicroContentId = _oContext.getValue("MicroContentId");
        int nSCMGroupId = _oContext.getValue("SCMGroupId", 1);
        SCMMicroContent oSCMMicroContent = SCMMicroContent.createNewInstance();
        oSCMMicroContent.setContent(sContent);
        oSCMMicroContent.setIsRetweeted(true);
        oSCMMicroContent.setRetweetedID(sMicroContentId);
        oSCMMicroContent.setGroupId(nSCMGroupId);
        String sSource = _oContext.getValue("source");
        if (CMyString.isEmpty(sSource)) {
            sSource = "SCM";
        }
        oSCMMicroContent.setSource(sSource);
        oSCMMicroContent.setPublishAccountIds(sAccountIds.substring(0, sAccountIds.length() - 1));
        oSCMMicroContent.setStatus(30);
        oSCMMicroContent.save(oCurrUser);
        String sWorkFlowIds = ConfigServer.getServer().getSysConfigValue("WORKFLOWS_FOR_SCM", "");
        IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent flowContent = FlowContentFactory.makeFlowContent(oSCMMicroContent);
        if (!CMyString.isEmpty(sWorkFlowIds) && flowContent.getOwnerFlow() != null) {
            FlowContext flowContext = new FlowContext(oCurrUser, flowContent);
            this.checkToUsers(flowContext);
            flowContext.setPostDesc("\u63d0\u4ea4\u5ba1\u6838\uff01");
            flowServer.submitTo(flowContext);
            oSCMMicroContent.setStatus(0);
            oSCMMicroContent.save(oCurrUser);
        }
        long lScheduleTime = 0L;
        long lNowTimeNum = new Date().getTime();
        String sCheduleTime = _oContext.getValue("ScheduleTime");
        if (!CMyString.isEmpty(sCheduleTime)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date dt = dateFormat.parse(sCheduleTime);
            lScheduleTime = dt.getTime();
        }
        if (lScheduleTime == 0L || lNowTimeNum > lScheduleTime) {
            this.m_publishserver.publish(oAccounts, oSCMMicroContent, null);
        } else {
            HashMap<String, CMyDateTime> oScheduleTime = null;
            oScheduleTime = new HashMap<String, CMyDateTime>();
            oScheduleTime.put("ScheduleTime", new CMyDateTime(lScheduleTime));
            this.m_publishserver.publish(oAccounts, oSCMMicroContent, oScheduleTime);
        }
        String sRetweetMCs = "";
        for (int i = 0; i < oAccounts.size(); ++i) {
            try {
                this.m_oSCMMicroContentMgr.saveRetweededMC((Account)oAccounts.getAt(i), oSCMMicroContent.getId(), sMicroContentId, null);
                continue;
            }
            catch (Exception e) {
                sRetweetMCs = sRetweetMCs + ((Account)oAccounts.getAt(i)).getAccountName() + "\uff1a\u4fdd\u5b58\u8f6c\u53d1\u5fae\u535a\u5185\u5bb9\u5f02\u5e38\uff01\n";
            }
        }
        if (!CMyString.isEmpty(sErrorMsg)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u6307\u5b9a\u7684\u8d26\u53f7\u53d1\u5e03\u5fae\u535a\u3002[Account=" + sErrorMsg.substring(0, sErrorMsg.length()) + "]");
        }
        return true;
    }

    private void checkToUsers(FlowContext _oFlowContext) throws WCMException {
        Users oOperusers = _oFlowContext.getNextNode().getOperUsers(null, true);
        if (oOperusers == null || oOperusers.size() == 0) {
            throw new WCMException("\u5de5\u4f5c\u6d41\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\u4e0a\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\u5458\uff01\u8bf7\u60a8\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3\u540e\u65b9\u53ef\u63d0\u4ea4\u5fae\u535a\u5ba1\u6838\uff01");
        }
    }

    public MicroContentWrapper queryUserTimeline(MethodContext _oContext) throws Throwable {
        int nAccountId = _oContext.getValue("AccountId", 0);
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        Account oUserAccount = Account.findById(nAccountId);
        if (oUserAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        User oCurrUser = this.getLoginUser();
        if (!SCMAuthServer.hasRight(oCurrUser, oUserAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u65e0\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        return this.m_oSCMMicroContentMgr.queryUserTimeline(oUserAccount, nPageIndex, nPageSize, _oContext.getParams());
    }

    public MicroContentWrapper queryUserTimelineByType(MethodContext _oContext) throws Throwable {
        int nAccountId = _oContext.getValue("AccountId", 0);
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        int nType = _oContext.getValue("Type", 0);
        Account oUserAccount = Account.findById(nAccountId);
        if (oUserAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        User oCurrUser = this.getLoginUser();
        if (!SCMAuthServer.hasRight(oCurrUser, oUserAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u65e0\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        return this.m_oSCMMicroContentMgr.queryUserTimelineByType(oUserAccount, nType, nPageIndex, nPageSize, _oContext.getParams());
    }

    public MicroContentWrapper queryHomeTimeline(MethodContext _oContext) throws Throwable {
        int nAccountId = _oContext.getValue("AccountId", 0);
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        Account oHomeAccount = Account.findById(nAccountId);
        if (oHomeAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        User oCurrUser = this.getLoginUser();
        if (!SCMAuthServer.hasRight(oCurrUser, oHomeAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u65e0\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        return this.m_oSCMMicroContentMgr.queryHomeTimeline(oHomeAccount, nPageIndex, nPageSize, _oContext.getParams());
    }

    public MicroContentWrapper queryMentions(MethodContext _oContext) throws Throwable {
        int nAccountId = _oContext.getValue("AccountId", 0);
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        Account oAccount = Account.findById(nAccountId);
        if (oAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        User oCurrUser = this.getLoginUser();
        if (!SCMAuthServer.hasRight(oCurrUser, oAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u65e0\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        return this.m_oSCMMicroContentMgr.queryMentions(oAccount, nPageIndex, nPageSize, _oContext.getParams());
    }

    public void setDocumentPublishFieldsForWCM(MethodContext _oContext) throws WCMException {
        String sSiteIds = _oContext.getValue("SiteIds");
        if (sSiteIds.length() == 0) {
            throw new NullPointerException("\u6307\u5b9a\u7684\u7ad9\u70b9ID\u4e3a\u7a7a\uff01");
        }
        String sDocumentFields = _oContext.getValue("DocumentFields");
        if (sSiteIds.length() == 0 || sDocumentFields.length() == 0) {
            throw new NullPointerException("\u6307\u5b9a\u7684\u6587\u6863\u5b57\u6bb5\u4e3a\u7a7a\uff01");
        }
        String[] pSiteId = sSiteIds.split(",");
        for (int i = 0; i < pSiteId.length; ++i) {
            int nSiteId = Integer.valueOf(pSiteId[i]);
            Channel oCurrChannel = Channel.findById(nSiteId);
            if (oCurrChannel == null || !oCurrChannel.canEdit(this.getLoginUser())) continue;
            try {
                oCurrChannel.validCanEditAndLock(this.getLoginUser());
                oCurrChannel.setPropertyWithString("SCMPublishFields", sDocumentFields);
                oCurrChannel.save();
                continue;
            }
            catch (WCMException e) {
                e.printStackTrace();
                oCurrChannel.unlock();
            }
        }
    }

    public SCMMicroContentAndFlowDocs queryMCAndFlow(MethodContext _oContext) throws Throwable {
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        int nSCMGroupId = _oContext.getValue("SCMGroupId", 0);
        SCMGroup oCurrSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oCurrSCMGroup == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5206\u7ec4\u672a\u627e\u5230\uff01\u5206\u7ec4ID[" + nSCMGroupId + "]");
        }
        if (!SCMAuthServer.hasRight(this.getLoginUser(), oCurrSCMGroup, 5)) {
            throw new WCMException("\u7528\u6237\u5bf9\u5f53\u524d\u6307\u5b9a\u7684\u5206\u7ec4\u6ca1\u6709\u67e5\u770b\u6743\u9650\uff01User[" + this.getLoginUser().getName() + "]& SCMGroupId[" + nSCMGroupId + "]");
        }
        WCMFilter oFilter = new WCMFilter("", "SCMGROUPID = ?", "");
        oFilter.addSearchValues(nSCMGroupId);
        oFilter.mergeWith(_oContext.getExtraWCMFilter());
        SCMMicroContents sSCMMCs = this.m_oSCMMicroContentMgr.querySCMMicroContents(oFilter);
        int nTotalNum = sSCMMCs.size();
        int nPageCount = nTotalNum % nPageSize == 0 ? nTotalNum / nPageSize : nTotalNum / nPageSize + 1;
        CPager currPager = new CPager(nPageSize);
        currPager.setCurrentPageIndex(nPageIndex);
        currPager.setItemCount(nTotalNum);
        SCMMicroContentAndFlowDocs oSCMMicroContentAndFlowDocs = new SCMMicroContentAndFlowDocs();
        for (int i = currPager.getFirstItemIndex() - 1; i < currPager.getLastItemIndex(); ++i) {
            SCMMicroContent tsc = (SCMMicroContent)sSCMMCs.getAt(i);
            if (tsc == null) continue;
            SCMMicroContentAndFlowDoc oSCMMicroContentAndFlowDoc = new SCMMicroContentAndFlowDoc();
            oSCMMicroContentAndFlowDoc.setoSCMMicroContent(tsc);
            FlowDocs oFlowDocs = SCMMicroContent.getFlowDocs(tsc.getId(), this.getLoginUser());
            oSCMMicroContentAndFlowDoc.setoFlowDocs(oFlowDocs);
            oSCMMicroContentAndFlowDocs.addMicroContentAndFlowDoc(oSCMMicroContentAndFlowDoc);
        }
        return oSCMMicroContentAndFlowDocs;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

