/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mobile;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.components.wcm.util.INameGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.TableInfo;
import com.trs.mobile.MyDBManager;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.webframework.controler.JSPRequestProcessor;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class MobileCreator {
    private static Logger logger = Logger.getLogger(MobileCreator.class);
    private static String m_sRootDomain = "";
    private static MobileCreator m_oInstance;
    private static boolean BPROCESSING;
    public static int DOCUMENT_CREATE_NUM;
    private MyDBManager m_oMyDBMgr;
    private boolean m_bWJBhd = false;
    private static String m_sMessage;
    public static String m_sTemplateFile;
    private static Templates m_oTemplats;
    public static String[] m_sSiteOutlineTemplateNames;
    public static String[] m_sChnlOutlineTemplateNames;
    public static String[] m_sPushMsgOutlineTemplateNames;
    public static String m_sDetailTemplateNames;
    public static String m_sSystemConfigTemplateName;
    public static String m_sChannel4SpecilTemplateName;
    private static String m_sCoverChnlId;
    private static String m_sSubscribechannels;
    private static int m_nMaxSubscribechannels;
    private static String m_sRegularchannels;
    private static int m_nMsgChnlId;
    private int[] m_nStatusOfCanPub = new int[]{1, 2, 10, 16, 15, 18, 1027, 21, 22};
    private TemplateMgr m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
    private TemplateEmployMgr m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    private AppendixMgr m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");

    private MobileCreator() {
    }

    public static synchronized MobileCreator getInstance() {
        if (m_oInstance == null) {
            m_oInstance = new MobileCreator();
        }
        return m_oInstance;
    }

    public void setRequest(HttpServletRequest _oRequest) {
        m_sRootDomain = this.makeRootDomain(_oRequest);
    }

    public void setDBMgr(MyDBManager _oMyDBMgr) {
        this.m_oMyDBMgr = _oMyDBMgr;
    }

    public String getCurrMessage() {
        return m_sMessage;
    }

    public boolean isProcessing() {
        return BPROCESSING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMobileSite(final int _nSrcSiteId, final String _sTemplateType) throws Exception {
        User loginUser;
        if (!PluginConfig.isStartMobilePortal()) {
            // empty if block
        }
        if (!(loginUser = this.getLoginUser()).isAdministrator()) {
            throw new WCMException("\u60a8\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u79fb\u52a8\u95e8\u6237\u7ad9\u70b9\uff01");
        }
        if (BPROCESSING) {
            return;
        }
        m_oTemplats = null;
        m_sCoverChnlId = "";
        m_sSubscribechannels = "";
        m_sRegularchannels = "";
        m_nMsgChnlId = 0;
        MobileCreator mobileCreator = this;
        synchronized (mobileCreator) {
            if (BPROCESSING) {
                return;
            }
            Thread t = new Thread(){

                @Override
                public void run() {
                    ContextHelper.initContext(loginUser);
                    BPROCESSING = true;
                    try {
                        WebSite oNewSite = MobileCreator.this.createMobileSiteOnly(_nSrcSiteId);
                        MobileCreator.this.createMobileSiteFolderPublishConfig(oNewSite, _nSrcSiteId);
                        MobileCreator.this.createMobileChannels(_nSrcSiteId, 0, oNewSite.getId(), 0);
                        MobileCreator.this.createMsgChannel(oNewSite.getId());
                        MobileCreator.this.importTemplate(oNewSite.getId(), _sTemplateType);
                        MobileCreator.this.configSiteTemplate(oNewSite.getId());
                        MobileCreator.this.verifyChnlListTypes(oNewSite);
                        MobileCreator.this.configMsgChnlTemplate(oNewSite.getId());
                        MobileCreator.this.verifySystemConfigTemplate(oNewSite.getId());
                        MobileCreator.this.verifyChannels4SpecialTemplate(oNewSite.getId());
                        MobileCreator.this.fullPublishSite(oNewSite.getId());
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u521b\u5efa\u79fb\u52a8\u95e8\u6237\u7ad9\u70b9\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    }
                    finally {
                        BPROCESSING = false;
                        m_sMessage = "-1";
                        m_sRootDomain = "";
                        MobileCreator.this.m_oMyDBMgr = null;
                    }
                }
            };
            t.start();
        }
    }

    private WebSite createMobileSiteOnly(int _nSrcSiteId) throws Exception {
        WebSite oNewSite;
        block17: {
            User loginUser = ContextHelper.getLoginUser();
            oNewSite = WebSite.createNewInstance();
            String SQL_QUERY_SITE = "select * from WCMWebSite where SiteId=?";
            Connection oConn = null;
            PreparedStatement oPreStmt = null;
            ResultSet result = null;
            try {
                oConn = this.m_oMyDBMgr.getConnection();
                oPreStmt = oConn.prepareStatement("select * from WCMWebSite where SiteId=?");
                oPreStmt.setInt(1, _nSrcSiteId);
                result = oPreStmt.executeQuery();
                if (result.next()) {
                    oNewSite.setDesc(result.getString("SiteDesc") + "_\u624b\u673a");
                    oNewSite.setParent(0);
                    oNewSite.setType(result.getInt("SiteType"));
                    oNewSite.setMobile(true);
                    INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
                    String sSiteName = m_oNameGenerator.generate(oNewSite, "SiteName", result.getString("SiteName") + "_\u624b\u673a");
                    oNewSite.setName(sSiteName);
                    oNewSite.save(loginUser);
                    int nNewSiteId = oNewSite.getId();
                    String SQL_INSERT_RELATION = "insert into XWCMWEBSITEMAPPING(SrcSiteId, NewSiteId) values(" + _nSrcSiteId + ", " + nNewSiteId + ")";
                    DBManager.getDBManager().sqlExecuteUpdate(SQL_INSERT_RELATION);
                    break block17;
                }
                throw new Exception("\u6307\u5b9a\u7ad9\u70b9[SiteId=" + _nSrcSiteId + "]\u4e0d\u5b58\u5728!");
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to query data!", ex);
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to close result", (Throwable)e);
                    }
                }
                if (oPreStmt != null) {
                    try {
                        oPreStmt.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                    }
                }
                if (oConn != null) {
                    this.m_oMyDBMgr.freeConnection(oConn);
                }
            }
        }
        return oNewSite;
    }

    private String makeRootDomain(HttpServletRequest _oRequest) {
        if (_oRequest == null) {
            return "http://not.set/";
        }
        String sRootDomain = _oRequest.getScheme() + "://" + _oRequest.getServerName();
        int nPort = _oRequest.getServerPort();
        if (nPort != -1) {
            sRootDomain = sRootDomain + ":" + nPort;
        }
        sRootDomain = sRootDomain + "/pub/";
        return sRootDomain;
    }

    private void createMobileSiteFolderPublishConfig(WebSite oNewSite, int _nSrcSiteId) throws WCMException {
        int nNewSiteId = oNewSite.getId();
        String sDataPath = "m" + nNewSiteId;
        String sRootDomain = m_sRootDomain;
        INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        FolderPublishConfig pubConfig = FolderPublishConfig.createNewInstance();
        WCMFilter filter = new WCMFilter("", "FolderType=?", "");
        filter.addSearchValues(103);
        sDataPath = m_oNameGenerator.generate(pubConfig, "DataPath", sDataPath, filter);
        JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
        HashMap<String, Object> serviceMap = new HashMap<String, Object>();
        String sServiceId = "wcm6_publish";
        String sMethodName = "saveSitePublishConfig";
        serviceMap.put("OBJECTID", nNewSiteId);
        serviceMap.put("SITETYPE", oNewSite.getType());
        serviceMap.put("DATAPATH", sDataPath);
        serviceMap.put("SITELANGUAGE", "8");
        serviceMap.put("PAGEENCODING", "utf-8");
        serviceMap.put("ROOTDOMAIN", sRootDomain + sDataPath);
        serviceMap.put("STATUSESCANDOPUB", CMyString.join(this.m_nStatusOfCanPub, ","));
        serviceMap.put("STATUSIDAFTERMODIFY", "1");
        try {
            processor.excute(sServiceId, sMethodName, serviceMap);
        }
        catch (WCMException e) {
            throw new WCMException("\u521b\u5efa\u7ad9\u70b9\u53d1\u5e03\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
    }

    private void importTemplate(int _nSiteId, String _sTemplateType) throws CMyException {
        String sTemplateDataPath;
        String sTempPath;
        m_sMessage = "\u6b63\u5728\u5bfc\u5165\u7ad9\u70b9\u6a21\u677f";
        String sMobileDataPath = this.getMobileDataPath();
        String sTemplateFileName = m_sTemplateFile + ".zip";
        String sTemplateDataFileBak = m_sTemplateFile + "_bak.zip";
        if (!CMyString.isEmpty(_sTemplateType) && CMyFile.fileExists(sMobileDataPath + m_sTemplateFile + _sTemplateType + ".zip")) {
            sTemplateFileName = m_sTemplateFile + _sTemplateType + ".zip";
            sTemplateDataFileBak = m_sTemplateFile + _sTemplateType + "_bak.zip";
        }
        if (!CMyFile.fileExists(sTempPath = (sTemplateDataPath = sMobileDataPath + sTemplateFileName) + "datatemp")) {
            CMyFile.makeDir(sTempPath, true);
        }
        sTemplateDataFileBak = sTempPath + File.separator + sTemplateDataFileBak;
        try {
            if (!CMyFile.fileExists(sTemplateDataPath)) {
                throw new WCMException("\u79fb\u52a8\u95e8\u6237\u7684\u6a21\u677f\u6587\u4ef6\u5305\u4e0d\u5b58\u5728\uff01\u3010" + sTemplateDataPath + "\u3011");
            }
            CMyFile.copyFile(sTemplateDataPath, sTemplateDataFileBak);
            JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
            HashMap<String, Object> serviceMap = new HashMap<String, Object>();
            String sServiceId = "wcm6_template";
            String sMethodName = "importTemplates";
            serviceMap.put("IMPORTFILE", sTemplateDataFileBak);
            serviceMap.put("SRCFILENAME", "TEMPLATE--MOBILEPORTAL.zip");
            serviceMap.put("IMPORTMODE", 1);
            serviceMap.put("PICMODE", 1);
            serviceMap.put("HOSTID", _nSiteId);
            serviceMap.put("HOSTTYPE", 103);
            serviceMap.put("FILEENCODE", "utf-8");
            processor.excute(sServiceId, sMethodName, serviceMap);
        }
        catch (WCMException e) {
            throw new WCMException("\u5bfc\u5165\u6a21\u677f\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
        finally {
            CMyFile.deleteDir(sTempPath);
            if (m_oTemplats != null) {
                m_oTemplats.clear();
            }
        }
    }

    private void configSiteTemplate(int nSiteId) throws WCMException {
        m_sMessage = "\u6b63\u5728\u914d\u7f6e\u7ad9\u70b9\u6a21\u677f";
        String sOutlineTemplateIds = this.getSiteOutLineTemplatesIds(nSiteId);
        IPublishElement publishElement = PublishElementFactory.lookupElement(103, nSiteId);
        this.m_oEmployMgr.setOutlineTemplates((IPublishFolder)publishElement, sOutlineTemplateIds, false);
    }

    private String getSiteOutLineTemplatesIds(int _siteId) throws WCMException {
        String sTemplateName;
        Template template;
        int i;
        Templates templates = this.getSiteAllTemplates(_siteId);
        StringBuffer outlineTemplateIds = new StringBuffer();
        for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            if (!m_sSiteOutlineTemplateNames[0].equals(sTemplateName)) continue;
            outlineTemplateIds.append(template.getId());
        }
        block1: for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            for (int k = 1; k < m_sSiteOutlineTemplateNames.length; ++k) {
                if (!m_sSiteOutlineTemplateNames[k].equals(sTemplateName)) continue;
                if (CMyString.isEmpty(outlineTemplateIds.toString())) {
                    outlineTemplateIds.append(template.getId());
                    continue block1;
                }
                outlineTemplateIds.append("," + template.getId());
                continue block1;
            }
        }
        return outlineTemplateIds.toString();
    }

    private Templates getSiteAllTemplates(int _nSiteId) throws WCMException {
        if (m_oTemplats != null) {
            return m_oTemplats;
        }
        IPublishFolder publishFolder = (IPublishFolder)PublishElementFactory.lookupElement(103, _nSiteId);
        TemplateMgr m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        m_oTemplats = m_oTemplateMgr.getManagedTemplates(publishFolder, -1, null, true);
        return m_oTemplats;
    }

    private String getMobileDataPath() throws WCMException {
        String sAppDir = ConfigServer.getServer().getInitProperty("WCM_PATH");
        if ("\\".equals(File.separator)) {
            sAppDir = CMyString.replaceStr(sAppDir, "/", File.separator);
        }
        if ((sAppDir = CMyString.setStrEndWith(sAppDir, File.separatorChar)) == null || sAppDir.trim().equals("")) {
            throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u5e94\u7528\u6240\u5728\u8def\u5f84\uff01");
        }
        String sMobileDataPath = sAppDir + "app" + File.separator + "smobile" + File.separator + "data" + File.separator;
        return sMobileDataPath;
    }

    private void createMobileChannels(int _nSrcSiteId, int _nParentId, int _nNewSiteId, int _NewParentId) throws Exception {
        User loginUser = this.getLoginUser();
        HashMap<Integer, Integer> channelIdsMapping = new HashMap<Integer, Integer>(60);
        String SQL_QUERY_CHANNELS = "select * from WCMChannel where SiteId=? and ParentId=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = this.m_oMyDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(SQL_QUERY_CHANNELS);
            oPreStmt.setInt(1, _nSrcSiteId);
            oPreStmt.setInt(2, _nParentId);
            result = oPreStmt.executeQuery();
            while (result.next()) {
                int nSrcChannelId = result.getInt("ChannelId");
                Channel oTempChannel = Channel.createNewInstance();
                oTempChannel.readFromRs(result, result.getMetaData());
                Channel oNewChannel = (Channel)oTempChannel.cloneToNewObj();
                oNewChannel.setSite(_nNewSiteId);
                oNewChannel.setParent(_NewParentId);
                oNewChannel.setAttribute("listtype", "1");
                oNewChannel.save(loginUser);
                channelIdsMapping.put(nSrcChannelId, oNewChannel.getId());
                m_sMessage = "\u6b63\u5728\u521b\u5efa\u79fb\u52a8\u680f\u76ee[" + oNewChannel + "]";
                int nNewChannelId = oNewChannel.getId();
                String SQL_INSERT_RELATION = "insert into XWCMCHANNELMAPPING(SrcChannelId, NewChannelId) values(" + nSrcChannelId + ", " + nNewChannelId + ")";
                DBManager.getDBManager().sqlExecuteUpdate(SQL_INSERT_RELATION);
                this.createMobileChannelFolderPublishConfig(oNewChannel, nSrcChannelId);
                this.createDocuments(nSrcChannelId, nNewChannelId);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query data!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oMyDBMgr.freeConnection(oConn);
            }
        }
        for (Map.Entry entry : channelIdsMapping.entrySet()) {
            Integer oSrcChannelId = (Integer)entry.getKey();
            Integer oNewChannelId = (Integer)entry.getValue();
            this.createMobileChannels(_nSrcSiteId, oSrcChannelId, _nNewSiteId, oNewChannelId);
        }
    }

    private void createMobileChannelFolderPublishConfig(Channel oNewChannel, int _nSrcChannelId) throws WCMException {
        String sDataPath;
        block21: {
            m_sMessage = "\u6b63\u5728\u521b\u5efa\u680f\u76ee[" + oNewChannel + "]\u7684\u53d1\u5e03\u4fe1\u606f";
            sDataPath = "";
            String SQL_QUERY__PUBLISH_CONFIG = "select * from WCMFolderPublishConfig where FolderType=? and FolderId=?";
            Connection oConn = null;
            PreparedStatement oPreStmt = null;
            ResultSet result = null;
            try {
                oConn = this.m_oMyDBMgr.getConnection();
                oPreStmt = oConn.prepareStatement(SQL_QUERY__PUBLISH_CONFIG);
                oPreStmt.setInt(1, 101);
                oPreStmt.setInt(2, _nSrcChannelId);
                result = oPreStmt.executeQuery();
                if (result.next()) {
                    sDataPath = result.getString("DataPath");
                    break block21;
                }
                return;
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to query data!", ex);
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to close result", (Throwable)e);
                    }
                }
                if (oPreStmt != null) {
                    try {
                        oPreStmt.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                    }
                }
                if (oConn != null) {
                    this.m_oMyDBMgr.freeConnection(oConn);
                }
            }
        }
        int mobileChannelId = oNewChannel.getId();
        IPublishElement publishElement = PublishElementFactory.lookupElement(101, mobileChannelId);
        WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        currPublishConfig.setFolderType(101, mobileChannelId);
        currPublishConfig.setDataPath(sDataPath);
        currPublishConfig.canEdit(this.getLoginUser());
        currPublishConfig.save(this.getLoginUser());
    }

    private void configChannelTemplate(Channel channel) throws WCMException {
        m_sMessage = "\u6b63\u5728\u4e3a\u79fb\u52a8\u680f\u76ee\u3010" + channel.getName() + "\u3011\u914d\u7f6e\u6a21\u677f";
        int nSiteId = channel.getSiteId();
        IPublishElement publishElement = PublishElementFactory.makeElementFrom(channel);
        String sOutlineTemplateIds = this.getChannelOutLineTemplatesIds(nSiteId);
        this.m_oEmployMgr.setOutlineTemplates((IPublishFolder)publishElement, sOutlineTemplateIds, false);
        int nDetailTemplateId = this.getDetailTemplateId(nSiteId);
        this.m_oEmployMgr.setDetailTemplate((IPublishFolder)publishElement, nDetailTemplateId, false);
    }

    private String getChannelOutLineTemplatesIds(int _siteId) throws WCMException {
        String sTemplateName;
        Template template;
        int i;
        Templates templates = this.getSiteAllTemplates(_siteId);
        StringBuffer outlineTemplateIds = new StringBuffer();
        for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            if (!m_sChnlOutlineTemplateNames[0].equals(sTemplateName)) continue;
            outlineTemplateIds.append(template.getId());
        }
        block1: for (i = 0; i < templates.size(); ++i) {
            template = (Template)templates.getAt(i);
            sTemplateName = template.getName();
            for (int k = 1; k < m_sChnlOutlineTemplateNames.length; ++k) {
                if (!m_sChnlOutlineTemplateNames[k].equals(sTemplateName)) continue;
                if (CMyString.isEmpty(outlineTemplateIds.toString())) {
                    outlineTemplateIds.append(template.getId());
                    continue block1;
                }
                outlineTemplateIds.append("," + template.getId());
                continue block1;
            }
        }
        return outlineTemplateIds.toString();
    }

    private int getDetailTemplateId(int _siteId) throws WCMException {
        Templates templates = this.getSiteAllTemplates(_siteId);
        int nTemplateId = 0;
        String[] detailTemplateNames = m_sDetailTemplateNames.split(",");
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            String sTemplateName = template.getName();
            if (this.m_bWJBhd) {
                if (sTemplateName.equals(detailTemplateNames[1])) {
                    nTemplateId = template.getId();
                }
            } else if (sTemplateName.equals(detailTemplateNames[0])) {
                nTemplateId = template.getId();
            }
            if (nTemplateId > 0) break;
        }
        return nTemplateId;
    }

    private void createDocuments(int srcChannel, int newChannel) throws WCMException {
        String SQL_QUERY_CHANNELS = "select WCMDOCUMENT.*, WCMCHNLDOC.CHNLID from WCMCHNLDOC, WCMDOCUMENT where CHNLID=? and WCMCHNLDOC.DOCID=WCMDOCUMENT.DOCID Order By WCMChnlDoc.DOCORDERPRI asc, WCMChnlDoc.DocOrder asc";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = this.m_oMyDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(SQL_QUERY_CHANNELS);
            oPreStmt.setInt(1, srcChannel);
            oPreStmt.setMaxRows(DOCUMENT_CREATE_NUM);
            result = oPreStmt.executeQuery();
            Channel channel = Channel.findById(newChannel);
            if (channel == null || channel.isVirtual()) {
                return;
            }
            while (result.next()) {
                JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
                HashMap<String, Object> serviceMap = new HashMap<String, Object>();
                String sServiceId = "wcm6_document";
                String sMethodName = "save";
                TableInfo oTableInfo = DBManager.getDBManager().getTableInfo("WCMDOCUMENT");
                Document oTempDocument = Document.createNewInstance();
                oTempDocument.setLoadText(true);
                oTempDocument.readFromRs(result, result.getMetaData());
                int nOldDocId = oTempDocument.getPropertyAsInt("DOCID", 0);
                oTempDocument = (Document)oTempDocument.cloneToNewWCMObj();
                Hashtable<String, Object> properties = oTempDocument.getProperties();
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    String sFieldName = entry.getKey();
                    Object objectValue = entry.getValue();
                    if (oTableInfo.getFieldInfo(sFieldName) == null) continue;
                    serviceMap.put(sFieldName.toUpperCase(), objectValue);
                }
                serviceMap.remove("DOCID");
                serviceMap.remove("SITEID");
                serviceMap.remove("DOCCHANNEL");
                serviceMap.put("OBJECTID", "0");
                serviceMap.put("CHANNELID", String.valueOf(newChannel));
                m_sMessage = "\u6b63\u5728\u521b\u5efa\u680f\u76ee\u3010" + channel + "\u3011\u4e0b\u7684<br />\u6587\u6863\u3010" + result.getString("DOCTITLE") + "\u3011";
                Integer oNewDocId = (Integer)processor.excute(sServiceId, sMethodName, serviceMap);
                this.createAppendixes(nOldDocId, oNewDocId);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query data!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oMyDBMgr.freeConnection(oConn);
            }
        }
    }

    private void createAppendixes(int nSrcDocId, int oNewDocId) throws WCMException {
        String SQL_QUERY_CHANNELS = "select * from WCMAPPENDIX where APPDOCID=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = this.m_oMyDBMgr.getConnection();
            oPreStmt = oConn.prepareStatement(SQL_QUERY_CHANNELS);
            oPreStmt.setInt(1, nSrcDocId);
            result = oPreStmt.executeQuery();
            Document document = Document.findById(oNewDocId);
            while (result.next()) {
                m_sMessage = "\u6b63\u5728\u521b\u5efa\u6587\u6863\u3010" + document + "\u3011\u7684\u9644\u4ef6";
                Appendix oTempAppendix = Appendix.createNewInstance();
                oTempAppendix.readFromRs(result, result.getMetaData());
                Appendix oAppendix = (Appendix)oTempAppendix.cloneToNewWCMObj();
                this.m_oAppendixMgr.addAppendix(document, oAppendix);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query data!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                this.m_oMyDBMgr.freeConnection(oConn);
            }
        }
    }

    private void verifyChnlListTypes(WebSite oNewSite) throws WCMException {
        Channel channel;
        int i;
        User loginUser = this.getLoginUser();
        WCMFilter filter = new WCMFilter();
        filter.setWhere("SiteId=?");
        filter.addSearchValues(oNewSite.getId());
        filter.setOrder("ParentId asc, ChnlOrder desc");
        ArrayList<String> imageChnlList = new ArrayList<String>();
        Channels channels = Channels.openWCMObjs(this.getLoginUser(), filter);
        int nSize = channels.size();
        for (i = 0; i < nSize; ++i) {
            channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.configChannelTemplate(channel);
            double rate = this.imageRateInChannel(channel.getId());
            if (rate < 80.0) {
                if (!(rate > 2.0) || imageChnlList.size() >= m_nMaxSubscribechannels) continue;
                imageChnlList.add(String.valueOf(channel.getId()));
                continue;
            }
            boolean isContain = false;
            if (CMyString.isEmpty(m_sCoverChnlId)) {
                m_sCoverChnlId = String.valueOf(channel.getId());
                logger.info((Object)("\u5c01\u9762\u680f\u76ee\uff1a" + channel));
                isContain = true;
            }
            if (CMyString.isEmpty(m_sRegularchannels)) {
                m_sRegularchannels = String.valueOf(channel.getId());
                isContain = true;
                logger.info((Object)("\u5934\u6761\u680f\u76ee\uff1a" + channel));
            }
            if (!CMyString.isEmpty(m_sRegularchannels) && m_sRegularchannels == m_sCoverChnlId) {
                m_sRegularchannels = String.valueOf(channel.getId());
                isContain = true;
                logger.info((Object)("\u5934\u6761\u680f\u76ee\uff1a" + channel));
            }
            if (!isContain && m_nMaxSubscribechannels >= m_sSubscribechannels.split(",").length) {
                if (!CMyString.isEmpty(m_sSubscribechannels)) {
                    m_sSubscribechannels = m_sSubscribechannels + ",";
                }
                m_sSubscribechannels = m_sSubscribechannels + String.valueOf(channel.getId());
                logger.info((Object)("\u8ba2\u9605\u7684\u680f\u76ee\uff1a" + m_sSubscribechannels + ";append pic chnl[>80]:" + channel));
            }
            channel.setAttribute("listtype", "7");
            channel.save(loginUser);
        }
        int length = imageChnlList.size();
        for (i = 0; i < length; ++i) {
            String sChnlId = (String)imageChnlList.get(i);
            if (sChnlId == null) continue;
            int nChnlId = Integer.parseInt(sChnlId);
            Channel channel2 = Channel.findById(nChnlId);
            if (m_nMaxSubscribechannels < m_sSubscribechannels.split(",").length) break;
            if (!CMyString.isEmpty(m_sSubscribechannels)) {
                m_sSubscribechannels = m_sSubscribechannels + ",";
            }
            m_sSubscribechannels = m_sSubscribechannels + String.valueOf(channel2.getId());
            logger.info((Object)("\u8ba2\u9605\u7684\u680f\u76ee\uff1a" + m_sSubscribechannels + ";append pic chnl[<80]:" + channel2));
        }
        nSize = channels.size();
        for (i = 0; i < nSize; ++i) {
            channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            if (m_nMaxSubscribechannels < m_sSubscribechannels.split(",").length) break;
            if (("," + m_sSubscribechannels + ",").indexOf("," + channel.getId() + ",") >= 0) continue;
            if (!CMyString.isEmpty(m_sSubscribechannels)) {
                m_sSubscribechannels = m_sSubscribechannels + ",";
            }
            m_sSubscribechannels = m_sSubscribechannels + String.valueOf(channel.getId());
            logger.info((Object)("\u8ba2\u9605\u7684\u680f\u76ee\uff1a" + m_sSubscribechannels + ";append text chnl:" + channel));
        }
    }

    private int getDocsCount(int nChnlId) throws WCMException {
        String sSQL = "select count(*) from WCMCHNLDOC where CHNLID=? and DocStatus>0 and DocChannel>0 ";
        int nDocsCount = DBManager.getDBManager().sqlExecuteIntQuery(sSQL, new int[]{nChnlId});
        return nDocsCount;
    }

    private int getImageDocsCount(int nChnlId) throws WCMException {
        String sSQL = "select count(*) from WCMCHNLDOC where CHNLID=? and ATTACHPIC>0 and DocStatus>0 and DocChannel>0 ";
        int nImageDocsCount = DBManager.getDBManager().sqlExecuteIntQuery(sSQL, new int[]{nChnlId});
        return nImageDocsCount;
    }

    private boolean isImageChannel(int nChnlId) throws WCMException {
        float fRate = 80.0f;
        return this.imageRateInChannel(nChnlId) > (double)fRate;
    }

    private double imageRateInChannel(int nChnlId) throws WCMException {
        int nDocsCount = this.getDocsCount(nChnlId);
        int nImageDocsCount = this.getImageDocsCount(nChnlId);
        Channel channel = Channel.findById(nChnlId);
        double rate = 0.0;
        rate = nDocsCount <= 0 || nImageDocsCount <= 0 ? 0.0 : 100.0 * (double)nImageDocsCount / (double)nDocsCount;
        logger.debug((Object)("imageRateInChannel:" + channel + ",rate:" + rate));
        return rate;
    }

    private void fullPublishSite(int _siteId) throws WCMException {
        m_sMessage = "\u6b63\u5728\u5b8c\u5168\u53d1\u5e03\u79fb\u52a8\u7ad9\u70b9\uff01";
        JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
        HashMap<String, Integer> serviceMap = new HashMap<String, Integer>();
        String sServiceId = "wcm6_publish";
        String sMethodName = "fullyPublish";
        serviceMap.put("OBJECTIDS", _siteId);
        serviceMap.put("OBJECTTYPE", 103);
        try {
            processor.excute(sServiceId, sMethodName, serviceMap);
        }
        catch (WCMException e) {
            throw new WCMException("\u5b8c\u5168\u53d1\u5e03\u7ad9\u70b9\u51fa\u73b0\u5f02\u5e38\uff01");
        }
    }

    private int getSystemTemplateId(int _siteId) throws WCMException {
        return this.getTemplateId(_siteId, m_sSystemConfigTemplateName);
    }

    private int getTemplateId(int _siteId, String sTempName) throws WCMException {
        Templates templates = this.getSiteAllTemplates(_siteId);
        int nTemplateId = 0;
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            String sTemplateName = template.getName();
            if (sTemplateName.equals(sTempName)) {
                nTemplateId = template.getId();
            }
            if (nTemplateId > 0) break;
        }
        return nTemplateId;
    }

    private void verifySystemConfigTemplate(int _siteId) throws WCMException {
        int nTemplateId = this.getSystemTemplateId(_siteId);
        if (nTemplateId <= 0) {
            logger.info((Object)"\u4e0d\u5b58\u5728[\u5ba2\u6237\u7aef\u7cfb\u7edf\u914d\u7f6e]\u6a21\u677f\uff0c\u5ffd\u7565\u5c01\u9762\u680f\u76ee\u7b49\u4e00\u4e9b\u7684\u8bbe\u7f6e");
            return;
        }
        Template template = Template.findById(nTemplateId);
        String sTempText = template.getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[===============\u5ba2\u6237\u7aef\u7cfb\u7edf\u914d\u7f6e]\u6a21\u677f==============");
            logger.debug((Object)sTempText);
        }
        sTempText = sTempText.replaceFirst("(?si)<regularchannels>[^<]*</regularchannels>", "<regularchannels>" + m_sRegularchannels + "</regularchannels>");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[=============================");
            logger.debug((Object)("<regularchannels>" + m_sRegularchannels + "</regularchannels>"));
        }
        sTempText = sTempText.replaceFirst("(?si)<subscribechannels>[^<]*</subscribechannels>", "<subscribechannels>" + m_sSubscribechannels + "</subscribechannels>");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[=============================");
            logger.debug((Object)("<subscribechannels>" + m_sSubscribechannels + "</subscribechannels>"));
        }
        sTempText = sTempText.replaceFirst("(?si)<coverChnlId>[^<]*</coverChnlId>", "<coverChnlId>" + m_sCoverChnlId + "</coverChnlId>");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[=============================");
            logger.debug((Object)("<coverChnlId>" + m_sCoverChnlId + "</coverChnlId>"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[=============\u4fee\u6539\u540e================");
            logger.debug((Object)sTempText);
        }
        template.setText(sTempText);
        this.m_oTemplateMgr.save(template, null, true, 2);
    }

    private void verifyChannels4SpecialTemplate(int _siteId) throws WCMException {
        int nTemplateId = this.getTemplateId(_siteId, m_sChannel4SpecilTemplateName);
        if (nTemplateId <= 0) {
            logger.info((Object)"\u4e0d\u5b58\u5728[\u8ba2\u9605\u7684\u680f\u76ee\u5217\u8868]\u6a21\u677f");
            return;
        }
        Template template = Template.findById(nTemplateId);
        String sTempText = template.getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[===============\u8ba2\u9605\u7684\u680f\u76ee\u5217\u8868]\u6a21\u677f==============");
            logger.debug((Object)sTempText);
        }
        String sAllChnlIds = m_sCoverChnlId;
        if (!CMyString.isEmpty(m_sRegularchannels)) {
            if (!CMyString.isEmpty(sAllChnlIds)) {
                sAllChnlIds = sAllChnlIds + ",";
            }
            sAllChnlIds = sAllChnlIds + m_sRegularchannels;
        }
        if (!CMyString.isEmpty(m_sSubscribechannels)) {
            if (!CMyString.isEmpty(sAllChnlIds)) {
                sAllChnlIds = sAllChnlIds + ",";
            }
            sAllChnlIds = sAllChnlIds + m_sSubscribechannels;
        }
        sTempText = sTempText.replaceFirst("(?is)(<TRS_CHANNELS[^>]*)CHNLIDS=['\"][^'\"]+['\"]([^>]*>)", "$1CHNLIDS='" + sAllChnlIds + "'$2");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[=============================");
            logger.debug((Object)sTempText);
        }
        template.setText(sTempText);
        this.m_oTemplateMgr.save(template, null, true, 2);
    }

    private void createSpecialChannel(int _nSiteId, boolean _bCreateMsgPush, boolean _bCreateWB) throws WCMException {
    }

    private void createMsgChannel(int _siteId) throws WCMException {
        String sChnlName = "\u6d88\u606f\u63a8\u9001";
        int nChnlId = DBManager.getDBManager().sqlExecuteIntQuery("select CHANNELID from WCMChannel where ChnlName like '%\u6d88\u606f\u63a8\u9001%'");
        if (nChnlId > 0) {
            logger.info((Object)"\u6d88\u606f\u63a8\u9001\u680f\u76ee\u5df2\u7ecf\u5b58\u5728,\u4e0d\u518d\u521b\u5efa");
        } else {
            logger.info((Object)"\u6d88\u606f\u63a8\u9001\u680f\u76ee\u521b\u5efa\u6210\u529f");
            Channel channel = Channel.createNewInstance();
            channel.setName(sChnlName);
            channel.setDesc(sChnlName);
            channel.setSite(_siteId);
            channel.setParent(0);
            channel.setCrUser(this.getLoginUser());
            channel.setCanPub(true);
            channel.setAttribute("LISTTYPE", "1");
            channel.save();
            nChnlId = channel.getId();
            IPublishElement publishElement = PublishElementFactory.lookupElement(101, nChnlId);
            WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
            currPublishConfig.setFolderType(101, nChnlId);
            currPublishConfig.setDataPath("notify");
            currPublishConfig.canEdit(this.getLoginUser());
            currPublishConfig.save(this.getLoginUser());
        }
        m_nMsgChnlId = nChnlId;
    }

    private void configMsgChnlTemplate(int _siteId) throws WCMException {
        if (m_nMsgChnlId <= 0) {
            return;
        }
        int nChnlId = m_nMsgChnlId;
        IPublishElement publishElement = PublishElementFactory.lookupElement(101, nChnlId);
        int nOutlineTempId = this.getTemplateId(_siteId, m_sPushMsgOutlineTemplateNames[0]);
        String sOtherTempIds = this.getTemplateId(_siteId, m_sPushMsgOutlineTemplateNames[1]) + "," + this.getTemplateId(_siteId, m_sPushMsgOutlineTemplateNames[2]);
        this.m_oEmployMgr.setOutlineTemplates((IPublishFolder)publishElement, nOutlineTempId + "," + sOtherTempIds, false);
        int nDetailTemplateId = this.getDetailTemplateId(_siteId);
        this.m_oEmployMgr.setDetailTemplate((IPublishFolder)publishElement, nDetailTemplateId, false);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    static {
        BPROCESSING = false;
        DOCUMENT_CREATE_NUM = 200;
        m_sMessage = "";
        m_sTemplateFile = "TEMPLATE--MOBILEPORTAL--READING";
        m_oTemplats = null;
        m_sSiteOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u7ad9\u70b9\u9996\u9875", "\u7ad9\u70b9\u8f85\u52a9\u6a21\u677f"};
        m_sChnlOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u680f\u76ee\u901a\u7528\u6982\u89c8", "\u680f\u76ee\u8f85\u52a9\u6a21\u677f"};
        m_sPushMsgOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u680f\u76ee\u901a\u7528\u6982\u89c8", "\u680f\u76ee\u8f85\u52a9\u6a21\u677f", "\u6d88\u606f\u63a8\u9001\u6700\u65b0\u65f6\u95f4"};
        m_sDetailTemplateNames = "\u6587\u6863\u8be6\u7ec6\u4fe1\u606f\u4e0d\u5e26\u683c\u5f0f,\u6587\u6863\u8be6\u7ec6\u4fe1\u606f\u5e26\u683c\u5f0f";
        m_sSystemConfigTemplateName = "\u5ba2\u6237\u7aef\u7cfb\u7edf\u914d\u7f6e";
        m_sChannel4SpecilTemplateName = "\u8ba2\u9605\u7684\u680f\u76ee\u5217\u8868";
        m_sCoverChnlId = "";
        m_sSubscribechannels = "";
        m_nMaxSubscribechannels = 6;
        m_sRegularchannels = "";
        m_nMsgChnlId = 0;
    }
}

