/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mlf.log;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import org.apache.log4j.Logger;

public class LogAuthUtil {
    private static Logger logger = Logger.getLogger(LogAuthUtil.class);

    public static void logAuthError(BaseObj baseObj, String ... operations) {
        if (baseObj == null) {
            return;
        }
        User loginUser = ContextHelper.getLoginUser();
        StringBuilder msg = new StringBuilder();
        msg.append("====AuthError==== ").append("User:").append(loginUser.toString()).append(", object:").append(baseObj.getClassName(true)).append("[ID=").append(baseObj.getId()).append("]").append(", operation:");
        if (operations != null && operations.length > 0) {
            for (String operation : operations) {
                msg.append(operation);
                msg.append(",");
            }
            msg.deleteCharAt(msg.length() - 1);
        }
        SimpleLogServer.warn(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "\u6743\u9650\u6821\u9a8c", "\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7", msg.toString());
    }

    public static void logAuthError(BaseObjs baseObjs, String ... operations) {
        if (baseObjs == null) {
            return;
        }
        User loginUser = ContextHelper.getLoginUser();
        StringBuilder msg = new StringBuilder();
        msg.append("====AuthError==== ").append("User:").append(loginUser.toString());
        String baseObjClassName = "";
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < baseObjs.size(); ++i) {
            BaseObj baseObj = baseObjs.getAt(i);
            if (i == 0) {
                baseObjClassName = baseObj.getClassName(true);
            }
            ids.append(baseObj.getId()).append(",");
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        msg.append(", object:").append(baseObjClassName).append("[ID=").append(ids.toString()).append("]");
        msg.append(", operation:");
        if (operations != null && operations.length > 0) {
            for (String operation : operations) {
                msg.append(operation);
                msg.append(",");
            }
            msg.deleteCharAt(msg.length() - 1);
        }
        SimpleLogServer.warn(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "\u6743\u9650\u6821\u9a8c", "\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7", msg.toString());
    }
}

