/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class CharsetDetector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized String detect(String fn) {
        Object param = ContextParameters.get(9, true);
        if (param != null) {
            return String.valueOf(param);
        }
        if (CMyString.isEmpty(fn)) {
            throw new IllegalArgumentException("file name not confirm!");
        }
        FileService file = new FileService(fn);
        if (file.isDirectory() || !file.exists()) {
            throw new IllegalArgumentException("[" + fn + "] is not a file or file not exists!");
        }
        nsDetector detector = new nsDetector(0);
        CharsetDetectionObserver observer = new CharsetDetectionObserver();
        detector.Init((nsICharsetDetectionObserver)observer);
        InputStream fis = null;
        try {
            fis = file.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedInputStream buffis = new BufferedInputStream(fis);
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = true;
        try {
            int len;
            while ((len = buffis.read(buf, 0, buf.length)) != -1) {
                if (isAscii) {
                    isAscii = detector.isAscii(buf, len);
                }
                if (isAscii || done) continue;
                done = detector.DoIt(buf, len, false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            detector.DataEnd();
        }
        finally {
            if (buffis != null) {
                try {
                    buffis.close();
                }
                catch (Exception exception) {}
            }
        }
        if (isAscii) {
            return "ISO-8859-1";
        }
        String encoding = observer.getCharset();
        if (encoding == null) {
            String[] prob = detector.getProbableCharsets();
            encoding = prob.length > 1 && ("utf-8".equals(prob[0]) || "UTF-8".equals(prob[0])) ? prob[0] : "GBK";
        }
        if ("GB2312".equalsIgnoreCase(encoding) || !Charset.isSupported(encoding)) {
            encoding = "GBK";
        }
        return encoding;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(CharsetDetector.detect(I18NMessage.get(CharsetDetector.class, "CharsetDetector.label1", "C:\\Documents and Settings\\Administrator\\\u684c\u9762\\\u7ad9\u70b91\\temp\\\u9996\u9875.htm")));
        }
        for (int i = 0; i < args.length; ++i) {
            System.out.println(CharsetDetector.detect(args[i]));
        }
    }

    private static class CharsetDetectionObserver
    implements nsICharsetDetectionObserver {
        private String _charset;

        private CharsetDetectionObserver() {
        }

        public void Notify(String charset) {
            this._charset = charset;
        }

        public String getCharset() {
            return this._charset;
        }
    }
}

