/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cache;

import com.trs.util.CMyString;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisHelper {
    public static Logger logger = Logger.getLogger(JedisHelper.class);
    private static JedisPool jedisPool;
    private static ThreadLocal<Long> timeUsedThreadLocal;

    public static Jedis getJedis() {
        JedisPool pool = JedisHelper.getJedisPool();
        if (logger.isDebugEnabled()) {
            timeUsedThreadLocal.set(System.currentTimeMillis());
        }
        return pool.getResource();
    }

    public static void returnResource(Jedis redis) {
        if (redis != null) {
            JedisHelper.getJedisPool().returnResource(redis);
            if (logger.isDebugEnabled()) {
                long startTime = timeUsedThreadLocal.get();
                timeUsedThreadLocal.remove();
                logger.debug((Object)("time used:" + (System.currentTimeMillis() - startTime) + "ms"));
                logger.debug((Object)"who call me?", (Throwable)new RuntimeException());
            }
        }
    }

    private static synchronized JedisPool getJedisPool() {
        if (jedisPool != null) {
            return jedisPool;
        }
        jedisPool = JedisHelper.getJedisPoolByEnv();
        if (jedisPool == null) {
            jedisPool = JedisHelper.getJedisPoolByProperties();
        }
        return jedisPool;
    }

    private static JedisPool getJedisPoolByProperties() {
        try {
            String password;
            URL redisURL = Loader.getResource((String)"cache/redis.properties");
            Properties properties = new Properties();
            properties.load(redisURL.openStream());
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            String maxTotal = properties.getProperty("redis.pool.maxActive");
            maxTotal = CMyString.showEmpty((String)maxTotal).trim();
            jedisPoolConfig.setMaxTotal(Integer.parseInt(maxTotal));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("maxTotal:" + maxTotal));
            }
            String maxWait = properties.getProperty("redis.pool.maxWait");
            maxWait = CMyString.showEmpty((String)maxWait).trim();
            jedisPoolConfig.setMaxWaitMillis((long)Integer.parseInt(maxWait));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("maxWait:" + maxWait));
            }
            String maxIdle = properties.getProperty("redis.pool.maxIdle");
            maxIdle = CMyString.showEmpty((String)maxIdle).trim();
            jedisPoolConfig.setMaxIdle(Integer.parseInt(maxIdle));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("maxIdle:" + maxIdle));
            }
            String testOnBorrow = properties.getProperty("redis.pool.testOnBorrow");
            testOnBorrow = CMyString.showEmpty((String)testOnBorrow).trim();
            jedisPoolConfig.setTestOnBorrow(Boolean.parseBoolean(testOnBorrow));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("testOnBorrow:" + testOnBorrow));
            }
            String host = properties.getProperty("redis.hostname");
            host = CMyString.showEmpty((String)host).trim();
            String port = properties.getProperty("redis.port");
            port = CMyString.showEmpty((String)port, (String)"6379").trim();
            int nport = Integer.parseInt(port);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("host:" + host + ";port:" + port));
            }
            password = CMyString.isEmpty((String)(password = properties.getProperty("redis.password"))) ? null : password;
            String db = properties.getProperty("redis.db");
            db = CMyString.showEmpty((String)db, (String)"0").trim();
            int ndb = Integer.parseInt(db);
            String timeout = properties.getProperty("redis.timeout");
            timeout = CMyString.showEmpty((String)timeout, (String)"20000").trim();
            int ntimeout = Integer.parseInt(timeout);
            JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, nport, ntimeout, password, ndb);
            return jedisPool;
        }
        catch (IOException e) {
            logger.error((Object)"\u52a0\u8f7dredis.properties\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static JedisPool getJedisPoolByEnv() {
        String sService = System.getenv().get("VCAP_SERVICES");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("VCAP_SERVICES:" + sService));
        }
        if (CMyString.isEmpty((String)sService)) {
            return null;
        }
        JSONObject serviceJson = JSONObject.fromObject((Object)sService);
        Object redis = serviceJson.get("redis");
        if (null == redis) {
            return null;
        }
        JSONArray redisService = JSONArray.fromObject((Object)redis);
        if (null == redisService || null == redisService.get(0)) {
            return null;
        }
        JSONObject redisJson = JSONObject.fromObject((Object)redisService.get(0));
        if (null == redisJson) {
            return null;
        }
        JSONObject credentials = JSONObject.fromObject((Object)redisJson.get("credentials"));
        JedisPoolConfig jedispool_config = new JedisPoolConfig();
        jedispool_config.setMaxTotal(100);
        jedispool_config.setMaxWaitMillis(1000L);
        jedispool_config.setMaxIdle(20);
        jedispool_config.setTestOnBorrow(true);
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)jedispool_config, credentials.getString("HOSTNAME"), credentials.getInt("PORT"));
        return pool;
    }

    static {
        timeUsedThreadLocal = new ThreadLocal<Long>(){

            @Override
            public Long initialValue() {
                return 0L;
            }
        };
    }
}

