/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.resource;

import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.I18NMessage;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class SourceTypeMgr {
    private static Logger logger = Logger.getLogger(SourceTypeMgr.class);
    private static String SOURCE_CONFIG_FILE = "source.config.ini";
    private static String SOURCE_SUPPORTTYPE_PARAM_NAME = "SourceSupportType";
    private static String SOURCE_TYPES_PARAM_NAME = "SourceTypes";
    private static String SOURCE_MGR_PARAM_NAME = "SourceMgrerGroups";
    public static String[] SOURCE_TYPE_ARRAY;
    public static int[] SOURCE_MGRER_ID_ARRAY;
    public static boolean SOURCE_SUPPORT_TYPE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSourceConfig() {
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        try {
            String sLine;
            fis = new FileService(ConfigConstants.DIR_APPROOT + SOURCE_CONFIG_FILE).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, "GBK"));
            while ((sLine = buffReader.readLine()) != null) {
                int nPos;
                if ((sLine = sLine.trim()).length() == 0 || sLine.charAt(0) == '#') continue;
                if (sLine.length() > SOURCE_SUPPORTTYPE_PARAM_NAME.length() && sLine.substring(0, SOURCE_SUPPORTTYPE_PARAM_NAME.length()).equalsIgnoreCase(SOURCE_SUPPORTTYPE_PARAM_NAME)) {
                    nPos = sLine.indexOf(58, SOURCE_SUPPORTTYPE_PARAM_NAME.length());
                    if (nPos < 0) continue;
                    SOURCE_SUPPORT_TYPE = sLine.substring(nPos + 1).trim().equalsIgnoreCase("true");
                }
                if (sLine.length() > SOURCE_TYPES_PARAM_NAME.length() && sLine.substring(0, SOURCE_TYPES_PARAM_NAME.length()).equalsIgnoreCase(SOURCE_TYPES_PARAM_NAME)) {
                    nPos = sLine.indexOf(58, SOURCE_TYPES_PARAM_NAME.length());
                    if (nPos < 0) continue;
                    SOURCE_TYPE_ARRAY = CMyString.split(sLine.substring(nPos + 1).trim(), ",");
                }
                if (sLine.length() <= SOURCE_MGR_PARAM_NAME.length() || !sLine.substring(0, SOURCE_MGR_PARAM_NAME.length()).equalsIgnoreCase(SOURCE_MGR_PARAM_NAME) || (nPos = sLine.indexOf(58, SOURCE_MGR_PARAM_NAME.length())) < 0) continue;
                SOURCE_MGRER_ID_ARRAY = CMyString.splitToInt(sLine.substring(nPos + 1).trim(), ",");
            }
        }
        catch (Exception ex) {
            logger.error((Object)I18NMessage.get(SourceTypeMgr.class, "SourceTypeMgr.label1", "\u521d\u59cb\u5316\u6765\u6e90\u8bbe\u7f6e\u53d1\u751f\u5f02\u5e38!"), (Throwable)ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!SOURCE_SUPPORT_TYPE) {
            SOURCE_TYPE_ARRAY = null;
            SOURCE_MGRER_ID_ARRAY = null;
            return;
        }
    }

    public static boolean isSourceMgr(User _user) {
        if (!SOURCE_SUPPORT_TYPE || SOURCE_MGRER_ID_ARRAY == null) {
            return false;
        }
        try {
            Groups grps = _user.getGroups();
            for (int i = 0; i < SOURCE_MGRER_ID_ARRAY.length; ++i) {
                if (grps.indexOf(SOURCE_MGRER_ID_ARRAY[i]) < 0) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) {
        int i;
        System.out.println(SOURCE_SUPPORT_TYPE);
        for (i = 0; SOURCE_TYPE_ARRAY != null && i < SOURCE_TYPE_ARRAY.length; ++i) {
            System.out.println(SOURCE_TYPE_ARRAY[i]);
        }
        for (i = 0; SOURCE_MGRER_ID_ARRAY != null && i < SOURCE_MGRER_ID_ARRAY.length; ++i) {
            System.out.println(SOURCE_MGRER_ID_ARRAY[i]);
        }
    }

    static {
        SOURCE_SUPPORT_TYPE = true;
        SourceTypeMgr.loadSourceConfig();
    }
}

