/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.publish.region.RegionEmploy;
import com.trs.components.wcm.publish.region.RegionEmployMgr;
import com.trs.components.wcm.publish.region.RegionEmploys;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.infra.common.WCMException;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IServiceListener;
import java.util.Iterator;

public class TemplateSaveListenerForRegionEmploy
implements IServiceListener {
    @Override
    public void afterServiceExecuted(ServiceListenerConfig listenerConfig, MethodContext methodContext, Object serviceResult) {
        int nTemplateId = methodContext.getObjectId();
        if (nTemplateId <= 0) {
            return;
        }
        try {
            Template currTemplate = Template.findById(nTemplateId);
            if (currTemplate == null) {
                return;
            }
            if (currTemplate.getType() != 1) {
                return;
            }
            RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
            RegionEmploys regionEmploys = regionEmployMgr.getRegionEmploysByObj(nTemplateId, 102);
            if (regionEmploys != null) {
                regionEmploys.removeAll();
            }
            String temtext = currTemplate.getText();
            TagDocument tagDoc = null;
            try {
                tagDoc = TagDocumentReader.read(temtext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (tagDoc == null) {
                return;
            }
            RegionInfo currRegion = null;
            Iterator itr = tagDoc.findItems("TRS_REGION");
            while (itr.hasNext()) {
                TagItem tagItem = (TagItem)itr.next();
                String sRegionName = tagItem.getAttribute("name");
                if (sRegionName == null || "".equals(sRegionName) || (currRegion = RegionInfo.findByName(sRegionName)) == null) continue;
                RegionEmploy oRegionEmploy = RegionEmploy.createNewInstance();
                oRegionEmploy.setRegionId(currRegion.getId());
                oRegionEmploy.setObjId(nTemplateId);
                oRegionEmploy.setObjType(102);
                oRegionEmploy.save();
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }
}

