/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.process;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IFlowNotifyWorker;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class FlowNotifyWorkerImpl
implements IFlowNotifyWorker {
    private static Logger logger = Logger.getLogger(FlowNotifyWorkerImpl.class);

    @Override
    public void addMsgEvent(User _currUser, Users _toUsers, String _sTitle, String _sDesc, int _nNotify) {
        this.addMsgEvent(_currUser, _toUsers, _sTitle, _sDesc, this.convertToMsgTypes(_nNotify));
    }

    @Override
    public void addMsgEvent(User _currUser, Users _toUsers, String _sTitle, String _sDesc, String _sNotifyTypes) {
        if (CMyString.isEmpty(_sNotifyTypes)) {
            return;
        }
        try {
            Message newMsg = new Message();
            newMsg.setCrUser(_currUser);
            newMsg.setTitle(_sTitle);
            newMsg.setBody(_sDesc);
            newMsg.setReceivers(204, _toUsers.getIdListAsString());
            newMsg.setSendTypes(_sNotifyTypes);
            newMsg.setProperty("MsgType", 3L);
            newMsg.save(_currUser);
            MessageServer.send(newMsg);
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(FlowNotifyWorkerImpl.class, "FlowNotifyWorkerImpl.label1", "\u521b\u5efa\u5de5\u4f5c\u6d41\u6d88\u606f\u5931\u8d25\uff01"), (Throwable)e);
        }
    }

    @Override
    public void addMsgEvent(User _currUser, User _toUser, String _sTitle, String _sDesc, String _sNotifyTypes) {
        if (CMyString.isEmpty(_sNotifyTypes)) {
            return;
        }
        try {
            Message newMsg = new Message();
            newMsg.setCrUser(_currUser);
            newMsg.setTitle(_sTitle);
            newMsg.setBody(_sDesc);
            newMsg.setReceivers(204, String.valueOf(_toUser.getId()));
            newMsg.setSendTypes(_sNotifyTypes);
            newMsg.setProperty("MsgType", 3L);
            newMsg.save(_currUser);
            MessageServer.send(newMsg);
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(FlowNotifyWorkerImpl.class, "FlowNotifyWorkerImpl.label1", "\u521b\u5efa\u5de5\u4f5c\u6d41\u6d88\u606f\u5931\u8d25\uff01"), (Throwable)e);
        }
    }

    private String convertToMsgTypes(int _nNotify) {
        String sSenderTypes = null;
        if (CMyBitsValue.getBitOfInt(_nNotify, 1)) {
            sSenderTypes = sSenderTypes != null ? sSenderTypes + "," : "";
            sSenderTypes = sSenderTypes + "Email";
        }
        if (CMyBitsValue.getBitOfInt(_nNotify, 2)) {
            sSenderTypes = sSenderTypes != null ? sSenderTypes + "," : "";
            sSenderTypes = sSenderTypes + "SMS";
        }
        if (CMyBitsValue.getBitOfInt(_nNotify, 0)) {
            sSenderTypes = sSenderTypes != null ? sSenderTypes + "," : "";
            sSenderTypes = sSenderTypes + "Message";
        }
        return sSenderTypes;
    }
}

