/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserContentBase;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.web.FieldTemplate;
import com.trs.components.metadata.web.HTMLMaker;
import com.trs.components.metadata.web.HTMLMakerFactory;
import com.trs.components.metadata.web.impl.FieldTemplateFactory;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class WCMTagParserViewField
extends TagParserContentBase {
    private static Logger logger = Logger.getLogger(WCMTagParserViewField.class);
    private static final int FULL_FIELD_NAME = 1;
    private static final int ENUM_VALUE = 2;
    private static final int _HTML = 3;
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");

    @Override
    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        if (this.m_host != null) {
            return this.m_host;
        }
        CMSObj upperHost = _context.getUpperHost().getSubstance();
        if (upperHost instanceof MetaViewField) {
            return upperHost;
        }
        MetaView oView = null;
        if (upperHost instanceof Document) {
            Document doc = (Document)upperHost;
            oView = MetaView.findById(doc.getKindId());
            if (oView == null) {
                throw new WCMException("\u5f53\u524d\u6587\u6863\u5173\u8054\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[DocId=" + doc.getId() + ",ViewId=" + doc.getKindId() + "]");
            }
        } else if (upperHost instanceof MetaView) {
            oView = (MetaView)upperHost;
        }
        if (oView != null) {
            String sFieldName = _context.getAttribute("id");
            if (CMyString.isEmpty(sFieldName)) {
                throw new WCMException(I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label1", "\u4f7f\u7528\u573a\u666f\u4e0d\u6b63\u786e\uff0c\u6ca1\u6709\u6307\u5b9a\u89c6\u56fe\u7684\u5b57\u6bb5\u540d\u79f0[id]\u5c5e\u6027"));
            }
            return this.m_oDataDefCacheMgr.getMetaViewField(oView.getId(), sFieldName);
        }
        return null;
    }

    @Override
    protected String[] parseHostNormalProperty(String _sName, PublishTagContext _context) throws WCMException {
        CMSObj upperHost = this.findHost(_context);
        if (upperHost == null || !(upperHost instanceof MetaViewField)) {
            return null;
        }
        String sValue = "";
        sValue = _sName.charAt(0) == '#' ? upperHost.getAttributeValue(_sName.substring(1)) : upperHost.getPropertyAsString(_sName);
        boolean isDblFilter = _context.getAttribute("DoubleFilter", false);
        String sFilterForHTML = _context.getAttribute("filterForHTML");
        String sfilterForJs = _context.getAttribute("filterForJs");
        String sfilterForJava = _context.getAttribute("filterForJava");
        if ("true".equalsIgnoreCase(sfilterForJs) || "1".equals(sfilterForJs)) {
            sValue = CMyString.filterForJs(sValue);
            if (isDblFilter) {
                sValue = CMyString.filterForJs(sValue);
            }
        } else if ("true".equalsIgnoreCase(sFilterForHTML) || "1".equals(sFilterForHTML)) {
            sValue = CMyString.filterForHTMLValue(sValue);
            if (isDblFilter) {
                sValue = CMyString.filterForHTMLValue(sValue);
            }
        } else if ("true".equalsIgnoreCase(sfilterForJava) || "1".equals(sfilterForJava)) {
            sValue = CMyString.filterForJava(sValue);
            if (isDblFilter) {
                sValue = CMyString.filterForJava(sValue);
            }
        }
        return new String[]{sValue};
    }

    @Override
    protected String[] parseHostSpecialProperty(int _nPropertyId, PublishTagContext _context) throws WCMException {
        CMSObj upperHost = this.findHost(_context);
        if (upperHost == null || !(upperHost instanceof MetaViewField)) {
            return null;
        }
        MetaViewField viewField = (MetaViewField)upperHost;
        MetaView view = MetaView.findById(viewField.getViewId());
        if (view == null) {
            return null;
        }
        switch (_nPropertyId) {
            case 1: {
                return new String[]{view.getTrueTableName() + "." + viewField.getName()};
            }
            case 2: {
                String sEnumValue = viewField.getEnmValue();
                if (_context.getAttribute("filterForJs", false)) {
                    return new String[]{CMyString.filterForJs(sEnumValue)};
                }
                String sValue = CMyString.filterForHTMLValue(sEnumValue);
                String sFilterForHTML = _context.getAttribute("filterForHTML");
                if (!"false".equalsIgnoreCase(sFilterForHTML) && !"0".equals(sFilterForHTML)) {
                    return new String[]{CMyString.filterForHTMLValue(sValue)};
                }
                return new String[]{sValue};
            }
            case 3: {
                return new String[]{this.buildFieldHtml(_context)};
            }
        }
        return null;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("FULLFIELDNAME", 1);
        this.registerHostSpecialProperty("ENMVALUE", 2);
        this.registerHostSpecialProperty("_HTML", 3);
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        return null;
    }

    private String buildFieldHtml(PublishTagContext _context) throws WCMException {
        TagDocument tagDoc;
        CMSObj upperHost = this.findHost(_context);
        if (upperHost == null || !(upperHost instanceof MetaViewField)) {
            return null;
        }
        MetaViewField viewField = (MetaViewField)upperHost;
        HTMLMaker htmlMaker = HTMLMakerFactory.getHTMLMaker(viewField.getType());
        htmlMaker.setViewField(viewField);
        String sTemplateType = this.getTemplateType(_context);
        FieldTemplate fieldTemplate = FieldTemplateFactory.getFieldTemplate(sTemplateType);
        htmlMaker.setFieldTemplate(fieldTemplate);
        String sTemplateContent = htmlMaker.makeHTML();
        try {
            tagDoc = TagDocumentReader.read(sTemplateContent);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label2", "\u8bfb\u53d6\u89c6\u56fe\u5b57\u6bb5[") + viewField + I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label3", "]\u6a21\u677f\u5931\u8d25"), e);
        }
        if (tagDoc == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label2", "\u8bfb\u53d6\u89c6\u56fe\u5b57\u6bb5[") + viewField + I18NMessage.get(WCMTagParserViewField.class, "WCMTagParserViewField.label3", "]\u6a21\u677f\u5931\u8d25"));
        }
        PublishTaskContext taskContext = new PublishTaskContext(null, null);
        IPublishElement pagePublishElement = PublishElementFactory.makeElementFrom(viewField);
        PublishPageContext oPageContext = new PublishPageContext(pagePublishElement, taskContext);
        PublishTagContext tagContext = new PublishTagContext(oPageContext);
        String[] results = TagParseHelper.parseItems(tagDoc.getItems(), tagContext);
        return results[0];
    }

    private String getTemplateType(PublishTagContext _context) {
        String sTemplateType = _context.getAttribute("type");
        if (sTemplateType == null) {
            for (TagItem parentTagItem = _context.getTagItem().getParent(); parentTagItem != null && ((sTemplateType = parentTagItem.getAttribute("type")) == null || !"TRS_VIEWFIELDS".equals(parentTagItem.getName()) && !"TRS_XVIEWFIELDGROUPFIELDS".equals(parentTagItem.getName())); parentTagItem = parentTagItem.getParent()) {
            }
        }
        return sTemplateType != null ? sTemplateType : "addedit";
    }
}

