/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.widget.tagparser.WCMTagParserBaseOperation;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class WCMTagParserDocOperation
extends WCMTagParserBaseOperation {
    private static Logger logger = Logger.getLogger(WCMTagParserDocOperation.class);
    private static TagBeanInfo s_TagBeanInfo = null;
    private static final int DOC_RECID = 1;
    private static final int DOC_RIGHTVALUE = 2;
    private static final int DOC_ORDER = 3;
    private static final int DOC_CHANNELID = 4;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            WCMTagParserBaseOperation.TBI tbi = new WCMTagParserBaseOperation.TBI();
            tbi.setName("TRS_DocOperation");
            tbi.setDesc("TRS_DocOperation");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("RightValue");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ATTRIBUTES");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("DocTitle,RecId,ChannelId");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXTRACLS");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    protected String parseHostSpecialProperty(int _nPropertyId, PublishTagContext _context) throws WCMException {
        if (this.m_host == null) {
            logger.error((Object)(_context.getTagItem() + "\u89e3\u6790\u5931\u8d25\uff01\u76f8\u5173\u6587\u6863\u6ca1\u6709\u627e\u5230\uff01"));
            return null;
        }
        Document oDocument = (Document)this.m_host;
        IPublishFolder content = _context.getUpperFolder();
        Channel currChannel = (Channel)content.getSubstance();
        ChnlDoc oChnlDoc = ChnlDoc.findByDocAndChnl(oDocument, currChannel);
        if (oChnlDoc == null) {
            oChnlDoc = ChnlDoc.findByDocument(oDocument);
        }
        String sRecID = oChnlDoc.getPropertyAsString("RECID");
        User currUser = ContextHelper.getLoginUser();
        switch (_nPropertyId) {
            case 1: {
                return sRecID;
            }
            case 2: {
                RightValue oRightValue = this.getRightValue(currUser, oDocument, currChannel);
                return oRightValue.toString();
            }
            case 3: {
                return String.valueOf(oChnlDoc.getDocOrder());
            }
            case 4: {
                return String.valueOf(currChannel.getId());
            }
        }
        return null;
    }

    @Override
    protected void registerHostSpecialAttributes() {
        this.registerHostSpecialAttribute("RIGHTVALUE", 2);
        this.registerHostSpecialAttribute("RECID", 1);
        this.registerHostSpecialAttribute("DOCORDER", 3);
        this.registerHostSpecialAttribute("CHANNELID", 4);
    }

    @Override
    protected String getDefaultField() {
        return "DocTitle,RecId,ChannelId";
    }

    private RightValue getRightValue(User _currUser, Document _oDocument, Channel _currChannel) throws WCMException {
        String sFlowDesc = _oDocument.getPropertyAsString("FLOWOPERATIONMARK");
        boolean bFlowRightPriority = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("FLOW_RIGHT_PRI", "false"));
        boolean bInFlow = bFlowRightPriority && !CMyString.isEmpty(sFlowDesc) && !sFlowDesc.equalsIgnoreCase("RESERVED_FORCED_END") && !sFlowDesc.equals(I18NMessage.get(ViewDocument.class, "ViewDocument.label8", "\u7ed3\u675f\u6d41\u8f6c"));
        int[] pRemoveRightIndexs = WCMRightTypes.getRemoveRightIndexs();
        boolean isOwner = _currUser.getName().equalsIgnoreCase(_oDocument.getCrUserName());
        if (this.isRightDefined(_oDocument)) {
            try {
                RightValue rightValue = new RightValue();
                rightValue.load(_currUser, 605, _oDocument.getId(), true);
                this.addOwnerValue(rightValue, isOwner);
                if (bInFlow) {
                    for (int i = 0; i < pRemoveRightIndexs.length; ++i) {
                        rightValue.setBit(pRemoveRightIndexs[i], false);
                    }
                }
                return rightValue;
            }
            catch (WCMException ex) {
                throw new WCMException(1100, I18NMessage.get(ViewDocument.class, "ViewDocument.label9", "\u83b7\u53d6\u6307\u5b9a\u5bf9\u8c61\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(") + this.getClass().getName() + ".getRightValue)", ex);
            }
        }
        if (_currUser.isAdministrator()) {
            RightValue rightValue = RightValue.getAdministratorRightValue();
            if (bInFlow) {
                for (int i = 0; i < pRemoveRightIndexs.length; ++i) {
                    rightValue.setBit(pRemoveRightIndexs[i], false);
                }
            }
            return rightValue;
        }
        Channel oDocChannel = _oDocument.getChannel();
        RightValue newRightValue = new RightValue();
        RightValue oCurrChnlRightValue = this.getChannelRightValue(_currUser, _currChannel);
        if (oDocChannel.getId() == _currChannel.getId()) {
            newRightValue = oCurrChnlRightValue;
        } else {
            RightValue oDocChannelRightValue = this.getChannelRightValue(_currUser, oDocChannel);
            newRightValue.copy(oDocChannelRightValue);
            int[] pRightIndexesOnChannel = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(_currChannel.getSiteId());
            for (int i = 0; i < pRightIndexesOnChannel.length; ++i) {
                int nRightIndex = pRightIndexesOnChannel[i];
                newRightValue.setBit(nRightIndex, oCurrChnlRightValue.getBit(nRightIndex));
            }
        }
        this.addOwnerValue(newRightValue, isOwner);
        if (bInFlow) {
            for (int i = 0; i < pRemoveRightIndexs.length; ++i) {
                newRightValue.setBit(pRemoveRightIndexs[i], false);
            }
        }
        return newRightValue;
    }

    private void addOwnerValue(RightValue _oRightValue, boolean _isOwner) {
        if (!_isOwner) {
            return;
        }
        int[] pRightIndexesOnOwner = DocumentAuthServer.INDEXES_OWNER_HAS;
        for (int i = 0; i < pRightIndexesOnOwner.length; ++i) {
            int nRightIndex = pRightIndexesOnOwner[i];
            _oRightValue.setBit(nRightIndex, true);
        }
    }

    private boolean isRightDefined(Document _oDocument) throws WCMException {
        RightCacheMgr oRightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        return oRightCacheMgr.isExistsRight(605, _oDocument.getDocId());
    }
}

